/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLParserUtil {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static final String[] GPO_PROP = new String[]{"SecurityDescriptor", "Computer", "User", "LinksTo"};

    public static Element getElement(List<Element> elementList, String elementName) {
        for (Element element : elementList) {
            String nodeName = element.getNodeName();
            if (!nodeName.equalsIgnoreCase(elementName)) continue;
            return element;
        }
        return null;
    }

    public static List<Element> getElementList(String fileName) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        try {
            Document doc = XMLParserUtil.parseXml(new File(fileName));
            Element rootElement = doc.getDocumentElement();
            for (String xmlProp : GPO_PROP) {
                elementList.add(XMLParserUtil.getChildElement(rootElement, xmlProp));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return elementList;
    }

    public static Element getElement(String fileName, String elementName) {
        Element element = null;
        try {
            Document doc = XMLParserUtil.parseXml(new File(fileName));
            Element rootElement = doc.getDocumentElement();
            element = XMLParserUtil.getChildElement(rootElement, elementName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXml(File file) throws IOException, SAXException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Document document = XMLParserUtil.parseXml(is);
            return document;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public static Document parseXml(InputStream source) throws IOException, SAXException {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            documentFactory.setValidating(false);
            DocumentBuilder docBuilder = documentFactory.newDocumentBuilder();
            return docBuilder.parse(source);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Creating document failed:" + pce.getMessage());
        }
    }

    public static Element getChildElement(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getChildElementText(Element parent, String name) {
        String text = "";
        Node element = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName())) continue;
            element = (Element)child;
            break;
        }
        if (element != null) {
            text = element.getTextContent();
        }
        return text;
    }

    public static List<Element> getChildrenByTagName(Element parent, String name) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName())) continue;
            nodeList.add((Element)child);
        }
        return nodeList;
    }

    public static List<Element> getAllChildElements(Element parent) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            nodeList.add((Element)child);
        }
        return nodeList;
    }

    public static HashMap<String, List<Element>> getExtenstionMap(Element element) {
        HashMap<String, List<Element>> extnMap = new HashMap<String, List<Element>>();
        if (element != null) {
            List<Element> extnDataList = XMLParserUtil.getChildrenByTagName(element, "ExtensionData");
            for (Element extnDataelement : extnDataList) {
                List<Element> extnList = XMLParserUtil.getChildrenByTagName(extnDataelement, "Extension");
                for (Element extnElement : extnList) {
                    String elementType = extnElement.getAttribute("xsi:type");
                    List<Element> extenList = extnMap.get(elementType = elementType.substring(elementType.indexOf(":") + 1));
                    if (extenList == null) {
                        extenList = new ArrayList<Element>();
                    }
                    extenList.add(extnElement);
                    extnMap.put(elementType, extenList);
                }
            }
        }
        return extnMap;
    }

    public static List<String> getExtnErrors(Element element) {
        Vector<String> errorList = new Vector<String>();
        if (element != null) {
            List<Element> extnDataList = XMLParserUtil.getChildrenByTagName(element, "ExtensionData");
            for (Element extnDataelement : extnDataList) {
                if (XMLParserUtil.getChildElement(extnDataelement, "Error") == null) continue;
                String extnName = XMLParserUtil.getChildElementText(extnDataelement, "Name");
                EVENT_LOGGER.warning("Error in extension : " + extnName);
                errorList.add(extnName);
            }
        }
        return errorList;
    }

    public static Map<String, List<String>> getExtnErrors(String fileName) {
        String[] elementNames;
        Hashtable<String, List<String>> map = null;
        for (String elementName : elementNames = new String[]{"Computer", "User"}) {
            List<String> errorList = XMLParserUtil.getExtnErrors(XMLParserUtil.getElement(fileName, elementName));
            if (errorList.isEmpty()) continue;
            EVENT_LOGGER.log(Level.WARNING, "Error in [{0}] extension of  file [{1}] ", new Object[]{elementName, fileName});
            if (map == null) {
                map = new Hashtable<String, List<String>>();
            }
            map.put(elementName, errorList);
        }
        return map;
    }
}

