/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdmTemplateComparator
extends DefaultExtensionCompartor {
    private static String[] keyElementNames = new String[]{"Category", "Name"};
    private static String[] nonKeyElementNames = new String[]{"State", "Comment"};
    private static ArrayList<String> subElementList = new ArrayList();

    public AdmTemplateComparator() {
        subElementList.add("DropDownList");
        subElementList.add("Numeric");
        subElementList.add("CheckBox");
        subElementList.add("Text");
        subElementList.add("EditText");
        subElementList.add("ListBox");
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        this.compareExtensionMap(this.getExtnMap(newXMLElementList), this.getExtnMap(oldXMLElementList), changeMap, type);
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, String type) {
        String propertyName;
        HashMap<String, Object> childDetailMap;
        Enumeration<?> propertyNames;
        Properties childElementProperties;
        HashMap<String, Object> detailMap;
        ArrayList changeList;
        Long policyPathId;
        String category;
        Set newKeySet = newDetailsMap.keySet();
        Set oldKeySet = oldDetailsMap.keySet();
        for (Object object : newKeySet) {
            HashMap newMap = (HashMap)newDetailsMap.get(object);
            category = (String)newMap.get("Category");
            policyPathId = GPOPolicyPathAPI.getInstance().getATPolicyPathId(category, type);
            changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", 1);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                detailMap.put("IS_ADM_TEMPLATE", true);
                detailMap.put("SETTING_NAME", newMap.get("Name"));
                detailMap.put("SETTING_NEW_VALUE", newMap.get("State"));
                detailMap.put("COMMENT_NEW_VALUE", newMap.get("Comment"));
                changeList.add(detailMap);
                if (newMap.get("ChildElements") != null) {
                    childElementProperties = (Properties)newMap.get("ChildElements");
                    propertyNames = childElementProperties.propertyNames();
                    while (propertyNames.hasMoreElements()) {
                        childDetailMap = new HashMap<String, Object>();
                        childDetailMap.put("CHANGE_TYPE", 1);
                        childDetailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                        childDetailMap.put("IS_ADM_TEMPLATE", true);
                        propertyName = (String)propertyNames.nextElement();
                        childDetailMap.put("SETTING_NAME", newMap.get("Name") + "/" + propertyName);
                        childDetailMap.put("SETTING_NEW_VALUE", childElementProperties.getProperty(propertyName));
                        changeList.add(childDetailMap);
                    }
                }
            } else {
                HashMap oldMap = (HashMap)oldDetailsMap.get(object);
                if (!oldMap.equals(newMap)) {
                    HashMap<String, Object> detailMap2;
                    String keyName;
                    Enumeration<?> enumeration;
                    if (newMap.get("Comment") == null) {
                        newMap.put("Comment", "-");
                    }
                    if (oldMap.get("Comment") == null) {
                        oldMap.put("Comment", "-");
                    }
                    if (!newMap.get("State").equals(oldMap.get("State")) || !newMap.get("Comment").equals(oldMap.get("Comment"))) {
                        HashMap<String, Object> detailMap3 = new HashMap<String, Object>();
                        detailMap3.put("CHANGE_TYPE", 2);
                        detailMap3.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
                        detailMap3.put("IS_ADM_TEMPLATE", true);
                        detailMap3.put("SETTING_NAME", newMap.get("Name"));
                        detailMap3.put("SETTING_NEW_VALUE", newMap.get("State"));
                        detailMap3.put("SETTING_OLD_VALUE", oldMap.get("State"));
                        detailMap3.put("COMMENT_NEW_VALUE", newMap.get("Comment"));
                        detailMap3.put("COMMENT_OLD_VALUE", oldMap.get("Comment"));
                        changeList.add(detailMap3);
                    }
                    Properties newchildElementProperties = (Properties)newMap.get("ChildElements");
                    Properties oldChildElementProperties = (Properties)oldMap.get("ChildElements");
                    if (newchildElementProperties != null) {
                        enumeration = newchildElementProperties.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            keyName = (String)enumeration.nextElement();
                            if (oldChildElementProperties != null && oldChildElementProperties.containsKey(keyName) && !newchildElementProperties.getProperty(keyName).equalsIgnoreCase(oldChildElementProperties.getProperty(keyName))) {
                                detailMap2 = new HashMap();
                                detailMap2.put("CHANGE_TYPE", 2);
                                detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
                                detailMap2.put("IS_ADM_TEMPLATE", true);
                                detailMap2.put("SETTING_NAME", newMap.get("Name") + "/" + keyName);
                                detailMap2.put("SETTING_NEW_VALUE", newchildElementProperties.getProperty(keyName));
                                detailMap2.put("SETTING_OLD_VALUE", oldChildElementProperties.getProperty(keyName));
                                changeList.add(detailMap2);
                                continue;
                            }
                            if (oldChildElementProperties != null && oldChildElementProperties.containsKey(keyName)) continue;
                            detailMap2 = new HashMap<String, Object>();
                            detailMap2.put("CHANGE_TYPE", 1);
                            detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                            detailMap2.put("IS_ADM_TEMPLATE", true);
                            detailMap2.put("SETTING_NAME", newMap.get("Name") + "/" + keyName);
                            detailMap2.put("SETTING_NEW_VALUE", newchildElementProperties.getProperty(keyName));
                            detailMap2.put("SETTING_OLD_VALUE", "-");
                            changeList.add(detailMap2);
                        }
                    }
                    if (oldChildElementProperties != null) {
                        enumeration = oldChildElementProperties.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            keyName = (String)enumeration.nextElement();
                            if (newchildElementProperties == null || newchildElementProperties.containsKey(keyName)) continue;
                            detailMap2 = new HashMap();
                            detailMap2.put("CHANGE_TYPE", 3);
                            detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                            detailMap2.put("IS_ADM_TEMPLATE", true);
                            detailMap2.put("SETTING_NAME", oldMap.get("Name") + "/" + keyName);
                            detailMap2.put("SETTING_NEW_VALUE", "-");
                            detailMap2.put("SETTING_OLD_VALUE", oldChildElementProperties.getProperty("State"));
                            changeList.add(detailMap2);
                        }
                    }
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
        for (Object object : oldKeySet) {
            HashMap oldMap = (HashMap)oldDetailsMap.get(object);
            category = (String)oldMap.get("Category");
            policyPathId = GPOPolicyPathAPI.getInstance().getATPolicyPathId(category, type);
            changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!newDetailsMap.containsKey(object)) {
                detailMap = new HashMap();
                detailMap.put("CHANGE_TYPE", 3);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                detailMap.put("IS_ADM_TEMPLATE", true);
                detailMap.put("SETTING_NAME", oldMap.get("Name"));
                detailMap.put("SETTING_OLD_VALUE", oldMap.get("State"));
                detailMap.put("COMMENT_OLD_VALUE", oldMap.get("Comment"));
                changeList.add(detailMap);
                if (oldMap.get("ChildElements") != null) {
                    childElementProperties = (Properties)oldMap.get("ChildElements");
                    propertyNames = childElementProperties.propertyNames();
                    while (propertyNames.hasMoreElements()) {
                        childDetailMap = new HashMap();
                        childDetailMap.put("CHANGE_TYPE", 3);
                        childDetailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                        childDetailMap.put("IS_ADM_TEMPLATE", true);
                        propertyName = (String)propertyNames.nextElement();
                        childDetailMap.put("SETTING_NAME", oldMap.get("Name") + "/" + propertyName);
                        childDetailMap.put("SETTING_OLD_VALUE", childElementProperties.getProperty(propertyName));
                        changeList.add(childDetailMap);
                    }
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap extnDetailsMap = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element nameNode;
                    int j;
                    String nodeLocalName;
                    Node node = nodeList.item(i);
                    short nodeType = node.getNodeType();
                    if (node.getLocalName() == null || nodeType != 1 || !(nodeLocalName = node.getLocalName()).equalsIgnoreCase("Policy")) continue;
                    HashMap<String, Object> policyMap = new HashMap<String, Object>();
                    String keyName = "";
                    for (j = 0; j < keyElementNames.length; ++j) {
                        nameNode = XMLParserUtil.getChildElement((Element)node, keyElementNames[j]);
                        policyMap.put(keyElementNames[j], nameNode.getTextContent());
                        if (j > 0) {
                            keyName = keyName + "/";
                        }
                        keyName = keyName + nameNode.getTextContent();
                    }
                    for (j = 0; j < nonKeyElementNames.length; ++j) {
                        nameNode = XMLParserUtil.getChildElement((Element)node, nonKeyElementNames[j]);
                        if (nameNode == null) continue;
                        policyMap.put(nonKeyElementNames[j], nameNode.getTextContent());
                    }
                    NodeList childNodeList = node.getChildNodes();
                    Properties childDetailProp = new Properties();
                    boolean isPrefixTextNodePresent = false;
                    String prefixTextString = "";
                    for (int j2 = 0; j2 < childNodeList.getLength(); ++j2) {
                        String childNodeName;
                        Node childNode = childNodeList.item(j2);
                        short childNodeType = childNode.getNodeType();
                        if (childNode.getLocalName() == null || childNodeType != 1 || !subElementList.contains(childNodeName = childNode.getLocalName())) continue;
                        String stateString = "NotConfigured";
                        if (childNodeName.equalsIgnoreCase("Text")) {
                            isPrefixTextNodePresent = true;
                            String prefixText = XMLParserUtil.getChildElement((Element)childNode, "Name").getTextContent();
                            if (!prefixText.trim().equalsIgnoreCase("") && !prefixText.contains("=")) {
                                prefixTextString = prefixText;
                                continue;
                            }
                            prefixTextString = "";
                            isPrefixTextNodePresent = false;
                            continue;
                        }
                        String nameString = XMLParserUtil.getChildElement((Element)childNode, "Name").getTextContent();
                        if (isPrefixTextNodePresent) {
                            nameString = prefixTextString + " - " + nameString;
                        }
                        if ((stateString = XMLParserUtil.getChildElement((Element)childNode, "State").getTextContent()).equalsIgnoreCase("Enabled")) {
                            if (childNodeName.equalsIgnoreCase("DropDownList")) {
                                Element valueNode = XMLParserUtil.getChildElement((Element)childNode, "Value");
                                childDetailProp.setProperty(nameString, XMLParserUtil.getChildElement(valueNode, "Name").getTextContent());
                                continue;
                            }
                            if (childNodeName.equalsIgnoreCase("Numeric") || childNodeName.equalsIgnoreCase("EditText")) {
                                childDetailProp.setProperty(nameString, XMLParserUtil.getChildElement((Element)childNode, "Value").getTextContent());
                                continue;
                            }
                            if (childNodeName.equalsIgnoreCase("CheckBox")) {
                                childDetailProp.setProperty(nameString, XMLParserUtil.getChildElement((Element)childNode, "State").getTextContent());
                                continue;
                            }
                            if (!childNodeName.equalsIgnoreCase("ListBox")) continue;
                            String expValue = XMLParserUtil.getChildElement((Element)childNode, "ExplicitValue").getTextContent();
                            Element valueNode = XMLParserUtil.getChildElement((Element)childNode, "Value");
                            List<Element> elements = XMLParserUtil.getChildrenByTagName(valueNode, "Element");
                            StringBuilder builder = new StringBuilder();
                            for (int k = 0; k < elements.size(); ++k) {
                                if (k > 0) {
                                    builder.append("; ");
                                }
                                if (expValue.equalsIgnoreCase("true")) {
                                    builder.append("Name=");
                                    builder.append(XMLParserUtil.getChildElement(elements.get(k), "Name").getTextContent());
                                    builder.append(", ");
                                    builder.append("Value=");
                                    builder.append(XMLParserUtil.getChildElement(elements.get(k), "Data").getTextContent());
                                    continue;
                                }
                                builder.append(XMLParserUtil.getChildElement(elements.get(k), "Data").getTextContent());
                            }
                            childDetailProp.setProperty(nameString, builder.toString());
                            continue;
                        }
                        childDetailProp.setProperty(nameString, stateString);
                    }
                    if (!childDetailProp.isEmpty()) {
                        policyMap.put("ChildElements", childDetailProp);
                    }
                    extnDetailsMap.put(keyName, policyMap);
                }
            }
        }
        return extnDetailsMap;
    }
}

