/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuditSettingsComparator
extends DefaultExtensionCompartor {
    private static HashMap advAudPolMap = null;
    private static final String BASE_POLICY_ID_PATTERN = "AudGPPolicyPathMapping:policy_path_id:212221";

    public AuditSettingsComparator() {
        AuditSettingsComparator.getAdvAudPolMap();
    }

    private static void getAdvAudPolMap() {
        advAudPolMap = new HashMap();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudAdvAudPolicyDetails", (Row)null);
            Iterator rowIterator = dataObject.getRows("AudAdvAudPolicyDetails");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                HashMap<String, Object> keyValuesMap = new HashMap<String, Object>();
                keyValuesMap.put("SUB_CATEGORY_NAME", row.get("SUB_CATEGORY_NAME"));
                keyValuesMap.put("CATEGORY_NAME", row.get("CATEGORY_NAME"));
                advAudPolMap.put(row.get("SUB_CATEGORY_GUID").toString().toLowerCase(), keyValuesMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        HashMap newDetailsMap = this.getExtnMap(newXMLElementList);
        HashMap oldDetailsMap = this.getExtnMap(oldXMLElementList);
        this.compareExtensionMap(newDetailsMap, oldDetailsMap, changeMap);
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap) {
        HashMap<String, Object> detailMap;
        ArrayList<HashMap<String, Object>> changeList;
        Long policyPathId;
        String categoryName;
        HashMap audpolMap;
        Set newKeySet = newDetailsMap.keySet();
        Set oldKeySet = oldDetailsMap.keySet();
        for (Object object : newKeySet) {
            String oldValueString;
            String newValueString;
            if (!oldDetailsMap.containsKey(object)) {
                newValueString = (String)newDetailsMap.get(object);
                audpolMap = (HashMap)advAudPolMap.get(object);
                categoryName = (String)audpolMap.get("CATEGORY_NAME");
                policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(categoryName, BASE_POLICY_ID_PATTERN, "AudGPPolicyPathMapping:policy_path_id:2");
                changeList = (ArrayList<HashMap<String, Object>>)changeMap.get(policyPathId);
                if (changeList == null) {
                    changeList = new ArrayList<HashMap<String, Object>>();
                }
                detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", 1);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                detailMap.put("SETTING_NAME", (String)audpolMap.get("SUB_CATEGORY_NAME"));
                String newValue = this.getValueString(newValueString);
                detailMap.put("SETTING_NEW_VALUE", newValue);
                changeList.add(detailMap);
                if (changeList.isEmpty()) continue;
                changeMap.put(policyPathId, changeList);
                continue;
            }
            newValueString = (String)newDetailsMap.get(object);
            if (newValueString.equalsIgnoreCase(oldValueString = (String)oldDetailsMap.get(object))) continue;
            HashMap audpolMap2 = (HashMap)advAudPolMap.get(object);
            String categoryName2 = (String)audpolMap2.get("CATEGORY_NAME");
            Long policyPathId2 = GPOPolicyPathAPI.getInstance().getPolicyPathId(categoryName2, BASE_POLICY_ID_PATTERN, "AudGPPolicyPathMapping:policy_path_id:2");
            ArrayList changeList2 = (ArrayList)changeMap.get(policyPathId2);
            if (changeList2 == null) {
                changeList2 = new ArrayList();
            }
            HashMap<String, Object> detailMap2 = new HashMap<String, Object>();
            detailMap2.put("CHANGE_TYPE", 2);
            detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
            detailMap2.put("SETTING_NAME", (String)audpolMap2.get("SUB_CATEGORY_NAME"));
            String valueString = (String)newDetailsMap.get("SettingValue");
            detailMap2.put("SETTING_NEW_VALUE", this.getValueString(newValueString));
            detailMap2.put("SETTING_OLD_VALUE", this.getValueString(oldValueString));
            changeList2.add(detailMap2);
            if (changeList2.isEmpty()) continue;
            changeMap.put(policyPathId2, changeList2);
        }
        for (Object object : oldKeySet) {
            String oldValueString = (String)oldDetailsMap.get(object);
            if (newDetailsMap.containsKey(object)) continue;
            audpolMap = (HashMap)advAudPolMap.get(object);
            categoryName = (String)audpolMap.get("CATEGORY_NAME");
            policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(categoryName, BASE_POLICY_ID_PATTERN, "AudGPPolicyPathMapping:policy_path_id:2");
            changeList = (ArrayList<HashMap<String, Object>>)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList<HashMap<String, Object>>();
            }
            detailMap = new HashMap();
            detailMap.put("CHANGE_TYPE", 3);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
            detailMap.put("SETTING_NAME", (String)audpolMap.get("SUB_CATEGORY_NAME"));
            String oldValue = this.getValueString(oldValueString);
            detailMap.put("SETTING_OLD_VALUE", oldValue);
            changeList.add(detailMap);
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    private String getValueString(String value) {
        String valueString = "No Auditing";
        if (value.equalsIgnoreCase("1")) {
            valueString = "Success";
        } else if (value.equalsIgnoreCase("2")) {
            valueString = "Failure";
        } else if (value.equalsIgnoreCase("3")) {
            valueString = "Success,Failure";
        }
        return valueString;
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap<String, String> extnDetailsMap = new HashMap<String, String>();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    short nodeType = node.getNodeType();
                    if (node.getLocalName() == null || nodeType != 1) continue;
                    Element subCategoryElement = XMLParserUtil.getChildElement((Element)node, "SubcategoryGuid");
                    String subCatGuid = subCategoryElement.getTextContent();
                    HashMap subCatDetails = (HashMap)advAudPolMap.get(subCatGuid);
                    Element settingValueElement = XMLParserUtil.getChildElement((Element)node, "SettingValue");
                    extnDetailsMap.put(subCategoryElement.getTextContent().toLowerCase(), settingValueElement.getTextContent());
                }
            }
        }
        return extnDetailsMap;
    }
}

