/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.ExtensionCompator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class DefaultExtensionCompartor
implements ExtensionCompator {
    protected static final String USER_CONFIG_PATTERN = "AudGPPolicyPathMapping:policy_path_id:3";
    protected static final String COMP_CONFIG_PATTERN = "AudGPPolicyPathMapping:policy_path_id:2";

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String exnType) {
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String configType, String extnType, int index) {
    }

    protected void compareDefaultExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, String type) {
        this.compareDefaultExtensionMap(newDetailsMap, oldDetailsMap, changeMap, true, type);
        this.compareDefaultExtensionMap(oldDetailsMap, newDetailsMap, changeMap, false, type);
    }

    private void compareDefaultExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, boolean checkModify, String type) {
        Set newKeySet = newDetailsMap.keySet();
        String pattern = COMP_CONFIG_PATTERN;
        if (type.equalsIgnoreCase("user")) {
            pattern = USER_CONFIG_PATTERN;
        }
        for (Object object : newKeySet) {
            HashMap newFolderMap = (HashMap)newDetailsMap.get(object);
            Set newFolderMapSet = newFolderMap.keySet();
            String folderName = (String)object;
            Long policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(folderName, pattern);
            ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                if (!checkModify) {
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                }
                for (Object object2 : newFolderMapSet) {
                    String newKeyName = (String)object2;
                    HashMap<String, Object> detailMap = new HashMap<String, Object>();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", newKeyName);
                    detailMap.put(settingValueString, newFolderMap.get(newKeyName));
                    changeList.add(detailMap);
                }
            } else if (checkModify) {
                HashMap<String, Object> detailMap;
                HashMap oldFolderMap = (HashMap)oldDetailsMap.get(object);
                Set oldFolderMapSet = oldFolderMap.keySet();
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                for (Object object2 : newFolderMapSet) {
                    if (!oldFolderMap.containsKey(object2)) {
                        String newKeyName = (String)object2;
                        detailMap = new HashMap<String, Object>();
                        detailMap.put("CHANGE_TYPE", changeType);
                        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                        detailMap.put("SETTING_NAME", newKeyName);
                        detailMap.put(settingValueString, newFolderMap.get(newKeyName));
                        changeList.add(detailMap);
                        continue;
                    }
                    String keyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("SETTING_NAME", keyName);
                    if (newFolderMap.get(keyName).equals(oldFolderMap.get(keyName))) continue;
                    changeType = 2;
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    settingValueString = "SETTING_NEW_VALUE";
                    detailMap.put(settingValueString, newFolderMap.get(keyName));
                    settingValueString = "SETTING_OLD_VALUE";
                    detailMap.put(settingValueString, oldFolderMap.get(keyName));
                    changeList.add(detailMap);
                }
                for (Object object2 : oldFolderMapSet) {
                    if (newFolderMap.containsKey(object2)) continue;
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                    String oldKeyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", oldKeyName);
                    detailMap.put(settingValueString, oldFolderMap.get(oldKeyName));
                    changeList.add(detailMap);
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    public String getMemberDetails(List<Element> elementList) {
        StringBuilder members = new StringBuilder();
        for (int i = 0; i < elementList.size(); ++i) {
            Element sidElement;
            Element element = elementList.get(i);
            Element nameElement = XMLParserUtil.getChildElement(element, "Name");
            if (nameElement != null) {
                if (i > 0) {
                    members.append(", ");
                }
                members.append(nameElement.getChildNodes().item(0).getTextContent());
            }
            if ((sidElement = XMLParserUtil.getChildElement(element, "SID")) == null) continue;
            members.append("(");
            members.append(sidElement.getChildNodes().item(0).getTextContent());
            members.append(")");
        }
        return members.toString();
    }

    public ArrayList<String> getMemberList(List<Element> elementList) {
        ArrayList<String> membersList = new ArrayList<String>();
        StringBuilder members = new StringBuilder();
        for (int i = 0; i < elementList.size(); ++i) {
            Element sidElement;
            Element element = elementList.get(i);
            Element nameElement = XMLParserUtil.getChildElement(element, "Name");
            if (nameElement != null) {
                members.append(nameElement.getChildNodes().item(0).getTextContent());
            }
            if ((sidElement = XMLParserUtil.getChildElement(element, "SID")) != null) {
                members.append("(");
                members.append(sidElement.getChildNodes().item(0).getTextContent());
                members.append(")");
            }
            membersList.add(members.toString());
        }
        return membersList;
    }

    public String getBooleanValue(String value) {
        String booleanValue = "-";
        booleanValue = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ? "Enabled" : (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0") ? "Disabled" : value);
        return booleanValue;
    }

    public String getBooleanSetting(Element element, String booleanProperty, String defaultBooleanValue) {
        String booleanValue = defaultBooleanValue;
        if (!XMLParserUtil.getChildElementText(element, booleanProperty).equalsIgnoreCase("")) {
            booleanValue = XMLParserUtil.getChildElementText(element, booleanProperty);
        }
        booleanValue = this.getBooleanValue(booleanValue);
        return booleanValue;
    }
}

