/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;

public class EQOSComparator
extends DefaultExtensionCompartor {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static final String ADV_SET_UVH = "AudGPPolicyPathMapping:policy_path_id:212301";
    private static final String COMP_POL_NAME_UVH = "AudGPPolicyPathMapping:policy_path_id:212302";
    private static final String USER_POL_NAME_UVH = "AudGPPolicyPathMapping:policy_path_id:312401";
    private static final String[] AUTO_TUNING_LEVEL = new String[]{rb.getString("adap.admin.general.server_settgs.normal_mode"), rb.getString("adap.EQOSComparator.Restricted"), rb.getString("adap.EQOSComparator.Highly_Restricted"), rb.getString("adap.EQOSComparator.Off")};
    private static final String[] AUTO_TUNING_LEVEL_TEXT = new String[]{rb.getString("adap.EQOSComparator.Level3"), rb.getString("adap.EQOSComparator.Level2"), rb.getString("adap.EQOSComparator.Level1"), rb.getString("adap.EQOSComparator.Level0")};
    private static final String[] UVH_STRINGS = new String[]{"AudGPPolicyPathMapping:policy_path_id:212301", "AudGPPolicyPathMapping:policy_path_id:212302", "AudGPPolicyPathMapping:policy_path_id:312401"};
    private static final String[] SCRIPT_TYPE_STRINGS = new String[]{rb.getString("adap.EQOSComparator.advanced"), rb.getString("adap.EQOSComparator.computer"), rb.getString("adap.EQOSComparator.user")};
    private static final String[] POLICY_PROPS = new String[]{"PolicyVersion", "DSCPValue", "ThrottleRate", "ApplicationName", "Resource", "ResourceRecursive", "Protocol", "LocalIPAndPrefix", "RemoteIPAndPrefix", "LocalPort", "RemotePort"};
    private static final String[] POLICY_PROP_STRINGS = new String[]{rb.getString("adap.EQOSComparator.Policy_Version"), rb.getString("adap.EQOSComparator.DSCP_Value"), rb.getString("adap.EQOSComparator.Throttle_Rate"), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.AUDColumnConfiguration.displayname.Application_Name")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.URL")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.URL_Recursion")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.Protocol")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.Source_IP")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.Destination_IP")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.Source_Port")}), rb.handleGetObject("adap.EQOSComparator.Policy_Conditions_Text", new String[]{rb.getString("adap.EQOSComparator.Destination_Port")})};
    private static final String[] DEFAULT_VALUES = new String[]{"", "0", "-1", "*", "", "", "*", "*/*", "*/*", "*", "*"};
    private static final String[] DEFAULT_VALUE_STRINGS = new String[]{"", "0", rb.getString("adap.EQOSComparator.Not_Specified"), rb.getString("adap.EQOSComparator.Any"), "", "", rb.getString("adap.EQOSComparator.TCP_UDP"), rb.getString("adap.EQOSComparator.Any"), rb.getString("adap.EQOSComparator.Any"), rb.getString("adap.EQOSComparator.Any"), rb.getString("adap.EQOSComparator.Any")};
    private static Properties autoTuningProps = null;
    private static HashMap<String, Long> uvhMap = null;

    public EQOSComparator() {
        int i;
        autoTuningProps = new Properties();
        for (i = 0; i < AUTO_TUNING_LEVEL.length; ++i) {
            autoTuningProps.setProperty(AUTO_TUNING_LEVEL[i], AUTO_TUNING_LEVEL_TEXT[i]);
        }
        uvhMap = new HashMap();
        for (i = 0; i < UVH_STRINGS.length; ++i) {
            Long uvhValue = DBObjectUtil.getUVHValues("AudGPPolicyPathMapping", UVH_STRINGS[i]);
            uvhMap.put(SCRIPT_TYPE_STRINGS[i], uvhValue);
        }
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        if (type.equalsIgnoreCase("Computer")) {
            Properties newAdvSettinsProps = this.getAdvSettingsMap(newXMLElementList);
            Properties oldAdvSettinsProps = this.getAdvSettingsMap(oldXMLElementList);
            this.compareAdvSettings(newAdvSettinsProps, oldAdvSettinsProps, changeMap);
        }
        HashMap<String, Properties> newDetailsMap = this.getPolicyElementMap(newXMLElementList);
        HashMap<String, Properties> oldDetailsMap = this.getPolicyElementMap(oldXMLElementList);
        this.comparePolicyMap(newDetailsMap, oldDetailsMap, changeMap, type, true);
        this.comparePolicyMap(oldDetailsMap, newDetailsMap, changeMap, type, false);
    }

    private void compareAdvSettings(Properties newAdvSettinsProps, Properties oldAdvSettinsProps, HashMap changeMap) {
        Long policyPathId = uvhMap.get(rb.getString("adap.EQOSComparator.advanced"));
        ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
        if (changeList == null) {
            changeList = new ArrayList();
        }
        int changeType = 1;
        String settingValueTypeString = "SETTING_NEW_VALUE";
        HashMap<String, Object> detailMap = null;
        Enumeration<?> newPropertyNames = newAdvSettinsProps.propertyNames();
        while (newPropertyNames.hasMoreElements()) {
            String oldPropvalue;
            String newPropertyName = (String)newPropertyNames.nextElement();
            if (!oldAdvSettinsProps.containsKey(newPropertyName)) {
                changeType = 1;
                detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", changeType);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                detailMap.put("SETTING_NAME", newPropertyName);
                detailMap.put(settingValueTypeString, newAdvSettinsProps.getProperty(newPropertyName));
                changeList.add(detailMap);
                continue;
            }
            changeType = 2;
            String newPropvalue = newAdvSettinsProps.getProperty(newPropertyName);
            if (newPropvalue.equals(oldPropvalue = oldAdvSettinsProps.getProperty(newPropertyName))) continue;
            detailMap = new HashMap();
            detailMap.put("CHANGE_TYPE", changeType);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
            detailMap.put("SETTING_NAME", newPropertyName);
            detailMap.put("SETTING_NEW_VALUE", newPropvalue);
            detailMap.put("SETTING_OLD_VALUE", oldPropvalue);
            changeList.add(detailMap);
        }
        Enumeration<?> oldPropertyNames = oldAdvSettinsProps.propertyNames();
        while (oldPropertyNames.hasMoreElements()) {
            String oldPropertyName = (String)oldPropertyNames.nextElement();
            if (newAdvSettinsProps.containsKey(oldPropertyName)) continue;
            changeType = 3;
            settingValueTypeString = "SETTING_OLD_VALUE";
            detailMap = new HashMap();
            detailMap.put("CHANGE_TYPE", changeType);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
            detailMap.put("SETTING_NAME", oldPropertyName);
            detailMap.put(settingValueTypeString, oldAdvSettinsProps.getProperty(oldPropertyName));
            changeList.add(detailMap);
        }
        if (!changeList.isEmpty()) {
            changeMap.put(policyPathId, changeList);
        }
    }

    private Properties getAdvSettingsMap(List<Element> elementList) {
        Properties advSetProperties = new Properties();
        Element element = null;
        Object elements = null;
        if (elementList != null && !elementList.isEmpty()) {
            String dscpMarking;
            String autoTuningLevel;
            Element extnElement = elementList.get(0);
            element = XMLParserUtil.getChildElement(extnElement, "QoSTCPAutoTuningSetting");
            if (element != null && !(autoTuningLevel = XMLParserUtil.getChildElementText(element, "TcpAutoTuningLevel")).equalsIgnoreCase("")) {
                advSetProperties.setProperty(rb.getString("adap.EQOSComparator.Inbound_TCP_Throughput_Level"), autoTuningProps.getProperty(autoTuningLevel));
            }
            if ((element = XMLParserUtil.getChildElement(extnElement, "QoSAppDscpMarkingSetting")) != null && !(dscpMarking = XMLParserUtil.getChildElementText(element, "AppDscpMarkingConfiguration")).equalsIgnoreCase("")) {
                advSetProperties.setProperty(rb.getString("adap.EQOSComparator.Applications_DSCP_Marking_Request"), dscpMarking);
            }
        }
        return advSetProperties;
    }

    private void comparePolicyMap(HashMap<String, Properties> newDetailsMap, HashMap<String, Properties> oldDetailsMap, HashMap changeMap, String type, boolean checkForModify) {
        Set<String> newPolicyNames = newDetailsMap.keySet();
        Set<String> oldPolicyNames = oldDetailsMap.keySet();
        String confTypePattern = "AudGPPolicyPathMapping:policy_path_id:2";
        String basePolicyPattern = COMP_POL_NAME_UVH;
        int changeType = 1;
        String settingValueTypeString = "SETTING_NEW_VALUE";
        if (type.equalsIgnoreCase("user")) {
            confTypePattern = "AudGPPolicyPathMapping:policy_path_id:3";
            basePolicyPattern = USER_POL_NAME_UVH;
        }
        HashMap<String, Object> detailMap = null;
        for (String newPolicyName : newPolicyNames) {
            Properties newProps;
            Long policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(newPolicyName, basePolicyPattern, confTypePattern);
            ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(newPolicyName)) {
                changeType = 1;
                settingValueTypeString = "SETTING_NEW_VALUE";
                if (!checkForModify) {
                    changeType = 3;
                    settingValueTypeString = "SETTING_OLD_VALUE";
                }
                newProps = newDetailsMap.get(newPolicyName);
                for (int i = 0; i < POLICY_PROPS.length; ++i) {
                    if (newProps.getProperty(POLICY_PROPS[i]) == null) continue;
                    detailMap = new HashMap<String, Object>();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", POLICY_PROP_STRINGS[i]);
                    String newValueString = newProps.getProperty(POLICY_PROPS[i]);
                    if (newValueString.equals(DEFAULT_VALUES[i])) {
                        newValueString = DEFAULT_VALUE_STRINGS[i];
                    }
                    detailMap.put(settingValueTypeString, newValueString);
                    changeList.add(detailMap);
                }
            } else if (checkForModify) {
                changeType = 2;
                newProps = newDetailsMap.get(newPolicyName);
                Properties oldProps = oldDetailsMap.get(newPolicyName);
                for (int i = 0; i < POLICY_PROPS.length; ++i) {
                    String newValue = "";
                    if (newProps.getProperty(POLICY_PROPS[i]) != null) {
                        newValue = newProps.getProperty(POLICY_PROPS[i]);
                    }
                    String oldValue = "";
                    if (oldProps.getProperty(POLICY_PROPS[i]) != null) {
                        oldValue = oldProps.getProperty(POLICY_PROPS[i]);
                    }
                    if (newValue.equals(oldValue)) continue;
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", POLICY_PROP_STRINGS[i]);
                    String valueString = newValue;
                    if (valueString.equals(DEFAULT_VALUES[i])) {
                        valueString = DEFAULT_VALUE_STRINGS[i];
                    }
                    settingValueTypeString = "SETTING_NEW_VALUE";
                    detailMap.put(settingValueTypeString, valueString);
                    valueString = oldValue;
                    if (valueString.equals(DEFAULT_VALUES[i])) {
                        valueString = DEFAULT_VALUE_STRINGS[i];
                    }
                    settingValueTypeString = "SETTING_OLD_VALUE";
                    detailMap.put(settingValueTypeString, valueString);
                    changeList.add(detailMap);
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    private HashMap<String, Properties> getPolicyElementMap(List<Element> elementList) {
        Element extnElement;
        HashMap<String, Properties> extnDetailsMap = new HashMap<String, Properties>();
        Element element = null;
        List<Element> elements = null;
        if (elementList != null && !elementList.isEmpty() && (elements = XMLParserUtil.getChildrenByTagName(extnElement = elementList.get(0), "QoSPolicy")) != null) {
            for (Element element2 : elements) {
                String name = XMLParserUtil.getChildElementText(element2, "PolicyName");
                Properties policyElementProps = new Properties();
                for (int i = 0; i < POLICY_PROPS.length; ++i) {
                    String policyValue;
                    element = XMLParserUtil.getChildElement(element2, POLICY_PROPS[i]);
                    if (element == null || (policyValue = element.getTextContent()).equalsIgnoreCase("")) continue;
                    policyElementProps.setProperty(POLICY_PROPS[i], policyValue);
                }
                extnDetailsMap.put(name, policyElementProps);
            }
        }
        return extnDetailsMap;
    }
}

