/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;

public class FRSettingsComparator
extends DefaultExtensionCompartor {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static final String BASIC_SETTING = rb.getString("adap.FRSettingsComparator.BASIC_SETTING");
    private static final String ADV_SETTING = rb.getString("adap.FRSettingsComparator.ADV_SETTING");
    private static final String NC_SETTING = rb.getString("adap.FRSettingsComparator.NC_SETTING");
    private static final String FOLLOW_SETTING = rb.getString("adap.FRSettingsComparator.FOLLOW_SETTING");
    private static final String REDIRECT_LOCAL = rb.getString("adap.FRSettingsComparator.REDIRECT_LOCAL");
    private static final String[] BOOL_PROPS = new String[]{"GrantExclusiveRights", "MoveContents", "ApplyToDownLevel"};
    private static final String[] BOOL_PROP_STRGS = new String[]{rb.getString("adap.FRSettingsComparator.GrantExclusiveRights"), rb.getString("adap.FRSettingsComparator.MoveContents"), rb.getString("adap.FRSettingsComparator.ApplyToDownLevel")};
    private static final String[] FOLDER_GUIDS = new String[]{"{3EB685DB-65F9-4CF6-A03A-E3EF65729F3D}", "{B4BFCC3A-DB2C-424C-B029-7FE99A87C641}", "{625B53C3-AB48-4EC1-BA1F-A1EF4146FC19}", "{FDD39AD0-238F-46AF-ADB4-6C85480369C7}", "{33E28130-4E1E-4676-835A-98395C3BC3BB}", "{4BD8D571-6D19-48D3-BE97-422220080E43}", "{18989B1D-99B5-455B-841C-AB7C74E4DDFC}", "{1777F761-68AD-4D8A-87BD-30B759FA33DD}", "{56784854-C6CB-462B-8169-88E350ACB882}", "{374DE290-123F-4565-9164-39C4925E467B}", "{BFB9D5E0-C6A9-404C-B2B2-AE6DB6AF4968}", "{7D1D3A04-DEBB-4115-95CF-2F29DA2920DA}", "{4C5C32FF-BB9D-43B0-B5B4-2D72E54EAAA4}", rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Application_Data"), rb.getString("adap.AUDGPPolicyPathMapping.policy_path.My_Documents"), rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Desktop"), rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Start_Menu")};
    private static final String[] FOLDER_NAMES = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.AppData(Roaming)", "adap.AUDGPPolicyPathMapping.policy_path.Desktop", "adap.AUDGPPolicyPathMapping.policy_path.Start_Menu", "adap.AUDGPPolicyPathMapping.policy_path.Documents", "adap.AUDGPPolicyPathMapping.policy_path.Pictures", "adap.AUDGPPolicyPathMapping.policy_path.Music", "adap.AUDGPPolicyPathMapping.policy_path.Videos", "adap.AUDGPPolicyPathMapping.policy_path.Favorites", "adap.AUDGPPolicyPathMapping.policy_path.Contacts", "adap.AUDGPPolicyPathMapping.policy_path.Downloads", "adap.AUDGPPolicyPathMapping.policy_path.Links", "adap.AUDGPPolicyPathMapping.policy_path.Searches", "adap.AUDGPPolicyPathMapping.policy_path.Saved_Games", "adap.AUDGPPolicyPathMapping.policy_path.Application_Data", "adap.AUDGPPolicyPathMapping.policy_path.My_Documents", "adap.AUDGPPolicyPathMapping.policy_path.Desktop", "adap.AUDGPPolicyPathMapping.policy_path.Start_Menu"};
    private Properties folderGuidProps = new Properties();

    public FRSettingsComparator() {
        for (int i = 0; i < FOLDER_GUIDS.length; ++i) {
            this.folderGuidProps.setProperty(FOLDER_GUIDS[i], FOLDER_NAMES[i]);
        }
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        HashMap newDetailsMap = this.getExtnMap(newXMLElementList);
        HashMap oldDetailsMap = this.getExtnMap(oldXMLElementList);
        this.compareExtensionMap(newDetailsMap, oldDetailsMap, changeMap, true);
        this.compareExtensionMap(oldDetailsMap, newDetailsMap, changeMap, false);
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, boolean checkModify) {
        Set newKeySet = newDetailsMap.keySet();
        for (Object object : newKeySet) {
            HashMap newFolderMap = (HashMap)newDetailsMap.get(object);
            Set newFolderMapSet = newFolderMap.keySet();
            String folderName = (String)object;
            Long policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(folderName, "AudGPPolicyPathMapping:policy_path_id:3");
            ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                String newSettingString = (String)newFolderMap.get("Setting");
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                if (!checkModify) {
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                }
                for (Object object2 : newFolderMapSet) {
                    String newKeyName = (String)object2;
                    HashMap<String, Object> detailMap = new HashMap<String, Object>();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", newKeyName);
                    if (newKeyName.equalsIgnoreCase("Path") && newSettingString.equals(ADV_SETTING)) {
                        Properties newPathProperties = (Properties)newFolderMap.get(newKeyName);
                        detailMap.put(settingValueString, this.getAdvPathString(newPathProperties));
                    } else {
                        String newValue = (String)newFolderMap.get(newKeyName);
                        detailMap.put(settingValueString, newValue);
                    }
                    changeList.add(detailMap);
                }
            } else if (checkModify) {
                String oldValue;
                Properties oldPathProperties;
                HashMap<String, Object> detailMap;
                HashMap oldFolderMap = (HashMap)oldDetailsMap.get(object);
                Set oldFolderMapSet = oldFolderMap.keySet();
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                String newSettingString = (String)newFolderMap.get("Setting");
                String oldSettingString = (String)oldFolderMap.get("Setting");
                for (Object object2 : newFolderMapSet) {
                    String newValue;
                    Properties newPathProperties;
                    if (!oldFolderMap.containsKey(object2)) {
                        String newKeyName = (String)object2;
                        detailMap = new HashMap<String, Object>();
                        detailMap.put("CHANGE_TYPE", changeType);
                        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                        detailMap.put("SETTING_NAME", newKeyName);
                        if (newKeyName.equalsIgnoreCase("Path") && newSettingString.equals(ADV_SETTING)) {
                            newPathProperties = (Properties)newFolderMap.get(newKeyName);
                            detailMap.put(settingValueString, this.getAdvPathString(newPathProperties));
                        } else {
                            newValue = (String)newFolderMap.get(newKeyName);
                            detailMap.put(settingValueString, newValue);
                        }
                        changeList.add(detailMap);
                        continue;
                    }
                    String keyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("SETTING_NAME", keyName);
                    if (newFolderMap.get(keyName).equals(oldFolderMap.get(keyName))) continue;
                    changeType = 2;
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    settingValueString = "SETTING_NEW_VALUE";
                    if (keyName.equalsIgnoreCase("Path") && newSettingString.equals(ADV_SETTING)) {
                        newPathProperties = (Properties)newFolderMap.get(keyName);
                        detailMap.put(settingValueString, this.getAdvPathString(newPathProperties));
                    } else {
                        newValue = (String)newFolderMap.get(keyName);
                        detailMap.put(settingValueString, newValue);
                    }
                    settingValueString = "SETTING_OLD_VALUE";
                    if (keyName.equalsIgnoreCase("Path") && oldSettingString.equals(ADV_SETTING)) {
                        oldPathProperties = (Properties)oldFolderMap.get(keyName);
                        detailMap.put(settingValueString, this.getAdvPathString(oldPathProperties));
                    } else {
                        oldValue = (String)oldFolderMap.get(keyName);
                        detailMap.put(settingValueString, oldValue);
                    }
                    changeList.add(detailMap);
                }
                for (Object object2 : oldFolderMapSet) {
                    if (newFolderMap.containsKey(object2)) continue;
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                    String oldKeyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", oldKeyName);
                    if (oldKeyName.equalsIgnoreCase("Path") && oldSettingString.equals(ADV_SETTING)) {
                        oldPathProperties = (Properties)oldFolderMap.get(oldKeyName);
                        detailMap.put(settingValueString, this.getAdvPathString(oldPathProperties));
                    } else {
                        oldValue = (String)oldFolderMap.get(oldKeyName);
                        detailMap.put(settingValueString, oldValue);
                    }
                    changeList.add(detailMap);
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    private String getAdvPathString(Properties newPathProperties) {
        StringBuilder path = new StringBuilder();
        int x = 0;
        Enumeration<?> nameEnum = newPathProperties.propertyNames();
        while (nameEnum.hasMoreElements()) {
            String groupName = (String)nameEnum.nextElement();
            if (x > 0) {
                path.append(", ");
            }
            path.append(rb.getString("adap.domain_settings.update_domain_details.actionname.group"));
            path.append(" : ");
            path.append(groupName);
            path.append(" --> ");
            path.append(rb.getString("adap.domain_settings.update_domain_details.actionname.group"));
            path.append(" : ");
            path.append(newPathProperties.getProperty(groupName));
            ++x;
        }
        return path.toString();
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap extnDetailsMap = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                List<Element> folderElements = XMLParserUtil.getChildrenByTagName(element, "Folder");
                if (folderElements == null) continue;
                for (int i = 0; i < folderElements.size(); ++i) {
                    boolean isAdvSetting;
                    Element folderElement = folderElements.get(i);
                    String folderGuid = null;
                    if (XMLParserUtil.getChildElement(folderElement, "Id") != null) {
                        folderGuid = XMLParserUtil.getChildElementText(folderElement, "Id");
                    } else if (XMLParserUtil.getChildElement(folderElement, "Name") != null) {
                        folderGuid = XMLParserUtil.getChildElementText(folderElement, "Name");
                    }
                    if (folderGuid == null) continue;
                    String folderName = this.folderGuidProps.getProperty(folderGuid);
                    String setting = "";
                    HashMap<String, String> folderMap = new HashMap<String, String>();
                    List<Element> locationElements = null;
                    setting = XMLParserUtil.getChildElementText(folderElement, "FollowParent").equalsIgnoreCase("true") ? FOLLOW_SETTING : (XMLParserUtil.getChildElementText(folderElement, "DoNotCare").equalsIgnoreCase("true") ? NC_SETTING : ((isAdvSetting = this.checkAdvSetting(locationElements = XMLParserUtil.getChildrenByTagName(folderElement, "Location"))) ? ADV_SETTING : BASIC_SETTING));
                    if (setting.equals(ADV_SETTING) || setting.equals(BASIC_SETTING)) {
                        Object path = "-";
                        String redirectToLocal = "false";
                        if (XMLParserUtil.getChildElement(folderElement, "RedirectToLocal") != null) {
                            redirectToLocal = XMLParserUtil.getChildElementText(folderElement, "RedirectToLocal");
                        }
                        if (redirectToLocal.equalsIgnoreCase("true")) {
                            path = REDIRECT_LOCAL;
                            setting = BASIC_SETTING;
                        } else {
                            path = setting.equals(BASIC_SETTING) ? this.getPath(locationElements) : this.getPathProperties(locationElements);
                        }
                        folderMap.put("Path", (String)path);
                        for (int j = 0; j < BOOL_PROPS.length; ++j) {
                            folderMap.put(BOOL_PROP_STRGS[j], this.getBooleanSetting(folderElement, BOOL_PROPS[j], "false"));
                        }
                        String policyRemovalBehavior = XMLParserUtil.getChildElementText(folderElement, "PolicyRemovalBehavior");
                        policyRemovalBehavior = policyRemovalBehavior.equalsIgnoreCase("LeaveContents") ? rb.getString("adap.FRSettingsComparator.LeaveContents") : rb.getString("adap.FRSettingsComparator.RemoveContents");
                        folderMap.put(rb.getString("adap.FRSettingsComparator.PolicyRemovalBehavior"), policyRemovalBehavior);
                    }
                    folderMap.put("Setting", setting);
                    extnDetailsMap.put(folderName, folderMap);
                }
            }
        }
        return extnDetailsMap;
    }

    private String getPath(List<Element> locationElements) {
        String destinationPath;
        String path = "-";
        if (locationElements != null && locationElements.size() == 1 && !(destinationPath = XMLParserUtil.getChildElementText(locationElements.get(0), "DestinationPath")).equalsIgnoreCase("")) {
            path = destinationPath;
        }
        return path;
    }

    private Properties getPathProperties(List<Element> locationElements) {
        Properties properties = new Properties();
        if (locationElements != null) {
            for (Element element : locationElements) {
                Element groupElement = XMLParserUtil.getChildElement(element, "SecurityGroup");
                String groupName = XMLParserUtil.getChildElementText(groupElement, "Name");
                String destinationPath = XMLParserUtil.getChildElementText(element, "DestinationPath");
                if (groupName.equalsIgnoreCase("")) continue;
                properties.setProperty(groupName, destinationPath);
            }
        }
        return properties;
    }

    private boolean checkAdvSetting(List<Element> locationElements) {
        boolean isAdvSetting = false;
        if (locationElements != null) {
            if (locationElements.size() == 1) {
                Element groupElement = XMLParserUtil.getChildElement(locationElements.get(0), "SecurityGroup");
                if (groupElement != null && XMLParserUtil.getChildElement(groupElement, "SID") != null && !XMLParserUtil.getChildElementText(groupElement, "SID").equalsIgnoreCase("s-1-1-0")) {
                    isAdvSetting = true;
                }
            } else {
                isAdvSetting = true;
            }
        }
        return isAdvSetting;
    }
}

