/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.IESTRINGS;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;

public class IESComparator
extends DefaultExtensionCompartor {
    private AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public Properties customStringProps = new Properties();
    public Properties customStringValueProps = new Properties();
    public Properties secZoneProps = new Properties();
    public Properties secZoneSiteProps = new Properties();

    public IESComparator() {
        int i;
        for (i = 0; i < IESTRINGS.CUSTOM_STRINGS.length; ++i) {
            this.customStringProps.setProperty(IESTRINGS.CUSTOM_STRINGS[i], IESTRINGS.CUSTOM_DISPLAY_STRINGS[i]);
        }
        for (i = 0; i < IESTRINGS.CUSTOM_STRING_VALUES.length; ++i) {
            this.customStringValueProps.setProperty(IESTRINGS.CUSTOM_STRING_VALUES[i], IESTRINGS.CUSTOM_STRING_DISPLAY_VALUES[i]);
        }
        for (i = 0; i < IESTRINGS.SEC_ZONES.length; ++i) {
            this.secZoneProps.setProperty(IESTRINGS.SEC_ZONES[i], IESTRINGS.SEC_ZONE_KEYS[i]);
            if (IESTRINGS.SEC_ZONE_SITES[i] == null) continue;
            this.secZoneSiteProps.setProperty(IESTRINGS.SEC_ZONES[i], IESTRINGS.SEC_ZONE_SITES[i]);
        }
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        HashMap newDetailsMap = this.getExtnMap(newXMLElementList);
        HashMap oldDetailsMap = this.getExtnMap(oldXMLElementList);
        this.comparePrefMode(newDetailsMap, oldDetailsMap, changeMap);
        this.compareDefaultExtensionMap(newDetailsMap, oldDetailsMap, changeMap, type);
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap<String, String> extnDetailsMap = new HashMap<String, String>();
        Element element = null;
        if (elementList != null && !elementList.isEmpty()) {
            Element extnElement = elementList.get(0);
            element = XMLParserUtil.getChildElement(extnElement, "PreferenceMode");
            String preferenceMode = "false";
            if (element != null) {
                preferenceMode = element.getTextContent();
                extnDetailsMap.put("PreferenceMode", preferenceMode);
            }
            if (!preferenceMode.equalsIgnoreCase("true")) {
                this.setBrowserUISettings(extnDetailsMap, extnElement);
                this.setConnSettings(extnDetailsMap, extnElement);
                this.setURLSettings(extnDetailsMap, extnElement);
                this.setSecuritySettings(extnDetailsMap, extnElement);
                this.setPrograms(extnDetailsMap, extnElement);
            }
        }
        return extnDetailsMap;
    }

    private void comparePrefMode(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap) {
        String newPrefString = (String)newDetailsMap.remove("PreferenceMode");
        Long iemPolicyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId("adap.AUDGPPolicyPathMapping.policy_path.Internet_Explorer_Maintenance", "AudGPPolicyPathMapping:policy_path_id:3");
        int changeType = 1;
        String settingValueString = "SETTING_NEW_VALUE";
        ArrayList changeList = (ArrayList)changeMap.get(iemPolicyPathId);
        if (changeList == null) {
            changeList = new ArrayList();
        }
        if (newPrefString != null && !oldDetailsMap.containsKey("PreferenceMode")) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            detailMap.put("CHANGE_TYPE", changeType);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
            detailMap.put("SETTING_NAME", this.rb.getString("adap.IESComparator.PreferenceMode"));
            detailMap.put(settingValueString, newPrefString);
            changeList.add(detailMap);
        } else {
            String oldPrefString = (String)oldDetailsMap.remove("PreferenceMode");
            if (oldPrefString != null && !oldPrefString.equalsIgnoreCase(newPrefString)) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", changeType);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                detailMap.put("SETTING_NAME", this.rb.getString("adap.IESComparator.PreferenceMode"));
                changeType = 2;
                detailMap.put(settingValueString, newPrefString);
                settingValueString = "SETTING_OLD_VALUE";
                detailMap.put(settingValueString, oldPrefString);
                changeList.add(detailMap);
            }
        }
        if (!changeList.isEmpty()) {
            changeMap.put(iemPolicyPathId, changeList);
        }
    }

    private void setBrowserUISettings(HashMap extnDetailsMap, Element extnElement) {
        this.setValues(extnDetailsMap, extnElement, IESTRINGS.BROWSER_UI_TITLES, IESTRINGS.BROWSER_UI_KEYS, IESTRINGS.BROWSER_UI_SUB_ELEMENTS, IESTRINGS.BROWSER_UI_SUB_ELEMENT_TEXTS);
        List<Element> elementList = XMLParserUtil.getChildrenByTagName(extnElement, "ToolbarButton");
        String[] captions = new String[]{"Caption", "ActionPath", "ColorIconPath", "GrayscaleIconPath", "ShowOnToolbar"};
        String[] captionDispStrings = new String[]{this.rb.getString("adap.IESComparator.Caption"), this.rb.getString("adap.common.text.action"), this.rb.getString("adap.IESComparator.Color_Icon"), this.rb.getString("adap.IESComparator.Grayscale_Icon"), this.rb.getString("adap.IESComparator.Shown_by_default")};
        if (elementList != null && !elementList.isEmpty()) {
            HashMap detailMap = extnDetailsMap.get(IESTRINGS.BROWSER_UI_KEYS[1]) != null ? (HashMap)extnDetailsMap.get(IESTRINGS.BROWSER_UI_KEYS[1]) : new HashMap();
            ArrayList<Properties> captionList = new ArrayList<Properties>();
            for (Element element2 : elementList) {
                Properties properties = new Properties();
                for (int i = 0; i < captions.length; ++i) {
                    properties.setProperty(captionDispStrings[i], XMLParserUtil.getChildElementText(element2, captions[i]));
                }
                captionList.add(properties);
            }
            detailMap.put(captionDispStrings[0], captionList);
            extnDetailsMap.put(IESTRINGS.BROWSER_UI_KEYS[1], detailMap);
        }
    }

    private void setConnSettings(HashMap extnDetailsMap, Element extnElement) {
        this.setValues(extnDetailsMap, extnElement, IESTRINGS.CONN_TTILES, IESTRINGS.CONN_KEYS, IESTRINGS.CONN_SUB_ELEMENTS, IESTRINGS.CONN_SUB_ELEMENT_TEXTS);
        Element element = XMLParserUtil.getChildElement(extnElement, "ProxySettings");
        if (element != null) {
            HashMap detailMap;
            String useSameProxy = XMLParserUtil.getChildElementText(element, "UseSameProxy");
            Element proxyTypeElement = null;
            HashMap hashMap = detailMap = extnDetailsMap.get(IESTRINGS.CONN_KEYS[3]) != null ? (HashMap)extnDetailsMap.get(IESTRINGS.CONN_KEYS[3]) : new HashMap();
            if (useSameProxy.equalsIgnoreCase("true")) {
                for (String proxyType : IESTRINGS.PROXY_TYPES) {
                    if (XMLParserUtil.getChildElement(element, proxyType) == null) continue;
                    proxyTypeElement = XMLParserUtil.getChildElement(element, proxyType);
                    break;
                }
                for (int i = 0; i < IESTRINGS.PROXY_TYPES.length; ++i) {
                    String addressText = XMLParserUtil.getChildElementText(proxyTypeElement, "Address");
                    String portText = XMLParserUtil.getChildElementText(proxyTypeElement, "Port");
                    detailMap.put(IESTRINGS.PROXY_TYPE_STRINGS[i], this.rb.handleGetObject("adap.IESComparator.Address_Port", new String[]{addressText, portText}));
                }
            } else {
                for (int i = 0; i < IESTRINGS.PROXY_TYPES.length; ++i) {
                    proxyTypeElement = XMLParserUtil.getChildElement(element, IESTRINGS.PROXY_TYPES[i]);
                    String addressText = XMLParserUtil.getChildElementText(proxyTypeElement, "Address");
                    String portText = XMLParserUtil.getChildElementText(proxyTypeElement, "Port");
                    detailMap.put(IESTRINGS.PROXY_TYPE_STRINGS[i], this.rb.handleGetObject("adap.IESComparator.Address_Port", new String[]{addressText, portText}));
                }
            }
            extnDetailsMap.put(IESTRINGS.CONN_KEYS[3], detailMap);
        }
    }

    private void setURLSettings(HashMap extnDetailsMap, Element extnElement) {
        int i;
        List<Element> elementList = null;
        Element element = null;
        HashMap detailMap = null;
        detailMap = extnDetailsMap.get("adap.AUDGPPolicyPathMapping.policy_path.Favorites_and_Links") != null ? (HashMap)extnDetailsMap.get("adap.AUDGPPolicyPathMapping.policy_path.Favorites_and_Links") : new HashMap();
        for (int i2 = 0; i2 < IESTRINGS.FAV_URLS.length; ++i2) {
            elementList = XMLParserUtil.getChildrenByTagName(extnElement, IESTRINGS.FAV_URLS[i2]);
            if (elementList == null) continue;
            StringBuilder urlBuilder = new StringBuilder();
            if (elementList.isEmpty()) continue;
            for (int j = 0; j < elementList.size(); ++j) {
                element = elementList.get(j);
                if (j > 0) {
                    urlBuilder.append(",");
                }
                urlBuilder.append(XMLParserUtil.getChildElementText(element, "Name"));
                urlBuilder.append("(");
                urlBuilder.append(XMLParserUtil.getChildElementText(element, "URL"));
                urlBuilder.append(")");
            }
            detailMap.put(IESTRINGS.FAV_URL_STRINGS[i2], urlBuilder.toString());
        }
        String[] booleanProps = new String[]{"PlaceFavoritesAtTop", "DeleteFavorites", "DeleteAdminFavoritesOnly", "DeleteChannels"};
        String[] booleanDisplayProps = new String[]{this.rb.getString("adpa.IESComparator.PlaceFavoritesAtTop"), this.rb.getString("adpa.IESComparator.DeleteFavorites"), this.rb.getString("adpa.IESComparator.DeleteAdminFavoritesOnly"), this.rb.getString("adpa.IESComparator.DeleteChannels")};
        for (i = 0; i < booleanProps.length; ++i) {
            element = null;
            element = XMLParserUtil.getChildElement(extnElement, booleanProps[i]);
            if (element == null) continue;
            String booleanValue = XMLParserUtil.getChildElementText(element, "Value");
            detailMap.put(booleanDisplayProps[i], this.getBooleanValue(booleanValue));
        }
        if (!detailMap.isEmpty()) {
            extnDetailsMap.put("adap.AUDGPPolicyPathMapping.policy_path.Favorites_and_Links", detailMap);
        }
        detailMap = extnDetailsMap.get("adap.AUDGPPolicyPathMapping.policy_path.Important_URLs") != null ? (HashMap)extnDetailsMap.get("adap.AUDGPPolicyPathMapping.policy_path.Important_URLs") : new HashMap();
        for (i = 0; i < IESTRINGS.IMP_URLS.length; ++i) {
            element = null;
            element = XMLParserUtil.getChildElement(extnElement, IESTRINGS.IMP_URLS[i]);
            if (element == null) continue;
            detailMap.put(IESTRINGS.IMP_URL_STRINGS[i], XMLParserUtil.getChildElementText(element, "Value"));
        }
        if (!detailMap.isEmpty()) {
            extnDetailsMap.put("adap.AUDGPPolicyPathMapping.policy_path.Important_URLs", detailMap);
        }
    }

    private void setPrograms(HashMap extnDetailsMap, Element extnElement) {
        String progKey = "adap.AUDGPPolicyPathMapping.policy_path.Programs";
        Element programElement = XMLParserUtil.getChildElement(extnElement, "Programs");
        if (programElement != null) {
            HashMap detailMap = extnDetailsMap.get(progKey) != null ? (HashMap)extnDetailsMap.get(progKey) : new HashMap();
            List<Element> elements = XMLParserUtil.getAllChildElements(programElement);
            for (Element element : elements) {
                detailMap.put(element.getLocalName(), element.getTextContent());
            }
            extnDetailsMap.put(progKey, detailMap);
        }
    }

    private void setSecuritySettings(HashMap extnDetailsMap, Element extnElement) {
        Element zonePrivacyElement = XMLParserUtil.getChildElement(extnElement, "EscOnSecurityZoneAndPrivacy");
        if (zonePrivacyElement != null) {
            Element privacyElement;
            List<Element> elementList = XMLParserUtil.getChildrenByTagName(zonePrivacyElement, "ZoneSettings");
            if (!elementList.isEmpty()) {
                for (Element zoneElement : elementList) {
                    String name = XMLParserUtil.getChildElementText(zoneElement, "Name");
                    String secLevel = XMLParserUtil.getChildElementText(zoneElement, "SecurityLevel");
                    List<Element> customStringElements = XMLParserUtil.getChildrenByTagName(zoneElement, "CustomSetting");
                    String secZoneKey = this.secZoneProps.getProperty(name);
                    HashMap detailMap = extnDetailsMap.get(secZoneKey) != null ? (HashMap)extnDetailsMap.get(secZoneKey) : new HashMap();
                    detailMap.put(this.rb.getString("adap.IESComparator.SecurityLevel"), secLevel);
                    for (Element csElement : customStringElements) {
                        String csName = this.customStringProps.getProperty(XMLParserUtil.getChildElementText(csElement, "Name"));
                        String value = XMLParserUtil.getChildElementText(csElement, "Value");
                        if (this.customStringValueProps.getProperty(value) != null) {
                            value = this.customStringValueProps.getProperty(value);
                        }
                        detailMap.put(csName, value);
                    }
                    if (this.secZoneSiteProps.getProperty(name) != null) {
                        detailMap.put(this.rb.getString("adap.IESComparator.Sites"), this.getSites(XMLParserUtil.getChildrenByTagName(extnElement, this.secZoneSiteProps.getProperty(name))));
                    }
                    extnDetailsMap.put(secZoneKey, detailMap);
                }
            }
            if ((privacyElement = XMLParserUtil.getChildElement(zonePrivacyElement, "Privacy")) != null) {
                String privacyKey = "adap.AUDGPPolicyPathMapping.policy_path.Privacy";
                HashMap detailMap = extnDetailsMap.get(privacyKey) != null ? (HashMap)extnDetailsMap.get(privacyKey) : new HashMap();
                for (int i = 0; i < IESTRINGS.PRIVACY_PROPS.length; ++i) {
                    detailMap.put(IESTRINGS.PRIVACY_PROP_STRINGS[i], XMLParserUtil.getChildElementText(privacyElement, IESTRINGS.PRIVACY_PROPS[i]));
                }
                List<Element> elements = null;
                elements = XMLParserUtil.getChildrenByTagName(extnElement, "EscOnAllowCookiesFromSites");
                if (!elements.isEmpty()) {
                    detailMap.put(this.rb.getString("adap.IESComparator.EscOnAllowCookiesFromSites"), this.getSites(XMLParserUtil.getChildrenByTagName(extnElement, "EscOnAllowCookiesFromSites")));
                }
                if (!(elements = XMLParserUtil.getChildrenByTagName(extnElement, "EscOnBlockCookiesFromSites")).isEmpty()) {
                    detailMap.put(this.rb.getString("adap.IESComparator.EscOnBlockCookiesFromSites"), this.getSites(XMLParserUtil.getChildrenByTagName(extnElement, "EscOnBlockCookiesFromSites")));
                }
                extnDetailsMap.put(privacyKey, detailMap);
            }
        }
    }

    private String getSites(List<Element> siteElements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < siteElements.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(XMLParserUtil.getChildElementText(siteElements.get(i), "Value"));
        }
        return builder.toString();
    }

    private void setValues(HashMap extnDetailsMap, Element extnElement, String[] titles, String[] keys, String[][] subelements, String[][] subelementText) {
        Element element = null;
        for (int i = 0; i < titles.length; ++i) {
            element = XMLParserUtil.getChildElement(extnElement, titles[i]);
            if (element == null) continue;
            HashMap detailMap = extnDetailsMap.get(keys[i]) != null ? (HashMap)extnDetailsMap.get(keys[i]) : new HashMap();
            for (int j = 0; j < subelements[i].length; ++j) {
                detailMap.put(subelementText[i][j], XMLParserUtil.getChildElementText(element, subelements[i][j]));
            }
            extnDetailsMap.put(keys[i], detailMap);
        }
    }
}

