/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PrefComparator
extends DefaultExtensionCompartor {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String exynType, int index) {
        this.compareDefaultExtensionMap(this.getExtnMap(newXMLElementList, index), this.getExtnMap(oldXMLElementList, index), changeMap, true, type, index);
        this.compareDefaultExtensionMap(this.getExtnMap(oldXMLElementList, index), this.getExtnMap(newXMLElementList, index), changeMap, false, type, index);
    }

    private HashMap getExtnMap(List<Element> elementList, int index) {
        HashMap extnDetailsMap = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                Element prefExtnElement = XMLParserUtil.getChildElement(element, GPOUtil.SIMPLE_PREF_EXTN_SUB_HEADINGS[index]);
                if (prefExtnElement == null) continue;
                for (String subElementName : GPOUtil.SIMPLE_PREF_EXTN_SUB_ELEMENTS[index]) {
                    List<Element> childElements = XMLParserUtil.getChildrenByTagName(prefExtnElement, subElementName);
                    if (childElements == null || childElements.size() <= 0) continue;
                    for (Element subElement : childElements) {
                        NamedNodeMap attributeMap = subElement.getAttributes();
                        Node uidNode = attributeMap.getNamedItem("uid");
                        Node nameNode = attributeMap.getNamedItem("name");
                        if (uidNode == null) continue;
                        String uid = uidNode.getNodeValue();
                        String name = nameNode.getNodeValue();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        for (int j = 0; j < attributeMap.getLength(); ++j) {
                            Node node = attributeMap.item(j);
                            hashMap.put(node.getLocalName(), node.getNodeValue());
                        }
                        hashMap.put("GPOSettingOrder", XMLParserUtil.getChildElementText(subElement, "GPOSettingOrder"));
                        this.setProperties(subElement, hashMap);
                        this.setFilters(subElement, hashMap);
                        extnDetailsMap.put(subElementName + " - Name: " + name + " , uid: " + uid, hashMap);
                    }
                }
            }
        }
        return extnDetailsMap;
    }

    private void setProperties(Element subElement, HashMap hashMap) {
        Element propertiesNode = XMLParserUtil.getChildElement(subElement, "Properties");
        NamedNodeMap attributeMap = propertiesNode.getAttributes();
        for (int j = 0; j < attributeMap.getLength(); ++j) {
            Node node = attributeMap.item(j);
            String nodeValue = node.getNodeValue();
            if (node.getLocalName().equalsIgnoreCase("action")) {
                if (nodeValue.equalsIgnoreCase("C")) {
                    nodeValue = RB.getString("adap.AUDAccessTypes.access_type_string_failure.Create");
                } else if (nodeValue.equalsIgnoreCase("R")) {
                    nodeValue = RB.getString("adap.PrefComaparator.Replace");
                } else if (nodeValue.equalsIgnoreCase("U")) {
                    nodeValue = RB.getString("adap.common.button.update");
                } else if (nodeValue.equalsIgnoreCase("D")) {
                    nodeValue = RB.getString("adap.AUDAccessTypes.access_type_string_failure.Delete");
                }
            }
            hashMap.put(RB.getString("adap.PrefComaparator.Properties") + "/" + node.getLocalName(), nodeValue);
        }
    }

    private void setFilters(Element subElement, HashMap hashMap) {
        Element filtersNode = XMLParserUtil.getChildElement(subElement, "Filters");
        if (filtersNode != null && filtersNode.hasChildNodes()) {
            StringBuffer filterBuffer = new StringBuffer();
            List<Element> childElements = XMLParserUtil.getAllChildElements(filtersNode);
            for (Element element : childElements) {
                this.setFilterString(element, filterBuffer);
            }
            hashMap.put("Filters", filterBuffer.toString());
        }
    }

    private void setFilterString(Element filtersNode, StringBuffer filterBuffer) {
        String isNot = filtersNode.getAttribute("not");
        String bool = filtersNode.getAttribute("bool");
        if (!filterBuffer.toString().equals("")) {
            filterBuffer.append(bool);
        }
        if (isNot.equalsIgnoreCase("1")) {
            filterBuffer.append("!");
        }
        filterBuffer.append("(");
        if (filtersNode.getLocalName().equalsIgnoreCase("FilterCollection")) {
            List<Element> childElements = XMLParserUtil.getAllChildElements(filtersNode);
            for (Element element : childElements) {
                this.setFilterString(element, filterBuffer);
            }
        } else {
            String filterName = filtersNode.getLocalName();
            NamedNodeMap attributeMap = filtersNode.getAttributes();
            filterBuffer.append(filterName);
            for (int j = 0; j < attributeMap.getLength(); ++j) {
                Node node = attributeMap.item(j);
                String nodename = node.getNodeName();
                String nodeValue = node.getNodeValue();
                if (j > 0) {
                    filterBuffer.append(", ");
                }
                filterBuffer.append(" ");
                filterBuffer.append(nodename);
                filterBuffer.append("=");
                filterBuffer.append(nodeValue);
            }
        }
        filterBuffer.append(")");
    }

    private void compareDefaultExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, boolean checkModify, String type, int index) {
        Set newKeySet = newDetailsMap.keySet();
        String pattern = "AudGPPolicyPathMapping:policy_path_id:2";
        Long parentPolicyId = GPOUtil.COMP_PREF_PATH_ID[index];
        if (type.equalsIgnoreCase("user")) {
            pattern = "AudGPPolicyPathMapping:policy_path_id:3";
            parentPolicyId = GPOUtil.USER_PREF_PATH_ID[index];
        }
        for (Object object : newKeySet) {
            HashMap newFolderMap = (HashMap)newDetailsMap.get(object);
            Set newFolderMapSet = newFolderMap.keySet();
            String folderName = (String)object;
            Long policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(folderName, parentPolicyId, pattern);
            ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                if (!checkModify) {
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                }
                for (Object object2 : newFolderMapSet) {
                    String newKeyName = (String)object2;
                    HashMap<String, Object> detailMap = new HashMap<String, Object>();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", newKeyName);
                    detailMap.put(settingValueString, newFolderMap.get(newKeyName));
                    changeList.add(detailMap);
                }
            } else if (checkModify) {
                HashMap<String, Object> detailMap;
                HashMap oldFolderMap = (HashMap)oldDetailsMap.get(object);
                Set oldFolderMapSet = oldFolderMap.keySet();
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                for (Object object2 : newFolderMapSet) {
                    if (!oldFolderMap.containsKey(object2)) {
                        String newKeyName = (String)object2;
                        detailMap = new HashMap<String, Object>();
                        detailMap.put("CHANGE_TYPE", changeType);
                        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                        detailMap.put("SETTING_NAME", newKeyName);
                        detailMap.put(settingValueString, newFolderMap.get(newKeyName));
                        changeList.add(detailMap);
                        continue;
                    }
                    String keyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("SETTING_NAME", keyName);
                    if (newFolderMap.get(keyName).equals(oldFolderMap.get(keyName))) continue;
                    changeType = 2;
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    settingValueString = "SETTING_NEW_VALUE";
                    detailMap.put(settingValueString, newFolderMap.get(keyName));
                    settingValueString = "SETTING_OLD_VALUE";
                    detailMap.put(settingValueString, oldFolderMap.get(keyName));
                    changeList.add(detailMap);
                }
                for (Object object2 : oldFolderMapSet) {
                    if (newFolderMap.containsKey(object2)) continue;
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                    String oldKeyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", oldKeyName);
                    detailMap.put(settingValueString, oldFolderMap.get(oldKeyName));
                    changeList.add(detailMap);
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }
}

