/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;

public class ScriptsComparator
extends DefaultExtensionCompartor {
    private static final String SCRIPT_STARTUP_UVH = "AudGPPolicyPathMapping:policy_path_id:212101";
    private static final String SCRIPT_SHUTDOWN_UVH = "AudGPPolicyPathMapping:policy_path_id:212102";
    private static final String SCRIPT_LOGON_UVH = "AudGPPolicyPathMapping:policy_path_id:312101";
    private static final String SCRIPT_LOGOFF_UVH = "AudGPPolicyPathMapping:policy_path_id:312102";
    private static final String[] UVH_STRINGS = new String[]{"AudGPPolicyPathMapping:policy_path_id:212101", "AudGPPolicyPathMapping:policy_path_id:212102", "AudGPPolicyPathMapping:policy_path_id:312101", "AudGPPolicyPathMapping:policy_path_id:312102"};
    private static final String[] SCRIPT_TYPE_STRINGS = new String[]{"Startup", "Shutdown", "Logon", "Logoff"};
    private static final String[] SCRIPT_PROPS = new String[]{"Command", "Parameters", "Type", "Order", "RunOrder"};
    private static HashMap<String, Long> uvhMap = null;

    public ScriptsComparator() {
        this.getUVHMap();
    }

    private void getUVHMap() {
        uvhMap = new HashMap();
        for (int i = 0; i < UVH_STRINGS.length; ++i) {
            Long uvhValue = DBObjectUtil.getUVHValues("AudGPPolicyPathMapping", UVH_STRINGS[i]);
            uvhMap.put(SCRIPT_TYPE_STRINGS[i], uvhValue);
        }
    }

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        HashMap newDetailsMap = this.getExtnMap(newXMLElementList);
        HashMap oldDetailsMap = this.getExtnMap(oldXMLElementList);
        this.compareExtensionMap(newDetailsMap, oldDetailsMap, changeMap);
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap<String, Properties> extnDetailsMap = new HashMap<String, Properties>();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                List<Element> scripElementList = XMLParserUtil.getChildrenByTagName(element, "Script");
                for (Element element2 : scripElementList) {
                    Properties properties = new Properties();
                    for (String scriptProp : SCRIPT_PROPS) {
                        Element element3 = XMLParserUtil.getChildElement(element2, scriptProp);
                        if (element3 == null) continue;
                        properties.setProperty(scriptProp, element3.getTextContent());
                    }
                    String command = properties.getProperty("Command");
                    extnDetailsMap.put(command, properties);
                }
            }
        }
        return extnDetailsMap;
    }

    private String getScriptParams(Properties properties) {
        String value = "";
        if (properties.getProperty("Parameters") != null) {
            value = value + "Parameters : " + properties.getProperty("Parameters") + ", ";
        }
        value = value + "Order : " + properties.getProperty("Order");
        String psValue = properties.getProperty("RunOrder");
        if (psValue != null) {
            psValue = psValue.equalsIgnoreCase("RunPSFirst") ? "Windows PowerShell scripts will run first" : (psValue.equalsIgnoreCase("RunPSSecond") ? "Windows PowerShell scripts will run last" : "Not configured");
            value = value + ", Script order: " + psValue;
        }
        return value;
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap) {
        HashMap<String, Object> detailMap;
        ArrayList<HashMap<String, Object>> changeList;
        Long policyPathId;
        String type;
        Set newKeySet = newDetailsMap.keySet();
        Set oldKeySet = oldDetailsMap.keySet();
        for (Object object : newKeySet) {
            Properties oldValueProp;
            Properties newValueProp;
            if (!oldDetailsMap.containsKey(object)) {
                newValueProp = (Properties)newDetailsMap.get(object);
                type = newValueProp.getProperty("Type");
                policyPathId = uvhMap.get(type);
                changeList = (ArrayList<HashMap<String, Object>>)changeMap.get(policyPathId);
                if (changeList == null) {
                    changeList = new ArrayList<HashMap<String, Object>>();
                }
                detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", 1);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                detailMap.put("SETTING_NAME", newValueProp.getProperty("Command"));
                detailMap.put("SETTING_NEW_VALUE", this.getScriptParams(newValueProp));
                changeList.add(detailMap);
                if (changeList.isEmpty()) continue;
                changeMap.put(policyPathId, changeList);
                continue;
            }
            newValueProp = (Properties)newDetailsMap.get(object);
            if (newValueProp.equals(oldValueProp = (Properties)oldDetailsMap.get(object))) continue;
            String type2 = newValueProp.getProperty("Type");
            Long policyPathId2 = uvhMap.get(type2);
            ArrayList changeList2 = (ArrayList)changeMap.get(policyPathId2);
            if (changeList2 == null) {
                changeList2 = new ArrayList();
            }
            HashMap<String, Object> detailMap2 = new HashMap<String, Object>();
            detailMap2.put("CHANGE_TYPE", 2);
            detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
            detailMap2.put("SETTING_NAME", newValueProp.getProperty("Command"));
            String valueString = (String)newDetailsMap.get("SettingValue");
            detailMap2.put("SETTING_NEW_VALUE", this.getScriptParams(newValueProp));
            detailMap2.put("SETTING_OLD_VALUE", this.getScriptParams(oldValueProp));
            changeList2.add(detailMap2);
            if (changeList2.isEmpty()) continue;
            changeMap.put(policyPathId2, changeList2);
        }
        for (Object object : oldKeySet) {
            if (newDetailsMap.containsKey(object)) continue;
            Properties oldValueProp = (Properties)oldDetailsMap.get(object);
            type = oldValueProp.getProperty("Type");
            policyPathId = uvhMap.get(type);
            changeList = (ArrayList<HashMap<String, Object>>)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList<HashMap<String, Object>>();
            }
            detailMap = new HashMap();
            detailMap.put("CHANGE_TYPE", 3);
            detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
            detailMap.put("SETTING_NAME", oldValueProp.getProperty("Command"));
            detailMap.put("SETTING_OLD_VALUE", this.getScriptParams(oldValueProp));
            changeList.add(detailMap);
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }
}

