/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.SecurityComparatorUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityComparator
extends DefaultExtensionCompartor {
    private HashMap secPolicyKeyMap = SecurityComparatorUtil.getPolicyKeyPathMap();
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        if (extnType.equals("SecuritySettings")) {
            this.compareExtensionMap(this.getExtnMap(newXMLElementList), this.getExtnMap(oldXMLElementList), changeMap);
            this.compareDefaultExtensionMap(this.getDefaultExtnMap(newXMLElementList), this.getDefaultExtnMap(oldXMLElementList), changeMap, type);
        } else if (extnType.equals("SoftwareRestrictionSettings")) {
            this.compareDefaultExtensionMap(SecurityComparatorUtil.getSRExtnMap(newXMLElementList), SecurityComparatorUtil.getSRExtnMap(oldXMLElementList), changeMap, type);
        } else if (extnType.equals("Policy")) {
            HashMap newACPolicyMap = this.getACPolicySettings(newXMLElementList);
            HashMap oldACPolicyMap = this.getACPolicySettings(oldXMLElementList);
            this.compareACPExtensionMap(newACPolicyMap, oldACPolicyMap, changeMap, type);
        } else if (extnType.equals("WLanSvcSettings")) {
            HashMap h1 = SecurityComparatorUtil.getWLANSettings(newXMLElementList);
            HashMap h2 = SecurityComparatorUtil.getWLANSettings(oldXMLElementList);
            this.compareWLANExtensionMap(h1, h2, changeMap);
        }
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap) {
        String settingName;
        HashMap<String, Object> childDetailsMap;
        Set childKeySet;
        String value;
        HashMap<String, Object> detailMap;
        ArrayList changeList;
        Long policyPathId;
        HashMap policyKeyPath;
        Set newKeySet = newDetailsMap.keySet();
        Set oldKeySet = oldDetailsMap.keySet();
        for (Object object : newKeySet) {
            policyKeyPath = (HashMap)this.secPolicyKeyMap.get(object);
            policyPathId = (Long)policyKeyPath.get("POLICY_PATH_ID");
            changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                detailMap = new HashMap<String, Object>();
                detailMap.put("CHANGE_TYPE", 1);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                detailMap.put("SETTING_NAME", policyKeyPath.get("POLICY_NAME"));
                if (newDetailsMap.get(object) instanceof String) {
                    value = (String)newDetailsMap.get(object);
                    if (policyKeyPath.get("POLICY_UNIT") != null) {
                        value = value + " " + policyKeyPath.get("POLICY_UNIT");
                    }
                    detailMap.put("SETTING_NEW_VALUE", value);
                    changeList.add(detailMap);
                } else if (newDetailsMap.get(object) instanceof ArrayList) {
                    detailMap.put("SETTING_NEW_VALUE", newDetailsMap.get(object).toString());
                    changeList.add(detailMap);
                } else if (newDetailsMap.get(object) instanceof HashMap) {
                    detailMap.put("SETTING_NEW_VALUE", "Enabled");
                    changeList.add(detailMap);
                    HashMap newChildMap = (HashMap)newDetailsMap.get(object);
                    childKeySet = newChildMap.keySet();
                    for (Object object2 : childKeySet) {
                        childDetailsMap = new HashMap<String, Object>();
                        childDetailsMap.put("CHANGE_TYPE", 1);
                        childDetailsMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                        settingName = (String)policyKeyPath.get("POLICY_NAME") + " / " + (String)object2;
                        childDetailsMap.put("SETTING_NAME", settingName);
                        childDetailsMap.put("SETTING_NEW_VALUE", newChildMap.get(object2));
                        changeList.add(childDetailsMap);
                    }
                }
            } else {
                Object oldValueObject;
                Object newValueObject = newDetailsMap.get(object);
                if (!newValueObject.equals(oldValueObject = oldDetailsMap.get(object))) {
                    String oldValue;
                    String newValue;
                    HashMap<String, Object> detailMap2 = new HashMap<String, Object>();
                    detailMap2.put("CHANGE_TYPE", 2);
                    detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
                    detailMap2.put("SETTING_NAME", policyKeyPath.get("POLICY_NAME"));
                    if (newValueObject instanceof String) {
                        newValue = (String)newValueObject;
                        oldValue = (String)oldValueObject;
                        if (!newValue.equalsIgnoreCase(oldValue)) {
                            if (policyKeyPath.get("POLICY_UNIT") != null) {
                                newValue = newValue + " " + policyKeyPath.get("POLICY_UNIT");
                                oldValue = oldValue + " " + policyKeyPath.get("POLICY_UNIT");
                            }
                            detailMap2.put("SETTING_NEW_VALUE", newValue);
                            detailMap2.put("SETTING_OLD_VALUE", oldValue);
                            changeList.add(detailMap2);
                        }
                    } else if (newValueObject instanceof ArrayList) {
                        newValue = newValueObject;
                        oldValue = oldValueObject;
                        if (!newValue.equals(oldValue)) {
                            detailMap2.put("SETTING_NEW_VALUE", newValue.toString());
                            detailMap2.put("SETTING_OLD_VALUE", oldValue.toString());
                            changeList.add(detailMap2);
                        }
                    } else if (newValueObject instanceof HashMap && !newValueObject.equals(oldValueObject)) {
                        HashMap newChildMap = (HashMap)newDetailsMap.get(object);
                        HashMap oldChildMap = (HashMap)oldDetailsMap.get(object);
                        Set childKeySet2 = newChildMap.keySet();
                        for (Object object2 : childKeySet2) {
                            HashMap<String, Object> childDetailsMap2 = new HashMap<String, Object>();
                            childDetailsMap2.put("CHANGE_TYPE", 2);
                            childDetailsMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
                            String settingName2 = (String)policyKeyPath.get("POLICY_NAME") + " / " + (String)object2;
                            childDetailsMap2.put("SETTING_NAME", settingName2);
                            if (oldChildMap.get(object2).equals(newChildMap.get(object2))) continue;
                            childDetailsMap2.put("SETTING_OLD_VALUE", oldChildMap.get(object2));
                            childDetailsMap2.put("SETTING_NEW_VALUE", newChildMap.get(object2));
                            changeList.add(childDetailsMap2);
                        }
                    }
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
        for (Object object : oldKeySet) {
            policyKeyPath = (HashMap)this.secPolicyKeyMap.get(object);
            policyPathId = (Long)policyKeyPath.get("POLICY_PATH_ID");
            changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!newDetailsMap.containsKey(object)) {
                detailMap = new HashMap();
                detailMap.put("CHANGE_TYPE", 3);
                detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                detailMap.put("SETTING_NAME", policyKeyPath.get("POLICY_NAME"));
                if (oldDetailsMap.get(object) instanceof String) {
                    value = (String)oldDetailsMap.get(object);
                    if (policyKeyPath.get("POLICY_UNIT") != null) {
                        value = value + " " + policyKeyPath.get("POLICY_UNIT");
                    }
                    detailMap.put("SETTING_OLD_VALUE", value);
                    changeList.add(detailMap);
                } else if (oldDetailsMap.get(object) instanceof ArrayList) {
                    detailMap.put("SETTING_OLD_VALUE", oldDetailsMap.get(object).toString());
                    changeList.add(detailMap);
                } else if (oldDetailsMap.get(object) instanceof HashMap) {
                    detailMap.put("SETTING_OLD_VALUE", "Enabled");
                    changeList.add(detailMap);
                    HashMap oldChildMap = (HashMap)oldDetailsMap.get(object);
                    childKeySet = oldChildMap.keySet();
                    for (Object object2 : childKeySet) {
                        childDetailsMap = new HashMap();
                        childDetailsMap.put("CHANGE_TYPE", 3);
                        childDetailsMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                        settingName = (String)policyKeyPath.get("POLICY_NAME") + " / " + (String)object2;
                        childDetailsMap.put("SETTING_NAME", settingName);
                        childDetailsMap.put("SETTING_OLD_VALUE", oldChildMap.get(object2));
                        changeList.add(childDetailsMap);
                    }
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    private void setAccountOptions(Element elementNode, HashMap extnDetailsMap) {
        Element nameNode = XMLParserUtil.getChildElement(elementNode, "Name");
        if (XMLParserUtil.getChildElement(elementNode, "SettingBoolean") != null) {
            String value = XMLParserUtil.getChildElement(elementNode, "SettingBoolean").getTextContent();
            value = this.getBooleanValue(value);
            extnDetailsMap.put(nameNode.getTextContent().toLowerCase(), value);
        } else if (XMLParserUtil.getChildElement(elementNode, "SettingNumber") != null) {
            String value = XMLParserUtil.getChildElement(elementNode, "SettingNumber").getTextContent();
            extnDetailsMap.put(nameNode.getTextContent().toLowerCase(), value);
        }
    }

    private void setAuditOptions(Element elementNode, HashMap extnDetailsMap) {
        Element nameNode = XMLParserUtil.getChildElement(elementNode, "Name");
        String successString = XMLParserUtil.getChildElement(elementNode, "SuccessAttempts").getTextContent();
        String failureString = XMLParserUtil.getChildElement(elementNode, "FailureAttempts").getTextContent();
        String valueString = "";
        if (successString.equalsIgnoreCase("true")) {
            valueString = "Success";
        }
        if (failureString.equalsIgnoreCase("true")) {
            if (!valueString.equals("")) {
                valueString = valueString + ", ";
            }
            valueString = valueString + "Failure";
        }
        extnDetailsMap.put(nameNode.getTextContent().toLowerCase(), valueString);
    }

    private void setUserRightsAssignment(Element elementNode, HashMap extnDetailsMap) {
        List<Element> memberList = XMLParserUtil.getChildrenByTagName(elementNode, "Member");
        Element nameNode = XMLParserUtil.getChildElement(elementNode, "Name");
        String name = nameNode.getChildNodes().item(0).getTextContent();
        extnDetailsMap.put(name.toLowerCase(), this.getMemberList(memberList));
    }

    private void setSecurityOptions(Element elementNode, HashMap extnDetailsMap) {
        Element keyNameNode = XMLParserUtil.getChildElement(elementNode, "KeyName");
        if (keyNameNode != null) {
            Element displayNameNode = XMLParserUtil.getChildElement(elementNode, "Display");
            if (displayNameNode != null) {
                Object value = SecurityComparatorUtil.getDisplaySettings(displayNameNode);
                String keyNameString = keyNameNode.getChildNodes().item(0).getTextContent();
                extnDetailsMap.put(keyNameString.toLowerCase(), value);
            }
        } else {
            Element sapnNode = XMLParserUtil.getChildElement(elementNode, "SystemAccessPolicyName");
            Element settingNode = XMLParserUtil.getChildElement(elementNode, "SettingNumber");
            String settingValue = "false";
            if (settingNode != null) {
                String settingNumber = settingNode.getTextContent();
                settingValue = this.getBooleanValue(settingNumber);
                extnDetailsMap.put(sapnNode.getTextContent().toLowerCase(), settingValue);
            } else {
                settingNode = XMLParserUtil.getChildElement(elementNode, "SettingString");
                settingValue = settingNode.getTextContent();
                extnDetailsMap.put(sapnNode.getTextContent().toLowerCase(), settingValue);
            }
        }
    }

    private void setEventLogSettings(Element elementNode, HashMap extnDetailsMap) {
        Element nameNode = XMLParserUtil.getChildElement(elementNode, "Name");
        Element logNode = XMLParserUtil.getChildElement(elementNode, "Log");
        String name = nameNode.getChildNodes().item(0).getTextContent();
        String logName = logNode.getChildNodes().item(0).getTextContent();
        String keyNameString = name + "\\" + logName;
        Element settingNode = XMLParserUtil.getChildElement(elementNode, "SettingNumber");
        String value = "-";
        if (settingNode != null) {
            String settingNumber = settingNode.getTextContent();
            if (name.equalsIgnoreCase("AuditLogRetentionPeriod")) {
                if (settingNumber.equalsIgnoreCase("0")) {
                    value = "As Needed";
                } else if (settingNumber.equalsIgnoreCase("1")) {
                    value = "By days";
                } else if (settingNumber.equalsIgnoreCase("2")) {
                    value = "Manually";
                }
            } else {
                value = settingNumber;
            }
        } else {
            settingNode = XMLParserUtil.getChildElement(elementNode, "SettingBoolean");
            if (settingNode != null) {
                String settingBoolean = settingNode.getTextContent();
                value = settingBoolean = this.getBooleanValue(settingBoolean);
            }
        }
        extnDetailsMap.put(keyNameString.toLowerCase(), value);
    }

    private void setRestrictedGroups(List<Element> elementList, HashMap extnDetailsMap) {
        if (!elementList.isEmpty()) {
            String resGroupkey = "adap.AUDGPPolicyPathMapping.policy_path.Restricted_Groups";
            HashMap detailMap = extnDetailsMap.get(resGroupkey) != null ? (HashMap)extnDetailsMap.get(resGroupkey) : new HashMap();
            for (Element element : elementList) {
                List<Element> list = null;
                list = XMLParserUtil.getChildrenByTagName(element, "GroupName");
                String groupName = this.getMemberDetails(list);
                StringBuilder builder = new StringBuilder();
                builder.append(rb.getString("adap.ADSMAttributeDetails.attrib_disp_name.Members_Name"));
                builder.append(" :: ");
                list = XMLParserUtil.getChildrenByTagName(element, "Member");
                builder.append(this.getMemberDetails(list));
                builder.append(", ");
                builder.append(rb.getString("adap.ADSMAttributeDetails.attrib_disp_name.Member_Of"));
                builder.append(" :: ");
                list = XMLParserUtil.getChildrenByTagName(element, "Memberof");
                builder.append(this.getMemberDetails(list));
                detailMap.put(groupName, builder.toString());
            }
            extnDetailsMap.put(resGroupkey, detailMap);
        }
    }

    private void setSystemServices(List<Element> elementList, HashMap extnDetailsMap) {
        if (!elementList.isEmpty()) {
            String ssGroupkey = "adap.AUDGPPolicyPathMapping.policy_path.System_Services";
            HashMap detailMap = extnDetailsMap.get(ssGroupkey) != null ? (HashMap)extnDetailsMap.get(ssGroupkey) : new HashMap();
            for (Element element : elementList) {
                detailMap.put(XMLParserUtil.getChildElementText(element, "Name"), XMLParserUtil.getChildElementText(element, "StartupMode"));
            }
            extnDetailsMap.put(ssGroupkey, detailMap);
        }
    }

    private void setFileRegistrySettings(List<Element> elementList, HashMap extnDetailsMap, String type) {
        String keyName = "adap.AUDGPPolicyPathMapping.policy_path.Registry";
        String keyDispString = rb.getString("adap.SecurityComparator.Key");
        String subKeyDispString = rb.getString("adap.SecurityComparator.subkeys");
        if (type.equals("file")) {
            keyName = "adap.AUDGPPolicyPathMapping.policy_path.File_System";
            keyDispString = rb.getString("adap.SecurityComparator.FileOrFolder");
            subKeyDispString = rb.getString("adap.SecurityComparator.all_child_objects");
        }
        Properties properties = new Properties();
        properties.setProperty("Prevent", rb.handleGetObject("adap.SecurityComparator.Prevent", new String[]{keyDispString}));
        properties.setProperty("Replace", rb.handleGetObject("adap.SecurityComparator.Replace", new String[]{keyDispString, subKeyDispString}));
        properties.setProperty("Propogate", rb.handleGetObject("adap.SecurityComparator.Propogate", new String[]{keyDispString, subKeyDispString}));
        if (!elementList.isEmpty()) {
            HashMap detailMap = extnDetailsMap.get(keyName) != null ? (HashMap)extnDetailsMap.get(keyName) : new HashMap();
            for (Element element : elementList) {
                String path = XMLParserUtil.getChildElementText(element, "Path");
                String mode = XMLParserUtil.getChildElementText(element, "Mode");
                detailMap.put(path, properties.get(mode));
            }
            extnDetailsMap.put(keyName, detailMap);
        }
    }

    private HashMap getDefaultExtnMap(List<Element> elementList) {
        HashMap extnDetailsMap = new HashMap();
        List<Element> elements = null;
        if (elementList != null && !elementList.isEmpty()) {
            Element element = elementList.get(0);
            elements = XMLParserUtil.getChildrenByTagName(element, "RestrictedGroups");
            this.setRestrictedGroups(elements, extnDetailsMap);
            elements = XMLParserUtil.getChildrenByTagName(element, "SystemServices");
            this.setSystemServices(elements, extnDetailsMap);
            elements = XMLParserUtil.getChildrenByTagName(element, "File");
            this.setFileRegistrySettings(elements, extnDetailsMap, "file");
            elements = XMLParserUtil.getChildrenByTagName(element, "Registry");
            this.setFileRegistrySettings(elements, extnDetailsMap, "key");
        }
        return extnDetailsMap;
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap extnDetailsMap = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            Element element = elementList.get(0);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                short nodeType = node.getNodeType();
                if (node.getLocalName() == null || nodeType != 1) continue;
                String nodeLocalName = node.getLocalName();
                if (nodeLocalName.equalsIgnoreCase("Account")) {
                    this.setAccountOptions((Element)node, extnDetailsMap);
                    continue;
                }
                if (nodeLocalName.equalsIgnoreCase("Audit")) {
                    this.setAuditOptions((Element)node, extnDetailsMap);
                    continue;
                }
                if (nodeLocalName.equalsIgnoreCase("UserRightsAssignment")) {
                    this.setUserRightsAssignment((Element)node, extnDetailsMap);
                    continue;
                }
                if (nodeLocalName.equalsIgnoreCase("SecurityOptions")) {
                    this.setSecurityOptions((Element)node, extnDetailsMap);
                    continue;
                }
                if (!nodeLocalName.equalsIgnoreCase("EventLog")) continue;
                this.setEventLogSettings((Element)node, extnDetailsMap);
            }
        }
        return extnDetailsMap;
    }

    private HashMap getACPolicySettings(List<Element> elementList) {
        HashMap newACPolicyMap = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            Element element = elementList.get(0);
            List<Element> childElementList = XMLParserUtil.getChildrenByTagName(element, "RuleCollection");
            for (Element childElement : childElementList) {
                String type = childElement.getAttribute("Type");
                HashMap ruleCollectionMap = new HashMap();
                if (childElement.hasChildNodes()) {
                    for (String ruleType : SecurityComparatorUtil.AP_RULE_TYPES) {
                        List<Element> filePublisherElementList = XMLParserUtil.getChildrenByTagName(childElement, ruleType);
                        for (Element filePublisherElement : filePublisherElementList) {
                            NamedNodeMap namedNodeMap = filePublisherElement.getAttributes();
                            int nodeMapSize = namedNodeMap.getLength();
                            Node idNode = namedNodeMap.getNamedItem("Id");
                            String idValue = idNode.getNodeValue();
                            Node nameNode = namedNodeMap.getNamedItem("Name");
                            String name = "";
                            String idKey = "";
                            if (nameNode != null) {
                                name = nameNode.getNodeValue();
                                idKey = name + " (" + rb.getString("adap.AUDGPPolicyPathMapping.policy_path.AppLocker.Id") + ":" + idValue + ")";
                            } else {
                                idKey = idValue;
                            }
                            HashMap<String, String> publisherMap = new HashMap<String, String>();
                            for (int i = 0; i < nodeMapSize; ++i) {
                                Node node = namedNodeMap.item(i);
                                String nodeValue = node.getNodeValue();
                                if (node.getNodeName().equalsIgnoreCase("UserOrGroupSid")) {
                                    nodeValue = ADAPObjectCacheAPI.getInstance().getObjectNameFromSID(null, nodeValue, null);
                                }
                                publisherMap.put(node.getNodeName(), nodeValue);
                            }
                            ruleCollectionMap.put(idKey, publisherMap);
                        }
                    }
                }
                newACPolicyMap.put(type, ruleCollectionMap);
            }
        }
        return newACPolicyMap;
    }

    protected void compareACPExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, String type) {
        this.compareACPExtensionMap(newDetailsMap, oldDetailsMap, changeMap, true, type);
        this.compareACPExtensionMap(oldDetailsMap, newDetailsMap, changeMap, false, type);
    }

    private void compareACPExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, boolean checkModify, String type) {
        Set newKeySet = newDetailsMap.keySet();
        String pattern = "AudGPPolicyPathMapping:policy_path_id:2";
        if (type.equalsIgnoreCase("user")) {
            pattern = "AudGPPolicyPathMapping:policy_path_id:3";
        }
        for (Object object : newKeySet) {
            HashMap newFolderMap = (HashMap)newDetailsMap.get(object);
            Set newFolderMapSet = newFolderMap.keySet();
            String folderName = (String)object;
            Long policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(folderName, pattern);
            ArrayList changeList = (ArrayList)changeMap.get(policyPathId);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            if (!oldDetailsMap.containsKey(object)) {
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                if (!checkModify) {
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                }
                for (Object object2 : newFolderMapSet) {
                    String newKeyName = (String)object2;
                    HashMap<String, Object> detailMap = new HashMap<String, Object>();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", newKeyName);
                    detailMap.put(settingValueString, newFolderMap.get(newKeyName).toString());
                    changeList.add(detailMap);
                }
            } else if (checkModify) {
                HashMap<String, Object> detailMap;
                HashMap oldFolderMap = (HashMap)oldDetailsMap.get(object);
                Set oldFolderMapSet = oldFolderMap.keySet();
                int changeType = 1;
                String settingValueString = "SETTING_NEW_VALUE";
                for (Object object2 : newFolderMapSet) {
                    if (!oldFolderMap.containsKey(object2)) {
                        String newKeyName = (String)object2;
                        detailMap = new HashMap<String, Object>();
                        detailMap.put("CHANGE_TYPE", changeType);
                        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                        detailMap.put("SETTING_NAME", newKeyName);
                        detailMap.put(settingValueString, newFolderMap.get(newKeyName).toString());
                        changeList.add(detailMap);
                        continue;
                    }
                    String keyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("SETTING_NAME", keyName);
                    if (newFolderMap.get(keyName).equals(oldFolderMap.get(keyName))) continue;
                    changeType = 2;
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    settingValueString = "SETTING_NEW_VALUE";
                    detailMap.put(settingValueString, newFolderMap.get(keyName).toString());
                    settingValueString = "SETTING_OLD_VALUE";
                    detailMap.put(settingValueString, oldFolderMap.get(keyName).toString());
                    changeList.add(detailMap);
                }
                for (Object object2 : oldFolderMapSet) {
                    if (newFolderMap.containsKey(object2)) continue;
                    changeType = 3;
                    settingValueString = "SETTING_OLD_VALUE";
                    String oldKeyName = (String)object2;
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", changeType);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
                    detailMap.put("SETTING_NAME", oldKeyName);
                    detailMap.put(settingValueString, oldFolderMap.get(oldKeyName).toString());
                    changeList.add(detailMap);
                }
            }
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    void compareWLANExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap) {
        this.compareWLANExtensionMap(newDetailsMap, oldDetailsMap, changeMap, true);
        this.compareWLANExtensionMap(oldDetailsMap, newDetailsMap, changeMap, false);
    }

    void compareWLANExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, boolean checkModify) {
        Set newKeySet = newDetailsMap.keySet();
        for (Object object : newKeySet) {
            Long policyPathId;
            HashMap newFolderMap = (HashMap)newDetailsMap.get(object);
            Set newFolderMapSet = newFolderMap.keySet();
            HashMap oldFolderMap = (HashMap)oldDetailsMap.get(object);
            String folderName = (String)object;
            if (newFolderMap.get("XP") != null) {
                policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId("XP", "AudGPPolicyPathMapping:policy_path_id:2");
            }
            if (newFolderMap.get("Vista") == null) continue;
            policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId("Vista", "AudGPPolicyPathMapping:policy_path_id:2");
            HashMap newFolderMap2 = (HashMap)newFolderMap.get("Vista");
            ArrayList changeList = (ArrayList)changeMap.get(0);
            if (changeList == null) {
                changeList = new ArrayList();
            }
            HashMap oldFolderMap2 = oldFolderMap.get("Vista") != null ? (HashMap)oldFolderMap.get("Vista") : new HashMap();
            this.setWlanMapChanges(newFolderMap2, oldFolderMap2, changeMap, checkModify);
            this.setWlanStringChanges(newFolderMap2, oldFolderMap2, checkModify, changeList);
            if (changeList.isEmpty()) continue;
            changeMap.put(policyPathId, changeList);
        }
    }

    void setWlanStringChanges(HashMap newFolderMap, HashMap oldFolderMap, boolean checkModify, ArrayList changeList) {
        block6: {
            block5: {
                if (!checkModify) break block5;
                if (oldFolderMap.size() == 0) {
                    for (String s : SecurityComparatorUtil.WLAN_VISTA_STRING_PROPS) {
                        changeList.add(SecurityComparatorUtil.getWLanStringChanges(newFolderMap, oldFolderMap, s, 1));
                    }
                } else {
                    for (String s : SecurityComparatorUtil.WLAN_VISTA_STRING_PROPS) {
                        if (newFolderMap.get(s).equals(oldFolderMap.get(s))) continue;
                        changeList.add(SecurityComparatorUtil.getWLanStringChanges(newFolderMap, oldFolderMap, s, 2));
                    }
                }
                break block6;
            }
            if (oldFolderMap.size() != 0) break block6;
            for (String s : SecurityComparatorUtil.WLAN_VISTA_STRING_PROPS) {
                changeList.add(SecurityComparatorUtil.getWLanStringChanges(newFolderMap, oldFolderMap, s, 3));
            }
        }
    }

    void setWlanMapChanges(HashMap newFolderMap, HashMap oldFolderMap, HashMap changeMap, boolean checkModify) {
        for (String s : SecurityComparatorUtil.WLAN_VISTA_MAP_PROPS) {
            int i;
            List newList = newFolderMap.get(s) != null ? (List)newFolderMap.get(s) : new ArrayList();
            List oldList = oldFolderMap.get(s) != null ? (List)oldFolderMap.get(s) : new ArrayList();
            ArrayList changeList = changeMap.get(GPOPolicyPathAPI.getInstance().getPolicyPathId(s, "AudGPPolicyPathMapping:policy_path_id:2")) != null ? (ArrayList)changeMap.get(GPOPolicyPathAPI.getInstance().getPolicyPathId(s, "AudGPPolicyPathMapping:policy_path_id:2")) : new ArrayList();
            for (i = 0; i < newList.size(); ++i) {
                if (oldList.contains(newList.get(i))) continue;
                changeList.add(SecurityComparatorUtil.getNetworkChangesMap(s, (Properties)newList.get(i), checkModify ? 1 : 3));
            }
            if (checkModify) {
                for (i = 0; i < oldList.size(); ++i) {
                    if (newList.contains(oldList.get(i))) continue;
                    changeList.add(SecurityComparatorUtil.getNetworkChangesMap(s, (Properties)oldList.get(i), 3));
                }
            }
            changeMap.put(GPOPolicyPathAPI.getInstance().getPolicyPathId(s, "AudGPPolicyPathMapping:policy_path_id:2"), changeList);
        }
    }
}

