/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;

public class SecurityComparatorUtil {
    public static final String SEC_POLICY_TABLE_NAME = "AudSecPolicyPath";
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static final String[] AP_RULE_TYPES = new String[]{"FilePublisherRule", "FilePathRule", "FileHashRule"};
    public static final String[] KEY_STRINGS = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.SR_Addn_Rule_Path", "adap.AUDGPPolicyPathMapping.policy_path.SR_Addn_Rule_Hash", "adap.AUDGPPolicyPathMapping.policy_path.SR_Addn_Rule_Cert", "adap.AUDGPPolicyPathMapping.policy_path.SR_Addn_Rule_Zone"};
    public static final String[] RULE_STRINGS = new String[]{"PathRule", "HashRule", "CertificateRule", "InternetZoneRule"};
    public static final String[] KEY_PROPERTY = new String[]{"Path", "FileDescription", "SubjectName", "Zone"};
    public static final String XP_POLICY = "XP";
    public static final String VISTA_POLICY = "Vista";
    public static final String[] WLAN_VISTA_STRING_PROPS = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.Vista_Name", "adap.AUDGPPolicyPathMapping.policy_path.Vista_Description", "adap.AUDGPPolicyPathMapping.policy_path.Use_Windows_WLAN_AutoConfig_service_for_clients", "adap.AUDGPPolicyPathMapping.policy_path.Allow_user_to_view_denied_networks", "adap.AUDGPPolicyPathMapping.policy_path.Allow_everyone_to_create_all_user_profiles", "adap.AUDGPPolicyPathMapping.policy_path.Only_use_Group_Policy_profiles_for_allowed_network", "adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Dont_allow_shared_user_credentials_for_network_authentication", "adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Dont_allow_hosted_network", "adap.AUDGPPolicyPathMapping.policy_path.Prevent_connections_to_ad-hoc_networks", "adap.AUDGPPolicyPathMapping.policy_path.Prevent_connections_to_infrastructure_networks", "adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Enable_Block_Period"};
    public static final String[] WLAN_VISTA_MAP_PROPS = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.Allowed_Networks", "adap.AUDGPPolicyPathMapping.policy_path.Blocked_Networks"};
    public static final String[] WLAN_PROFILE_SECAUTH_PROPS = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.Authentication", "adap.AUDGPPolicyPathMapping.policy_path.Encryption", "adap.AUDGPPolicyPathMapping.policy_path.useOneX", "adap.AUDGPPolicyPathMapping.policy_path.FIPSMode"};
    public static final String[] WLAN_PROFILE_SEC_PROPS = new String[]{"adap.AUDGPPolicyPathMapping.policy_path.PMKCacheMode", "adap.AUDGPPolicyPathMapping.policy_path.PMKCacheTTL", "adap.AUDGPPolicyPathMapping.policy_path.PMKCacheSize", "adap.AUDGPPolicyPathMapping.policy_path.preAuthMode", "adap.AUDGPPolicyPathMapping.policy_path.preAuthThrottle"};
    public static final String[] WLAN_PROFILE_SECAUTH_KEYS = new String[]{"authentication", "encryption", "useOneX", "FIPSMode"};
    public static final String[] WLAN_PROFILE_SEC_KEYS = new String[]{"PMKCacheMode", "PMKCacheTTL", "PMKCacheSize", "preAuthMode", "preAuthThrottle"};
    public static final String BASE_KEY_STRING = "adap.AUDGPPolicyPathMapping.policy_path.";
    public static final String BASE_DISPLAY_STRING = "adap.SecurityComparator.";

    static HashMap getPolicyKeyPathMap() {
        HashMap secPolicyKeyMap = new HashMap();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SEC_POLICY_TABLE_NAME, (Row)null);
            Iterator rowIterator = dataObject.getRows(SEC_POLICY_TABLE_NAME);
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                HashMap<String, Object> keyValuesMap = new HashMap<String, Object>();
                Long policyPathId = (Long)row.get("POLICY_PATH_ID");
                keyValuesMap.put("POLICY_PATH_ID", policyPathId);
                keyValuesMap.put("POLICY_PATH", GPOPolicyPathAPI.getInstance().getDisplayPolicyPath(policyPathId));
                keyValuesMap.put("POLICY_NAME", row.get("POLICY_NAME"));
                if (row.get("POLICY_UNIT") != null) {
                    keyValuesMap.put("POLICY_UNIT", rb.getString((String)row.get("POLICY_UNIT")));
                }
                secPolicyKeyMap.put(row.get("POLICY_KEY").toString().toLowerCase(), keyValuesMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return secPolicyKeyMap;
    }

    static Object getDisplaySettings(Element element) {
        if (XMLParserUtil.getChildElement(element, "DisplayBoolean") != null) {
            String value = XMLParserUtil.getChildElement(element, "DisplayBoolean").getTextContent();
            return SecurityComparatorUtil.getBooleanValue(value);
        }
        if (XMLParserUtil.getChildElement(element, "DisplayNumber") != null) {
            String displayString = XMLParserUtil.getChildElement(element, "DisplayNumber").getTextContent();
            displayString = displayString + " " + XMLParserUtil.getChildElement(element, "Units").getTextContent();
            return displayString;
        }
        if (XMLParserUtil.getChildElement(element, "DisplayString") != null) {
            return XMLParserUtil.getChildElement(element, "DisplayString").getTextContent();
        }
        if (XMLParserUtil.getChildElement(element, "DisplayStrings") != null) {
            Element childNode = XMLParserUtil.getChildElement(element, "DisplayStrings");
            StringBuilder value = new StringBuilder();
            List<Element> list = XMLParserUtil.getChildrenByTagName(childNode, "Value");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(list.get(i).getTextContent());
            }
            return value.toString();
        }
        if (XMLParserUtil.getChildElement(element, "DisplayFields") != null) {
            Element childNode = XMLParserUtil.getChildElement(element, "DisplayFields");
            List<Element> elements = XMLParserUtil.getChildrenByTagName(childNode, "Field");
            HashMap<String, String> childElementsMap = new HashMap<String, String>();
            for (Element element2 : elements) {
                String nameString = XMLParserUtil.getChildElement(element2, "Name").getTextContent();
                String valueString = XMLParserUtil.getChildElement(element2, "Value").getTextContent();
                valueString = SecurityComparatorUtil.getBooleanValue(valueString);
                childElementsMap.put(nameString, valueString);
            }
            return childElementsMap;
        }
        return "-";
    }

    static String getBooleanValue(String value) {
        String booleanValue = "-";
        booleanValue = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ? "Enabled" : (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("0") ? "Disabled" : value);
        return booleanValue;
    }

    static String getSecurityLevelString(String secLevel) {
        if (secLevel.equalsIgnoreCase("BasicUser")) {
            return rb.getString("adap.SecurityComparator.BasicUser");
        }
        if (secLevel.equalsIgnoreCase("Disallowed")) {
            return rb.getString("adap.SecurityComparator.DefaultSecurityLevel_Disallowed");
        }
        return rb.getString("adap.SecurityComparator.DefaultSecurityLevel_Unrestricted");
    }

    static HashMap getSRExtnMap(List<Element> elementList) {
        HashMap<String, HashMap> extnDetailsMap = new HashMap<String, HashMap>();
        if (elementList != null && !elementList.isEmpty()) {
            Element trustPublisherElement;
            Element element = elementList.get(0);
            Element generalElement = XMLParserUtil.getChildElement(element, "General");
            String srKey = "adap.AUDGPPolicyPathMapping.policy_path.Software_Restriction_Policies";
            HashMap detailMap = extnDetailsMap.get(srKey) != null ? (HashMap)extnDetailsMap.get(srKey) : new HashMap();
            String settingText = XMLParserUtil.getChildElementText(generalElement, "ApplicableBinaries");
            if (!settingText.equalsIgnoreCase("")) {
                if (settingText.equalsIgnoreCase("NonLibraries")) {
                    detailMap.put(rb.getString("adap.SecurityComparator.ApplicableBinaries"), rb.getString("adap.SecurityComparator.ApplicableBinaries_NonLibraries"));
                } else {
                    detailMap.put(rb.getString("adap.SecurityComparator.ApplicableBinaries"), rb.getString("adap.SecurityComparator.ApplicableBinaries_All"));
                }
            }
            if (!(settingText = XMLParserUtil.getChildElementText(generalElement, "ApplicableUsers")).equalsIgnoreCase("")) {
                if (settingText.equalsIgnoreCase("NonAdmins")) {
                    detailMap.put(rb.getString("adap.SecurityComparator.ApplicableUsers"), rb.getString("adap.SecurityComparator.ApplicableUsers_NonAdmins"));
                } else {
                    detailMap.put(rb.getString("adap.SecurityComparator.ApplicableUsers"), rb.getString("adap.SecurityComparator.ApplicableUsers_All"));
                }
            }
            if (!(settingText = XMLParserUtil.getChildElementText(generalElement, "CertificateRulesEnabled")).equalsIgnoreCase("")) {
                if (settingText.equalsIgnoreCase("EnforceCertificateRules")) {
                    detailMap.put(rb.getString("adap.SecurityComparator.CertificateRulesEnabled"), rb.getString("adap.SecurityComparator.CertificateRulesEnabled_EnforceCertificateRules"));
                } else {
                    detailMap.put(rb.getString("adap.SecurityComparator.CertificateRulesEnabled"), rb.getString("adap.SecurityComparator.CertificateRulesEnabled_IgnoreCertificateRules"));
                }
            }
            if (!(settingText = XMLParserUtil.getChildElementText(trustPublisherElement = XMLParserUtil.getChildElement(generalElement, "TrustedPublishers"), "PublishSelector")).equalsIgnoreCase("")) {
                if (settingText.equalsIgnoreCase("EnterpriseAdmins")) {
                    detailMap.put(rb.getString("adap.SecurityComparator.PublishSelector"), rb.getString("adap.SecurityComparator.EnterpriseAdmins"));
                } else if (settingText.equalsIgnoreCase("LocalAdmins")) {
                    detailMap.put(rb.getString("adap.SecurityComparator.PublishSelector"), rb.getString("adap.SecurityComparator.LocalAdmins"));
                } else {
                    detailMap.put(rb.getString("adap.SecurityComparator.PublishSelector"), rb.getString("adap.SecurityComparator.Users"));
                }
            }
            Element revokeCheckElement = XMLParserUtil.getChildElement(trustPublisherElement, "RevokeCheck");
            String publisher = XMLParserUtil.getChildElementText(revokeCheckElement, "Publisher");
            String timestamp = XMLParserUtil.getChildElementText(revokeCheckElement, "Timestamp");
            if (publisher.equalsIgnoreCase("true") && timestamp.equalsIgnoreCase("true")) {
                detailMap.put(rb.getString("adap.SecurityComparator.RevokeCheck"), rb.getString("adap.SecurityComparator.RevokeCheck.All"));
            } else if (publisher.equalsIgnoreCase("true") && timestamp.equalsIgnoreCase("false")) {
                detailMap.put(rb.getString("adap.SecurityComparator.RevokeCheck"), rb.getString("adap.SecurityComparator.RevokeCheck.Publisher"));
            } else if (publisher.equalsIgnoreCase("false") && timestamp.equalsIgnoreCase("true")) {
                detailMap.put(rb.getString("adap.SecurityComparator.RevokeCheck"), rb.getString("adap.SecurityComparator.RevokeCheck.Timestamp"));
            } else if (publisher.equalsIgnoreCase("false") && timestamp.equalsIgnoreCase("false")) {
                detailMap.put(rb.getString("adap.SecurityComparator.RevokeCheck"), rb.getString("adap.SecurityComparator.RevokeCheck.None"));
            }
            Element exeElement = XMLParserUtil.getChildElement(generalElement, "ExecutableFiles");
            List<Element> fileTypeElements = XMLParserUtil.getChildrenByTagName(exeElement, "FileType");
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (Element element2 : fileTypeElements) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(element2.getTextContent());
                ++i;
            }
            detailMap.put(rb.getString("adap.SecurityComparator.Designated_File_Types"), builder.toString());
            extnDetailsMap.put(srKey, detailMap);
            srKey = "adap.AUDGPPolicyPathMapping.policy_path.SR_Security_Level";
            detailMap = extnDetailsMap.get(srKey) != null ? (HashMap)extnDetailsMap.get(srKey) : new HashMap();
            String defaultSecLevel = XMLParserUtil.getChildElementText(generalElement, "DefaultSecurityLevel");
            detailMap.put(rb.getString("adap.SecurityComparator.DefaultSecurityLevel"), SecurityComparatorUtil.getSecurityLevelString(defaultSecLevel));
            extnDetailsMap.put(srKey, detailMap);
            for (int j = 0; j < KEY_STRINGS.length; ++j) {
                List<Element> ruleElements = XMLParserUtil.getChildrenByTagName(element, RULE_STRINGS[j]);
                if (ruleElements.isEmpty()) continue;
                detailMap = extnDetailsMap.get(KEY_STRINGS[j]) != null ? (HashMap)extnDetailsMap.get(KEY_STRINGS[j]) : new HashMap();
                for (Element element2 : ruleElements) {
                    String keyProp = KEY_PROPERTY[j];
                    String keyPropValue = XMLParserUtil.getChildElementText(element2, keyProp);
                    if (keyProp.equalsIgnoreCase("Zone")) {
                        keyPropValue = rb.getString(BASE_DISPLAY_STRING + keyPropValue);
                    }
                    StringBuilder valueBuilder = new StringBuilder();
                    valueBuilder.append(rb.getString("adap.IESComparator.SecurityLevel"));
                    valueBuilder.append(" :");
                    valueBuilder.append(SecurityComparatorUtil.getSecurityLevelString(XMLParserUtil.getChildElementText(element2, "SecurityLevel")));
                    valueBuilder.append(", ");
                    valueBuilder.append(rb.getString("adap.SecurityComparator.ModificationTime"));
                    valueBuilder.append(XMLParserUtil.getChildElementText(element2, "ModificationTime"));
                    detailMap.put(keyPropValue, valueBuilder.toString());
                }
                extnDetailsMap.put(KEY_STRINGS[j], detailMap);
            }
        }
        return extnDetailsMap;
    }

    static List<Properties> getNetworkList(Element element) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            for (Element element2 : XMLParserUtil.getChildrenByTagName(element, "network")) {
                Properties properties = new Properties();
                properties.setProperty(rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Network_Name_SSID"), XMLParserUtil.getChildElement(element2, "networkName").getTextContent());
                properties.setProperty(rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Network_Type"), XMLParserUtil.getChildElement(element2, "networkType").getTextContent().equals("ESS") ? rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Infrasctucture") : (XMLParserUtil.getChildElement(element2, "networkType").getTextContent().equals("IBSS") ? rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Adhoc") : "-"));
                list.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    static HashMap getWLanStringChanges(HashMap newFolderMap, HashMap oldFolderMap, String s, int changeType) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("CHANGE_TYPE", changeType);
        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
        detailMap.put("SETTING_NAME", s);
        if (changeType == 2) {
            detailMap.put("SETTING_NEW_VALUE", newFolderMap.get(s));
            detailMap.put("SETTING_OLD_VALUE", oldFolderMap.get(s));
        } else if (changeType == 1) {
            detailMap.put("SETTING_NEW_VALUE", newFolderMap.get(s));
        } else if (changeType == 3) {
            detailMap.put("SETTING_OLD_VALUE", newFolderMap.get(s));
        }
        return detailMap;
    }

    static HashMap getNetworkChangesMap(String s, Properties properties, int changeType) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("CHANGE_TYPE", changeType);
        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(changeType));
        detailMap.put("SETTING_NEW_VALUE", properties.toString());
        detailMap.put("SETTING_NAME", s);
        return detailMap;
    }

    static HashMap getWLANSettings(List<Element> elementList) {
        HashMap h1 = new HashMap();
        HashMap h3 = new HashMap();
        if (elementList != null && !elementList.isEmpty()) {
            Element e1 = elementList.get(0);
            List<Element> l1 = XMLParserUtil.getChildrenByTagName(e1, "WLanSvcSetting");
            for (Element e2 : l1) {
                List<Element> l2 = XMLParserUtil.getChildrenByTagName(e2, "WLanPolicies");
                Iterator<Element> itr2 = l2.iterator();
                while (itr2.hasNext()) {
                    HashMap<String, Object> h2 = new HashMap<String, Object>();
                    Element e3 = itr2.next();
                    String s = XMLParserUtil.getChildElementText(e3, "policyType");
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Vista_Name", XMLParserUtil.getChildElementText(e3, "name"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Vista_Description", XMLParserUtil.getChildElementText(e3, "description"));
                    Element e4 = XMLParserUtil.getChildElement(e3, "globalFlags");
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Use_Windows_WLAN_AutoConfig_service_for_clients", XMLParserUtil.getChildElementText(e4, "enableAutoConfig"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Allow_user_to_view_denied_networks", XMLParserUtil.getChildElementText(e4, "showDeniedNetwork"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Allow_everyone_to_create_all_user_profiles", XMLParserUtil.getChildElementText(e4, "allowEveryoneToCreateAllUserProfiles"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Only_use_Group_Policy_profiles_for_allowed_network", XMLParserUtil.getChildElementText(e4, "onlyUseGPProfilesForAllowedNetworks"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Dont_allow_shared_user_credentials_for_network_authentication", XMLParserUtil.getChildElementText(e4, "enableExplicitCreds"));
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Dont_allow_hosted_network", XMLParserUtil.getChildElementText(e4, "enableSoftAP"));
                    String blockPeriod = XMLParserUtil.getChildElement(e4, "blockPeriod") != null ? XMLParserUtil.getChildElementText(e4, "blockPeriod") : "-";
                    h2.put("adap.AUDGPPolicyPathMapping.policy_path.Windows_7_Policy_Settings_Enable_Block_Period", blockPeriod);
                    Element e5 = XMLParserUtil.getChildElement(e3, "networkFilter");
                    if (e5 != null) {
                        h2.put("adap.AUDGPPolicyPathMapping.policy_path.Prevent_connections_to_ad-hoc_networks", XMLParserUtil.getChildElementText(e5, "denyAllIBSS"));
                        h2.put("adap.AUDGPPolicyPathMapping.policy_path.Prevent_connections_to_infrastructure_networks", XMLParserUtil.getChildElementText(e5, "denyAllESS"));
                    }
                    if (XMLParserUtil.getChildElement(e5, "allowList") != null) {
                        h2.put("adap.AUDGPPolicyPathMapping.policy_path.Allowed_Networks", XMLParserUtil.getChildElement(e5, "allowList") != null ? SecurityComparatorUtil.getNetworkList(XMLParserUtil.getChildElement(e5, "allowList")) : new ArrayList());
                    }
                    if (XMLParserUtil.getChildElement(e5, "blockList") != null) {
                        h2.put("adap.AUDGPPolicyPathMapping.policy_path.Blocked_Networks", XMLParserUtil.getChildElement(e5, "blockList") != null ? SecurityComparatorUtil.getNetworkList(XMLParserUtil.getChildElement(e5, "blockList")) : new ArrayList());
                    }
                    h3.put(s, h2);
                }
            }
        }
        h1.put("adap.AUDGPPolicyPathMapping.policy_path.Wireless_Network_(802.11)_Policies", h3);
        return h1;
    }

    static List<HashMap> getWAPProfileList(Element element) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        try {
            for (Element element2 : XMLParserUtil.getChildrenByTagName(element, "WLANProfile")) {
                HashMap<String, String> profileMap = new HashMap<String, String>();
                String profileName = XMLParserUtil.getChildElementText(element2, "name");
                profileMap.put("adap.AUDGPPolicyPathMapping.policy_path.Profile_Name", profileName);
                String networkType = XMLParserUtil.getChildElement(element2, "connectionType").getTextContent().equals("ESS") ? rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Infrasctucture") : (XMLParserUtil.getChildElement(element2, "connectionType").getTextContent().equals("IBSS") ? rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Adhoc") : "-");
                profileMap.put("adap.AUDGPPolicyPathMapping.policy_path.Network_Type", networkType);
                if (XMLParserUtil.getChildElement(element2, "connectionMode") != null) {
                    profileMap.put("adap.AUDGPPolicyPathMapping.policy_path.Automatically_connect_to_this_network", XMLParserUtil.getChildElementText(element2, "connectionMode").equals("auto") ? rb.getString("adap.common.text.filter_link.enabled") : rb.getString("adap.common.text.filter_link.disabled"));
                }
                if (XMLParserUtil.getChildElement(element2, "autoSwitch") != null) {
                    profileMap.put("adap.AUDGPPolicyPathMapping.policy_path.Automatically_switch_to_a_more_preferred_network", XMLParserUtil.getChildElementText(element2, "autoSwitch").equals("true") ? rb.getString("adap.common.text.filter_link.enabled") : rb.getString("adap.common.text.filter_link.disabled"));
                }
                Element ssidConfig = XMLParserUtil.getChildElement(element2, "SSIDConfig");
                List<Element> ssidList = XMLParserUtil.getChildrenByTagName(ssidConfig, "SSID");
                ArrayList ssidProps = new ArrayList();
                Iterator<Element> iterator = ssidList.iterator();
                while (iterator.hasNext()) {
                    Properties properties = new Properties();
                    Element element3 = iterator.next();
                    properties.setProperty(rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Network_Name_SSID"), XMLParserUtil.getChildElementText(element3, "name"));
                    properties.setProperty(rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Network_Broadcasts_its_SSID"), XMLParserUtil.getChildElementText(ssidConfig, "nonBroadcast"));
                }
                if (XMLParserUtil.getChildElement(element2, "MSM") == null) continue;
                Element msmElement = XMLParserUtil.getChildElement(element2, "MSM");
                Element secElement = XMLParserUtil.getChildElement(msmElement, "security");
                Element aeElement = XMLParserUtil.getChildElement(secElement, "authEncryption");
                Properties secProps = new Properties();
                if (XMLParserUtil.getChildElementText(aeElement, "authentication") == null) continue;
                secProps.setProperty(rb.getString("adap.AUDGPPolicyPathMapping.policy_path.Authentication"), XMLParserUtil.getChildElementText(aeElement, "authentication"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void setPropertyValues() {
    }

    static HashMap getPKExtnMap(List<Element> elementList) {
        HashMap<String, HashMap> extnDetailsMap = new HashMap<String, HashMap>();
        Element extnElement = null;
        Element element = null;
        if (elementList != null && !elementList.isEmpty()) {
            String elementName;
            extnElement = elementList.get(0);
            element = XMLParserUtil.getChildElement(extnElement, elementName = "AutoEnrollmentSettings");
            if (element != null) {
                extnDetailsMap.put(BASE_KEY_STRING + elementName, SecurityComparatorUtil.getAESettings(element));
            }
            extnDetailsMap.put(BASE_KEY_STRING + elementName, SecurityComparatorUtil.getStoreSettings(element));
            extnDetailsMap.put(BASE_KEY_STRING + elementName, SecurityComparatorUtil.getAESettings(element));
            extnDetailsMap.put(BASE_KEY_STRING + elementName, SecurityComparatorUtil.getCPVTPSettings(element));
        }
        return extnDetailsMap;
    }

    static HashMap getStoreSettings(Element element) {
        String property = null;
        String value = null;
        HashMap<String, String> detailMap = new HashMap<String, String>();
        Element childElement = null;
        property = "EnrollCertificatesAutomatically";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        childElement = XMLParserUtil.getChildElement(element, "Options");
        property = "RenewUpdateRevoke";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "UpdateTemplates";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "ExpiryNotification";
        value = element.getTextContent();
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(value));
        if (value.equalsIgnoreCase("true")) {
            property = "NotifyPercent";
            detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        }
        return detailMap;
    }

    static HashMap getAESettings(Element element) {
        String property = null;
        String value = null;
        HashMap<String, String> detailMap = new HashMap<String, String>();
        Element childElement = null;
        property = "EnrollCertificatesAutomatically";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        childElement = XMLParserUtil.getChildElement(element, "Options");
        property = "RenewUpdateRevoke";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "UpdateTemplates";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "ExpiryNotification";
        value = element.getTextContent();
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(value));
        if (value.equalsIgnoreCase("true")) {
            property = "NotifyPercent";
            detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        }
        return detailMap;
    }

    static HashMap getCPVTPSettings(Element element) {
        String property = null;
        String value = null;
        HashMap detailMap = null;
        Element childElement = null;
        property = "EnrollCertificatesAutomatically";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        childElement = XMLParserUtil.getChildElement(element, "Options");
        property = "RenewUpdateRevoke";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "UpdateTemplates";
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(XMLParserUtil.getChildElementText(childElement, property)));
        property = "ExpiryNotification";
        value = element.getTextContent();
        detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(value));
        if (value.equalsIgnoreCase("true")) {
            property = "NotifyPercent";
            detailMap.put(rb.getString(BASE_DISPLAY_STRING + property), SecurityComparatorUtil.getBooleanValue(element.getTextContent()));
        }
        return detailMap;
    }
}

