/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.gpo.extensions;

import com.adventnet.sym.adsm.auditing.server.gpo.GPOPolicyPathAPI;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.XMLParserUtil;
import com.adventnet.sym.adsm.auditing.server.gpo.extensions.DefaultExtensionCompartor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class SoftwareSettingsComparator
extends DefaultExtensionCompartor {
    private static final String COMP_SOFT_INS_UVH = "AudGPPolicyPathMapping:policy_path_id:211";
    private static final String USER_SOFT_INS_UVH = "AudGPPolicyPathMapping:policy_path_id:311";
    private static final String[] APPLICATION_TYPE = new String[]{"MsiApplication", "ZapApplication"};
    private static String[] booleanProperties = new String[]{"AutoInstall", "UninstallUnmanaged", "DisplayInARP", "IgnoreLanguage", "Allowx86Onia64", "IncludeCOM"};
    private static String[] booleanPropertyStrings = new String[]{"General/Auto-install this application by file extension activation", "General/Uninstall this application when it falls out of the scope of management", "General/Do not display this package in the Add/Remove Programs control panel", "Advanced Deployment Options/Ignore language when deploying this package", "Advanced Deployment Options/Make this 32-bit X86 application available to Win64 machines", "Advanced Deployment Options/Include OLE class and product information"};

    @Override
    public void compareExtension(List<Element> newXMLElementList, List<Element> oldXMLElementList, HashMap changeMap, String type, String extnType) {
        HashMap newDetailsMap = this.getExtnMap(newXMLElementList);
        HashMap oldDetailsMap = this.getExtnMap(oldXMLElementList);
        this.compareExtensionMap(newDetailsMap, oldDetailsMap, changeMap, type);
    }

    private void compareExtensionMap(HashMap newDetailsMap, HashMap oldDetailsMap, HashMap changeMap, String type) {
        HashMap<String, Object> detailMap;
        ArrayList changeList;
        Long policyPathId;
        String policyPath;
        String softwareName;
        Set newKeySet = newDetailsMap.keySet();
        Set oldKeySet = oldDetailsMap.keySet();
        String confTypePattern = "AudGPPolicyPathMapping:policy_path_id:2";
        String basePolicyPattern = COMP_SOFT_INS_UVH;
        if (type.equalsIgnoreCase("user")) {
            confTypePattern = "AudGPPolicyPathMapping:policy_path_id:3";
            basePolicyPattern = USER_SOFT_INS_UVH;
        }
        for (Object object : newKeySet) {
            HashMap newDeployMap;
            if (!oldDetailsMap.containsKey(object)) {
                softwareName = (String)object;
                newDeployMap = (HashMap)newDetailsMap.get(softwareName);
                Set newDeploySet = newDeployMap.keySet();
                for (Object object2 : newDeploySet) {
                    String newDeployKeyName = (String)object2;
                    HashMap newDeployValueMap = (HashMap)newDeployMap.get(object2);
                    policyPath = softwareName + "/" + newDeployKeyName;
                    policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(policyPath, basePolicyPattern, confTypePattern);
                    changeList = (ArrayList)changeMap.get(policyPathId);
                    if (changeList == null) {
                        changeList = new ArrayList();
                    }
                    Set newInfoSet = newDeployValueMap.keySet();
                    for (Object object3 : newInfoSet) {
                        detailMap = new HashMap<String, Object>();
                        detailMap.put("CHANGE_TYPE", 1);
                        detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(1));
                        detailMap.put("SETTING_NAME", object3);
                        detailMap.put("SETTING_NEW_VALUE", newDeployValueMap.get(object3));
                        changeList.add(detailMap);
                    }
                    if (changeList.isEmpty()) continue;
                    changeMap.put(policyPathId, changeList);
                }
                continue;
            }
            softwareName = (String)object;
            newDeployMap = (HashMap)newDetailsMap.get(softwareName);
            HashMap oldDeployMap = (HashMap)oldDetailsMap.get(softwareName);
            Set newDeploySet = newDeployMap.keySet();
            for (Object object2 : newDeploySet) {
                String newDeployKeyName = (String)object2;
                HashMap newDeployValueMap = (HashMap)newDeployMap.get(object2);
                HashMap oldDeployValueMap = (HashMap)oldDeployMap.get(object2);
                String policyPath2 = softwareName + "/" + newDeployKeyName;
                Long policyPathId2 = GPOPolicyPathAPI.getInstance().getPolicyPathId(policyPath2, basePolicyPattern, confTypePattern);
                ArrayList changeList2 = (ArrayList)changeMap.get(policyPathId2);
                if (changeList2 == null) {
                    changeList2 = new ArrayList();
                }
                Set newInfoSet = newDeployValueMap.keySet();
                for (Object object3 : newInfoSet) {
                    Object oldValue;
                    Object newValue = newDeployValueMap.get(object3);
                    if (newValue.equals(oldValue = oldDeployValueMap.get(object3))) continue;
                    HashMap<String, Object> detailMap2 = new HashMap<String, Object>();
                    detailMap2.put("CHANGE_TYPE", 2);
                    detailMap2.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(2));
                    detailMap2.put("SETTING_NAME", object3);
                    detailMap2.put("SETTING_NEW_VALUE", newValue);
                    detailMap2.put("SETTING_OLD_VALUE", oldValue);
                    changeList2.add(detailMap2);
                }
                if (changeList2.isEmpty()) continue;
                changeMap.put(policyPathId2, changeList2);
            }
        }
        for (Object object : oldKeySet) {
            if (newDetailsMap.containsKey(object)) continue;
            softwareName = (String)object;
            HashMap oldDeployMap = (HashMap)oldDetailsMap.get(softwareName);
            Set oldDeploySet = oldDeployMap.keySet();
            for (Object object2 : oldDeploySet) {
                String oldDeployKeyName = (String)object2;
                HashMap oldDeployValueMap = (HashMap)oldDeployMap.get(object2);
                policyPath = softwareName + "/" + oldDeployKeyName;
                policyPathId = GPOPolicyPathAPI.getInstance().getPolicyPathId(policyPath, basePolicyPattern, confTypePattern);
                changeList = (ArrayList)changeMap.get(policyPathId);
                if (changeList == null) {
                    changeList = new ArrayList();
                }
                Set oldInfoSet = oldDeployValueMap.keySet();
                for (Object object3 : oldInfoSet) {
                    detailMap = new HashMap();
                    detailMap.put("CHANGE_TYPE", 3);
                    detailMap.put("CHANGE_TYPE_TEXT", GPOUtil.getChangeText(3));
                    detailMap.put("SETTING_NAME", object3);
                    detailMap.put("SETTING_OLD_VALUE", oldDeployValueMap.get(object3));
                    changeList.add(detailMap);
                }
                if (changeList.isEmpty()) continue;
                changeMap.put(policyPathId, changeList);
            }
        }
    }

    private HashMap getExtnMap(List<Element> elementList) {
        HashMap<String, HashMap<String, HashMap>> extnDetailsMap = new HashMap<String, HashMap<String, HashMap>>();
        if (elementList != null && !elementList.isEmpty()) {
            for (Element element : elementList) {
                for (String appType : APPLICATION_TYPE) {
                    List<Element> appElementList = XMLParserUtil.getChildrenByTagName(element, appType);
                    for (Element element2 : appElementList) {
                        Element nameElement = XMLParserUtil.getChildElement(element2, "Name");
                        String name = nameElement.getTextContent();
                        HashMap<String, HashMap> deployMap = (HashMap<String, HashMap>)extnDetailsMap.get(name);
                        if (deployMap == null) {
                            deployMap = new HashMap<String, HashMap>();
                        }
                        deployMap.put("Product Information", this.getProductInformation(element2));
                        deployMap.put("Deployment Information", this.getDeploymentInfo(element2));
                        deployMap.put("Advanced", this.getAdvancedInfo(element2));
                        extnDetailsMap.put(name, deployMap);
                    }
                }
            }
        }
        return extnDetailsMap;
    }

    private HashMap getProductInformation(Element element) {
        HashMap<String, String> productInfoMap = new HashMap<String, String>();
        String version = XMLParserUtil.getChildElementText(element, "MajorVersion") + "." + XMLParserUtil.getChildElementText(element, "MinorVersion");
        productInfoMap.put("Version", version);
        productInfoMap.put("Language", XMLParserUtil.getChildElementText(element, "LanguageId"));
        String platform = "0";
        platform = XMLParserUtil.getChildElementText(element, "Architecture");
        platform = platform.equalsIgnoreCase("9") ? "x64" : "x86";
        productInfoMap.put("Platform", platform);
        productInfoMap.put("SupportURL", XMLParserUtil.getChildElementText(element, "SupportURL"));
        return productInfoMap;
    }

    private HashMap getDeploymentInfo(Element element) {
        HashMap<String, String> deploymentInfoMap = new HashMap<String, String>();
        String deploymentType = "Publish";
        if (XMLParserUtil.getChildElement(element, "DeploymentType") != null) {
            deploymentType = XMLParserUtil.getChildElementText(element, "DeploymentType");
        }
        deploymentInfoMap.put("General/Deployment type", deploymentType);
        deploymentInfoMap.put("General/Deployment source", XMLParserUtil.getChildElementText(element, "Path"));
        deploymentInfoMap.put("General/Installation user interface options", XMLParserUtil.getChildElementText(element, "InstallationUILevel"));
        for (int i = 0; i < booleanProperties.length; ++i) {
            deploymentInfoMap.put(booleanPropertyStrings[i], this.getBooleanSetting(element, booleanProperties[i], "true"));
        }
        return deploymentInfoMap;
    }

    private HashMap getAdvancedInfo(Element element) {
        HashMap<String, String> advancedInfoMap = new HashMap<String, String>();
        Element upgradeElement = XMLParserUtil.getChildElement(element, "Upgrades");
        if (upgradeElement != null) {
            advancedInfoMap.put("Upgrades/Required upgrade for existing packages", this.getBooleanSetting(upgradeElement, "Mandatory", "true"));
        }
        return advancedInfoMap;
    }
}

