/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogListener;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.net.InetAddress;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class ImportLogFileUtil {
    public static HashMap<String, String> computerNameMap = null;
    private static volatile ImportLogFileUtil importLogFileUtil = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    int[] machineTypeArray = new int[]{1, 4, 16, 64, 256, 4096, 16384};
    String[] versionArray = new String[]{"5", "6"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImportLogFileUtil getInstance() {
        if (importLogFileUtil != null) return importLogFileUtil;
        Class<ImportLogFileUtil> clazz = ImportLogFileUtil.class;
        synchronized (ImportLogFileUtil.class) {
            importLogFileUtil = new ImportLogFileUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return importLogFileUtil;
        }
    }

    public ArrayList getImportLogList(String sortColumn, String sortOrder, Integer count, Integer fromIndex, Integer range) throws Exception {
        ArrayList list = new ArrayList();
        Long taskId = DBObjectUtil.getUVHValues("TaskEngine_Task", "TaskEngine_Task:task_id:18");
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"TaskEngine_Task"));
        Criteria criteria = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_ID"), (Object)taskId, 0);
        Join scheduleTaskJoin = new Join("TaskEngine_Task", "Scheduled_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 2);
        Join scheduleJoin = new Join("Scheduled_Task", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
        Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
        Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
        Join pathConfigJoin = new Join("Schedule", "AudImportLogPathConfig", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
        query.setCriteria(criteria);
        query.addJoin(scheduleTaskJoin);
        query.addJoin(scheduleJoin);
        query.addJoin(periodicJoin);
        query.addJoin(calendarJoin);
        query.addJoin(pathConfigJoin);
        query.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID", (String)"SCHEDULE_SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"));
        query.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID", (String)"SCHEDULED_TASK_SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"TASK_ID"));
        query.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID", (String)"CALENDAR_SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"REPEAT_FREQUENCY"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"UNIT_OF_TIME", (String)"CALENDAR_UNIT_OF_TIME"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"TIME_OF_DAY"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DAY_OF_WEEK"));
        query.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DATE_OF_MONTH"));
        query.addSelectColumn(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID", (String)"PERIODIC_SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"Periodic", (String)"TIME_PERIOD"));
        query.addSelectColumn(Column.getColumn((String)"Periodic", (String)"UNIT_OF_TIME", (String)"PERIODIC_UNIT_OF_TIME"));
        query.addSelectColumn(Column.getColumn((String)"Periodic", (String)"START_DATE"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"PATH_ID"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"SCHEDULE_ID", (String)"IMPORT_LOG_SCHEDULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"EVENT_LOG_PATH"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"CREATION_TIME"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"MODIFICATION_TIME"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"REPORT_TYPE"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"MESSAGE"));
        SortColumn sortCol = null;
        String tableName = sortColumn.substring(0, sortColumn.indexOf("-"));
        String columnName = sortColumn.substring(sortColumn.indexOf("-") + 1);
        if (sortColumn != null && sortOrder != null) {
            sortCol = sortOrder.equalsIgnoreCase("desc") ? new SortColumn(Column.getColumn((String)tableName, (String)columnName), false) : new SortColumn(Column.getColumn((String)tableName, (String)columnName), true);
        }
        if (sortCol == null) {
            sortCol = new SortColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"MODIFICATION_TIME"), false);
        }
        Integer innerTopVal = fromIndex - 1 + range;
        if (count > 0 && count < innerTopVal) {
            range = count % range;
        }
        Range obj = new Range(fromIndex.intValue(), range.intValue());
        query.addSortColumn(sortCol);
        query.setRange(obj);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        if (dataObject.size("Schedule") > 0) {
            Iterator iterator = dataObject.getRows("Schedule");
            while (iterator.hasNext()) {
                Hashtable<String, Object> importLogDetails = new Hashtable<String, Object>();
                Row scheduleRow = (Row)iterator.next();
                importLogDetails.put("SCHEDULE_ID", (Long)scheduleRow.get("SCHEDULE_ID"));
                importLogDetails.put("SCHEDULE_NAME", (String)scheduleRow.get("SCHEDULE_NAME"));
                Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogPathConfig", (String)"SCHEDULE_ID"), scheduleRow.get("SCHEDULE_ID"), 0);
                Row pathConfigRow = dataObject.getRow("AudImportLogPathConfig", crit);
                boolean once = false;
                if (pathConfigRow != null) {
                    Criteria c;
                    if (pathConfigRow.get("REPORT_TYPE").toString().equalsIgnoreCase("once")) {
                        once = true;
                    }
                    importLogDetails.put("REPORT_TYPE", pathConfigRow.get("REPORT_TYPE"));
                    importLogDetails.put("PATH_ID", pathConfigRow.get("PATH_ID"));
                    importLogDetails.put("EVENT_LOG_PATH", pathConfigRow.get("EVENT_LOG_PATH"));
                    importLogDetails.put("CREATION_TIME", pathConfigRow.get("CREATION_TIME"));
                    importLogDetails.put("MODIFICATION_TIME", pathConfigRow.get("MODIFICATION_TIME"));
                    importLogDetails.put("MESSAGE", "-");
                    if (pathConfigRow.get("MESSAGE") != null) {
                        importLogDetails.put("MESSAGE", pathConfigRow.get("MESSAGE"));
                    }
                    DataObject schedulerDO = dataObject;
                    if (pathConfigRow.get("REPORT_TYPE").toString().equalsIgnoreCase("once") || pathConfigRow.get("REPORT_TYPE").toString().equalsIgnoreCase("hourly")) {
                        c = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), scheduleRow.get("SCHEDULE_ID"), 0);
                        Row periodicRow = schedulerDO.getRow("Periodic", c);
                        java.util.Date dateObj = (java.util.Date)periodicRow.get("START_DATE");
                        importLogDetails.put("selectedHour", dateObj.getHours());
                        importLogDetails.put("selectedMinute", dateObj.getMinutes());
                    } else {
                        c = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), scheduleRow.get("SCHEDULE_ID"), 0);
                        Row calendarRow = schedulerDO.getRow("Calendar", c);
                        if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("daily")) {
                            importLogDetails.put("selectedHour", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                            importLogDetails.put("selectedMinute", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                        } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("weekly")) {
                            importLogDetails.put("dayOfWeek", (Integer)calendarRow.get("DAY_OF_WEEK"));
                            importLogDetails.put("selectedHour", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                            importLogDetails.put("selectedMinute", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                        } else if (((String)calendarRow.get("REPEAT_FREQUENCY")).equalsIgnoreCase("monthly")) {
                            importLogDetails.put("dayOfWeek", (Integer)calendarRow.get("DATE_OF_MONTH"));
                            importLogDetails.put("selectedHour", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() / 60);
                            importLogDetails.put("selectedMinute", ((Long)calendarRow.get("TIME_OF_DAY")).intValue() % 60);
                        }
                    }
                }
                Criteria taskInputCrit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), scheduleRow.get("SCHEDULE_ID"), 0);
                Row taskInputRow = dataObject.getRow("Scheduled_Task", taskInputCrit);
                importLogDetails.put("STATUS", (Integer)taskInputRow.get("ADMIN_STATUS"));
                String lastScheduleTime = this.getRecentScheduleTime((Long)scheduleRow.get("SCHEDULE_ID"));
                StringBuffer scheduleTime = new StringBuffer();
                scheduleTime.append(ReportSchedulerUtil.getTimePeriod(dataObject, (Long)scheduleRow.get("SCHEDULE_ID")));
                if (once) {
                    scheduleTime = ImportLogFileUtil.getScheduleTime((Long)scheduleRow.get("SCHEDULE_ID"));
                    scheduleTime.append(" (");
                    scheduleTime.append(rb.getString("adap.reports.schedule_reports.schedule_reports.once.text"));
                    scheduleTime.append(")");
                }
                importLogDetails.put("LAST_SCHEDULE_TIME", lastScheduleTime);
                importLogDetails.put("SCHEDULE_TIME", scheduleTime);
                list.add(importLogDetails);
            }
        }
        return list;
    }

    public static StringBuffer getScheduleTime(Long scheduleId) {
        StringBuffer scheduleTime = new StringBuffer();
        try {
            Row row;
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("Task_Input")) != null) {
                Timestamp timeStamp = (Timestamp)row.get("SCHEDULE_TIME");
                SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy hh:mm a");
                scheduleTime.append(sdf.format(timeStamp));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return scheduleTime;
    }

    public String getRecentScheduleTime(Long scheduleId) throws Exception {
        Row row;
        String lastScheduleTime = "-";
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Schedule_Audit"));
        Criteria scheAuditCrit = new Criteria(Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        SortColumn sortCol = new SortColumn(Column.getColumn((String)"Schedule_Audit", (String)"SCHEDULE_START_TIME"), false);
        query.addSortColumn(sortCol);
        query.addSelectColumn(Column.getColumn((String)"Schedule_Audit", (String)"*"));
        query.setCriteria(scheAuditCrit);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("Schedule_Audit")) != null) {
            lastScheduleTime = TimeUtil.getSimpleDateFormat(new java.util.Date(((Timestamp)row.get("SCHEDULE_START_TIME")).getTime()));
        }
        return lastScheduleTime;
    }

    public void updateImportLog(DataObject dataObject, Long scheduleId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject schedulerDO = CommonUtil.getPersistence(new boolean[0]).getForPersonality("AudImportLogPathConfig", crit);
        DataObject diffDataObject = schedulerDO.diff(dataObject);
        if (diffDataObject.size("Scheduled_Task") > 0) {
            Row row = diffDataObject.getFirstRow("Scheduled_Task");
            Row taskRow = schedulerDO.getFirstRow("Scheduled_Task");
            row.set("ADMIN_STATUS", taskRow.get("ADMIN_STATUS"));
            diffDataObject.updateRow(row);
        }
        CommonUtil.getPersistence(new boolean[0]).update(diffDataObject);
    }

    public void changeAdminStatus(Long scheduleId, Integer val) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", crit);
        Row row = dataObject.getRow("Scheduled_Task");
        row.set("ADMIN_STATUS", (Object)val);
        dataObject.updateRow(row);
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
    }

    public void deleteScheduler(Long scheduleId) throws Exception {
        Row row = this.getLogPathRow("SCHEDULE_ID", scheduleId);
        Integer pathId = (Integer)row.get("PATH_ID");
        Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        CommonUtil.getPersistenceLite().delete(criteria);
    }

    public ArrayList<String> getImportLogFileList(Integer pathId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AudImportLogFiles"));
        Criteria criteria = new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)"PATH_ID"), (Object)pathId, 0);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn((String)"AudImportLogFiles", (String)"FILE_ID"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogFiles", (String)"FILE_NAME"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iterator = dataObject.getRows("AudImportLogFiles");
        while (iterator.hasNext()) {
            Row importFileRow = (Row)iterator.next();
            String fileName = (String)importFileRow.get("FILE_NAME");
            list.add(fileName);
        }
        return list;
    }

    public void addFileInDB(ArrayList<String> list, Integer pathId, String reportType) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        for (String fileName : list) {
            Row row = new Row("AudImportLogFiles");
            row.set("PATH_ID", (Object)pathId);
            row.set("FILE_NAME", (Object)fileName);
            row.set("REPORT_TYPE", (Object)reportType);
            row.set("MESSAGE", (Object)"adap.common.text.status_msg.yet_to_fetch_event_data");
            if (reportType != null && reportType.equalsIgnoreCase("once")) {
                row.set("MESSAGE", (Object)"adap.common.text.status_msg.running");
                HashMap<String, Object> map = new HashMap<String, Object>();
                DataAccess.generateValues((Row)row);
                Integer fileId = (Integer)row.get("FILE_ID");
                map.put("FILE_ID", fileId);
                map.put("FILE_NAME", fileName);
                ImportLogListener.getInstance().readArchiveLog(map);
            }
            dataObject.addRow(row);
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public Row getLogPathRow(String columnName, Object val) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogPathConfig", (String)columnName), val, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudImportLogPathConfig", crit);
        Row row = dataObject.getRow("AudImportLogPathConfig");
        return row;
    }

    public Integer getArchiveFileCount(Integer pathId) throws Exception {
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT COUNT(*) FROM ");
        buff.append("AudImportLogFiles");
        if (pathId != -1) {
            buff.append(" WHERE ");
            buff.append("PATH_ID");
            buff.append("='");
            buff.append(pathId);
            buff.append("'");
        }
        int count = QueryUtil.getRowsCount(buff.toString());
        return count;
    }

    public ArrayList<HashMap<String, Object>> getArchiveFileList(Integer pathId, Integer count, Integer fromIndex, Integer range) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AudImportLogFiles"));
        Criteria criteria = null;
        if (pathId != -1) {
            criteria = new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)"PATH_ID"), (Object)pathId, 0);
            query.setCriteria(criteria);
        }
        query.addSelectColumn(Column.getColumn((String)"AudImportLogFiles", (String)"*"));
        Integer innerTopVal = fromIndex - 1 + range;
        if (count > 0 && count < innerTopVal) {
            range = count % range;
        }
        Range obj = new Range(fromIndex.intValue(), range.intValue());
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AudImportLogFiles", (String)"FILE_NAME"), true));
        query.setRange(obj);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iterator = dataObject.getRows("AudImportLogFiles", criteria);
        while (iterator.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Row archiveLogRow = (Row)iterator.next();
            String fileName = (String)archiveLogRow.get("FILE_NAME");
            Long recentEventTime = (Long)archiveLogRow.get("RECENT_EVENT_TIME");
            String message = (String)archiveLogRow.get("MESSAGE");
            map.put("FILE_ID", (Integer)archiveLogRow.get("FILE_ID"));
            map.put("FILE_NAME", fileName);
            map.put("FIRST_EVENT_TIME", (Long)archiveLogRow.get("FIRST_EVENT_TIME") == 0L ? "-" : TimeUtil.getSimpleDateFormat(new java.util.Date((Long)archiveLogRow.get("FIRST_EVENT_TIME") * 1000L)));
            map.put("RECENT_EVENT_TIME", recentEventTime == 0L ? "-" : TimeUtil.getSimpleDateFormat(new java.util.Date(recentEventTime * 1000L)));
            map.put("STATUS", (Boolean)archiveLogRow.get("STATUS"));
            map.put("MESSAGE", message);
            list.add(map);
        }
        return list;
    }

    public ArrayList<HashMap<String, Object>> getUnreadFileList(String logPath, Integer pathId) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AudImportLogFiles"));
        Criteria criteria = new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)"PATH_ID"), (Object)pathId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)"STATUS"), (Object)false, 0));
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn((String)"AudImportLogFiles", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        Iterator iterator = dataObject.getRows("AudImportLogFiles", criteria);
        while (iterator.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Row archiveLogRow = (Row)iterator.next();
            String fileName = logPath + File.separator + archiveLogRow.get("FILE_NAME").toString();
            map.put("PATH_ID", archiveLogRow.get("PATH_ID"));
            map.put("FILE_ID", archiveLogRow.get("FILE_ID"));
            map.put("FILE_NAME", fileName);
            list.add(map);
        }
        return list;
    }

    public int[] getEventIdList() {
        int[] eventIds = null;
        try {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (int machineType : this.machineTypeArray) {
                int[] list;
                if (!this.isEnabledMachine(machineType).booleanValue()) continue;
                for (int eventId : list = AuditEventAPI.getInstance().getAuditEvents(this.versionArray, machineType)) {
                    if (idList.contains(eventId)) continue;
                    idList.add(eventId);
                }
            }
            if (!idList.isEmpty()) {
                eventIds = new int[idList.size()];
                int i = 0;
                Iterator i$ = idList.iterator();
                while (i$.hasNext()) {
                    int eventId;
                    eventIds[i] = eventId = ((Integer)i$.next()).intValue();
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return eventIds;
    }

    public Boolean isEnabledMachine(Integer machineType) {
        Boolean b = false;
        try {
            if (machineType == 1) {
                b = this.IsDcEnabled();
            } else {
                Row row;
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"MACHINE_TYPE"), (Object)machineType, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDComputerEventRead", criteria);
                if (dataObject != null && !dataObject.isEmpty() && (row = dataObject.getFirstRow("AUDComputerEventRead")) != null) {
                    b = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public Boolean IsDcEnabled() {
        Boolean b = false;
        try {
            Row row;
            Table baseTable = Table.getTable((String)"AUDDCEventRead");
            Table joinTable = Table.getTable((String)"Scheduled_Task");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Criteria criteria = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"), (Object)3, 0);
            Column col = Column.getColumn((String)"AUDDCEventRead", (String)"*");
            query.addJoin(join);
            query.setCriteria(criteria);
            query.addSelectColumn(col);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject != null && !dataObject.isEmpty() && (row = dataObject.getFirstRow("AUDDCEventRead")) != null) {
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public String getMachineName(String filePath) {
        String machineName = null;
        try {
            if (filePath != null) {
                if (filePath.contains("\\\\")) {
                    filePath = filePath.replace("\\\\", "");
                    int pos = filePath.indexOf(92);
                    machineName = filePath.substring(0, pos);
                } else {
                    machineName = InetAddress.getLocalHost().getHostName();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineName;
    }

    public String getDomainName(String computerName) {
        String domainName = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMComputerGeneralDetails"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)computerName, 0, false);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMMON_NAME"), (Object)computerName, 0, false));
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)computerName, 0, false));
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"*"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Row row = obj.getRow("ADSMComputerGeneralDetails");
            if (row != null) {
                domainName = row.get("DOMAIN_NAME").toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainName;
    }

    public void updateImportLogFileStatus(Integer fileId, HashMap map) {
        try {
            if (map != null) {
                HashMap<String, Object> logFileMap = new HashMap<String, Object>();
                logFileMap.put("FILE_ID", fileId);
                if (map.containsKey("errorMessage")) {
                    logFileMap.put("MESSAGE", map.get("errorMessage"));
                } else if (map.containsKey("running")) {
                    logFileMap.put("MESSAGE", map.get("running"));
                } else {
                    Hashtable table = (Hashtable)map.get("result");
                    logFileMap.put("STATUS", true);
                    logFileMap.put("MESSAGE", "adap.common.text.status_msg.success");
                    logFileMap.put("EVENT_READ", table.get("RecordNumber"));
                    logFileMap.put("FIRST_EVENT_TIME", table.get("StartTime"));
                    logFileMap.put("RECENT_EVENT_TIME", table.get("TimeWritten"));
                    ADSMPersUtil.updateSyMParameter("importCrunch", "true");
                }
                this.updateImportLogFile(logFileMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateImportLogFile(HashMap map) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)"FILE_ID"), map.remove("FILE_ID"), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudImportLogFiles", crit);
            Row row = dataObject.getRow("AudImportLogFiles");
            if (row != null) {
                Set keySet = map.keySet();
                for (Object key : keySet) {
                    row.set(key.toString(), map.get(key));
                }
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void enableMetaTableEntry() throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"ACTIVE_TABLE"), (Object)false, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMetaTable", crit);
        if (dataObject != null && !dataObject.isEmpty()) {
            Iterator iterator = dataObject.getRows("AUDMetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("ACTIVE_TABLE", (Object)true);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }

    public void updateLogPathStatus(HashMap map) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogPathConfig", (String)"PATH_ID"), map.remove("PATH_ID"), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudImportLogPathConfig", crit);
            Row row = dataObject.getRow("AudImportLogPathConfig");
            if (row != null) {
                Set keySet = map.keySet();
                for (Object key : keySet) {
                    row.set(key.toString(), map.get(key));
                }
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateAdminStatus(Long scheduleId, HashMap map) {
        try {
            if (map != null && !map.containsKey("errorMessage")) {
                this.changeAdminStatus(scheduleId, 4);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<String> getMetaTableList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMetaTable"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"IMPORT_TABLE"), (Object)true, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"), (Object)0, 1));
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDMetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                list.add(row.get("LOOKUP_TABLENAME").toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public void updateTaskInput(Long scheduleId, String noOfDays) throws Exception {
        java.util.Date javaDate = new java.util.Date();
        Date date = new Date(javaDate.getTime());
        date.setDate(date.getDate() + new Integer(noOfDays));
        Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
        Row row = dataObject.getRow("Task_Input");
        row.set("SCHEDULE_TIME", (Object)date);
        dataObject.updateRow(row);
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
    }

    public void updatePeriodic(Long scheduleId, String noOfDays) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
        Row row = dataObject.getRow("Periodic");
        row.set("TIME_PERIOD", (Object)(24 * new Integer(noOfDays)));
        dataObject.updateRow(row);
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
    }

    public HashMap checkFolderPermission(String filePath) throws Exception {
        HashMap map = new HashMap();
        String computerName = ImportLogFileUtil.getInstance().getMachineName(filePath);
        String domainName = ImportLogFileUtil.getInstance().getDomainName(computerName);
        if (domainName == null) {
            throw new Exception(rb.getString("adap.admin.importlog.machine_name_not_found"));
        }
        map = ADHandler.getArchiveFiles(domainName, computerName, filePath, true);
        return map;
    }

    public TreeMap<Integer, String> getImportLogListMap() throws Exception {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AudImportLogPathConfig"));
        query.addSelectColumn(Column.getColumn((String)"AudImportLogPathConfig", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        map.put(-1, rb.getString("adap.common.text.filter_link.all"));
        Row fileRow = this.getImportFileRow("REPORT_TYPE", "once");
        if (fileRow != null) {
            map.put(0, rb.getString("adap.reports.schedule_reports.schedule_reports.once.text"));
        }
        Iterator iterator = dataObject.getRows("AudImportLogPathConfig");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Integer pathId = (Integer)row.get("PATH_ID");
            String logPath = (String)row.get("EVENT_LOG_PATH");
            if (pathId == 0) continue;
            map.put(pathId, logPath);
        }
        return map;
    }

    public Row getImportFileRow(String columnName, Object val) throws Exception {
        Row row = null;
        Criteria crit = new Criteria(Column.getColumn((String)"AudImportLogFiles", (String)columnName), val, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudImportLogFiles", crit);
        if (!dataObject.isEmpty()) {
            row = dataObject.getFirstRow("AudImportLogFiles");
        }
        return row;
    }

    public String getNameFromDnsName(String dnsName) {
        String computerName = dnsName;
        try {
            if (computerName != null && computerName.contains(".")) {
                int pos = computerName.indexOf(46);
                computerName = computerName.substring(0, pos);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return computerName;
    }

    public Integer getPathCount() throws Exception {
        int count = 0;
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT COUNT(*) FROM ");
        buff.append("AudImportLogPathConfig");
        count = QueryUtil.getRowsCount(buff.toString());
        return count;
    }
}

