/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.importlog;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.eventcollection.EventFetchThreadPool;
import com.adventnet.sym.adsm.auditing.server.importlog.FetchArchiveEventData;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogFileUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.BackupTableUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class ImportLogListener {
    private static volatile ImportLogListener importLogListener = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static HashMap<String, Integer> logFileStatus = null;
    public static String[] columndisplayname = new String[]{"adap.admin.administration.restore_event_table.file_name", "adap.tab.talkback.text.from", "adap.tab.talkback.text.to", "adap.AUDColumnConfiguration.displayname.STATUS"};
    public static String[] columnname = new String[]{"FILE_NAME", "FIRST_EVENT_TIME", "RECENT_EVENT_TIME", "MESSAGE"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImportLogListener getInstance() {
        if (importLogListener != null) return importLogListener;
        Class<ImportLogListener> clazz = ImportLogListener.class;
        synchronized (ImportLogListener.class) {
            logFileStatus = new HashMap();
            importLogListener = new ImportLogListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return importLogListener;
        }
    }

    public Boolean addArchiveFileInDB(Integer pathId, String reportType) throws Exception {
        Row row = ImportLogFileUtil.getInstance().getLogPathRow("PATH_ID", pathId);
        String filePath = (String)row.get("EVENT_LOG_PATH");
        String computerName = ImportLogFileUtil.getInstance().getMachineName(filePath);
        String domainName = ImportLogFileUtil.getInstance().getDomainName(computerName);
        HashMap map = new HashMap();
        if (reportType.equalsIgnoreCase("once")) {
            map = ADHandler.getArchiveFiles(domainName, computerName, filePath, false);
        } else {
            filePath = filePath + File.separator + "*";
            map = ADHandler.getArchiveFiles(domainName, computerName, filePath, false);
        }
        HashMap<String, Object> pathMap = new HashMap<String, Object>();
        pathMap.put("PATH_ID", pathId);
        if (map.containsKey("errorMessage")) {
            pathMap.put("MESSAGE", map.get("errorMessage"));
        } else {
            ArrayList<String> list = ImportLogFileUtil.getInstance().getImportLogFileList(pathId);
            ArrayList resultList = (ArrayList)map.get("result");
            ArrayList<String> addFileList = new ArrayList<String>();
            for (Object fileName : resultList) {
                if (list.contains(fileName) || !fileName.toString().toLowerCase().contains(".evt") && !fileName.toString().toLowerCase().contains(".evtx")) continue;
                addFileList.add(fileName.toString());
            }
            if (!addFileList.isEmpty()) {
                ImportLogFileUtil.getInstance().addFileInDB(addFileList, pathId, reportType);
            }
            pathMap.put("MESSAGE", "adap.common.text.status_msg.success");
        }
        ImportLogFileUtil.getInstance().updateLogPathStatus(pathMap);
        return true;
    }

    public void runArchiveLog(Long scheduleId) {
        try {
            Row row = ImportLogFileUtil.getInstance().getLogPathRow("SCHEDULE_ID", scheduleId);
            if (row != null) {
                this.addArchiveFileInDB((Integer)row.get("PATH_ID"), row.get("REPORT_TYPE").toString());
                ArrayList<HashMap<String, Object>> list = ImportLogFileUtil.getInstance().getUnreadFileList(row.get("EVENT_LOG_PATH").toString(), (Integer)row.get("PATH_ID"));
                if (!list.isEmpty()) {
                    for (HashMap<String, Object> map : list) {
                        this.readArchiveLog(map);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readArchiveLog(HashMap<String, Object> map) throws Exception {
        if (map != null) {
            if (logFileStatus.get(map.get("FILE_NAME").toString()) != null && logFileStatus.get(map.get("FILE_NAME").toString()) == 1) {
                throw new Exception(rb.handleGetObject("adap.EventDataHandler.Fetching_data_for_", new String[]{map.get("FILE_NAME").toString()}));
            }
            logFileStatus.put(map.get("FILE_NAME").toString(), 1);
            EventFetchThreadPool eventFetchThreadPool = EventFetchThreadPool.getInstance(3);
            FetchArchiveEventData archiveEventData = new FetchArchiveEventData(map);
            HashMap<String, String> statusMap = new HashMap<String, String>();
            statusMap.put("running", "adap.common.text.status_msg.running");
            if (map.get("FILE_ID") != null) {
                ImportLogFileUtil.getInstance().updateImportLogFileStatus((Integer)map.get("FILE_ID"), statusMap);
            }
            eventFetchThreadPool.runTask(archiveEventData);
        }
    }

    public static void runBackup() {
        try {
            ArrayList<String> list = ImportLogFileUtil.getInstance().getMetaTableList();
            BackupTableUtil.dumpTable(list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

