/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.importlog;

import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogListener;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportLogTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        block4: {
            try {
                reportLogger.log(Level.INFO, "Scheduling the Import Log Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
                String scheduleIdUVH = "Schedule:schedule_id:UVH@5001";
                Long archiveId = DBObjectUtil.getUVHValues("Schedule", scheduleIdUVH);
                Long scheduleId = taskContext.getScheduleID();
                if (archiveId != null && archiveId.equals(scheduleId)) {
                    ImportLogListener.getInstance();
                    ImportLogListener.runBackup();
                }
                ImportLogListener.getInstance().runArchiveLog(scheduleId);
            }
            catch (Exception ex) {
                reportLogger.log(Level.INFO, "DBG:: Exception while ImportLogFile Update task..");
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OutOfMemoryError)) break block4;
                reportLogger.log(Level.INFO, "NativeThread Exception in ImportLogTask....");
                reportLogger.log(Level.INFO, "JVM will be Restarted due to out of memory from event update task in ImportLogTask....");
            }
        }
        reportLogger.log(Level.INFO, "Completed the Import Log Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "configureImportLogFile";
    }
}

