/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.ProcessMonitor;
import com.adventnet.sym.adsm.auditing.server.monitor.CorrelateTimedEvents;
import com.adventnet.sym.adsm.auditing.server.monitor.CorrelationRule;
import com.adventnet.sym.adsm.auditing.server.monitor.Group;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.util.DelayBlockingQueue;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public final class Action {
    private static final Logger LOGGER = Logger.getLogger("EventLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private String name = null;
    private String description = null;
    private Long id = 0L;
    private List<Group> groupsList = new ArrayList<Group>();
    private Hashtable correlationEvents = new Hashtable();
    private ArrayList<CorrelationRule> correlationRules = null;
    private ArrayList<String> correlationVariables = null;
    private int correlationOperator = 101;
    private long timeInterval = 0L;
    private boolean useAdvCorrelations = false;
    private static final int DEFAULT_HANDLER = 0;
    private static final int SPECIFIC_567_HANDLER = 1;
    private static final int SPECIFIC_4656_HANDLER = 2;
    private static final int DELETE_2K3_HANDLER = 3;
    private static final int DELETE_2K8_HANDLER = 4;
    private static final int MOVE_2K8_HANDLER = 5;
    private static final int MOVE_RENAME_NETAPP_HANDLER = 6;
    private static final int CREATION_HANDLER = 7;
    private static final int MOVE_2K3_HANDLER = 8;
    public static Hashtable<String, List<String>> deletedEventObjectName = new Hashtable();
    public static Hashtable<String, List<Long>> deletedEventRecNo = new Hashtable();
    public static HashMap<Long, Integer> action_HandlerType = new HashMap();
    public static HashMap<Long, Integer> action_AccessTypes = new HashMap();
    private static final Hashtable CORRELATION_EVENTS_MAP = new Hashtable();
    private static final long DELAY_TIME = 10000L;
    private static final int EVT_PROCESSING_Q_SIZE = 5000;
    private static final DelayBlockingQueue<CorrelateTimedEvents> EVT_PROCESSING_Q = new DelayBlockingQueue(5000);
    private static EventCorrelationThread eventCorrelationThread = null;

    public static Integer getAccessType(Long actionId) {
        return action_AccessTypes.get(actionId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Group> getGroupsList() {
        return this.groupsList;
    }

    public void setGroupsList(List<Group> groupsList) {
        this.groupsList = groupsList;
    }

    public boolean isUseAdvCorrelations() {
        return this.useAdvCorrelations;
    }

    public void setUseAdvCorrelations(boolean useAdvCorrelations) {
        this.useAdvCorrelations = useAdvCorrelations;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public ArrayList<CorrelationRule> getCorrelationRules() {
        return this.correlationRules;
    }

    public void setCorrelationRules(ArrayList<CorrelationRule> correlationRules) {
        this.correlationRules = correlationRules;
    }

    public ArrayList<String> getCorrelationVariables() {
        return this.correlationVariables;
    }

    public void setCorrelationVariables(ArrayList<String> correlationVariables) {
        this.correlationVariables = correlationVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeEventCollectionThread(String threadName) {
        if (eventCorrelationThread != null) return;
        Class<EventCorrelationThread> clazz = EventCorrelationThread.class;
        synchronized (EventCorrelationThread.class) {
            if (eventCorrelationThread != null) return;
            eventCorrelationThread = new EventCorrelationThread(EVT_PROCESSING_Q, threadName);
            eventCorrelationThread.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean evaluate(Hashtable<String, Object> eventTable) {
        boolean b = false;
        for (Group group : this.groupsList) {
            if (!group.evaluate(eventTable)) continue;
            b = true;
            break;
        }
        return b;
    }

    private Hashtable getCorrelationTable() {
        return null;
    }

    private static Long calculate(Long ip1, Long ip2, String readDirection) {
        Long op = readDirection != null && readDirection.equals("0") ? Long.valueOf(ip1 - ip2) : Long.valueOf(ip1 + ip2);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> correlate(Hashtable<String, Object> eventTable, Long monitorId, Long actionId) {
        Hashtable returnEventTable = null;
        Hashtable sourceTable = null;
        Hashtable correlationTable = null;
        Hashtable correlationTimeTable = null;
        Hashtable<Integer, Hashtable> groupEvents = null;
        Hashtable events = null;
        String source = null;
        Integer timeGenerated = 0;
        int actionHandler = 0;
        Integer handlerType = action_HandlerType.get(actionId);
        if (handlerType == null) {
            handlerType = 0;
        }
        actionHandler = handlerType;
        Hashtable hashtable = this.correlationEvents;
        synchronized (hashtable) {
            for (Group group : this.groupsList) {
                Long tempRecNo;
                if (!group.evaluate(eventTable)) continue;
                source = (String)eventTable.get("DomainController");
                timeGenerated = (Integer)eventTable.get("TimeGenerated");
                Long recordNumber = (Long)eventTable.get("RecordNumber");
                sourceTable = this.correlationEvents.containsKey(source) ? (Hashtable)this.correlationEvents.get(source) : new Hashtable();
                String correlationValues = this.getCorrelationValues(eventTable) + "," + monitorId.toString() + "," + actionId.toString();
                String correlationValues2 = "";
                String readDirection = null;
                if (eventTable.containsKey("ReadDirection")) {
                    readDirection = (String)eventTable.get("ReadDirection");
                }
                if (actionHandler == 4) {
                    if ((Integer)eventTable.get("EventCode") == 4663) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = Action.calculate((long)tempRecNo, 1L, readDirection);
                        correlationValues = correlationValues + "," + tempRecNo;
                        List<Long> deletedRecNoList = deletedEventRecNo.get(source);
                        if (deletedRecNoList == null) {
                            deletedRecNoList = Collections.synchronizedList(new ArrayList());
                        }
                        deletedRecNoList.add(tempRecNo);
                        deletedEventRecNo.put(source, deletedRecNoList);
                    }
                }
                if (actionHandler == 2) {
                    if ((Integer)eventTable.get("EventCode") == 4656) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = Action.calculate((long)tempRecNo, 1L, readDirection);
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (actionHandler == 5) {
                    if ((Integer)eventTable.get("EventCode") == 4656 && eventTable.get("Access Mask").equals("0x110080")) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else if ((Integer)eventTable.get("EventCode") == 4663 && eventTable.get("Access Mask").equals("0x10000")) {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = Action.calculate((long)tempRecNo, 1L, readDirection);
                        String defaultcorrelationValues = correlationValues;
                        correlationValues = correlationValues + "," + tempRecNo;
                        List<Long> deletedRecNoList = deletedEventRecNo.get(source);
                        if (deletedRecNoList != null && deletedRecNoList.remove(Action.calculate((long)tempRecNo, -1L, readDirection))) break;
                        String objectName = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese"))).toLowerCase() : ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"))).toLowerCase();
                        List<String> deletedFileList = deletedEventObjectName.get(source);
                        if (deletedFileList != null && deletedFileList.contains(objectName + timeGenerated)) break;
                        Long tempRecNo2 = (Long)eventTable.get("TempRecNo");
                        tempRecNo2 = Action.calculate((long)tempRecNo2, 3L, readDirection);
                        correlationValues2 = defaultcorrelationValues + "," + tempRecNo2;
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = Action.calculate((long)tempRecNo, 3L, readDirection);
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (actionHandler == 8) {
                    if ((Integer)eventTable.get("EventCode") == 560 && (eventTable.get("Access Mask").equals("0x110080") || eventTable.get("Access Mask").equals("0x110000"))) {
                        String defaultcorrelationValues = correlationValues;
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                        Long tempRecNo2 = (Long)eventTable.get("TempRecNo");
                        if ((tempRecNo2 = Long.valueOf(tempRecNo2 - 2L)) >= 0L) {
                            correlationValues2 = defaultcorrelationValues + "," + tempRecNo2;
                        }
                    } else if ((Integer)eventTable.get("EventCode") == 567 && eventTable.get("Access Mask").equals("0x10000")) {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = tempRecNo - 1L;
                        correlationValues = correlationValues + "," + tempRecNo;
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = tempRecNo - 2L;
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (actionHandler == 3) {
                    if ((Integer)eventTable.get("EventCode") == 564) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = ((Integer)eventTable.get("MachineType") & 0x20000) == 131072 ? Action.calculate((long)tempRecNo, 1L, readDirection) : Action.calculate((long)tempRecNo, 2L, readDirection);
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (actionHandler == 1) {
                    if ((Integer)eventTable.get("EventCode") == 567) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = Action.calculate((long)tempRecNo, 1L, readDirection);
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (actionHandler == 6) {
                    if (group.getPriorityId() == 2) {
                        correlationValues = correlationValues + "," + eventTable.get("TempRecNo");
                    } else {
                        tempRecNo = (Long)eventTable.get("TempRecNo");
                        tempRecNo = tempRecNo + 1L;
                        correlationValues = correlationValues + "," + tempRecNo;
                    }
                }
                if (sourceTable.containsKey(correlationValues)) {
                    correlationTimeTable = (Hashtable)sourceTable.get(correlationValues);
                } else {
                    correlationTimeTable = new Hashtable();
                    if (actionHandler == 5 || actionHandler == 8) {
                        correlationTimeTable.put("TEMP_REC_NO", (Long)eventTable.get("TempRecNo"));
                    }
                    correlationTimeTable.put("TIME_ADDED", System.currentTimeMillis());
                    correlationTimeTable.put("TIME_GENERATED", (Integer)eventTable.get("TimeGenerated"));
                }
                correlationTable = correlationTimeTable.containsKey("CORRELATION_TABLE") ? (Hashtable)correlationTimeTable.get("CORRELATION_TABLE") : new Hashtable();
                groupEvents = correlationTable.containsKey(group.getPriorityId()) ? (Hashtable<Integer, Hashtable>)correlationTable.get(group.getPriorityId()) : new Hashtable<Integer, Hashtable>();
                events = groupEvents.containsKey(timeGenerated) ? (Hashtable)groupEvents.get(timeGenerated) : new Hashtable();
                events.put(recordNumber, eventTable);
                groupEvents.put(timeGenerated, events);
                correlationTable.put(group.getPriorityId(), groupEvents);
                correlationTimeTable.put("CORRELATION_TABLE", correlationTable);
                sourceTable.put(correlationValues, correlationTimeTable);
                this.correlationEvents.put(source, sourceTable);
                if (actionHandler != 5 && actionHandler != 8 || correlationValues2.equals("")) break;
                if (sourceTable.containsKey(correlationValues2)) {
                    correlationTimeTable = (Hashtable)sourceTable.get(correlationValues2);
                } else {
                    correlationTimeTable = new Hashtable();
                    correlationTimeTable.put("TEMP_REC_NO", (Long)eventTable.get("TempRecNo"));
                    correlationTimeTable.put("TIME_ADDED", System.currentTimeMillis());
                    correlationTimeTable.put("TIME_GENERATED", (Integer)eventTable.get("TimeGenerated"));
                }
                correlationTable = correlationTimeTable.containsKey("CORRELATION_TABLE") ? (Hashtable)correlationTimeTable.get("CORRELATION_TABLE") : new Hashtable();
                int groupPriorityIdKey = 3;
                if (correlationTable.containsKey(groupPriorityIdKey)) break;
                groupEvents = new Hashtable<Integer, Hashtable>();
                events = groupEvents.containsKey(timeGenerated) ? (Hashtable)groupEvents.get(timeGenerated) : new Hashtable();
                events.put(recordNumber, eventTable);
                groupEvents.put(timeGenerated, events);
                correlationTable.put(groupPriorityIdKey, groupEvents);
                correlationTimeTable.put("CORRELATION_TABLE", correlationTable);
                sourceTable.put(correlationValues2, correlationTimeTable);
                this.correlationEvents.put(source, sourceTable);
                break;
            }
            if (sourceTable != null && !sourceTable.isEmpty()) {
                ArrayList toBeRemovedKeys = new ArrayList();
                Enumeration enumeration = sourceTable.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    correlationTimeTable = (Hashtable)sourceTable.get(key);
                    correlationTable = (Hashtable)correlationTimeTable.get("CORRELATION_TABLE");
                    if (this.groupsList.size() > 1 && this.groupsList.size() == correlationTable.size()) {
                        int i;
                        Hashtable[] groupEventTables = new Hashtable[this.groupsList.size()];
                        Integer[] groupEventIds = new Integer[this.groupsList.size()];
                        for (i = 0; i < this.groupsList.size(); ++i) {
                            groupEventTables[i] = this.getValueTable(correlationTable, i + 1);
                            groupEventIds[i] = (Integer)groupEventTables[i].get("EventCode");
                        }
                        if (groupEventIds[0].equals(567) && groupEventIds[1].equals(560) && actionHandler != 8) {
                            returnEventTable = groupEventTables[1];
                        } else if (groupEventIds[0].equals(4663) && groupEventIds[1].equals(4660)) {
                            returnEventTable = groupEventTables[0];
                            returnEventTable.put("FirstLine", RB.getString("adap.ObjectAccessListener.An_object_was_deleted"));
                            returnEventTable.put("NeedToCheckIsFileExists2k8", true);
                        } else if (actionHandler == 7) {
                            returnEventTable = groupEventTables[0];
                            returnEventTable.put("NeedToCheckIsFileCreationTime", true);
                        } else if (groupEventIds[0].equals(560) && groupEventIds[1].equals(564)) {
                            returnEventTable = groupEventTables[0];
                            returnEventTable.put("NeedToCheckIsFileExists2k3", true);
                        } else if (groupEventIds[0].equals(560) && groupEventIds[1].equals(560)) {
                            if (actionHandler == 0 && ((Integer)eventTable.get("MachineType") & 0x100) == 256) {
                                returnEventTable = groupEventTables[1];
                                toBeRemovedKeys.add(key);
                            } else {
                                int newNameLastIndex;
                                String newFileLocation;
                                int lastIndex;
                                String oldFileLocation;
                                returnEventTable = groupEventTables[0];
                                returnEventTable.put("NEW_UNC_NAME", groupEventTables[1].get("UNC Path"));
                                String oldName = groupEventTables[0].get("UNC Path").toString();
                                String newName = groupEventTables[1].get("UNC Path").toString();
                                if (oldName.indexOf("\\") != -1 && newName.indexOf("\\") != -1 && (oldFileLocation = oldName.substring(0, (lastIndex = oldName.lastIndexOf("\\")) + 1)).equals(newFileLocation = newName.substring(0, (newNameLastIndex = newName.lastIndexOf("\\")) + 1))) {
                                    returnEventTable.put("ACCESS_TYPE", 14);
                                }
                            }
                        } else if (actionHandler == 5 || actionHandler == 8) {
                            int n = i = actionHandler == 8 ? 1 : 0;
                            if (groupEventIds[2].equals(4663) && (groupEventTables[2].get("Access Mask").equals("0x2") || groupEventTables[2].get("Access Mask").equals("0x4")) || groupEventIds[2].equals(560) && (groupEventTables[2].get("Access Mask").equals("0x100002") || groupEventTables[2].get("Access Mask").equals("0x100004"))) {
                                String movedFolderName = (String)groupEventTables[i].get("Object Name");
                                int endIndex = movedFolderName.lastIndexOf("\\");
                                if (endIndex != -1) {
                                    movedFolderName = movedFolderName.substring(0, endIndex);
                                }
                                if (groupEventTables[2].get("Object Name").toString().equals(movedFolderName)) {
                                    groupEventTables[i].put("ACCESS_TYPE", 14);
                                } else {
                                    groupEventTables[i].put("NEW_UNC_NAME", groupEventTables[2].get("UNC Path").toString());
                                }
                            }
                            returnEventTable = groupEventTables[i];
                        } else {
                            returnEventTable = groupEventTables[0];
                        }
                        toBeRemovedKeys.add(key);
                        break;
                    }
                    if (!(actionHandler != 5 && actionHandler != 8 || (Long)eventTable.get("TempRecNo") <= (Long)correlationTimeTable.get("TEMP_REC_NO") + 20L && System.currentTimeMillis() <= (Long)correlationTimeTable.get("TIME_ADDED") + 20000L)) {
                        if (correlationTable.containsKey(1) && correlationTable.containsKey(2)) {
                            int i = actionHandler == 8 ? 2 : 1;
                            returnEventTable = this.getValueTable(correlationTable, i);
                        }
                        toBeRemovedKeys.add(key);
                        break;
                    }
                    if (actionHandler == 5 || actionHandler == 8 || (Integer)eventTable.get("TimeGenerated") <= (Integer)correlationTimeTable.get("TIME_GENERATED") + 20000 && System.currentTimeMillis() <= (Long)correlationTimeTable.get("TIME_ADDED") + 20000L) continue;
                    toBeRemovedKeys.add(key);
                }
                for (Object key : toBeRemovedKeys) {
                    sourceTable.remove(key);
                }
                this.correlationEvents.put(source, sourceTable);
            }
        }
        if (returnEventTable != null) {
            String domainName;
            String objectName;
            Boolean needToCheckIsFileExists2k8 = (Boolean)returnEventTable.get("NeedToCheckIsFileExists2k8");
            Boolean needToCheckIsFileExists2k3 = (Boolean)returnEventTable.get("NeedToCheckIsFileExists2k3");
            Boolean needToCheckIsFileCreationTime = (Boolean)returnEventTable.get("NeedToCheckIsFileCreationTime");
            if (needToCheckIsFileExists2k8 != null && needToCheckIsFileExists2k8.booleanValue()) {
                objectName = (String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? ((String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese"))).toLowerCase() : ((String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"))).toLowerCase();
                String uncPath = (String)returnEventTable.get("UNC Path");
                domainName = (String)returnEventTable.get("DomainName");
                boolean isFileExists = Boolean.FALSE;
                try {
                    if (uncPath != null) {
                        isFileExists = ADHandler.isFileExits(domainName, 1L, uncPath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!isFileExists) {
                    Integer eventTime = (Integer)eventTable.get("TimeGenerated");
                    List<String> deletedFilelist = deletedEventObjectName.get(returnEventTable.get("DomainController"));
                    if (deletedFilelist == null) {
                        deletedFilelist = Collections.synchronizedList(new ArrayList());
                    }
                    if (objectName != null && !objectName.contains(".")) {
                        deletedFilelist.add(objectName + eventTime);
                        deletedFilelist.add(objectName + (eventTime - 1));
                    }
                    deletedEventObjectName.put((String)returnEventTable.get("DomainController"), deletedFilelist);
                    if (deletedFilelist.size() > 100) {
                        deletedFilelist.remove(0);
                        deletedFilelist.remove(0);
                    }
                    returnEventTable.put("NeedToCheckIsFileExists2k8", false);
                } else {
                    returnEventTable = null;
                }
            } else if (needToCheckIsFileExists2k3 != null && needToCheckIsFileExists2k3.booleanValue()) {
                String uncPath = (String)returnEventTable.get("UNC Path");
                String domainName2 = (String)returnEventTable.get("DomainName");
                boolean isFileExists = Boolean.FALSE;
                try {
                    if (uncPath != null) {
                        isFileExists = ADHandler.isFileExits(domainName2, 1L, uncPath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!isFileExists) {
                    returnEventTable.put("NeedToCheckIsFileExists2k3", false);
                } else {
                    returnEventTable = null;
                }
            } else if (needToCheckIsFileCreationTime != null && needToCheckIsFileCreationTime.booleanValue()) {
                objectName = (String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? ((String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese"))).toLowerCase() : ((String)returnEventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"))).toLowerCase();
                String uncPath = (String)returnEventTable.get("UNC Path");
                domainName = (String)returnEventTable.get("DomainName");
                String fileCreationTime = "";
                try {
                    if (uncPath != null) {
                        fileCreationTime = ADHandler.getFileCreatedTime(domainName, 1L, uncPath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!returnEventTable.get("TimeGenerated").toString().equals(fileCreationTime)) {
                    returnEventTable = null;
                }
            }
        }
        return returnEventTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correlateUserAttributeEvent(Hashtable<String, Object> eventTable, Monitor monitor) {
        Object returnEventTable = null;
        Long tempRecno = 0L;
        for (Group group : this.groupsList) {
            if (!group.evaluate(eventTable)) continue;
            int timeGenerated = (Integer)eventTable.get("TimeGenerated");
            Long recordNumber = (Long)eventTable.get("RecordNumber");
            eventTable.put("CategoryId", monitor.getCategoryId());
            eventTable.put("MonitorId", monitor.getId());
            eventTable.put("monitorDomainName", monitor.getDomainName());
            String correlationValues = this.getCorrelationValues(eventTable);
            String combinedKey = "";
            String combinedGroupEventKey = "";
            String combinedCorrelationTable = "";
            Hashtable hashtable = CORRELATION_EVENTS_MAP;
            synchronized (hashtable) {
                if ((Integer)eventTable.get("EventCode") == 403) {
                    tempRecno = (Long)eventTable.get("RecordNumber") + 2L;
                    combinedKey = tempRecno + ":" + eventTable.get("DomainController") + ":" + eventTable.get("MonitorId") + ":" + this.getId().toString();
                } else {
                    combinedKey = correlationValues + ":" + eventTable.get("DomainController") + ":" + eventTable.get("MonitorId") + ":" + this.getId().toString();
                }
                Hashtable correlationTable = CORRELATION_EVENTS_MAP.containsKey(combinedKey) ? (Hashtable)CORRELATION_EVENTS_MAP.get(combinedKey) : new Hashtable();
                Hashtable groupEvents = correlationTable.containsKey(group.getPriorityId()) ? (Hashtable)correlationTable.get(group.getPriorityId()) : new Hashtable();
                Hashtable events = groupEvents.containsKey(timeGenerated) ? (Hashtable)groupEvents.get(timeGenerated) : new Hashtable();
                events.put(recordNumber, eventTable);
                groupEvents.put(timeGenerated, events);
                correlationTable.put(group.getPriorityId(), groupEvents);
                CORRELATION_EVENTS_MAP.put(combinedKey, correlationTable);
            }
            this.addWorkItem(combinedKey);
        }
        this.process();
    }

    public static Hashtable getEventTableAdfs(Hashtable corrvalEventTable) {
        Hashtable rowTable = new Hashtable();
        Enumeration gid = corrvalEventTable.keys();
        while (gid.hasMoreElements()) {
            Object groupid = gid.nextElement();
            Hashtable correlation = (Hashtable)corrvalEventTable.get(groupid);
            Enumeration timegen = correlation.keys();
            Object time = timegen.nextElement();
            Hashtable groupevents = (Hashtable)correlation.get(time);
            Enumeration rec = groupevents.keys();
            while (rec.hasMoreElements()) {
                Object recordno = rec.nextElement();
                Hashtable events = (Hashtable)groupevents.get(recordno);
                Enumeration evs = events.keys();
                while (evs.hasMoreElements()) {
                    Object evtkey = evs.nextElement();
                    if (events.get("EventCode").toString().equals("4625") && (evtkey.equals("CategoryId") || evtkey.equals("MonitorId"))) continue;
                    rowTable.put(evtkey, events.get(evtkey));
                }
            }
        }
        return rowTable;
    }

    public static Hashtable getEventTable(Hashtable corrvalEventTable) {
        Hashtable rowTable = null;
        Enumeration corrvalEnum = corrvalEventTable.keys();
        while (corrvalEnum.hasMoreElements()) {
            Object groupKey = corrvalEnum.nextElement();
            Hashtable groupEventTable = (Hashtable)corrvalEventTable.get(groupKey);
            Enumeration groupEnum = groupEventTable.keys();
            while (groupEnum.hasMoreElements()) {
                Object eventsKey = groupEnum.nextElement();
                Hashtable eventsTable = (Hashtable)groupEventTable.get(eventsKey);
                int i = 0;
                long recordNo = 0L;
                Enumeration eventsEnum = eventsTable.keys();
                while (eventsEnum.hasMoreElements()) {
                    Object eventKey = eventsEnum.nextElement();
                    Hashtable eventTable = (Hashtable)eventsTable.get(eventKey);
                    String operationType = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Operation_Type"));
                    if (i == 0 && operationType != null) {
                        if (operationType.equals(RB.getString("adap.Action.Value_Added"))) {
                            rowTable = new Hashtable(eventTable);
                        } else {
                            eventTable.put("ATTRIBUTES_OLD_VALUE", eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value")));
                            eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"), "");
                            rowTable = new Hashtable(eventTable);
                        }
                        rowTable.put("CategoryId", eventTable.get("CategoryId"));
                        rowTable.put("MonitorId", eventTable.get("MonitorId"));
                    } else if (i > 0 && rowTable != null) {
                        if (operationType != null && operationType.equals(RB.getString("adap.Action.Value_Added"))) {
                            String addedVal = (String)rowTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"));
                            String addedVal1 = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"));
                            if (addedVal != "") {
                                StringBuffer bufOb = new StringBuffer(addedVal);
                                bufOb = bufOb.append(',').append(addedVal1);
                                rowTable.put(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"), bufOb.toString());
                            } else {
                                rowTable.put(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"), addedVal1);
                            }
                        } else {
                            String deletedVal = (String)rowTable.get("ATTRIBUTES_OLD_VALUE");
                            String deletedVal1 = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Attribute_Value"));
                            if (deletedVal != null) {
                                StringBuffer deletedValBufOb = new StringBuffer(deletedVal);
                                deletedValBufOb = deletedValBufOb.append(',').append(deletedVal1);
                                rowTable.put("ATTRIBUTES_OLD_VALUE", deletedValBufOb.toString());
                            } else {
                                rowTable.put("ATTRIBUTES_OLD_VALUE", deletedVal1);
                            }
                        }
                    }
                    if (i == 0) {
                        recordNo = (Long)eventTable.get("RecordNumber");
                    } else {
                        long currentRecordNo = (Long)eventTable.get("RecordNumber");
                        if (recordNo < currentRecordNo) {
                            recordNo = currentRecordNo;
                        }
                        if (i == eventsTable.size() - 1) {
                            rowTable.put("RecordNumber", recordNo);
                        }
                    }
                    ++i;
                }
            }
        }
        return rowTable;
    }

    private Hashtable getValueTable(Hashtable correlationTable, int groupPriorityId) {
        Hashtable valueTable = null;
        Hashtable groupEvents = (Hashtable)correlationTable.get(groupPriorityId);
        Enumeration timeEnum = groupEvents.keys();
        while (timeEnum.hasMoreElements()) {
            Object timekey = timeEnum.nextElement();
            Hashtable recordTable = (Hashtable)groupEvents.get(timekey);
            Enumeration recordEnum = recordTable.keys();
            while (recordEnum.hasMoreElements()) {
                Object recordkey = recordEnum.nextElement();
                valueTable = (Hashtable)recordTable.get(recordkey);
            }
        }
        return valueTable;
    }

    private String getCorrelationValues(Hashtable eventTable) {
        String correlationValues = "";
        if (this.correlationVariables != null) {
            for (String string : this.correlationVariables) {
                if (eventTable.get(string) == null) continue;
                if (!correlationValues.equals("")) {
                    correlationValues = correlationValues + ",";
                }
                correlationValues = correlationValues + eventTable.get(string);
            }
        }
        return correlationValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Action :");
        builder.append(" -> ");
        builder.append(" Name :  ");
        builder.append(this.name);
        if (this.groupsList != null) {
            for (Group grp : this.groupsList) {
                builder.append(grp);
            }
        }
        builder.append(" Uses Correlation :  ");
        builder.append(this.useAdvCorrelations);
        builder.append(". ");
        return builder.toString();
    }

    public void addWorkItem(String correlationValues) {
        try {
            LOGGER.fine("Offering :" + EVT_PROCESSING_Q.toString());
            EVT_PROCESSING_Q.offer(new CorrelateTimedEvents(correlationValues, 10000L));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void process() {
        ArrayList expired = new ArrayList();
        EVT_PROCESSING_Q.drainTo(expired);
        LOGGER.fine("After Draining :" + EVT_PROCESSING_Q.toString());
        for (CorrelateTimedEvents timedOutEvent : expired) {
            try {
                String s = timedOutEvent.getCorrelationValues();
                Hashtable cuh = (Hashtable)CORRELATION_EVENTS_MAP.remove(s);
                String[] str = s.split(":");
                if (cuh == null) continue;
                if (DBObjectUtil.getUVHValues("AUDAction", "AUDAction:action_id:1700").toString().equals(str[str.length - 1])) {
                    Boolean status = cuh.size() == 2 ? Boolean.TRUE : Boolean.FALSE;
                    if (!status.booleanValue()) continue;
                    ProcessMonitor.addEventRows(Action.getEventTableAdfs(cuh));
                    continue;
                }
                if (DBObjectUtil.getUVHValues("AUDAction", "AUDAction:action_id:1800").toString().equals(str[str.length - 1])) {
                    if (cuh.size() != 3) continue;
                    ProcessMonitor.addEventRows(this.getClaimstable(cuh));
                    continue;
                }
                if (DBObjectUtil.getUVHValues("AUDAction", "AUDAction:action_id:1900").toString().equals(str[str.length - 1])) {
                    if (cuh.size() < 2) continue;
                    ProcessMonitor.addEventRows(this.getClaimstable(cuh));
                    continue;
                }
                ProcessMonitor.addEventRows(Action.getEventTable(cuh));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Hashtable<String, Object> getClaimstable(Hashtable corrvalEventTable) {
        Hashtable<String, Object> rowTable = new Hashtable<String, Object>();
        Enumeration corrvalEnum = corrvalEventTable.keys();
        while (corrvalEnum.hasMoreElements()) {
            Object groupKey = corrvalEnum.nextElement();
            Hashtable groupEventTable = (Hashtable)corrvalEventTable.get(groupKey);
            Enumeration groupEnum = groupEventTable.keys();
            while (groupEnum.hasMoreElements()) {
                Object eventsKey = groupEnum.nextElement();
                Hashtable eventsTable = (Hashtable)groupEventTable.get(eventsKey);
                boolean i = false;
                long recordNo = 0L;
                String callerIdentity = "";
                Enumeration eventsEnum = eventsTable.keys();
                while (eventsEnum.hasMoreElements()) {
                    Object eventKey = eventsEnum.nextElement();
                    Hashtable eventTable = (Hashtable)eventsTable.get(eventKey);
                    if ((Integer)groupKey == 16 || (Integer)groupKey == 22) {
                        if (eventTable.containsKey("Inside Corporate Network")) {
                            rowTable.put("Inside Corporate Network", eventTable.get("Inside Corporate Network"));
                        }
                        if (eventTable.containsKey("IP Address")) {
                            rowTable.put("IP Address", eventTable.get("IP Address"));
                        }
                        if ((Integer)groupKey == 22 && eventTable.get("Subject Account Name") != null) {
                            rowTable.put("Account Name", eventTable.get("Subject Account Name"));
                        }
                        callerIdentity = callerIdentity + eventTable.get("Caller Identity");
                    }
                    if ((Integer)groupKey == 15) {
                        rowTable.put("Issued Claims", eventTable.get("Issued Claims"));
                        if (eventTable.containsKey("Subject Account Name")) {
                            rowTable.put("Subject Account Name", eventTable.get("Subject Account Name"));
                        }
                    }
                    if ((Integer)groupKey != 14 && (Integer)groupKey != 21) continue;
                    rowTable.put("Relying Party", eventTable.get("Relying Party"));
                    rowTable.put("TimeGenerated", eventTable.get("TimeGenerated").toString());
                    rowTable.put("DomainController", eventTable.get("DomainController"));
                    rowTable.put("CategoryId", eventTable.get("CategoryId"));
                    rowTable.put("MonitorId", eventTable.get("MonitorId"));
                    rowTable.put("monitorDomainName", eventTable.get("monitorDomainName"));
                    rowTable.put("EventCode", eventTable.get("EventCode"));
                    rowTable.put("MachineType", eventTable.get("MachineType"));
                    rowTable.put("RecordNumber", eventTable.get("RecordNumber"));
                    rowTable.put("DomainController", eventTable.get("DomainController"));
                }
                if ((Integer)groupKey != 16 && (Integer)groupKey != 22 || callerIdentity.equals("")) continue;
                rowTable.put("Caller Identity", callerIdentity);
            }
        }
        if ((Integer)rowTable.get("EventCode") == 324) {
            rowTable.put("Failure Reason", "Federation Service could not authorize token issuance");
            rowTable.put("EventType", "16");
        } else {
            rowTable.put("FirstLine", "An Account was Successfully Logged in");
            rowTable.put("EventType", "8");
        }
        return rowTable;
    }

    static {
        try {
            String tableName = "AUDActionHandler";
            Column col = Column.getColumn((String)tableName, (String)"UNIQUE_ID");
            Criteria criteria = new Criteria(col, null, 1);
            DataObject confDO = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Iterator iterator = confDO.getRows(tableName);
            int rowCount = confDO.size(tableName);
            for (int i = 0; i < rowCount; ++i) {
                Row row = (Row)iterator.next();
                Long actionID = (Long)row.get("ACTION_ID");
                Integer handlerType = (Integer)row.get("ACTION_HANDLER");
                Integer accessType = (Integer)row.get("ACCESS_TYPE");
                action_HandlerType.put(actionID, handlerType);
                action_AccessTypes.put(actionID, accessType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class EventCorrelationThread
    extends Thread {
        private DelayBlockingQueue<CorrelateTimedEvents> delayed;

        public EventCorrelationThread(DelayBlockingQueue<CorrelateTimedEvents> delayed) {
            this.delayed = delayed;
        }

        public EventCorrelationThread(DelayBlockingQueue<CorrelateTimedEvents> delayed, String name) {
            super(name);
            this.delayed = delayed;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        public void checkAndProcess() {
            this.waitForUpdate(100L);
            Action.this.process();
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

