/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.common.server.ntfs.FileSystemAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class AudFileMonitorCriteriaHandler {
    public static void addFileServersShares(Hashtable fsDetails) {
        try {
            String domainName = (String)fsDetails.get("domainName");
            ArrayList<Long> monitorList = AuditMonitorAPI.getInstance().getMonitorsForDomain(domainName, "false", 2);
            DataObject monitorCriteriaDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            ArrayList shareNameList = (ArrayList)fsDetails.get("LOCATIONS");
            Object[] shareIds = shareNameList.toArray(new Object[shareNameList.size()]);
            DataObject shareDataObject = FileSystemAPI.getShareDO(shareIds, "LOCATION");
            if (shareDataObject != null && !shareDataObject.isEmpty()) {
                for (Long monitorId : monitorList) {
                    Row monitorServerRow = new Row("AUDFileMonitorServers");
                    String serverName = (String)fsDetails.get("serverName");
                    monitorServerRow.set("MONITOR_ID", (Object)monitorId);
                    monitorServerRow.set("SERVERNAME", (Object)serverName);
                    monitorServerRow.set("ALL_SHARES", (Object)false);
                    UniqueValueHolder criteriaId = (UniqueValueHolder)monitorServerRow.get("CRITERIA_ID");
                    monitorCriteriaDO.addRow(monitorServerRow);
                    Iterator iterator = shareDataObject.getRows("ADSMShareGeneralDetails");
                    while (iterator.hasNext()) {
                        Row shareRow = (Row)iterator.next();
                        Row monitorShareRow = new Row("AUDFileMonitorShares");
                        monitorShareRow.set("CRITERIA_ID", (Object)criteriaId);
                        monitorShareRow.set("SHARE_NAME", shareRow.get("LOCATION"));
                        monitorShareRow.set("LOCAL_PATH", shareRow.get("LOCAL_PATH"));
                        monitorCriteriaDO.addRow(monitorShareRow);
                    }
                }
            }
            CommonUtil.getPersistence(new boolean[0]).add(monitorCriteriaDO);
            MonitorManager.getInstance().getMonitors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addFileServerShares(Object monitorId, String domainName, HashMap selectedObjectsMap, DataObject updateDO) {
        try {
            Set serverSet = selectedObjectsMap.keySet();
            for (String serverName : serverSet) {
                ArrayList<Row> shareRowList = FileSystemAPI.getInstance().getSharesForServer(domainName, serverName, "false");
                Properties shareProperties = new Properties();
                for (Row row : shareRowList) {
                    shareProperties.setProperty((String)row.get("LOCATION"), (String)row.get("LOCAL_PATH"));
                }
                ArrayList shareList = (ArrayList)selectedObjectsMap.get(serverName);
                Row serverRow = new Row("AUDFileMonitorServers");
                serverRow.set("MONITOR_ID", monitorId);
                serverRow.set("SERVERNAME", (Object)serverName);
                serverRow.set("ALL_SHARES", (Object)false);
                UniqueValueHolder criteriaIdHolder = (UniqueValueHolder)serverRow.get("CRITERIA_ID");
                for (Object object : shareList) {
                    String shareName = (String)object;
                    String shareLocalPath = shareProperties.getProperty(shareName);
                    if (shareLocalPath == null) continue;
                    Row shareRow = new Row("AUDFileMonitorShares");
                    shareRow.set("CRITERIA_ID", (Object)criteriaIdHolder);
                    shareRow.set("SHARE_NAME", (Object)shareName);
                    shareRow.set("LOCAL_PATH", (Object)shareLocalPath);
                    updateDO.addRow(shareRow);
                }
                updateDO.addRow(serverRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFileServerShares(Long monitorId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void addFileServersShares(String domainName, String serverName, ArrayList shareList) {
        try {
            ArrayList<Long> monitorList = AuditMonitorAPI.getInstance().getMonitorsForDomain(domainName, "false", 2);
            DataObject monitorCriteriaDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria serverCriteria = new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"MONITOR_ID"), (Object)monitorList.toArray(), 8);
            Criteria cri = new Criteria(Column.getColumn((String)"AUDFileMonitorServers", (String)"SERVERNAME"), (Object)serverName, 0);
            serverCriteria = serverCriteria.and(cri);
            Object[] shareIds = shareList.toArray(new Object[shareList.size()]);
            DataObject shareDataObject = FileSystemAPI.getShareDO(shareIds, "LOCATION");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDFileMonitorServers", serverCriteria);
            if (shareDataObject != null && !shareDataObject.isEmpty() && dataObject != null && !dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDFileMonitorServers");
                while (iterator.hasNext()) {
                    Row monitorServerRow = (Row)iterator.next();
                    Long criteriaId = (Long)monitorServerRow.get("CRITERIA_ID");
                    Iterator iterator1 = shareDataObject.getRows("ADSMShareGeneralDetails");
                    while (iterator1.hasNext()) {
                        Row shareRow = (Row)iterator1.next();
                        Row monitorShareRow = new Row("AUDFileMonitorShares");
                        monitorShareRow.set("CRITERIA_ID", (Object)criteriaId);
                        monitorShareRow.set("SHARE_NAME", shareRow.get("LOCATION"));
                        monitorShareRow.set("LOCAL_PATH", shareRow.get("LOCAL_PATH"));
                        monitorCriteriaDO.addRow(monitorShareRow);
                    }
                }
            }
            CommonUtil.getPersistence(new boolean[0]).add(monitorCriteriaDO);
            MonitorManager.getInstance().getMonitors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

