/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AudMonitorCriteriaHandler {
    public static boolean deleteMonitorCriteriaObjects(Long monitorId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorCriteria", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteMonitorCriteriaResult(Long criteriaId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorCriteriaResult", (String)"CRITERIA_ID"), (Object)criteriaId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void updateMonitorCriteriaObjects(String domainName, Integer reportId) {
        if (reportId == 15) {
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "organizationalUnit", "user");
        } else if (reportId == 109) {
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "organizationalUnit", "group");
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "group", "user");
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "group", "computer");
        } else if (reportId == 210) {
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "organizationalUnit", "computer");
        } else if (reportId == 701) {
            AudMonitorCriteriaHandler.updateCriteriaResultObjects(domainName, "organizationalUnit", "organizationalUnit");
        }
        if (reportId == 15 || reportId == 109 || reportId == 210 || reportId == 701) {
            try {
                MonitorManager.getInstance().getMonitors(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateCriteriaResultObjects(String domainName, String objectClass, String resultObjectClass) {
        ArrayList<Long> categoryIdList = AudMonitorCriteriaHandler.getCategories(objectClass, resultObjectClass);
        for (Long categoryId : categoryIdList) {
            ArrayList<Long> monitorList = AudMonitorCriteriaHandler.getMonitorsForCategory(domainName, categoryId);
            for (Long monitorId : monitorList) {
                AudMonitorCriteriaHandler.updateMonitorCriteriaResult(domainName, objectClass, monitorId, categoryId);
            }
        }
    }

    public static ArrayList<Long> getMonitorsForCategory(String domainName, Long categoryId) {
        ArrayList<Long> monitorList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"), (Object)categoryId, 0);
            criteria = criteria.and(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", criteria);
            Iterator rowIterator = dataObject.getRows("AUDMonitor");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                monitorList.add((Long)row.get("MONITOR_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorList;
    }

    public static ArrayList<Long> getCategories(String objectClass, String resultObjectClass) {
        ArrayList<Long> categoryIdList = new ArrayList<Long>();
        LinkedHashMap categoryMap = AuditCatgoryAPI.getInstance().getCategories();
        for (Map.Entry entry : categoryMap.entrySet()) {
            ObjectClass[] categorySelectObjects;
            Category category = (Category)entry.getValue();
            ObjectClass categoryResultObjectClass = category.getResultObjectClass();
            if (!categoryResultObjectClass.getObjectClass().equalsIgnoreCase(resultObjectClass) || category.getCategorySelectObjects() == null) continue;
            for (ObjectClass categorySelectObjectClass : categorySelectObjects = category.getCategorySelectObjects()) {
                if (!categorySelectObjectClass.getObjectClass().equalsIgnoreCase(objectClass)) continue;
                categoryIdList.add((Long)entry.getKey());
            }
        }
        return categoryIdList;
    }

    public static ArrayList<Row> getCriteriaResult(String domainName, Object criteriaId, String guid, String objectClass, Object categoryId) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        try {
            ObjectClass resultObject = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId).getResultObjectClass();
            String resultObjectClass = resultObject.getObjectClass();
            Long logonCategoryId = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:1");
            Long ouCategoryId = DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:7");
            Long[] mgmtIds = new Long[]{DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:3"), DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:4"), DBObjectUtil.getUVHValues("AUDCategories", "AUDCategories:category_id:5")};
            boolean isSecCriteria = false;
            String secVariableType = "SAM_ACCOUNT_NAME";
            if (logonCategoryId.equals(categoryId)) {
                isSecCriteria = true;
            }
            for (int i = 0; i < mgmtIds.length; ++i) {
                if (!categoryId.equals(mgmtIds[i])) continue;
                isSecCriteria = true;
                secVariableType = "OBJECT_GUID";
            }
            String primaryVariableType = "SID_STRING";
            if (ouCategoryId.equals(categoryId)) {
                primaryVariableType = "OBJECT_GUID";
            }
            if (objectClass.equalsIgnoreCase(resultObjectClass) && primaryVariableType.equalsIgnoreCase("SID_STRING")) {
                Row dirObjectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, guid, objectClass);
                if (dirObjectRow != null) {
                    Row row;
                    String sidString = (String)dirObjectRow.get(primaryVariableType);
                    Row monitorCriteriaResultRow = new Row("AUDMonitorCriteriaResult");
                    monitorCriteriaResultRow.set("CRITERIA_ID", criteriaId);
                    monitorCriteriaResultRow.set("CRITERIA_OBJECT", (Object)sidString);
                    monitorCriteriaResultRow.set("VARIABLE_TYPE", (Object)primaryVariableType);
                    rowList.add(monitorCriteriaResultRow);
                    if (isSecCriteria && (row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, sidString, "SID_STRING", objectClass)) != null) {
                        Row monitorCriteriaResultRow2 = new Row("AUDMonitorCriteriaResult");
                        monitorCriteriaResultRow2.set("CRITERIA_ID", criteriaId);
                        monitorCriteriaResultRow2.set("CRITERIA_OBJECT", row.get(secVariableType));
                        monitorCriteriaResultRow2.set("VARIABLE_TYPE", (Object)secVariableType);
                        rowList.add(monitorCriteriaResultRow2);
                    }
                }
            } else {
                ArrayList criteiaResultObjectList = DirectoryObjectAPI.getInstance().getChildObjects(domainName, objectClass, resultObjectClass, guid);
                for (Object object2 : criteiaResultObjectList) {
                    HashMap hashMap = (HashMap)object2;
                    Row monitorCriteriaResultRow = new Row("AUDMonitorCriteriaResult");
                    monitorCriteriaResultRow.set("CRITERIA_ID", criteriaId);
                    monitorCriteriaResultRow.set("CRITERIA_OBJECT", hashMap.get(primaryVariableType));
                    monitorCriteriaResultRow.set("VARIABLE_TYPE", (Object)primaryVariableType);
                    rowList.add(monitorCriteriaResultRow);
                    if (!isSecCriteria) continue;
                    Row monitorCriteriaResultRow2 = new Row("AUDMonitorCriteriaResult");
                    monitorCriteriaResultRow2.set("CRITERIA_ID", criteriaId);
                    monitorCriteriaResultRow2.set("CRITERIA_OBJECT", hashMap.get(secVariableType));
                    monitorCriteriaResultRow2.set("VARIABLE_TYPE", (Object)secVariableType);
                    rowList.add(monitorCriteriaResultRow2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowList;
    }

    public static void addMonitorCriteriaObjects(String domainName, Object monitorId, DataObject dataObject, HashMap selectedObjectsMap, Object categoryId) {
        try {
            Set objectClasses = selectedObjectsMap.keySet();
            for (String objectClass : objectClasses) {
                ArrayList objectsList = (ArrayList)selectedObjectsMap.get(objectClass);
                for (Object object : objectsList) {
                    HashMap objectMap = (HashMap)object;
                    String guid = (String)objectMap.get("OBJECT_GUID");
                    Row monitorCriteriaRow = new Row("AUDMonitorCriteria");
                    monitorCriteriaRow.set("MONITOR_ID", monitorId);
                    monitorCriteriaRow.set("OBJECT_CLASS", (Object)objectClass);
                    monitorCriteriaRow.set("OBJECT_GUID", (Object)guid);
                    UniqueValueHolder criteriaId = (UniqueValueHolder)monitorCriteriaRow.get("CRITERIA_ID");
                    dataObject.addRow(monitorCriteriaRow);
                    if (objectClass.equalsIgnoreCase("domainDNS")) continue;
                    ArrayList<Row> rowList = AudMonitorCriteriaHandler.getCriteriaResult(domainName, criteriaId, guid, objectClass, categoryId);
                    for (Row row : rowList) {
                        dataObject.addRow(row);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateMonitorCriteriaResult(String domainName, String objectClass, Long monitorId, Long categoryId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorCriteria", (String)"MONITOR_ID"), (Object)monitorId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitorCriteria", (String)"OBJECT_CLASS"), (Object)objectClass, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorCriteria", criteria);
            DataObject updateDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Iterator rowIterator = dataObject.getRows("AUDMonitorCriteria");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                Long criteriaId = (Long)row.get("CRITERIA_ID");
                ArrayList<Row> rowList = AudMonitorCriteriaHandler.getCriteriaResult(domainName, criteriaId, (String)row.get("OBJECT_GUID"), objectClass, categoryId);
                if (rowList.size() <= 0 || !AudMonitorCriteriaHandler.deleteMonitorCriteriaResult(criteriaId)) continue;
                for (Row newRow : rowList) {
                    updateDataObject.addRow(newRow);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).add(updateDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

