/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AudColumnConfig;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class AudMonitorReportHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static boolean createMonitorReport(Long monitorId, HashMap propsMap, HashMap columnMap, String defaultSortColumn, HashMap categoryElementColumnMap) {
        boolean isReportCreated = false;
        try {
            String monitorName = (String)propsMap.get("MONITOR_NAME");
            HashMap<String, Cloneable> reportDetailsMap = new HashMap<String, Cloneable>();
            HashMap audReportsMap = new HashMap();
            audReportsMap.put("REPORT_CATEGORY_TYPE", propsMap.get("MONITOR_TYPE"));
            audReportsMap.put("REPORT_CATEGORY_ID", 1L);
            audReportsMap.put("AUDIT_REPORT_NAME", monitorName);
            audReportsMap.put("DISPLAY_TYPE", "TABLE");
            audReportsMap.put("TITLE", monitorName);
            audReportsMap.put("DESCRIPTION", rb.handleGetObject("adap.AudMonitorReportHandler.Showing_Reports_for_monitorName", new String[]{monitorName}));
            audReportsMap.put("TILE_NAME", "report");
            audReportsMap.put("PRIORITY", 21L);
            boolean isInputNeeded = true;
            audReportsMap.put("IS_INPUT_NEEDED", isInputNeeded);
            audReportsMap.put("JASPER_NAME", "UserDetails.xml");
            reportDetailsMap.put("AUDReports", audReportsMap);
            String dbServerName = CommonUtil.getDBServerName();
            ArrayList queryList = new ArrayList();
            HashMap<String, Object> sqlQueryMap = new HashMap<String, Object>();
            sqlQueryMap.put("SQL_STRING", AuditMonitorAPI.getInstance().getMonitorReportSQLString(monitorId, (Long)propsMap.get("CATEGORY_ID")));
            sqlQueryMap.put("COUNT_SQL_STRING", AuditMonitorAPI.getInstance().getMonitorReportCountSQLString(monitorId));
            sqlQueryMap.put("GROUPBYUSED", false);
            sqlQueryMap.put("UNION_USED", true);
            ArrayList uqList = new ArrayList();
            HashMap<String, String> uqMap = new HashMap<String, String>();
            uqMap.put("UNION_QUERY", AuditMonitorAPI.getInstance().getMonitorReportUnionSQLString(monitorId));
            uqMap.put("UNION_COUNT_QUERY", AuditMonitorAPI.getInstance().getMonitorReportUnionCountSQLString(monitorId));
            uqList.add(uqMap);
            sqlQueryMap.put("AUDUnionQuery", uqList);
            HashMap<String, String> cvConfigMap = new HashMap<String, String>();
            cvConfigMap.put("CV_NAME", monitorName);
            sqlQueryMap.put("AUDCVConfig", cvConfigMap);
            sqlQueryMap.put("AUDColumnConfiguration", columnMap);
            queryList.add(sqlQueryMap);
            reportDetailsMap.put("AUDSQLQuery", queryList);
            HashMap<String, Object> viewConfigMap = new HashMap<String, Object>();
            viewConfigMap.put("EMPTY_TABLE_MESSAGE", rb.handleGetObject("adap.AudMonitorReportHandler.No_Result_Found"));
            viewConfigMap.put("PAGELENGTH", 25);
            viewConfigMap.put("SORTCOLUMN", defaultSortColumn);
            viewConfigMap.put("SORTORDER", "DESC");
            reportDetailsMap.put("AUDTableViewConfig", viewConfigMap);
            Long reportId = AuditReportHandler.saveNewReportDetails(reportDetailsMap, categoryElementColumnMap);
            if (reportId != null) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row row = new Row("AUDMonitorReportMap");
                row.set("MONITOR_ID", (Object)monitorId);
                row.set("AUDIT_REPORT_ID", (Object)reportId);
                dataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                AUDCustomViewAPI.getInstance().addCvIdInMap(reportId);
                AudColumnConfig.getInstance().addColDispNameInMap(reportId);
                AuditReportAPI.getInstance().addORUpdateReportDetails(reportId);
            }
            isReportCreated = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isReportCreated;
    }

    public boolean deleteMonitorReportViewColumns(Long monitorId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorRepViewColumns", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

