/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.JSONUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuditActionHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static boolean saveAction(HashMap actionMap) throws Exception {
        try {
            DataObject actionDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row actionRow = new Row("AUDAction");
            actionRow.set("ACTION_NAME", (Object)((String)actionMap.get("ACTION_NAME")));
            actionRow.set("ACTION_DESCRIPTION", (Object)((String)actionMap.get("ACTION_DESCRIPTION")));
            actionRow.set("CATEGORY_ID", (Object)Long.parseLong(String.valueOf(actionMap.get("CATEGORY_ID"))));
            Boolean useAdvCorrelations = (Boolean)actionMap.get("USE_ADV_CORRELATIONS");
            UniqueValueHolder actionIDHolder = (UniqueValueHolder)actionRow.get("ACTION_ID");
            if (useAdvCorrelations.booleanValue()) {
                actionRow.set("USE_ADV_CORRELATIONS", (Object)useAdvCorrelations);
                actionRow.set("TIME_INTERVAL", (Object)Long.parseLong(String.valueOf(actionMap.get("TIME_INTERVAL"))));
                actionRow.set("OPERATOR", (Object)102);
                ArrayList rowList = AuditActionHandler.getCorrelationRow(actionMap, actionIDHolder);
                for (Object object : rowList) {
                    Row row = (Row)object;
                    actionDataObject.addRow(row);
                }
            }
            actionDataObject.addRow(actionRow);
            AuditActionHandler.addActionGroups(actionMap, actionDataObject, actionIDHolder);
            CommonUtil.getPersistence(new boolean[0]).add(actionDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public static ArrayList getCorrelationRow(HashMap actionMap, Object actionId) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        try {
            ArrayList correlationVariables = (ArrayList)actionMap.get("correlationVariables");
            for (Object object : correlationVariables) {
                Row row = new Row("AUDCorrelationRules");
                row.set("ACTION_ID", actionId);
                row.set("VARIABLE_ID", object);
                rowList.add(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowList;
    }

    public static boolean deleteCorrelationRows(Object actionId) {
        boolean isDeleted = false;
        try {
            Criteria deleteCriteria = new Criteria(Column.getColumn((String)"AUDCorrelationRules", (String)"ACTION_ID"), actionId, 0);
            CommonUtil.getPersistenceLite().delete(deleteCriteria);
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean addActionGroups(HashMap actionMap, DataObject dataObject, Object actionId) {
        try {
            TreeMap actionGroupsMap = (TreeMap)actionMap.get("ACTION_GROUPS");
            Set groupKeySet = actionGroupsMap.keySet();
            int priorityId = 1;
            for (String groupKey : groupKeySet) {
                HashMap groupMap = (HashMap)actionGroupsMap.get(groupKey);
                Row groupRow = new Row("AUDGroup");
                groupRow.set("GROUP_NAME", (Object)((String)groupMap.get("GROUP_NAME")));
                groupRow.set("ACTION_ID", actionId);
                groupRow.set("PRIORITY_ID", (Object)priorityId++);
                String string = (String)groupMap.get("OPERATOR");
                if (string == null) {
                    string = String.valueOf(groupMap.get("LOGIC_OPERATOR"));
                }
                if (string != null) {
                    groupRow.set("OPERATOR", (Object)Integer.parseInt(string));
                }
                UniqueValueHolder groupIDHolder = (UniqueValueHolder)groupRow.get("GROUP_ID");
                HashMap rulesMap = (HashMap)groupMap.get("GROUP_RULES");
                Set rulesKeySet = rulesMap.keySet();
                for (String ruleKey : rulesKeySet) {
                    HashMap ruleDetailsMap = (HashMap)rulesMap.get(ruleKey);
                    Row ruleRow = new Row("AUDRule");
                    ruleRow.set("OPERATOR", (Object)Integer.parseInt(String.valueOf(ruleDetailsMap.get("REL_OPERATOR"))));
                    ruleRow.set("VARIABLE_ID", (Object)Long.parseLong(String.valueOf(ruleDetailsMap.get("VARIABLE_ID"))));
                    if (ruleDetailsMap.containsKey("VALUE_TEXT")) {
                        ruleRow.set("VALUE", (Object)((String)ruleDetailsMap.get("VALUE_TEXT")));
                    } else {
                        ruleRow.set("VALUE", (Object)((String)ruleDetailsMap.get("VALUE")));
                    }
                    ruleRow.set("GROUP_ID", (Object)groupIDHolder);
                    dataObject.addRow(ruleRow);
                }
                if (groupRow.get("OPERATOR") == null) {
                    groupRow.set("OPERATOR", (Object)101);
                }
                dataObject.addRow(groupRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean copyAction(Long actionId, String actionName) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAction");
            tablesList.add("AUDGroup");
            tablesList.add("AUDRule");
            tablesList.add("AUDCorrelationRules");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDCorrelationRules");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
            DataObject toBeAddedDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row actionRow = dataObject.getRow("AUDAction");
            Row toBeAddedActionRow = new Row("AUDAction");
            toBeAddedActionRow.set("ACTION_NAME", (Object)actionName);
            toBeAddedActionRow.set("ACTION_DESCRIPTION", actionRow.get("ACTION_DESCRIPTION"));
            toBeAddedActionRow.set("CATEGORY_ID", actionRow.get("CATEGORY_ID"));
            Boolean useAdvCorrelations = (Boolean)actionRow.get("USE_ADV_CORRELATIONS");
            UniqueValueHolder actionIDHolder = (UniqueValueHolder)toBeAddedActionRow.get("ACTION_ID");
            if (useAdvCorrelations.booleanValue()) {
                toBeAddedActionRow.set("USE_ADV_CORRELATIONS", (Object)useAdvCorrelations);
                toBeAddedActionRow.set("TIME_INTERVAL", (Object)((Long)actionRow.get("TIME_INTERVAL")));
                toBeAddedActionRow.set("OPERATOR", (Object)102);
                Iterator rowIterator = dataObject.getRows("AUDCorrelationRules");
                while (rowIterator.hasNext()) {
                    Row correlationRow = (Row)rowIterator.next();
                    Row toBeAddedCorrelationRow = new Row("AUDCorrelationRules");
                    toBeAddedCorrelationRow.set("ACTION_ID", (Object)actionIDHolder);
                    toBeAddedCorrelationRow.set("VARIABLE_ID", correlationRow.get("VARIABLE_ID"));
                    toBeAddedCorrelationRow.set("CORRELATION_OPERATOR", correlationRow.get("CORRELATION_OPERATOR"));
                    toBeAddedDataObject.addRow(toBeAddedCorrelationRow);
                }
            }
            toBeAddedDataObject.addRow(toBeAddedActionRow);
            UniqueValueHolder actionValueHolder = (UniqueValueHolder)toBeAddedActionRow.get("ACTION_ID");
            Iterator groupItr = dataObject.getRows("AUDGroup");
            while (groupItr.hasNext()) {
                Row groupRow = (Row)groupItr.next();
                Row toBeAddedGroupRow = new Row("AUDGroup");
                toBeAddedGroupRow.set("GROUP_NAME", groupRow.get("GROUP_NAME"));
                toBeAddedGroupRow.set("OPERATOR", groupRow.get("OPERATOR"));
                toBeAddedGroupRow.set("ACTION_ID", (Object)actionValueHolder);
                toBeAddedGroupRow.set("PRIORITY_ID", groupRow.get("PRIORITY_ID"));
                UniqueValueHolder groupValueHolder = (UniqueValueHolder)toBeAddedGroupRow.get("GROUP_ID");
                Long groupId = (Long)groupRow.get("GROUP_ID");
                Criteria groupCriteria = new Criteria(Column.getColumn((String)"AUDRule", (String)"GROUP_ID"), (Object)groupId, 0);
                Iterator ruleItr = dataObject.getRows("AUDRule", groupCriteria);
                while (ruleItr.hasNext()) {
                    Row ruleRow = (Row)ruleItr.next();
                    Row toBeAddedRuleRow = new Row("AUDRule");
                    toBeAddedRuleRow.set("GROUP_ID", (Object)groupValueHolder);
                    toBeAddedRuleRow.set("VARIABLE_ID", ruleRow.get("VARIABLE_ID"));
                    toBeAddedRuleRow.set("OPERATOR", ruleRow.get("OPERATOR"));
                    toBeAddedRuleRow.set("VALUE", ruleRow.get("VALUE"));
                    toBeAddedDataObject.addRow(toBeAddedRuleRow);
                }
                toBeAddedDataObject.addRow(toBeAddedGroupRow);
            }
            CommonUtil.getPersistence(new boolean[0]).add(toBeAddedDataObject);
            status = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean updateAction(HashMap actionMap, Long actionId) throws Exception {
        try {
            Criteria updateCriteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
            DataObject updateDO = CommonUtil.getPersistence(new boolean[0]).get("AUDAction", updateCriteria);
            Row updateRow = updateDO.getRow("AUDAction");
            updateRow.set("ACTION_NAME", (Object)((String)actionMap.get("ACTION_NAME")));
            updateRow.set("ACTION_DESCRIPTION", (Object)((String)actionMap.get("ACTION_DESCRIPTION")));
            Boolean useAdvCorrelations = (Boolean)actionMap.get("USE_ADV_CORRELATIONS");
            if (useAdvCorrelations.booleanValue()) {
                updateRow.set("USE_ADV_CORRELATIONS", (Object)useAdvCorrelations);
                updateRow.set("TIME_INTERVAL", (Object)Long.parseLong(String.valueOf(actionMap.get("TIME_INTERVAL"))));
                updateRow.set("OPERATOR", (Object)102);
                if (AuditActionHandler.deleteCorrelationRows(actionId)) {
                    DataObject correlationDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    ArrayList rowList = AuditActionHandler.getCorrelationRow(actionMap, actionId);
                    for (Object object : rowList) {
                        Row row = (Row)object;
                        correlationDO.addRow(row);
                    }
                    CommonUtil.getPersistence(new boolean[0]).add(correlationDO);
                }
            } else {
                updateRow.set("USE_ADV_CORRELATIONS", (Object)useAdvCorrelations);
                updateRow.set("OPERATOR", (Object)101);
                updateRow.set("TIME_INTERVAL", (Object)0);
                AuditActionHandler.deleteCorrelationRows(actionId);
            }
            updateDO.updateRow(updateRow);
            CommonUtil.getPersistence(new boolean[0]).update(updateDO);
            DataObject groupDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (AuditActionHandler.deleteActionGroups(actionId)) {
                AuditActionHandler.addActionGroups(actionMap, groupDO, actionId);
                CommonUtil.getPersistence(new boolean[0]).add(groupDO);
            }
            MonitorManager.getInstance().updateMonitorMap(actionId);
            System.out.println("action id in auditActionHandler :: " + actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public static boolean deleteActionGroups(Long actionId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDGroup", (String)"ACTION_ID"), (Object)actionId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteAction(Long actionId) {
        Boolean status = false;
        try {
            Criteria checkCriteria = new Criteria(Column.getColumn((String)"AUDMonitorActions", (String)"ACTION_ID"), (Object)actionId, 0);
            DataObject updateDO = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorActions", checkCriteria);
            boolean a = false;
            if (updateDO.isEmpty()) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
                CommonUtil.getPersistenceLite().delete(criteria);
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public static boolean deleteCheck(Long actionId) {
        Boolean status = false;
        try {
            Criteria checkCriteria = new Criteria(Column.getColumn((String)"AUDMonitorActions", (String)"ACTION_ID"), (Object)actionId, 0);
            DataObject updateDO = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorActions", checkCriteria);
            if (updateDO.isEmpty()) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public static Hashtable getActionDetails(Long actionId) throws Exception {
        Hashtable<String, Object> actionTable = new Hashtable<String, Object>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDAction");
            tablesList.add("AUDGroup");
            tablesList.add("AUDRule");
            tablesList.add("AUDRuleVariables");
            tablesList.add("AUDCorrelationRules");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDGroup");
            leftJoinList.add("AUDRule");
            leftJoinList.add("AUDRuleVariables");
            leftJoinList.add("AUDCorrelationRules");
            DataObject actionDataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
            Row actionRow = actionDataObject.getRow("AUDAction");
            actionTable.put("CATEGORY_ID", actionRow.get("CATEGORY_ID"));
            actionTable.put("ACTION_ID", actionId);
            actionTable.put("ACTION_NAME", (String)actionRow.get("ACTION_NAME"));
            actionTable.put("ACTION_DESCRIPTION", (String)actionRow.get("ACTION_DESCRIPTION"));
            Boolean useAdvCorrelations = (Boolean)actionRow.get("USE_ADV_CORRELATIONS");
            actionTable.put("USE_ADV_CORRELATIONS", useAdvCorrelations);
            actionTable.put("TIME_INTERVAL", actionRow.get("TIME_INTERVAL"));
            if (useAdvCorrelations.booleanValue()) {
                Criteria correlationRuleCriteria = new Criteria(Column.getColumn((String)"AUDCorrelationRules", (String)"ACTION_ID"), (Object)actionId, 0);
                ArrayList<Object> correlationVarList = new ArrayList<Object>();
                Iterator correlationRuleIterator = actionDataObject.getRows("AUDCorrelationRules", correlationRuleCriteria);
                while (correlationRuleIterator.hasNext()) {
                    Row correlationRuleRow = (Row)correlationRuleIterator.next();
                    correlationVarList.add(correlationRuleRow.get("VARIABLE_ID"));
                }
                actionTable.put("correlationVariables", correlationVarList);
            }
            Criteria actionCriteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
            ArrayList<Hashtable> groupsList = new ArrayList<Hashtable>();
            TreeMap treeMap = new TreeMap();
            Iterator groupIterator = actionDataObject.getRows("AUDGroup", actionCriteria);
            while (groupIterator.hasNext()) {
                Row groupRow = (Row)groupIterator.next();
                Hashtable<String, Object> groupTable = new Hashtable<String, Object>();
                Long groupId = (Long)groupRow.get("GROUP_ID");
                Integer priorityId = (Integer)groupRow.get("PRIORITY_ID");
                groupTable.put("GROUP_ID", groupId);
                groupTable.put("GROUP_NAME", (String)groupRow.get("GROUP_NAME"));
                groupTable.put("LOGIC_OPERATOR", groupRow.get("OPERATOR"));
                groupTable.put("PRIORITY_ID", priorityId);
                Criteria groupCriteria = new Criteria(Column.getColumn((String)"AUDRule", (String)"GROUP_ID"), (Object)groupId, 0);
                ArrayList rulesList = new ArrayList();
                Iterator rowIterator = actionDataObject.getRows("AUDRule", groupCriteria);
                while (rowIterator.hasNext()) {
                    Row ruleRow = (Row)rowIterator.next();
                    Hashtable<String, Object> ruleTable = new Hashtable<String, Object>();
                    Long ruleId = (Long)ruleRow.get("RULE_ID");
                    ruleTable.put("RULE_ID", ruleId);
                    Long variableId = (Long)ruleRow.get("VARIABLE_ID");
                    ruleTable.put("VARIABLE_ID", variableId);
                    ruleTable.put("REL_OPERATOR", ruleRow.get("OPERATOR"));
                    ruleTable.put("VALUE", (String)ruleRow.get("VALUE"));
                    rulesList.add(ruleTable);
                }
                groupTable.put("GROUP_RULES", rulesList);
                treeMap.put(priorityId, groupTable);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                groupsList.add((Hashtable)entry.getValue());
            }
            actionTable.put("ACTION_GROUPS", groupsList);
        }
        catch (Exception e) {
            new Exception("Error in Getting Action Details");
            e.printStackTrace();
        }
        return actionTable;
    }

    public static JSONObject getActionDetails2(Long actionId, Long categoryId) throws Exception {
        JSONObject actionTable = new JSONObject();
        try {
            ArrayList variablesList = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId).getVariablesList();
            JSONObject variablesSelectInput = JSONUtil.mapToJSONObject(AuditActionHandler.setSelectValues(categoryId, variablesList));
            JSONArray variablesArray = new JSONArray();
            JSONObject variablesObject = new JSONObject();
            for (int i = 0; i < variablesList.size(); ++i) {
                JSONObject variable = new JSONObject();
                Hashtable variableTable = (Hashtable)variablesList.get(i);
                Enumeration iter = variableTable.keys();
                while (iter.hasMoreElements()) {
                    String ele = String.valueOf(iter.nextElement());
                    variable.put(ele, variableTable.get(ele));
                }
                variable.put("name", (Object)rb.getString(String.valueOf(variableTable.get("VARIABLE_DISPLAY_NAME"))));
                variable.put("value", variableTable.get("VARIABLE_ID"));
                variablesObject.put(String.valueOf(variableTable.get("VARIABLE_ID")), (Object)(variableTable.get("VARIABLE_DATATYPE") + "," + variableTable.get("INPUT_TYPE")));
                variablesArray.put((Object)variable);
            }
            HashMap relationalOperators = ActionConstants.getRelationalOperaions();
            JSONObject operators = JSONUtil.mapToJSONObject(relationalOperators);
            actionTable.put("ACTION_GROUPS", (Object)new JSONArray());
            actionTable.put("ACTION_NAME", (Object)"");
            actionTable.put("ACTION_DESCRIPTION", (Object)"");
            actionTable.put("CATEGORY_ID", (Object)categoryId);
            actionTable.put("USE_ADV_CORRELATIONS", false);
            actionTable.put("TIME_INTERVAL", (Object)"0");
            if (actionId != null) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
                ArrayList<String> tablesList = new ArrayList<String>();
                tablesList.add("AUDAction");
                tablesList.add("AUDGroup");
                tablesList.add("AUDRule");
                tablesList.add("AUDRuleVariables");
                tablesList.add("AUDCorrelationRules");
                ArrayList<String> leftJoinList = new ArrayList<String>();
                leftJoinList.add("AUDGroup");
                leftJoinList.add("AUDRule");
                leftJoinList.add("AUDRuleVariables");
                leftJoinList.add("AUDCorrelationRules");
                DataObject actionDataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
                Row actionRow = actionDataObject.getRow("AUDAction");
                actionTable.put("CATEGORY_ID", actionRow.get("CATEGORY_ID"));
                actionTable.put("ACTION_ID", (Object)actionId);
                actionTable.put("ACTION_NAME", (Object)rb.getString((String)actionRow.get("ACTION_NAME")));
                actionTable.put("ACTION_DESCRIPTION", (Object)rb.getString((String)actionRow.get("ACTION_DESCRIPTION")));
                Boolean useAdvCorrelations = (Boolean)actionRow.get("USE_ADV_CORRELATIONS");
                actionTable.put("USE_ADV_CORRELATIONS", (Object)useAdvCorrelations);
                actionTable.put("TIME_INTERVAL", actionRow.get("TIME_INTERVAL"));
                if (useAdvCorrelations.booleanValue()) {
                    Criteria correlationRuleCriteria = new Criteria(Column.getColumn((String)"AUDCorrelationRules", (String)"ACTION_ID"), (Object)actionId, 0);
                    JSONArray correlationVarList = new JSONArray();
                    Iterator correlationRuleIterator = actionDataObject.getRows("AUDCorrelationRules", correlationRuleCriteria);
                    while (correlationRuleIterator.hasNext()) {
                        Row correlationRuleRow = (Row)correlationRuleIterator.next();
                        JSONObject ruleRow = new JSONObject();
                        ruleRow.put("value", correlationRuleRow.get("VARIABLE_ID"));
                        correlationVarList.put((Object)ruleRow);
                    }
                    actionTable.put("correlationVariables2", (Object)correlationVarList);
                }
                Criteria actionCriteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
                JSONArray groupsList = new JSONArray();
                TreeMap<Integer, JSONObject> treeMap = new TreeMap<Integer, JSONObject>();
                Iterator groupIterator = actionDataObject.getRows("AUDGroup", actionCriteria);
                while (groupIterator.hasNext()) {
                    Row groupRow = (Row)groupIterator.next();
                    JSONObject groupTable = new JSONObject();
                    Long groupId = (Long)groupRow.get("GROUP_ID");
                    Integer priorityId = (Integer)groupRow.get("PRIORITY_ID");
                    groupTable.put("GROUP_ID", (Object)groupId);
                    groupTable.put("GROUP_CLASS", (Object)("CLASS" + groupId));
                    groupTable.put("GROUP_NAME", (Object)rb.getString((String)groupRow.get("GROUP_NAME")));
                    groupTable.put("LOGIC_OPERATOR", groupRow.get("OPERATOR"));
                    groupTable.put("PRIORITY_ID", (Object)priorityId);
                    Criteria groupCriteria = new Criteria(Column.getColumn((String)"AUDRule", (String)"GROUP_ID"), (Object)groupId, 0);
                    JSONArray rulesList = new JSONArray();
                    Iterator rowIterator = actionDataObject.getRows("AUDRule", groupCriteria);
                    while (rowIterator.hasNext()) {
                        Row ruleRow = (Row)rowIterator.next();
                        JSONObject ruleTable = new JSONObject();
                        Long ruleId = (Long)ruleRow.get("RULE_ID");
                        ruleTable.put("RULE_ID", (Object)ruleId);
                        Long variableId = (Long)ruleRow.get("VARIABLE_ID");
                        ruleTable.put("VARIABLE_ID", (Object)variableId);
                        ruleTable.put("REL_OPERATOR", ruleRow.get("OPERATOR"));
                        ruleTable.put("VALUE", (Object)((String)ruleRow.get("VALUE")));
                        ruleTable.put("OPERATORS", operators.get(String.valueOf(variablesObject.get(String.valueOf(variableId)))));
                        ruleTable.put("SELECT_VALUE_LIST", variablesSelectInput.opt(String.valueOf(variableId)));
                        rulesList.put((Object)ruleTable);
                    }
                    groupTable.put("GROUP_RULES", (Object)rulesList);
                    treeMap.put(priorityId, groupTable);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    groupsList.put((Object)((JSONObject)entry.getValue()));
                }
                actionTable.put("ACTION_GROUPS", (Object)groupsList);
            }
            actionTable.put("variablesArray", (Object)variablesArray);
            actionTable.put("operators", (Object)operators);
            actionTable.put("variablesSelectInput", (Object)variablesSelectInput);
            actionTable.put("variablesObject", (Object)variablesObject);
        }
        catch (Exception e) {
            new Exception("Error in Getting Action Details");
            e.printStackTrace();
        }
        return actionTable;
    }

    public static HashMap setSelectValues(Long categoryId, ArrayList variablesList) {
        HashMap variablesSelectInput = new HashMap();
        for (Object object : variablesList) {
            SchemaClass schemaClass;
            String[] schemaClasses;
            Hashtable variableTable = (Hashtable)object;
            if (!variableTable.get("INPUT_TYPE").toString().equalsIgnoreCase("SINGLE_SELECT")) continue;
            String variableName = (String)variableTable.get("VARIABLE_NAME");
            HashMap selectValueMap = new HashMap();
            ArrayList selectList = new ArrayList();
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<String> textList = new ArrayList<String>();
            if (variableName.equalsIgnoreCase("ObjectClass") || variableName.contains("ObjectClass")) {
                for (String schemaIdGuid : schemaClasses = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId).getCategorySchemaClasses()) {
                    schemaClass = SchemaAPI.getInstance().getSchemaClass(schemaIdGuid);
                    valueList.add(schemaIdGuid);
                    textList.add(schemaClass.getCommonDisplayName());
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("name", schemaClass.getCommonDisplayName());
                    item.put("value", schemaIdGuid);
                    selectList.add(item);
                }
            } else if (variableName.equalsIgnoreCase("adap.AUDRuleVariables.variable_name.Access_Mask")) {
                ArrayList accessMaskList = SchemaAPI.getInstance().getAccessMaskList(categoryId);
                for (int i = 0; i < accessMaskList.size(); ++i) {
                    Properties properties = (Properties)accessMaskList.get(i);
                    if (!properties.getProperty("VISIBLE").equalsIgnoreCase("true")) continue;
                    valueList.add(properties.getProperty("ACCESS_MASK"));
                    textList.add(properties.getProperty("DISPLAY_NAME"));
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("name", properties.getProperty("DISPLAY_NAME"));
                    item.put("value", properties.getProperty("ACCESS_MASK"));
                    selectList.add(item);
                }
            } else if (variableName.equalsIgnoreCase("adap.AUDRuleVariables.variable_name.Attributes")) {
                for (String schemaClassName : schemaClasses = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId).getCategorySchemaClasses()) {
                    schemaClass = SchemaAPI.getInstance().getSchemaClass(schemaClassName);
                    ArrayList<String> attributesList = schemaClass.getAttributeList();
                    for (String systemIdGuid : attributesList) {
                        try {
                            if (valueList.contains(systemIdGuid)) continue;
                            valueList.add(systemIdGuid);
                            textList.add(SchemaAPI.getInstance().getAttribute(systemIdGuid).getCommonName());
                            HashMap<String, String> item = new HashMap<String, String>();
                            item.put("name", SchemaAPI.getInstance().getAttribute(systemIdGuid).getCommonName());
                            item.put("value", systemIdGuid);
                            selectList.add(item);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            selectValueMap.put("VALUE", valueList);
            selectValueMap.put("TEXT", textList);
            variableTable.put("SELECT_VALUE_MAP", selectValueMap);
            variablesSelectInput.put(variableTable.get("VARIABLE_ID"), selectList);
        }
        return variablesSelectInput;
    }
}

