/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class AuditCategoryHandler {
    private static AuditCategoryHandler categoryHandler = null;
    private static HashMap categoryReportColumns = null;
    private static HashMap categoryElementMapColumns = null;
    private static HashMap defaultSortColumnMap = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static HashMap<Long, HashMap> columnsMap = null;

    private AuditCategoryHandler() {
        this.getCategoryReportColumnsFromDB();
        this.getCategoryElementMapFromDB();
    }

    public HashMap getCategoryReportColumns(Object categoryId) {
        return (HashMap)categoryReportColumns.get(categoryId);
    }

    public HashMap getColumnsMap() {
        return columnsMap;
    }

    public HashMap getCategoryElementMapColumns(Object categoryId) {
        return (HashMap)categoryElementMapColumns.get(categoryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditCategoryHandler getInstance() {
        if (categoryHandler != null) return categoryHandler;
        Class<AuditMonitorHandler> clazz = AuditMonitorHandler.class;
        synchronized (AuditMonitorHandler.class) {
            if (categoryHandler != null) return categoryHandler;
            categoryHandler = new AuditCategoryHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return categoryHandler;
        }
    }

    public String getDeafultSortColumn(Long categoryId) {
        String defaultSortColumn = null;
        try {
            defaultSortColumn = (String)defaultSortColumnMap.get(categoryId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultSortColumn;
    }

    public void getCategoryReportColumnsFromDB() {
        try {
            columnsMap = new HashMap();
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDReportColumns");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportColumns", (String)"CATEGORY_ID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, criteria);
            if (dataObject.size("AUDReportColumns") > 0) {
                categoryReportColumns = new HashMap();
                Iterator iterator = dataObject.getRows("AUDReportColumns");
                while (iterator.hasNext()) {
                    String[] columnsArray;
                    Row row = (Row)iterator.next();
                    Object categoryId = row.get("CATEGORY_ID");
                    HashMap valueMap = null;
                    valueMap = categoryReportColumns.get(categoryId) == null ? new HashMap() : (HashMap)categoryReportColumns.get(categoryId);
                    String columnName = (String)row.get("COLUMN_NAME");
                    String tableName = (String)row.get("TABLE_NAME");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("COLUMN_NAME", columnName);
                    for (String string : columnsArray = new String[]{"COLUMN_DISPLAY_NAME", "VISIBLE", "INPUT_VALUE", "EXPECTED_OBJECT_CLASS", "SORTENABLED", "SEARCHENABLED", "PRIORITY_ID", "COLUMN_DATA_TYPE", "DATE_FORMAT", "TRANSFORMER", "SUBREPORT_CV_ID", "SUBREPORT_PARAM_DATATYPE", "COLUMN_SELECTION_ID", "ELEMENT_ID", "INPUT_VALUE", "COLUMN_ID", "IS_TEXT_COLUMN"}) {
                        hashMap.put(string, row.get(string));
                    }
                    String[] booleanProps = new String[]{"ESCAPE_HTML", "MANDATORY", "BGCOLUMN"};
                    Boolean[] defaultBooleanValue = new Boolean[]{true, false, false};
                    for (int i = 0; i < booleanProps.length; ++i) {
                        hashMap.put(booleanProps[i], row.get(booleanProps[i]) != null ? booleanProps[i] : defaultBooleanValue[i]);
                    }
                    Boolean isDeafultSortColumn = (Boolean)row.get("IS_DEFAULT_SORT_COLUMN");
                    hashMap.put("IS_DEFAULT_SORT_COLUMN", isDeafultSortColumn);
                    if (isDeafultSortColumn.booleanValue()) {
                        if (defaultSortColumnMap == null) {
                            defaultSortColumnMap = new HashMap();
                        }
                        defaultSortColumnMap.put(categoryId, columnName);
                    }
                    columnsMap.put((Long)row.get("COLUMN_ID"), hashMap);
                    valueMap.put(tableName + "/" + columnName, hashMap);
                    categoryReportColumns.put(categoryId, valueMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataObject getAuditCategories() {
        DataObject categoryDataObject = null;
        try {
            Table table = Table.getTable((String)"AUDCategories");
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_ID"), null, 1);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDCategories", (String)"*"));
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)"AUDCategories", (String)"PRIORITY_ID"), true);
            query.addSortColumn(sortColumn);
            categoryDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categoryDataObject;
    }

    public ObjectClass[] getSelectObjectClasses(Object categoryId) {
        ObjectClass[] categorySelectObjects = null;
        try {
            Table table = Table.getTable((String)"AUDCategorySelectObjects");
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCategorySelectObjects", (String)"CATEGORY_ID"), categoryId, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDCategorySelectObjects", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategorySelectObjects", (String)"PRIORITY_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            ArrayList<ObjectClass> categorySelectObjList = new ArrayList<ObjectClass>();
            Iterator iterator = dataObject.getRows("AUDCategorySelectObjects");
            while (iterator.hasNext()) {
                Row objRow = (Row)iterator.next();
                String objClass = (String)objRow.get("OBJECT_CLASS");
                categorySelectObjList.add(DirectoryObjectAPI.getInstance().getObjectClass(objClass));
            }
            categorySelectObjects = new ObjectClass[categorySelectObjList.size()];
            categorySelectObjects = categorySelectObjList.toArray(categorySelectObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categorySelectObjects;
    }

    public ArrayList getActionsForCategory(Long categoryId) {
        ArrayList actionsList = new ArrayList();
        try {
            Criteria categoryCriteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"CATEGORY_ID"), (Object)categoryId, 0);
            if (!LicenseUtil.isProfEdn()) {
                categoryCriteria = categoryCriteria.and(new Criteria(Column.getColumn((String)"AUDAction", (String)"LICENSE_TYPE"), (Object)1, 0));
            }
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDCategories");
            tablesList.add("AUDAction");
            DataObject actionDataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, categoryCriteria);
            Iterator actionIterator = actionDataObject.getRows("AUDAction");
            while (actionIterator.hasNext()) {
                Row actionRow = (Row)actionIterator.next();
                Hashtable<String, Object> actionTable = new Hashtable<String, Object>();
                Long actionId = (Long)actionRow.get("ACTION_ID");
                actionTable.put("ACTION_ID", actionId);
                actionTable.put("ACTION_NAME", (String)actionRow.get("ACTION_NAME"));
                actionTable.put("ACTION_DESCRIPTION", (String)actionRow.get("ACTION_DESCRIPTION"));
                actionsList.add(actionTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionsList;
    }

    public ArrayList getVariablesForCategory(Long categoryId) {
        ArrayList variablesList = new ArrayList();
        try {
            Table table = Table.getTable((String)"AUDCategoryVariables");
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Join join = new Join("AUDCategoryVariables", "AUDRuleVariables", new String[]{"VARIABLE_ID"}, new String[]{"VARIABLE_ID"}, 2);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDCategoryVariables", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDRuleVariables", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategoryVariables", (String)"PRIORITY_ID"), true));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCategoryVariables", (String)"CATEGORY_ID"), (Object)categoryId, 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDRuleVariables");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("VARIABLE_ID", row.get("VARIABLE_ID"));
                hashtable.put("VARIABLE_DATATYPE", row.get("VARIABLE_DATATYPE"));
                hashtable.put("VARIABLE_NAME", (String)row.get("VARIABLE_NAME"));
                hashtable.put("VARIABLE_DISPLAY_NAME", (String)row.get("VARIABLE_DISPLAY_NAME"));
                hashtable.put("INPUT_TYPE", row.get("INPUT_TYPE"));
                variablesList.add(hashtable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variablesList;
    }

    public void getCategoryElementMapFromDB() {
        HashMap categoryMap = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_ID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDCategories", criteria);
            if (dataObject.size("AUDCategories") > 0) {
                categoryElementMapColumns = new HashMap();
                Iterator iterator = dataObject.getRows("AUDCategories");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Object category_id = row.get("CATEGORY_ID");
                    if (categoryElementMapColumns.get(category_id) == null) {
                        categoryMap = new HashMap();
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)"AUDCategoryElementMap", (String)"CATEGORY_ID"), category_id, 0);
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDCategoryElementMap", crit);
                    if (dObj.size("AUDCategoryElementMap") > 0) {
                        ArrayList<Object> idList = new ArrayList<Object>();
                        ArrayList<Object> priorityList = new ArrayList<Object>();
                        Iterator iter = dObj.getRows("AUDCategoryElementMap");
                        while (iter.hasNext()) {
                            Row idRow = (Row)iter.next();
                            Object element_id = idRow.get("ELEMENT_ID");
                            idList.add(element_id);
                            Object priorityId = idRow.get("PRIORITY_ID");
                            priorityList.add(priorityId);
                        }
                        categoryMap.put("ELEMENT_ID", idList);
                        categoryMap.put("PRIORITY_ID", priorityList);
                    }
                    categoryElementMapColumns.put(category_id, categoryMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String[] getSchemaClasses(Object categoryId) {
        String[] categorySchemaClasses = null;
        try {
            String tableName = "AUDCategorySchemaClasses";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CATEGORY_ID"), categoryId, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"PRIORITY_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            ArrayList<String> categorySchemaClassList = new ArrayList<String>();
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row objRow = (Row)iterator.next();
                String schemaIdGuid = (String)objRow.get("SCHEMA_ID_GUID");
                categorySchemaClassList.add(schemaIdGuid);
            }
            categorySchemaClasses = new String[categorySchemaClassList.size()];
            categorySchemaClasses = categorySchemaClassList.toArray(categorySchemaClasses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categorySchemaClasses;
    }
}

