/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class AuditCatgoryAPI {
    private static AuditCatgoryAPI auditCatgoryAPI = null;
    private HashMap categoryTypeMap = null;
    private LinkedHashMap categories = null;
    private static final int AD_AUDIT_CATEGORY = 1;
    private static final int FILE_AUDIT_CATEGORY = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditCatgoryAPI getInstance() {
        if (auditCatgoryAPI != null) return auditCatgoryAPI;
        Class<AuditCatgoryAPI> clazz = AuditCatgoryAPI.class;
        synchronized (AuditCatgoryAPI.class) {
            if (auditCatgoryAPI != null) return auditCatgoryAPI;
            auditCatgoryAPI = new AuditCatgoryAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return auditCatgoryAPI;
        }
    }

    private AuditCatgoryAPI() {
        try {
            this.categories = new LinkedHashMap();
            this.categoryTypeMap = new HashMap();
            DataObject dataObject = AuditCategoryHandler.getInstance().getAuditCategories();
            Iterator iterator = dataObject.getRows("AUDCategories");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long categoryId = (Long)row.get("CATEGORY_ID");
                this.categories.put(categoryId, new Category(categoryId, row));
                Integer categoryType = (Integer)row.get("CATEGORY_TYPE");
                ArrayList<Long> categoryList = (ArrayList<Long>)this.categoryTypeMap.get(categoryType);
                if (categoryList == null) {
                    categoryList = new ArrayList<Long>();
                }
                categoryList.add(categoryId);
                this.categoryTypeMap.put(categoryType, categoryList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Category getCategoryObject(Object categoryId) {
        return (Category)this.categories.get(categoryId);
    }

    public LinkedHashMap getCategories() {
        return this.categories;
    }

    public LinkedHashMap getCategories(Integer categoryType) {
        LinkedHashMap categoryMap = new LinkedHashMap();
        ArrayList categoryList = (ArrayList)this.categoryTypeMap.get(categoryType);
        for (Object object : categoryList) {
            categoryMap.put(object, this.getCategoryObject(object));
        }
        return categoryMap;
    }
}

