/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AuditMonitorAPI {
    private static AuditMonitorAPI monitorAPI = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditMonitorAPI getInstance() {
        if (monitorAPI != null) return monitorAPI;
        Class<AuditMonitorAPI> clazz = AuditMonitorAPI.class;
        synchronized (AuditMonitorAPI.class) {
            if (monitorAPI != null) return monitorAPI;
            monitorAPI = new AuditMonitorAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitorAPI;
        }
    }

    public ArrayList getMonitorsList() {
        ArrayList monitorsList = new ArrayList();
        try {
            DataObject monitorsListDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", (Row)null);
            Iterator iterator = monitorsListDataObject.getRows("AUDMonitor");
            while (iterator.hasNext()) {
                Row monitorRow = (Row)iterator.next();
                List columnList = monitorRow.getColumns();
                HashMap monitorMap = new HashMap();
                for (Object object : columnList) {
                    monitorMap.put(object, monitorRow.get(object.toString()));
                }
                monitorsList.add(monitorMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorsList;
    }

    public ArrayList getMonitorsList(String strIsProfileAdded, String domainName, String strCategoryId, HashMap addnParamsMap, String strIsCustomProfile, String enableMontior) {
        ArrayList monitorsList = new ArrayList();
        Criteria criteria = null;
        boolean isProfileAdded = true;
        boolean isAscending = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDMonitor"));
            if (strIsProfileAdded != null) {
                if (strIsProfileAdded.equalsIgnoreCase("false")) {
                    isProfileAdded = false;
                }
                criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"IS_PROFILE_ADDED"), (Object)isProfileAdded, 0);
            }
            if (strIsCustomProfile != null) {
                if (strIsCustomProfile.equalsIgnoreCase("true")) {
                    isProfileAdded = true;
                }
                criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"IS_CUSTOM_PROFILE"), (Object)isProfileAdded, 0);
            }
            if (domainName != null && !domainName.equals("All")) {
                Criteria domainCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria == null ? domainCriteria : criteria.and(domainCriteria);
            }
            if (strCategoryId != null && !strCategoryId.equals("All")) {
                Long categoryId = Long.parseLong(strCategoryId);
                Criteria categoryCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"), (Object)categoryId, 0);
                criteria = criteria == null ? categoryCriteria : criteria.and(categoryCriteria);
            } else if (strCategoryId != null && strCategoryId.equalsIgnoreCase("All")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_TYPE"), (Object)1, 0));
            }
            if (enableMontior != null && enableMontior.equals("enableMonitor")) {
                Criteria enableMonitorCrit = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"IS_ENABLED"), (Object)true, 0);
                criteria = criteria == null ? enableMonitorCrit : criteria.and(enableMonitorCrit);
            }
            if (!LicenseUtil.isProfEdn()) {
                Criteria LicenseCriteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"LICENSE_TYPE"), (Object)1, 0));
                criteria = criteria == null ? LicenseCriteria : criteria.and(LicenseCriteria);
            }
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"*"));
            SortColumn sortcolumn = null;
            if (addnParamsMap == null) {
                sortcolumn = new SortColumn(Column.getColumn((String)"AUDMonitor", (String)"MODIFICATION_TIME"), isAscending);
            } else {
                String sColumn = (String)addnParamsMap.get("sortColumn");
                String sOrder = (String)addnParamsMap.get("sortOrder");
                if (sOrder == null && sColumn == null) {
                    sColumn = "CREATION_TIME";
                    sOrder = "ASC";
                }
                if (sOrder.equalsIgnoreCase("ASC")) {
                    isAscending = true;
                }
                sortcolumn = new SortColumn(Column.getColumn((String)"AUDMonitor", (String)sColumn), isAscending);
            }
            Join monitorReportJoin = new Join("AUDMonitor", "AUDMonitorReportMap", new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 1);
            query.addJoin(monitorReportJoin);
            query.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"*"));
            query.addSortColumn(sortcolumn);
            DataObject monitorsListDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = monitorsListDataObject.getRows("AUDMonitor");
            while (iterator.hasNext()) {
                Row monitorRow = (Row)iterator.next();
                List columnList = monitorRow.getColumns();
                HashMap<Object, Object> monitorMap = new HashMap<Object, Object>();
                for (Object object : columnList) {
                    monitorMap.put(object, monitorRow.get(object.toString()));
                }
                Long monitorId = (Long)monitorRow.get("MONITOR_ID");
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"), (Object)monitorId, 0);
                Row monitorReportRow = monitorsListDataObject.getRow("AUDMonitorReportMap", criteria2);
                Long auditReportId = (Long)monitorReportRow.get("AUDIT_REPORT_ID");
                monitorMap.put("AUDIT_REPORT_ID", auditReportId);
                monitorsList.add(monitorMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorsList;
    }

    public DataObject getMonitorDO(Long monitorId) {
        DataObject monitorDataObject = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDMonitor");
            tablesList.add("AUDMonitorActions");
            tablesList.add("AUDMonitorCriteria");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDMonitorActions");
            leftJoinList.add("AUDMonitorCriteria");
            monitorDataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorDataObject;
    }

    public HashMap getMonitorDetails(Long monitorId) {
        HashMap<Object, Object> monitorMap = new HashMap<Object, Object>();
        try {
            DataObject monitorDataObject = this.getMonitorDO(monitorId);
            if (monitorDataObject != null && !monitorDataObject.isEmpty()) {
                Row monitorRow = monitorDataObject.getRow("AUDMonitor");
                List columnList = monitorRow.getColumns();
                for (Object object : columnList) {
                    monitorMap.put(object, monitorRow.get(object.toString()));
                }
                String domainName = (String)monitorMap.get("DOMAIN_NAME");
                ArrayList<Object> actionsList = new ArrayList<Object>();
                Iterator actionIterator = monitorDataObject.getRows("AUDMonitorActions");
                while (actionIterator.hasNext()) {
                    Row actionRow = (Row)actionIterator.next();
                    actionsList.add(actionRow.get("ACTION_ID"));
                }
                monitorMap.put("selectedActionsList", actionsList);
                Integer monitorType = (Integer)monitorRow.get("MONITOR_TYPE");
                if (monitorType == 1 || monitorType == 3) {
                    HashMap selectedObjectsGUIDMap = new HashMap();
                    Iterator iterator = monitorDataObject.getRows("AUDMonitorCriteria");
                    while (iterator.hasNext()) {
                        Row criteriaObjRow = (Row)iterator.next();
                        String objectClass = (String)criteriaObjRow.get("OBJECT_CLASS");
                        ArrayList objList = (ArrayList)selectedObjectsGUIDMap.get(objectClass);
                        if (objList == null) {
                            objList = new ArrayList();
                        }
                        String guid = (String)criteriaObjRow.get("OBJECT_GUID");
                        Row dirObjectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, guid, objectClass);
                        if (dirObjectRow != null) {
                            HashMap<String, Object> objectMap = new HashMap<String, Object>();
                            objectMap.put("OBJECT_GUID", guid);
                            objectMap.put("NAME", dirObjectRow.get("NAME"));
                            objList.add(objectMap);
                        }
                        selectedObjectsGUIDMap.put(objectClass, objList);
                    }
                    if (selectedObjectsGUIDMap == null) {
                        selectedObjectsGUIDMap = new HashMap();
                    }
                    monitorMap.put("selectedObjectsMap", selectedObjectsGUIDMap);
                } else if (monitorType == 2) {
                    monitorMap.put("selectedObjectsMap", this.getConfiguredServers(monitorId));
                }
            }
        }
        catch (Exception e) {
            new Exception("Error in Getting Action Details");
            e.printStackTrace();
        }
        return monitorMap;
    }

    public HashMap getConfiguredServers(Long monitorId) {
        HashMap serverMap = new HashMap();
        try {
            String serverTableName = "AUDFileMonitorServers";
            String shareTableName = "AUDFileMonitorShares";
            Criteria monitorCriteria = new Criteria(Column.getColumn((String)serverTableName, (String)"MONITOR_ID"), (Object)monitorId, 0);
            Join join = new Join(serverTableName, shareTableName, new String[]{"CRITERIA_ID"}, new String[]{"CRITERIA_ID"}, 2);
            Table serverTable = Table.getTable((String)serverTableName);
            SelectQueryImpl query = new SelectQueryImpl(serverTable);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)serverTableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)shareTableName, (String)"*"));
            query.setCriteria(monitorCriteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator serverIterator = dataObject.getRows(serverTableName);
            while (serverIterator.hasNext()) {
                Row serverRow = (Row)serverIterator.next();
                Long criteriaId = (Long)serverRow.get("CRITERIA_ID");
                String serverName = (String)serverRow.get("SERVERNAME");
                Criteria serverCriteria = new Criteria(Column.getColumn((String)shareTableName, (String)"CRITERIA_ID"), (Object)criteriaId, 0);
                ArrayList<String> shareList = (ArrayList<String>)serverMap.get(serverName);
                if (shareList == null) {
                    shareList = new ArrayList<String>();
                }
                Iterator shareIterator = dataObject.getRows(shareTableName, serverCriteria);
                while (shareIterator.hasNext()) {
                    Row shareRow = (Row)shareIterator.next();
                    shareList.add((String)shareRow.get("SHARE_NAME"));
                }
                serverMap.put(serverName, shareList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverMap;
    }

    public String getTableName(Long monitorId) {
        String tableName = null;
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("AUDMonitor");
            tablesList.add("AUDCategories");
            Criteria monitorCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, monitorCriteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDCategories");
                tableName = (String)row.get("TABLE_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableName;
    }

    public Object getMonitorProperty(Long monitorId, String columnName) {
        Object monitorProperty = null;
        try {
            Criteria monitorCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", monitorCriteria);
            Row row = dataObject.getRow("AUDMonitor");
            monitorProperty = row.get(columnName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorProperty;
    }

    public String getMonitorReportSQLString(Long monitorId, Long categoryId) {
        String sqlString = "";
        try {
            String monitorTableName = AuditMonitorAPI.getInstance().getTableName(monitorId);
            sqlString = "SELECT ${TOPVAL} ${COLUMNS} FROM (SELECT ${TOPVAL} * FROM ( SELECT ${INNERTOPVAL} * FROM (${UNION_QUERY} ) as innerTable ${ORDER_BY} ${INNERLIMIT}) as resultTable ${CHANGE_ORDER_BY} ${LIMIT}) as " + monitorTableName + " ${ORDER_BY} ${LIMIT}";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlString;
    }

    public String getMonitorReportCountSQLString(Long monitorId) {
        String sqlString = "";
        try {
            String monitorTableName = AuditMonitorAPI.getInstance().getTableName(monitorId);
            sqlString = "SELECT ${GRAPHTOPVAL} SUM(adapcount) as adapcount ${COLUMNS} FROM (${UNION_COUNT_QUERY}) as " + monitorTableName + " ${GROUP_BY} ${ORDER_BY} ${LIMIT}";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlString;
    }

    public String getMonitorReportUnionCountSQLString(Long monitorId) {
        String sqlString = "";
        try {
            String monitorTableName = AuditMonitorAPI.getInstance().getTableName(monitorId);
            sqlString = "SELECT COUNT(*) as adapcount, TIME_GENERATED FROM ${TABLE:" + monitorTableName + "} WHERE MONITOR_ID=" + monitorId + " AND TIME_GENERATED BETWEEN ${FROM} AND ${TO} AND ${SCRITERIA} GROUP BY TIME_GENERATED";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sqlString;
    }

    public String getMonitorUnionCountSQLString(Long monitorId) {
        String sqlString = "";
        try {
            String monitorTableName = AuditMonitorAPI.getInstance().getTableName(monitorId);
            sqlString = monitorTableName.equalsIgnoreCase("audgpomgmt") ? "SELECT COUNT(*) as adapcount ${COLUMNS} FROM ${TABLE:" + monitorTableName + "} WHERE MONITOR_ID=" + monitorId + " AND TIME_GENERATED BETWEEN ${FROM} AND ${TO} AND ${SCRITERIA} ${GROUP_BY}" : this.getMonitorReportUnionCountSQLString(monitorId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sqlString;
    }

    public String getMonitorReportUnionSQLString(Long monitorId) {
        String sqlString = "";
        try {
            String monitorTableName = AuditMonitorAPI.getInstance().getTableName(monitorId);
            sqlString = "SELECT ${INNERTOPVAL} ${COLUMNS} FROM ${TABLE:" + monitorTableName + "} as " + monitorTableName + " WHERE MONITOR_ID=" + monitorId + " AND TIME_GENERATED BETWEEN ${FROM} AND ${TO} AND ${SCRITERIA} ${ORDER_BY} ${INNERLIMIT}";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sqlString;
    }

    public int getMonitorsCountForDomain(String domainName) {
        int count = 0;
        String query = "SELECT COUNT(*) FROM AUDMONITOR WHERE DOMAIN_NAME='" + domainName + "'";
        count = QueryUtil.getRowsCount(query);
        return count;
    }

    public ArrayList<Long> getMonitorsForDomain(String domainName, String isCustomProfile, int monitorType) {
        ArrayList<Long> monitorList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_TYPE"), (Object)monitorType, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            if (isCustomProfile != null) {
                boolean flag = Boolean.valueOf(isCustomProfile);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"IS_CUSTOM_PROFILE"), (Object)flag, 0));
            }
            DataObject monitorDataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", criteria);
            Iterator iterator = monitorDataObject.getRows("AUDMonitor");
            while (iterator.hasNext()) {
                Row monitorRow = (Row)iterator.next();
                monitorList.add((Long)monitorRow.get("MONITOR_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return monitorList;
    }
}

