/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.persistence.xml.Xml2DoConverter;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AudColumnConfig;
import com.adventnet.sym.adsm.auditing.server.monitor.AudFileMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudMonitorCriteriaHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudMonitorReportHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.GroupHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class AuditMonitorHandler {
    private static volatile AuditMonitorHandler auditMonitorHandler = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditMonitorHandler getInstance() {
        if (auditMonitorHandler != null) return auditMonitorHandler;
        Class<AuditMonitorHandler> clazz = AuditMonitorHandler.class;
        synchronized (AuditMonitorHandler.class) {
            if (auditMonitorHandler != null) return auditMonitorHandler;
            auditMonitorHandler = new AuditMonitorHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return auditMonitorHandler;
        }
    }

    public boolean canDelete(Long monitorId) {
        boolean status = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDMonitor"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Row r = dObj.getRow("AUDMonitor");
            if (((Boolean)r.get("IS_CUSTOM_PROFILE")).booleanValue()) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return status;
        }
        return status;
    }

    public boolean deleteMonitor(Long monitorId) {
        boolean status = false;
        try {
            String tableName = "AUDMonitorReportMap";
            Criteria criMonRep = new Criteria(Column.getColumn((String)tableName, (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criMonRep);
            if (!dataObj.isEmpty()) {
                Long reportId = (Long)dataObj.getRow(tableName).get("AUDIT_REPORT_ID");
                MyFavRepHandler.deleteReport((String)Long.toString(reportId));
            }
            AUDCustomViewAPI.getInstance().deleteCvIdInMap(monitorId);
            AudColumnConfig.getInstance().deleteColDispNameInMap(monitorId);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            status = this.deleteMonitorAlerts(monitorId);
            ArrayList<Long> monList = new ArrayList<Long>();
            monList.add(monitorId);
            MonitorManager.getInstance();
            MonitorManager.deleteMonitorFromMonitorMap(monList);
            AuditReportAPI.getInstance().setReportsDetails();
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public boolean deleteMonitorAlerts(Long monitorId) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlert", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public boolean deleteMonitorReports(Long monitorId) {
        try {
            String sqlString = AuditMonitorAPI.getInstance().getMonitorReportSQLString(monitorId, 0L);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"SQL_STRING"), (Object)sqlString, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean deleteMonitorActions(Long monitorId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorActions", (String)"MONITOR_ID"), (Object)monitorId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addMonitorActions(Object monitorId, DataObject dataObject, ArrayList actionsList) {
        try {
            for (Object object : actionsList) {
                Row monitorActionMappingRow = new Row("AUDMonitorActions");
                monitorActionMappingRow.set("MONITOR_ID", monitorId);
                monitorActionMappingRow.set("ACTION_ID", object);
                dataObject.addRow(monitorActionMappingRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean saveMonitor(HashMap propsMap, ArrayList actionsList, HashMap selectedObjectsMap, HashMap columnMap, String defaultSortColumn, HashMap categoryElementColumnMap) {
        boolean status = false;
        try {
            DataObject monitorDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row monitorRow = new Row("AUDMonitor");
            Set keys = propsMap.keySet();
            for (String key : keys) {
                monitorRow.set(key, propsMap.get(key));
            }
            Integer monitorType = (Integer)monitorRow.get("MONITOR_TYPE");
            System.out.println("Save Monitor MonitorType : " + monitorType);
            monitorRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            monitorRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            Object categoryId = propsMap.get("CATEGORY_ID");
            UniqueValueHolder monitorIdHolder = (UniqueValueHolder)monitorRow.get("MONITOR_ID");
            monitorDataObject.addRow(monitorRow);
            this.addMonitorActions(monitorIdHolder, monitorDataObject, actionsList);
            String domainName = (String)propsMap.get("DOMAIN_NAME");
            if (selectedObjectsMap == null || selectedObjectsMap.isEmpty()) {
                selectedObjectsMap = new HashMap();
                String objectGuid = DomainDetailsAPI.getDomainObjectGuid(domainName);
                HashMap<String, String> objMap = new HashMap<String, String>();
                objMap.put("DOMAIN_NAME", domainName);
                objMap.put("OBJECT_GUID", objectGuid);
                ArrayList<HashMap<String, String>> objList = new ArrayList<HashMap<String, String>>();
                objList.add(objMap);
                selectedObjectsMap.put("domainDNS", objList);
            }
            if (monitorType == 1) {
                AudMonitorCriteriaHandler.addMonitorCriteriaObjects(domainName, monitorIdHolder, monitorDataObject, selectedObjectsMap, categoryId);
            } else if (monitorType == 2) {
                AudFileMonitorCriteriaHandler.addFileServerShares(monitorIdHolder, domainName, selectedObjectsMap, monitorDataObject);
            } else if (monitorType == 3) {
                AudMonitorCriteriaHandler.addMonitorCriteriaObjects(domainName, monitorIdHolder, monitorDataObject, selectedObjectsMap, categoryId);
            }
            CommonUtil.getPersistence(new boolean[0]).add(monitorDataObject);
            AudMonitorReportHandler.createMonitorReport((Long)monitorIdHolder.getValue(), propsMap, columnMap, defaultSortColumn, categoryElementColumnMap);
            ArrayList<Long> monitorIdList = new ArrayList<Long>();
            monitorIdList.add((Long)monitorIdHolder.getValue());
            MonitorManager.getInstance().getMonitors(null);
            status = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public boolean updateMonitor(Long monitorId, HashMap propsMap, ArrayList actionsList, HashMap selectedObjectsMap) {
        boolean status = false;
        try {
            ArrayList<HashMap<String, String>> objList;
            HashMap<String, String> objMap;
            String objectGuid;
            Criteria updateMonitorCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject updateDO = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitor", updateMonitorCriteria);
            Row monitorRow = updateDO.getRow("AUDMonitor");
            Set keys = propsMap.keySet();
            for (String key : keys) {
                monitorRow.set(key, propsMap.get(key));
            }
            monitorRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            Integer monitorType = (Integer)monitorRow.get("MONITOR_TYPE");
            Long categoryId = (Long)propsMap.get("CATEGORY_ID");
            updateDO.updateRow(monitorRow);
            CommonUtil.getPersistence(new boolean[0]).update(updateDO);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"), (Object)monitorId, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AUDMonitorReportMap");
            tableList.add("AUDReports");
            tableList.add("AUDReportCVMapping");
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
            if (dObj.size("AUDMonitorReportMap") > 0) {
                Row idRow = dObj.getRow("AUDReports");
                Long reportId = (Long)idRow.get("AUDIT_REPORT_ID");
                idRow.set("TITLE", (Object)((String)propsMap.get("MONITOR_NAME") + " in " + (String)propsMap.get("DOMAIN_NAME")));
                idRow.set("AUDIT_REPORT_NAME", (Object)((String)propsMap.get("MONITOR_NAME")));
                dObj.updateRow(idRow);
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
                Row cvIdRow = dObj.getRow("AUDReportCVMapping");
                Long cvId = (Long)cvIdRow.get("CV_ID");
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)cvId, 0);
                DataObject graphDO = CommonUtil.getPersistence(new boolean[0]).get("AUDGraphOptions", criteria);
                if (graphDO.size("AUDGraphOptions") > 0) {
                    Row graphRow = graphDO.getRow("AUDGraphOptions");
                    graphRow.set("GRAPH_TITLE", (Object)((String)propsMap.get("MONITOR_NAME") + " in " + (String)propsMap.get("DOMAIN_NAME")));
                    graphDO.updateRow(graphRow);
                    CommonUtil.getPersistence(new boolean[0]).update(graphDO);
                }
                AuditReportAPI.getInstance().addORUpdateReportDetails(reportId);
            }
            updateDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (this.deleteMonitorActions(monitorId)) {
                this.addMonitorActions(monitorId, updateDO, actionsList);
            }
            String domainName = (String)propsMap.get("DOMAIN_NAME");
            if (monitorType == 1) {
                if (selectedObjectsMap == null || selectedObjectsMap.isEmpty()) {
                    selectedObjectsMap = new HashMap();
                    objectGuid = DomainDetailsAPI.getDomainObjectGuid(domainName);
                    objMap = new HashMap<String, String>();
                    objMap.put("DOMAIN_NAME", domainName);
                    objMap.put("OBJECT_GUID", objectGuid);
                    objList = new ArrayList<HashMap<String, String>>();
                    objList.add(objMap);
                    selectedObjectsMap.put("domainDNS", objList);
                }
                if (AudMonitorCriteriaHandler.deleteMonitorCriteriaObjects(monitorId)) {
                    AudMonitorCriteriaHandler.addMonitorCriteriaObjects(domainName, monitorId, updateDO, selectedObjectsMap, categoryId);
                }
            } else if (monitorType == 2) {
                if (AudFileMonitorCriteriaHandler.deleteFileServerShares(monitorId)) {
                    AudFileMonitorCriteriaHandler.addFileServerShares(monitorId, domainName, selectedObjectsMap, updateDO);
                }
            } else if (monitorType == 3) {
                if (selectedObjectsMap == null || selectedObjectsMap.isEmpty()) {
                    selectedObjectsMap = new HashMap();
                    objectGuid = DomainDetailsAPI.getDomainObjectGuid(domainName);
                    objMap = new HashMap();
                    objMap.put("DOMAIN_NAME", domainName);
                    objMap.put("OBJECT_GUID", objectGuid);
                    objList = new ArrayList();
                    objList.add(objMap);
                    selectedObjectsMap.put("domainDNS", objList);
                }
                if (AudMonitorCriteriaHandler.deleteMonitorCriteriaObjects(monitorId)) {
                    AudMonitorCriteriaHandler.addMonitorCriteriaObjects(domainName, monitorId, updateDO, selectedObjectsMap, categoryId);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).add(updateDO);
            status = true;
            MonitorManager.getInstance().getMonitors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public boolean copyMonitor(Long monitorId, String monitorName) {
        boolean status = false;
        try {
            DataObject dataObject = AuditMonitorAPI.getInstance().getMonitorDO(monitorId);
            if (dataObject != null && !dataObject.isEmpty()) {
                Row actionRow;
                DataObject toBeAddedMonitorDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row monitorRow = dataObject.getRow("AUDMonitor");
                Row toBeAddedMonitorRow = new Row("AUDMonitor");
                toBeAddedMonitorRow.set("MONITOR_NAME", (Object)monitorName);
                toBeAddedMonitorRow.set("MONITOR_DESCRIPTION", monitorRow.get("MONITOR_DESCRIPTION"));
                toBeAddedMonitorRow.set("CATEGORY_ID", monitorRow.get("CATEGORY_ID"));
                toBeAddedMonitorRow.set("DOMAIN_NAME", monitorRow.get("DOMAIN_NAME"));
                toBeAddedMonitorRow.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
                toBeAddedMonitorRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
                toBeAddedMonitorDO.addRow(toBeAddedMonitorRow);
                UniqueValueHolder monitorValueHolder = (UniqueValueHolder)toBeAddedMonitorRow.get("MONITOR_ID");
                Iterator iterator = dataObject.getRows("AUDMonitorActions");
                while (iterator.hasNext()) {
                    actionRow = (Row)iterator.next();
                    Row toBeAddedActionRow = new Row("AUDMonitorActions");
                    toBeAddedActionRow.set("ACTION_ID", actionRow.get("ACTION_ID"));
                    toBeAddedActionRow.set("MONITOR_ID", (Object)monitorValueHolder);
                    toBeAddedMonitorDO.addRow(toBeAddedActionRow);
                }
                iterator = dataObject.getRows("AUDMonitorCriteria");
                while (iterator.hasNext()) {
                    actionRow = (Row)iterator.next();
                    Row toBeAddedCriteraObjRow = new Row("AUDMonitorCriteria");
                    toBeAddedCriteraObjRow.set("OBJECT_GUID", actionRow.get("OBJECT_GUID"));
                    toBeAddedCriteraObjRow.set("OBJECT_CLASS", actionRow.get("OBJECT_CLASS"));
                    toBeAddedCriteraObjRow.set("MONITOR_ID", (Object)monitorValueHolder);
                    toBeAddedMonitorDO.addRow(toBeAddedCriteraObjRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(toBeAddedMonitorDO);
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public void createDefaultMonitors(Properties domainProperties) {
        try {
            String fileName = "..\\conf\\adap\\monitor.xml";
            DataObject dataObject = Xml2DoConverter.transform((String)fileName);
            this.createDefaultMonitors(domainProperties, dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDefaultMonitors(Properties domainProperties, DataObject dataObject) throws Exception {
        this.createDefaultMonitors(domainProperties, dataObject, true);
    }

    public void createDefaultMonitors(Properties domainProperties, DataObject dataObject, boolean action) {
        try {
            String rootDomainNamingContext;
            Row row;
            String domainName = domainProperties.getProperty("DOMAIN_NAME");
            String domainSID = domainProperties.getProperty("SID_STRING");
            String objectGuid = domainProperties.getProperty("OBJECT_GUID");
            ArrayList<Long> monitorIdWithGroupList = new ArrayList<Long>();
            List tableNameList = dataObject.getTableNames();
            for (Object object2 : tableNameList) {
                String tableName = (String)object2;
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row2 = (Row)iterator.next();
                    List columnList = row2.getColumns();
                    for (Object object3 : columnList) {
                        String stringValue;
                        String columnName = (String)object3;
                        Object rowValue = row2.get(columnName);
                        if (rowValue == null || !(stringValue = rb.getString(rowValue.toString())).contains("%domainName%")) continue;
                        stringValue = stringValue.replaceAll("%domainName%", domainName);
                        row2.set(columnName, (Object)stringValue);
                    }
                }
            }
            Iterator iterator = dataObject.getRows("AUDMonitor");
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                row.set("CREATION_TIME", (Object)System.currentTimeMillis());
                row.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            }
            iterator = dataObject.getRows("AUDAlertProfile");
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                row.set("ALERT_MESSAGE", (Object)rb.getString((String)row.get("ALERT_MESSAGE")));
                row.set("CREATION_TIME", (Object)System.currentTimeMillis());
                row.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            iterator = dataObject.getRows("AUDMonitorCriteria");
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                String objectClass = (String)row.get("OBJECT_CLASS");
                if (objectClass.equalsIgnoreCase("domainDNS")) {
                    row.set("OBJECT_GUID", (Object)domainProperties.getProperty("OBJECT_GUID"));
                    dataObject.updateRow(row);
                    continue;
                }
                if (!objectClass.equalsIgnoreCase("group")) continue;
                monitorIdWithGroupList.add((Long)row.get("MONITOR_ID"));
            }
            DataObject monitorCriteriaDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String[] groupSIDs = new String[]{"S-1-5-32-544", domainSID + "-" + "512"};
            Properties properties = DomainHandler.getConfiguredValues(domainName, 1L);
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            if (defaultNamingContext.equalsIgnoreCase(rootDomainNamingContext = properties.getProperty("ROOT_DOMAIN_NAMING_CONTEXT"))) {
                groupSIDs = new String[]{"S-1-5-32-544", domainSID + "-" + "512", domainSID + "-" + "518", domainSID + "-" + "519"};
            }
            for (Object e : monitorIdWithGroupList) {
                Long mId = (Long)e;
                Criteria mIdCriteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)mId, 0);
                Row mIdRow = dataObject.getRow("AUDMonitor", mIdCriteria);
                Long categoryId = (Long)mIdRow.get("CATEGORY_ID");
                ArrayList groupsList = new ArrayList();
                try {
                    for (String groupSID : groupSIDs) {
                        Row groupRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, groupSID, "SID_STRING", "group");
                        HashMap<String, Object> objectMap = new HashMap<String, Object>();
                        objectMap.put("OBJECT_GUID", groupRow.get("OBJECT_GUID"));
                        groupsList.add(objectMap);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                HashMap selectedObjectsMap = new HashMap();
                selectedObjectsMap.put("group", groupsList);
                AudMonitorCriteriaHandler.deleteMonitorCriteriaObjects(mId);
                String usersCountQuery = "SELECT COUNT(*) FROM ADSMUSERGENERALDETAILS WHERE DOMAIN_NAME='" + domainName + "'";
                int count = QueryUtil.getRowsCount(usersCountQuery);
                if (count < 1) {
                    GroupHandler.updateGroupUsers(domainName, groupSIDs);
                }
                AudMonitorCriteriaHandler.addMonitorCriteriaObjects(domainName, mId, monitorCriteriaDO, selectedObjectsMap, categoryId);
            }
            CommonUtil.getPersistence(new boolean[0]).add(monitorCriteriaDO);
            Iterator iterator2 = dataObject.getRows("AUDMonitorReportMap");
            while (iterator2.hasNext()) {
                Row row2 = (Row)iterator2.next();
                Long reportId = (Long)row2.get("AUDIT_REPORT_ID");
                Long monitorId = (Long)row2.get("MONITOR_ID");
                Criteria reportCVCriteria = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                Row reportCVRow = dataObject.getRow("AUDReportCVMapping", reportCVCriteria);
                Long cvIdHolder = (Long)reportCVRow.get("CV_ID");
                Criteria sqlCriteria = new Criteria(Column.getColumn((String)"AUDSQLQuery", (String)"CV_ID"), (Object)cvIdHolder, 0);
                Row sqlRow = dataObject.getRow("AUDSQLQuery", sqlCriteria);
                String sqlString = (String)sqlRow.get("SQL_STRING");
                sqlString = sqlString.replace("${monitorId}", Long.toString(monitorId));
                String countSqlString = (String)sqlRow.get("COUNT_SQL_STRING");
                countSqlString = countSqlString.replace("${monitorId}", Long.toString(monitorId));
                sqlRow.set("SQL_STRING", (Object)sqlString);
                sqlRow.set("COUNT_SQL_STRING", (Object)countSqlString);
                dataObject.updateRow(sqlRow);
                Long sqlQueryId = (Long)sqlRow.get("QUERY_ID");
                Criteria unionCriteria = new Criteria(Column.getColumn((String)"AUDUnionQuery", (String)"QUERY_ID"), (Object)sqlQueryId, 0);
                Row unionRow = dataObject.getRow("AUDUnionQuery", unionCriteria);
                if (unionRow == null) continue;
                String unionString = (String)unionRow.get("UNION_QUERY");
                unionString = unionString.replace("${monitorId}", Long.toString(monitorId));
                String countUnionString = (String)unionRow.get("UNION_COUNT_QUERY");
                countUnionString = countUnionString.replace("${monitorId}", Long.toString(monitorId));
                unionRow.set("UNION_QUERY", (Object)unionString);
                unionRow.set("UNION_COUNT_QUERY", (Object)countUnionString);
                dataObject.updateRow(unionRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            if (action) {
                MonitorManager.getInstance().getMonitors(null);
                AUDCustomViewAPI.getInstance().getReportCVIds();
                AlertProfileAPI.getInstance().getAlertProfiles();
                AudColumnConfig.getInstance().getColumnAliasDisplayNames();
                AuditReportAPI.getInstance().setReportsDetails();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteDomainBasedMonitors(String domainName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            AuditReportAPI.getInstance().setReportsDetails();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean enableDisableMonitor(Long monitorId, String action) {
        boolean b = true;
        try {
            if (action != null) {
                String tableName = "AUDMonitor";
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"MONITOR_ID"), (Object)monitorId, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                Row row = dataObject.getRow(tableName);
                System.out.println("monitor id is : : " + monitorId);
                if (action.equals("Enable")) {
                    row.set("IS_ENABLED", (Object)true);
                } else {
                    row.set("IS_ENABLED", (Object)false);
                }
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                b = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = false;
        }
        return b;
    }
}

