/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.category.EventCategoryListener;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCategoryHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.ArrayList;

public class Category {
    private Long id = null;
    private String name = null;
    private String description = null;
    private ObjectClass resultObjectClass = null;
    private String tableName = null;
    private String showSelectObjects = null;
    private Integer priorityId = null;
    private ObjectClass[] categorySelectObjects = null;
    private ArrayList variablesList = null;
    private EventCategoryListener categoryListener = null;
    private String[] categorySchemaClasses = null;
    private String objectType = "DS";

    public Category(Long categoryId, Row row) {
        try {
            this.id = (Long)row.get("CATEGORY_ID");
            this.name = (String)row.get("CATEGORY_NAME");
            this.description = (String)row.get("CATEGORY_DESCRIPTION");
            this.resultObjectClass = DirectoryObjectAPI.getInstance().getObjectClass((String)row.get("RESULT_OBJ_CLASS"));
            this.tableName = (String)row.get("TABLE_NAME");
            this.priorityId = (Integer)row.get("PRIORITY_ID");
            this.showSelectObjects = (String)row.get("SHOW_SELECT_OBJECTS");
            if (this.showSelectObjects.equalsIgnoreCase("true")) {
                this.categorySelectObjects = AuditCategoryHandler.getInstance().getSelectObjectClasses(categoryId);
            }
            this.objectType = (String)row.get("OBJECT_TYPE");
            this.variablesList = AuditCategoryHandler.getInstance().getVariablesForCategory(categoryId);
            String categoryListenerName = (String)row.get("CATEGORY_LISTENER");
            Class<?> classToInvoke = Class.forName(categoryListenerName.trim());
            this.categoryListener = (EventCategoryListener)classToInvoke.newInstance();
            this.categorySchemaClasses = AuditCategoryHandler.getInstance().getSchemaClasses(this.id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectClass[] getCategorySelectObjects() {
        return this.categorySelectObjects;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPriorityId() {
        return this.priorityId;
    }

    public ObjectClass getResultObjectClass() {
        return this.resultObjectClass;
    }

    public String getShowSelectObjects() {
        return this.showSelectObjects;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ArrayList getVariablesList() {
        return this.variablesList;
    }

    public EventCategoryListener getCategoryListener() {
        return this.categoryListener;
    }

    public String[] getCategorySchemaClasses() {
        return this.categorySchemaClasses;
    }

    public void setCategorySchemaClasses(String[] categorySchemaClasses) {
        this.categorySchemaClasses = categorySchemaClasses;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }
}

