/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class CorrelateTimedEvents
implements Delayed {
    private final long origin = System.currentTimeMillis();
    private final long delay;
    private final String correlationValues;

    public CorrelateTimedEvents(String correlationValues, long delay) {
        this.correlationValues = correlationValues;
        this.delay = delay;
    }

    public String getCorrelationValues() {
        return this.correlationValues;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof CorrelateTimedEvents) {
            long diff = this.delay - ((CorrelateTimedEvents)delayed).delay;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationValues == null ? 0 : this.correlationValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorrelateTimedEvents)) {
            return false;
        }
        CorrelateTimedEvents other = (CorrelateTimedEvents)obj;
        return !(this.correlationValues == null ? other.correlationValues != null : !this.correlationValues.equals(other.correlationValues));
    }

    public String toString() {
        return "CorrelateTimedEvents [origin=" + this.origin + ", delay=" + this.delay + ", correlationValues=" + this.correlationValues + "]";
    }
}

