/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import java.util.Hashtable;

public class CorrelationRule {
    private long id = 0L;
    private String ruleVariable = null;
    private int dataType = 0;

    public CorrelationRule(Long id, String ruleVariable, int dataType) {
        this.id = id;
        this.ruleVariable = ruleVariable;
        this.dataType = dataType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getRuleVariable() {
        return this.ruleVariable;
    }

    public void setRuleVariable(String ruleVariable) {
        this.ruleVariable = ruleVariable;
    }

    private Object getValue(Hashtable eventTable) {
        Object value = eventTable.get(this.ruleVariable);
        if (value == null) {
            Hashtable messageTable = (Hashtable)eventTable.get("Message");
            value = messageTable.get(this.ruleVariable);
        }
        return value;
    }

    private boolean evaluate(Hashtable eventTable1, Hashtable eventTable2) {
        boolean isSatisfied = false;
        if (this.dataType == 1001) {
            isSatisfied = this.compareStringValues(this.getValue(eventTable1), this.getValue(eventTable2));
        } else if (this.dataType == 1002 || this.dataType == 1005) {
            isSatisfied = this.compareNumericValues(this.getValue(eventTable1), this.getValue(eventTable2));
        } else if (this.dataType == 1003) {
            isSatisfied = this.compareBooleanValues(this.getValue(eventTable1), this.getValue(eventTable2));
        }
        return isSatisfied;
    }

    private boolean compareStringValues(Object value1, Object value2) {
        boolean flag = false;
        try {
            String valueString1 = value1.toString().toLowerCase();
            String valueString2 = value2.toString().toLowerCase();
            flag = valueString1.equals(valueString2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private boolean compareNumericValues(Object value1, Object value2) {
        boolean flag = false;
        try {
            long valueLong1 = Long.parseLong(value1.toString());
            long valueLong2 = Long.parseLong(value2.toString());
            flag = valueLong1 == valueLong2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private boolean compareBooleanValues(Object value1, Object value2) {
        boolean flag = false;
        try {
            boolean valueBoolean1 = Boolean.valueOf(value1.toString());
            boolean valueBoolean2 = Boolean.valueOf(value2.toString());
            flag = valueBoolean1 == valueBoolean2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private boolean compareHexaValues(Object value1, Object value2) {
        boolean flag = false;
        try {
            long valueLong1 = Long.decode(value1.toString());
            long valueLong2 = Long.decode(value2.toString());
            flag = (valueLong1 & valueLong2) == valueLong2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Correlation Rule :");
        builder.append(" -> ");
        builder.append(". ");
        builder.append("Rule Variable is -->");
        builder.append(this.ruleVariable);
        return builder.toString();
    }
}

