/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.monitor.Rule;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Group {
    private long id = 0L;
    private String name = new String();
    private int operation = 0;
    private List<Rule> rulesList = new ArrayList<Rule>();
    private int priorityId = 1;

    public Group() {
    }

    public Group(Long id, String name, ArrayList<Rule> rulesList, int operation) {
        this.id = id;
        this.rulesList = rulesList;
        this.name = name;
        this.operation = operation;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public List<Rule> getRulesList() {
        return this.rulesList;
    }

    public void setPriorityId(int priorityId) {
        this.priorityId = priorityId;
    }

    public void setRulesList(List<Rule> rulesList) {
        this.rulesList = rulesList;
    }

    public int getPriorityId() {
        return this.priorityId;
    }

    public boolean evaluate(Hashtable<String, Object> eventTable) {
        int ruleListSize = this.rulesList.size();
        if (ruleListSize == 1) {
            Rule rule = this.rulesList.get(0);
            return rule.evaluate(eventTable);
        }
        boolean result = true;
        for (int i = 0; i < ruleListSize; ++i) {
            Rule rule = this.rulesList.get(i);
            boolean isRuleSatisfied = rule.evaluate(eventTable);
            if (this.operation == 101) {
                if (isRuleSatisfied) {
                    result = result && isRuleSatisfied;
                    continue;
                }
                return false;
            }
            if (this.operation != 102) continue;
            if (isRuleSatisfied) {
                return true;
            }
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Group :");
        builder.append(" -> ");
        builder.append(" Name :  ");
        builder.append(this.name);
        builder.append("Priority Id is ");
        builder.append(this.priorityId);
        builder.append(". ");
        if (this.rulesList != null) {
            for (Rule rul : this.rulesList) {
                builder.append(rul);
            }
        }
        builder.append(". Operator is -->");
        builder.append(ActionConstants.getStringOperation(this.operation));
        builder.append(". ");
        return builder.toString();
    }
}

