/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.AuditEventAPI;
import com.adventnet.sym.adsm.auditing.server.EventVariablesAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterMonitorCriteria;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.importlog.ImportLogFileUtil;
import com.adventnet.sym.adsm.auditing.server.monitor.Action;
import com.adventnet.sym.adsm.auditing.server.monitor.MonitorManager;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.ExcludeFilesHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Monitor {
    private Long id = 0L;
    private Long categoryId = 0L;
    private String name = null;
    private String description = null;
    private String domainName = null;
    private boolean isAlertProfileEnabled = false;
    private List<Action> actionList = null;
    protected ArrayList<HashMap<String, Object>> alertProfiles = null;
    private List<String> criteriaObjectClass = null;
    private HashMap<String, ArrayList<String>> criteriaResultMap = null;
    private HashMap<String, HashMap<String, String>> criteriaServerMap = null;
    private Long auditReportId = 0L;
    private int monitorType = 1;
    private Pattern pattern = Pattern.compile("\\\\\\w+\\\\\\w+\\\\(.+)");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final AuditEventAPI AUDIT_EVENT_API = AuditEventAPI.getInstance();
    private static final ClusterMonitorCriteria CLUSTER_MONITOR_CRITERIA = ClusterMonitorCriteria.getInstance();
    private static final ExcludeFilesHandler EXCLUDE_FILES_HANDLER = ExcludeFilesHandler.getInstance();
    private static final EventVariablesAPI EVENT_VARIABLES_API = EventVariablesAPI.getInstance();
    private static final FileIntegrityManager FILE_INTEGRITY_MANAGER = FileIntegrityManager.getInstance();
    private static final Boolean IS_MOUNTED_DRIVE = Boolean.valueOf(CommonUtil.getSysParams("IsMountedDrive"));
    private static List<Integer> events = new ArrayList<Integer>(){
        {
            this.add(5136);
            this.add(4625);
            this.add(500);
            this.add(501);
            this.add(403);
            this.add(299);
            this.add(412);
            this.add(324);
        }
    };

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public void setAuditReportId(Long auditReportId) {
        this.auditReportId = auditReportId;
    }

    public Long getAuditReportId() {
        return this.auditReportId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public boolean isAlertProfileEnabled() {
        return this.isAlertProfileEnabled;
    }

    public void setAlertProfileEnabled(boolean isAlertProfileEnabled) {
        this.isAlertProfileEnabled = isAlertProfileEnabled;
    }

    public List<Action> getActionList() {
        return this.actionList;
    }

    public void setActionList(List<Action> actionList) {
        this.actionList = actionList;
    }

    public ArrayList<HashMap<String, Object>> getAlertProfiles() {
        return this.alertProfiles;
    }

    public void setAlertProfiles(ArrayList<HashMap<String, Object>> alertProfiles) {
        this.alertProfiles = alertProfiles;
    }

    public List<String> getCriteriaObjectClass() {
        return this.criteriaObjectClass;
    }

    public void setCriteriaObjectClass(List<String> criteriaObjectClass) {
        this.criteriaObjectClass = criteriaObjectClass;
    }

    public HashMap<String, ArrayList<String>> getCriteriaResult() {
        return this.criteriaResultMap;
    }

    public void setCriteriaResult(HashMap<String, ArrayList<String>> criteriaResultMap) {
        this.criteriaResultMap = criteriaResultMap;
    }

    public HashMap<String, HashMap<String, String>> getCriteriaServerMap() {
        return this.criteriaServerMap;
    }

    public void setCriteriaServerMap(HashMap<String, HashMap<String, String>> criteriaServerMap) {
        this.criteriaServerMap = criteriaServerMap;
    }

    public int getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(int monitorType) {
        this.monitorType = monitorType;
    }

    public Hashtable<String, Object> evaluate(Hashtable<String, Object> eventTable, Monitor monitor) throws DataAccessException {
        Integer machineType;
        Hashtable<String, Object> returnEventTable = null;
        Hashtable<String, Object> processEventTable = eventTable;
        boolean c = false;
        if (this.monitorType == 1) {
            c = this.checkForCriteriaResult(processEventTable);
            if (c) {
                c = this.checkForServiceAccounts(processEventTable);
            }
        } else if (this.monitorType == 2) {
            c = this.checkForFileObjectCriteriaResult(processEventTable);
        } else if (this.monitorType == 3 && ((machineType = (Integer)eventTable.get("MachineType")) & 0x4000) == 16384) {
            c = this.checkForFileIntegrity(processEventTable);
        }
        if (c) {
            for (Action action : this.actionList) {
                if (this.monitorType == 2 || this.monitorType == 3 || this.monitorType == 1 && (Integer)processEventTable.get("EventCode") == 4663) {
                    processEventTable = (Hashtable<String, Object>)eventTable.clone();
                }
                boolean d = false;
                if (!action.isUseAdvCorrelations()) {
                    d = action.evaluate(processEventTable);
                    if (d) {
                        returnEventTable = processEventTable;
                    }
                } else if (events.contains((Integer)processEventTable.get("EventCode"))) {
                    processEventTable = (Hashtable)eventTable.clone();
                    action.correlateUserAttributeEvent(processEventTable, monitor);
                } else {
                    returnEventTable = action.correlate(processEventTable, monitor.getId(), action.getId());
                }
                if (!(d = returnEventTable != null)) continue;
                if (this.monitorType != 2 && this.monitorType != 3 && (this.monitorType != 1 || (Integer)processEventTable.get("EventCode") != 4663 && (Integer)processEventTable.get("EventCode") != 5140 && (Integer)processEventTable.get("EventCode") != 5142 && (Integer)processEventTable.get("EventCode") != 5143 && (Integer)processEventTable.get("EventCode") != 5144)) break;
                returnEventTable.put("ActionId", action.getId());
                break;
            }
        }
        return returnEventTable;
    }

    private boolean checkForCriteriaResult(Hashtable<String, Object> eventTable) {
        if (this.criteriaObjectClass == null) {
            this.criteriaObjectClass = new ArrayList<String>();
        }
        if (this.criteriaObjectClass.isEmpty()) {
            this.criteriaObjectClass.add("domainDNS");
        }
        if (eventTable.get("EventCode").toString().equals("299") && eventTable.get("Relying Party").toString().contains(eventTable.get("DomainController").toString().toLowerCase())) {
            return false;
        }
        if (this.criteriaObjectClass.get(0).equalsIgnoreCase("organizationalUnit") && eventTable.get("EventCode").toString().equalsIgnoreCase("5137")) {
            return this.checkForADObjectCriteriaResultForCreation(eventTable);
        }
        return this.criteriaObjectClass.get(0).equalsIgnoreCase("domainDNS") ? true : this.checkForADObjectCriteriaResult(eventTable);
    }

    private boolean checkForADObjectCriteriaResultForCreation(Hashtable<String, Object> eventTable) {
        boolean b = false;
        HashMap<String, String> keyValuesMap = this.getKeyValuesFromEvent(eventTable);
        Set<String> keyValueSet = keyValuesMap.keySet();
        for (String string : keyValueSet) {
            String keyValueFromEvent = keyValuesMap.get(string);
            keyValueFromEvent = keyValueFromEvent.toLowerCase();
            ArrayList<String> resultKeyValues = this.criteriaResultMap.get(string);
            String objectDn = eventTable.get("Object DN").toString();
            String[] dnArray = objectDn.split(",");
            int dnArrayLength = dnArray.length;
            String ouGuid = " ";
            for (int i = 0; i < dnArrayLength; ++i) {
                if (!dnArray[i].toLowerCase().contains("ou=")) continue;
                dnArray[i] = objectDn.substring(objectDn.indexOf(dnArray[i]), objectDn.length());
                try {
                    Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), (Object)dnArray[i], 0);
                    DataObject d = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", c);
                    if (d == null || d.isEmpty()) continue;
                    Row r = d.getRow("ADSMOUDetails", (Criteria)null);
                    ouGuid = ouGuid + r.get("OBJECT_GUID").toString();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((keyValueFromEvent = keyValueFromEvent + ouGuid).equalsIgnoreCase("-") || resultKeyValues == null) continue;
            Iterator<String> i$ = resultKeyValues.iterator();
            while (i$.hasNext()) {
                String object;
                String string2 = object = i$.next();
                if (!keyValueFromEvent.toLowerCase().contains(string2.toLowerCase())) continue;
                return true;
            }
        }
        return b;
    }

    private boolean checkForFileIntegrity(Hashtable<String, Object> eventTable) {
        boolean finalresult = true;
        Integer eventNo = (Integer)eventTable.get("EventCode");
        if (eventNo == 4660 || eventNo == 567 || eventNo == 564 || eventNo == 5140) {
            finalresult = true;
        } else {
            String machineName;
            String systemDrive;
            String objectName;
            String string = objectName = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese")) : (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"));
            if (objectName == null) {
                finalresult = false;
            }
            if (finalresult && (finalresult = this.checkForFimConfiguredFolders(objectName = objectName.toLowerCase(), systemDrive = FILE_INTEGRITY_MANAGER.getSystemDrive(machineName = (String)eventTable.get("DomainController"), this.domainName)))) {
                finalresult = this.checkForFimConfiguredFileTypes(objectName);
            }
        }
        return finalresult;
    }

    private boolean checkForFimConfiguredFolders(String objectName, CharSequence systemDrive) {
        boolean result = false;
        ArrayList<String> configuredFolders = FILE_INTEGRITY_MANAGER.getConfiguredFolderList(this.domainName);
        if (configuredFolders == null) {
            return result;
        }
        int length = configuredFolders.size();
        for (int index = 0; index < length; ++index) {
            String folderName = configuredFolders.get(index).replace("%SystemDrive%", systemDrive).toLowerCase();
            if (!objectName.startsWith(folderName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean checkForFimConfiguredFileTypes(String objectName) {
        boolean result = false;
        ArrayList<String> configuredFileTypes = FILE_INTEGRITY_MANAGER.getConfiguredFileTypeList(this.domainName);
        if (configuredFileTypes == null) {
            return result;
        }
        if (configuredFileTypes.contains("*.*")) {
            return true;
        }
        int length = configuredFileTypes.size();
        for (int index = 0; index < length; ++index) {
            String fileType = configuredFileTypes.get(index).substring(1).toLowerCase();
            if (!objectName.endsWith(fileType)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean checkForADObjectCriteriaResult(Hashtable<String, Object> eventTable) {
        boolean b = false;
        HashMap<String, String> keyValuesMap = this.getKeyValuesFromEvent(eventTable);
        Set<String> keyValueSet = keyValuesMap.keySet();
        for (String string : keyValueSet) {
            String keyValueFromEvent = keyValuesMap.get(string);
            keyValueFromEvent = keyValueFromEvent.toLowerCase();
            ArrayList<String> resultKeyValues = this.criteriaResultMap.get(string);
            if (keyValueFromEvent.equalsIgnoreCase("-") || resultKeyValues == null) continue;
            for (String object : resultKeyValues) {
                String string2 = object;
                if (!keyValueFromEvent.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return b;
    }

    private boolean checkForFileObjectCriteriaResult(Hashtable<String, Object> eventTable) {
        boolean b = false;
        boolean c = false;
        Integer machineType = (Integer)eventTable.get("MachineType");
        if ((machineType & 4) == 4 || (machineType & 0x40) == 64 || (machineType & 0x100) == 256 || (machineType & 0x10000) == 65536 || (machineType & 0x20000) == 131072) {
            Integer eventNumber = (Integer)eventTable.get("EventCode");
            if (eventNumber == 560 || eventNumber == 4656 || eventNumber == 4663 || eventNumber == 4670 || eventNumber == 4907 || eventNumber == 563 || eventNumber == 4659 || eventNumber == 9999) {
                String source = ((String)eventTable.get("DomainController")).toLowerCase();
                if ((machineType & 0x10000) == 65536) {
                    source = ImportLogFileUtil.getInstance().getNameFromDnsName(source);
                }
                String domainFromEvent = (String)eventTable.get("DomainName");
                if (machineType != 1 && ((machineType & 0x40) == 64 || (machineType & 0x10000) == 65536)) {
                    ArrayList<Properties> capList = CLUSTER_MONITOR_CRITERIA.getClusterCaps(domainFromEvent, source);
                    HashMap<String, Boolean> clusterDriveSharedMap = new HashMap<String, Boolean>();
                    if (capList != null && capList.size() > 0) {
                        for (int i = 0; i < capList.size(); ++i) {
                            c = false;
                            Properties capProps = capList.get(i);
                            String capName = ((String)capProps.get("CLUSTER_CAP_NAME")).toLowerCase();
                            c = this.checkForFileShareCriteria(capName, eventTable, Boolean.TRUE, clusterDriveSharedMap);
                            if (c) break;
                        }
                    }
                    if (!c && !clusterDriveSharedMap.isEmpty()) {
                        String objectName;
                        String string = objectName = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese"))).toLowerCase() : ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"))).toLowerCase();
                        if (!(ExcludeFilesHandler.getInstance().isPatternMatches(objectName) || objectName.contains("$recycle.bin") || objectName.contains("system volume information"))) {
                            String uncPath;
                            HashMap<String, String> serverShareMap;
                            String capName;
                            for (Map.Entry<String, Boolean> entry : clusterDriveSharedMap.entrySet()) {
                                capName = entry.getKey();
                                uncPath = MonitorManager.getSANDriveShare(this.domainName, capName, objectName, serverShareMap = this.criteriaServerMap.get(capName), Boolean.TRUE, IS_MOUNTED_DRIVE);
                                if (uncPath == null) continue;
                                eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), uncPath);
                                c = true;
                                break;
                            }
                            if (!c) {
                                for (Map.Entry<String, Boolean> entry : clusterDriveSharedMap.entrySet()) {
                                    capName = entry.getKey();
                                    uncPath = MonitorManager.getSANDriveShare(this.domainName, capName, objectName, serverShareMap = this.criteriaServerMap.get(capName), Boolean.FALSE, IS_MOUNTED_DRIVE);
                                    if (uncPath == null) continue;
                                    eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), uncPath);
                                    c = true;
                                    break;
                                }
                            }
                        }
                    }
                    b = !(c || (machineType & 4) != 4 && (machineType & 0x10000) != 65536) ? this.checkForFileShareCriteria(source, eventTable, Boolean.FALSE, null) : c;
                } else {
                    b = this.checkForFileShareCriteria(source, eventTable, Boolean.FALSE, null);
                }
            } else if (((machineType & 0x100) == 256 || (machineType & 0x10000) == 65536) && eventNumber == 567) {
                String source = ((String)eventTable.get("DomainController")).toLowerCase();
                b = eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) != null ? this.checkForFileShareCriteria(source, eventTable, Boolean.FALSE, null) : true;
            } else if (eventNumber == 562 || eventNumber == 564 || eventNumber == 567 || eventNumber == 4658 || eventNumber == 4660) {
                if ((machineType & 0x20000) == 131072) {
                    eventTable.put("DomainController", eventTable.get("DomainController").toString().toLowerCase());
                }
                b = true;
            }
        } else if ((machineType & 0x80000) == 524288) {
            boolean isJuncPathSet = true;
            String source = ((String)eventTable.get("DomainController")).toLowerCase();
            if (eventTable.get("OBJECT_JUNC_PATH") == null) {
                isJuncPathSet = NetAppHandler.setNaVserverEventObjJuncPath(eventTable, false);
                Integer eventId = (Integer)eventTable.get("EventCode");
                if (eventId == 9999) {
                    NetAppHandler.setNaVserverEventObjJuncPath(eventTable, true);
                }
            }
            if (isJuncPathSet) {
                b = this.checkForFileShareCriteria(source, eventTable, Boolean.FALSE, null);
            }
        } else {
            b = Boolean.FALSE;
        }
        return b;
    }

    private boolean checkForFileShareCriteria(String source, Hashtable<String, Object> eventTable, Boolean isClusterShare, HashMap<String, Boolean> clusterDriveSharedMap) {
        boolean b = false;
        boolean isDriveShared = Boolean.FALSE;
        Integer machineType = (Integer)eventTable.get("MachineType");
        HashMap<String, String> serverShareMap = this.criteriaServerMap.get(source);
        String objectName = (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name")) == null ? ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name_For_Chinese"))).toLowerCase() : ((String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Object_Name"))).toLowerCase();
        Boolean isExcluded = false;
        if (serverShareMap != null && objectName != null && !objectName.trim().equals("")) {
            String uncPath;
            for (Map.Entry<String, String> entry : serverShareMap.entrySet()) {
                String shareLocalPath = entry.getKey();
                if (objectName.charAt(0) == '\\') {
                    String driveTrimmedPath;
                    if ((machineType & 0x100) == 256) {
                        driveTrimmedPath = shareLocalPath.substring(2);
                        if (!objectName.startsWith(driveTrimmedPath) || ExcludeFilesHandler.getInstance().isPatternMatches(objectName)) continue;
                        b = true;
                        if (objectName.endsWith("\\")) {
                            objectName = objectName.substring(0, objectName.length() - 1);
                        }
                        eventTable.put("UNC Path", objectName.replace(driveTrimmedPath, entry.getValue()));
                        break;
                    }
                    if ((machineType & 0x20000) == 131072) {
                        driveTrimmedPath = shareLocalPath.substring(2);
                        if (!objectName.startsWith(driveTrimmedPath) || ExcludeFilesHandler.getInstance().isPatternMatches(objectName)) continue;
                        b = true;
                        if (objectName.endsWith("\\")) {
                            objectName = objectName.substring(0, objectName.length() - 1);
                        }
                        eventTable.put("UNC Path", objectName.replace(driveTrimmedPath, entry.getValue()));
                        eventTable.put("DomainController", eventTable.get("DomainController").toString().toLowerCase());
                        eventTable.put("Object Type", "File");
                        break;
                    }
                    if (shareLocalPath.length() == 3) {
                        isDriveShared = Boolean.TRUE;
                        if (!isClusterShare.booleanValue()) continue;
                        clusterDriveSharedMap.put(source, Boolean.TRUE);
                        continue;
                    }
                    driveTrimmedPath = shareLocalPath.substring(3);
                    Matcher matcher = this.pattern.matcher(objectName);
                    if (!matcher.find()) continue;
                    String shareTrimmedPath = matcher.group(1);
                    isExcluded = ExcludeFilesHandler.getInstance().isPatternMatches(objectName);
                    if (isExcluded.booleanValue()) continue;
                    if (shareTrimmedPath.startsWith(driveTrimmedPath)) {
                        b = true;
                        eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), shareTrimmedPath.replace(driveTrimmedPath, entry.getValue()));
                        break;
                    }
                    if (!IS_MOUNTED_DRIVE.booleanValue()) continue;
                    isDriveShared = Boolean.TRUE;
                    clusterDriveSharedMap.put(source, Boolean.TRUE);
                    String finalTrimmedPath = driveTrimmedPath.substring(driveTrimmedPath.indexOf("\\") + 1, driveTrimmedPath.length());
                    if (!shareTrimmedPath.startsWith(finalTrimmedPath)) continue;
                    b = true;
                    eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), shareTrimmedPath.replace(finalTrimmedPath, entry.getValue()));
                    break;
                }
                if ((machineType & 0x80000) == 524288) {
                    String shareUncPath = entry.getValue().replaceAll("\\\\", "\\\\\\\\");
                    String shareJuncPath = entry.getKey();
                    String objUncPath = (String)eventTable.get("UNC Path");
                    String objJuncPath = (String)eventTable.get("OBJECT_JUNC_PATH");
                    if (shareUncPath != null && shareUncPath.contains("$")) {
                        shareUncPath = shareUncPath.replace("$", "\\$");
                    }
                    if (shareJuncPath != null && shareJuncPath.toLowerCase().startsWith("c:\\")) {
                        shareJuncPath = shareJuncPath.substring(2);
                        shareJuncPath = shareJuncPath.replaceAll("\\\\", "/");
                    }
                    if (shareJuncPath.equals("/")) continue;
                    if (shareJuncPath.endsWith("/")) {
                        shareJuncPath = shareJuncPath.substring(0, shareJuncPath.length() - 1);
                    }
                    if (objJuncPath == null || !objJuncPath.toLowerCase().startsWith(shareJuncPath.toLowerCase())) continue;
                    if (ExcludeFilesHandler.getInstance().isPatternMatches(objJuncPath)) break;
                    if (objUncPath == null) {
                        objUncPath = objJuncPath.replaceFirst("(?i)" + shareJuncPath, shareUncPath).replaceAll("/", "\\\\");
                        eventTable.put("UNC Path", objUncPath);
                        eventTable.put("Object Name", objJuncPath);
                        Integer eventId = (Integer)eventTable.get("EventCode");
                        if (eventId == 9999) {
                            String newObjUncPath = null;
                            String newObjJuncPath = (String)eventTable.get("NEW_UNC_NAME");
                            if (newObjJuncPath != null && newObjJuncPath.toLowerCase().startsWith(shareJuncPath.toLowerCase())) {
                                newObjUncPath = newObjJuncPath.replaceFirst("(?i)" + shareJuncPath, shareUncPath).replaceAll("/", "\\\\");
                                eventTable.put("NEW_UNC_NAME", newObjUncPath);
                                eventTable.put("UNC_NAME", objUncPath);
                            }
                        }
                    }
                    if (eventTable.get("Object Type") != null && eventTable.get("Object Type").toString().equals("Directory")) {
                        eventTable.put("Object Type", "File");
                    }
                    b = true;
                    break;
                }
                if (shareLocalPath.length() == 3) {
                    shareLocalPath = shareLocalPath.substring(0, shareLocalPath.length() - 1);
                }
                if (!objectName.startsWith(shareLocalPath) || EXCLUDE_FILES_HANDLER.isPatternMatches(objectName)) continue;
                b = true;
                eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), objectName.replace(shareLocalPath, entry.getValue()));
                break;
            }
            if (!(!isDriveShared || isClusterShare.booleanValue() || b || ExcludeFilesHandler.getInstance().isPatternMatches(objectName) || objectName.contains("$recycle.bin") || objectName.contains("system volume information") || (uncPath = MonitorManager.getSANDriveShare(this.domainName, source, objectName, serverShareMap, Boolean.FALSE, IS_MOUNTED_DRIVE)) == null)) {
                eventTable.put(RB.getString("adap.AUDRuleVariables.variable_name.UNC_Path"), uncPath);
                b = true;
            }
        }
        return b;
    }

    private HashMap<String, String> getKeyValuesFromEvent(Hashtable<String, Object> evntTbl) {
        HashMap<String, String> keyValuesMap = new HashMap<String, String>();
        Integer evntNo = (Integer)evntTbl.get("EventCode");
        HashMap<String, String> eventKeyMap = EVENT_VARIABLES_API.getEvtVarSID(evntNo);
        Set<String> set = eventKeyMap.keySet();
        for (String string : set) {
            String key = eventKeyMap.get(string);
            Object keyValue = evntTbl.get(key);
            if (string.equals("SID_STRING")) {
                String sidString = null;
                if (keyValue == null) {
                    sidString = "-";
                } else {
                    sidString = ((String)keyValue).replace("%{", "");
                    sidString = sidString.replace("}", "");
                }
                keyValuesMap.put(string, sidString);
                continue;
            }
            if (string.equals("OBJECT_GUID")) {
                String objectGUID = null;
                objectGUID = keyValue == null ? "-" : ((String)keyValue).replace("%{", "{");
                keyValuesMap.put(string, objectGUID);
                continue;
            }
            if (keyValue == null) continue;
            keyValuesMap.put(string, keyValue.toString());
        }
        return keyValuesMap;
    }

    private boolean checkForServiceAccounts(Hashtable<String, Object> eventTable) {
        String domainName;
        ArrayList<String> usersList;
        boolean b = true;
        Integer eventNumber = (Integer)eventTable.get("EventCode");
        if ((eventNumber == 672 || eventNumber == 675 || eventNumber == 4768 || eventNumber == 4771) && (usersList = AUDIT_EVENT_API.getUsersList(domainName = (String)eventTable.get("DomainName"))) != null && usersList.size() > 0) {
            String userName = "";
            userName = eventNumber == 672 || eventNumber == 675 ? (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.User_Name")) : (String)eventTable.get(RB.getString("adap.AUDRuleVariables.variable_name.Account_Name"));
            for (int i = 0; i < usersList.size(); ++i) {
                String name = usersList.get(i);
                if (!name.equalsIgnoreCase(userName)) continue;
                b = false;
                break;
            }
        }
        return b;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Monitor :");
        builder.append(" -> ");
        builder.append(" Name :  ");
        builder.append(this.name);
        builder.append(" -> ");
        builder.append(" Domain  :  ");
        builder.append(this.domainName);
        for (Action actn : this.actionList) {
            builder.append(actn);
        }
        return builder.toString();
    }
}

