/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventManager;
import com.adventnet.sym.adsm.auditing.server.EventVariablesAPI;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileManager;
import com.adventnet.sym.adsm.auditing.server.alert.AudColumnConfig;
import com.adventnet.sym.adsm.auditing.server.alert.notification.AlertNotificationManager;
import com.adventnet.sym.adsm.auditing.server.monitor.Action;
import com.adventnet.sym.adsm.auditing.server.monitor.CorrelationRule;
import com.adventnet.sym.adsm.auditing.server.monitor.Group;
import com.adventnet.sym.adsm.auditing.server.monitor.Monitor;
import com.adventnet.sym.adsm.auditing.server.monitor.RLock;
import com.adventnet.sym.adsm.auditing.server.monitor.Rule;
import com.adventnet.sym.adsm.auditing.server.monitor.RuleVariable;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MonitorManager {
    private static MonitorManager monitorManager = null;
    private static ConcurrentHashMap<String, HashMap<Long, HashMap<Long, Monitor>>> monitorMap = null;
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final Logger EVENT_LOGGER = Logger.getLogger(MonitorManager.class.getName());
    private static final String MONITOR_REPORT_TABLE = "AUDMonitorReportMap";
    private static final String MONITOR_SERVER_TABLE = "AUDFileMonitorServers";
    private static final String MONITOR_SHARE_TABLE = "AUDFileMonitorShares";
    private static final String ALERT_MONITORMAP_TABLE = "AUDAlertMonitorMap";
    private static final String ALERT_PROFILE_TABLE = "AUDAlertProfile";
    private static final String CORRELATION_RULES_TABLE = "AUDCorrelationRules";
    public static HashMap<String, HashMap<String, HashMap<String, HashMap<String, Object>>>> sanDriveTable = new HashMap();
    private static Object domainLock = new Object();
    private static Object serverLock = new Object();
    private static Object sanDriveShareMapLock = new Object();
    private static final RLock<String> RLOCK = new RLock();

    private MonitorManager() {
        try {
            this.getMonitors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitorManager getInstance() {
        if (monitorManager != null) return monitorManager;
        Class<MonitorManager> clazz = MonitorManager.class;
        synchronized (MonitorManager.class) {
            if (monitorManager != null) return monitorManager;
            monitorManager = new MonitorManager();
            AUDCustomViewAPI.getInstance();
            AudColumnConfig.getInstance();
            EventManager.getInstance();
            AlertProfileManager.getInstance();
            AlertNotificationManager.getInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitorManager;
        }
    }

    public void getMonitors(ArrayList<Long> monitorIdList) throws DataAccessException {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("AUDMonitor");
        tableList.add(MONITOR_REPORT_TABLE);
        tableList.add("AUDMonitorActions");
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"IS_ENABLED"), (Object)true, 0);
        if (monitorIdList != null) {
            criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"MONITOR_ID"), (Object)monitorIdList.toArray(), 8);
        }
        DataObject monitorDO = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
        DataObject actionDO = CommonUtil.getPersistence(new boolean[0]).get("AUDAction", (Row)null);
        DataObject groupDO = CommonUtil.getPersistence(new boolean[0]).get("AUDGroup", (Row)null);
        DataObject ruleDO = CommonUtil.getPersistence(new boolean[0]).get("AUDRule", (Row)null);
        DataObject correlationRuleDO = CommonUtil.getPersistence(new boolean[0]).get(CORRELATION_RULES_TABLE, (Row)null);
        DataObject serverDataObject = CommonUtil.getPersistence(new boolean[0]).get(MONITOR_SERVER_TABLE, (Row)null);
        DataObject shareDataObject = CommonUtil.getPersistence(new boolean[0]).get(MONITOR_SHARE_TABLE, (Row)null);
        ArrayList<String> alertProfileTableList = new ArrayList<String>();
        alertProfileTableList.add(ALERT_MONITORMAP_TABLE);
        alertProfileTableList.add(ALERT_PROFILE_TABLE);
        Criteria alertProfileCriteria = new Criteria(Column.getColumn((String)ALERT_MONITORMAP_TABLE, (String)"ALERT_PROFILE_ID"), null, 1);
        DataObject alertProfileDO = CommonUtil.getPersistence(new boolean[0]).get(alertProfileTableList, alertProfileCriteria);
        Iterator monitorIterator = monitorDO.getRows("AUDMonitor");
        while (monitorIterator.hasNext()) {
            HashMap<Long, Monitor> categoryMap;
            HashMap<Long, HashMap<Long, Monitor>> domainMap;
            Integer monitorType;
            Row monitorRow = (Row)monitorIterator.next();
            Monitor monitor = new Monitor();
            Long monitorId = (Long)monitorRow.get("MONITOR_ID");
            monitor.setId(monitorId);
            Long categoryId = (Long)monitorRow.get("CATEGORY_ID");
            EVENT_LOGGER.log(Level.FINE, " Getting Details for Monitor Id {0} : ", new Object[]{monitorId});
            monitor.setName((String)monitorRow.get("MONITOR_NAME"));
            monitor.setCategoryId(categoryId);
            monitor.setMonitorType((Integer)monitorRow.get("MONITOR_TYPE"));
            Boolean isProfileAdded = (Boolean)monitorRow.get("IS_PROFILE_ADDED");
            String domainName = (String)monitorRow.get("DOMAIN_NAME");
            monitor.setAlertProfileEnabled(isProfileAdded);
            ArrayList<Action> actionList = this.getActionList(monitorId, monitorDO, actionDO, groupDO, ruleDO, correlationRuleDO);
            monitor.setActionList(actionList);
            monitor.setDomainName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)MONITOR_REPORT_TABLE, (String)"MONITOR_ID"), (Object)monitorId, 0);
            Row monitorMapRow = monitorDO.getRow(MONITOR_REPORT_TABLE, crit);
            if (monitorMapRow != null) {
                monitor.setAuditReportId((Long)monitorMapRow.get("AUDIT_REPORT_ID"));
            }
            if ((monitorType = (Integer)monitorRow.get("MONITOR_TYPE")) == 1 || monitorType == 3) {
                HashMap<String, Object> criteriaObjectMap = MonitorManager.getADCriteriaObjectMap(monitorId);
                monitor.setCriteriaObjectClass((ArrayList)criteriaObjectMap.get("criteriaObjectClassList"));
                ArrayList criteriaObjectIdList = (ArrayList)criteriaObjectMap.get("criteriaObjectIdList");
                HashMap<String, ArrayList<String>> criteriaResultMap = MonitorManager.getADCriteriaResultMap(criteriaObjectIdList);
                monitor.setCriteriaResult(criteriaResultMap);
            } else if (monitorType == 2) {
                HashMap<String, HashMap<String, String>> criteriaServerMap = this.getFileCriteriaObjects(monitorId, serverDataObject, shareDataObject);
                ArrayList<String> criteriaObjectClassList = new ArrayList<String>();
                criteriaObjectClassList.add("computer");
                monitor.setCriteriaServerMap(criteriaServerMap);
            }
            if (isProfileAdded.booleanValue()) {
                ArrayList<HashMap<String, Object>> alertProfileList = this.getAlertProfiles(monitorId, alertProfileDO);
                monitor.setAlertProfiles(alertProfileList);
            }
            if (monitorMap == null) {
                monitorMap = new ConcurrentHashMap();
            }
            if ((domainMap = monitorMap.get(domainName)) == null) {
                domainMap = new HashMap();
            }
            if ((categoryMap = domainMap.get(categoryId)) == null) {
                categoryMap = new HashMap();
            }
            categoryMap.put(monitorId, monitor);
            domainMap.put(categoryId, categoryMap);
            monitorMap.put(domainName, domainMap);
        }
        EVENT_LOGGER.log(Level.FINE, new StringBuffer().append("Monitor Object is ").append(monitorMap).toString());
    }

    public static HashMap<String, Object> getADCriteriaObjectMap(Long monitorId) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> criteriaObjectClassList = new ArrayList<String>();
        ArrayList<Long> criteriaObjectIdList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorCriteria", (String)"MONITOR_ID"), (Object)monitorId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorCriteria", criteria);
            if (!dataObject.isEmpty()) {
                Iterator criObjIterator = dataObject.getRows("AUDMonitorCriteria");
                while (criObjIterator.hasNext()) {
                    Row row = (Row)criObjIterator.next();
                    criteriaObjectClassList.add((String)row.get("OBJECT_CLASS"));
                    criteriaObjectIdList.add((Long)row.get("CRITERIA_ID"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("criteriaObjectClassList", criteriaObjectClassList);
        hashMap.put("criteriaObjectIdList", criteriaObjectIdList);
        EVENT_LOGGER.log(Level.FINE, "criteriaObjectMap for monitor id {0} is {1}", new Object[]{monitorId, hashMap});
        return hashMap;
    }

    public static HashMap<String, ArrayList<String>> getADCriteriaResultMap(ArrayList<Long> criteriaObjectIdList) {
        HashMap<String, ArrayList<String>> criteriaResultMap = new HashMap<String, ArrayList<String>>();
        try {
            Long[] criteriaObjectIds = criteriaObjectIdList.toArray(new Long[criteriaObjectIdList.size()]);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDMonitorCriteriaResult", (String)"CRITERIA_ID"), (Object)criteriaObjectIds, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDMonitorCriteriaResult", criteria);
            if (!dataObject.isEmpty()) {
                Iterator critResObjIterator = dataObject.getRows("AUDMonitorCriteriaResult");
                while (critResObjIterator.hasNext()) {
                    Row critResObjRow = (Row)critResObjIterator.next();
                    String variableType = (String)critResObjRow.get("VARIABLE_TYPE");
                    ArrayList<String> obj = criteriaResultMap.get(variableType);
                    ArrayList<String> arrayList = obj;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add((String)critResObjRow.get("CRITERIA_OBJECT"));
                    criteriaResultMap.put(variableType, arrayList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EVENT_LOGGER.log(Level.FINE, "criteriaResultMap for criteriaObjectIdList {0} is {1}", new Object[]{criteriaObjectIdList, criteriaResultMap});
        return criteriaResultMap;
    }

    public HashMap<String, HashMap<String, String>> getFileCriteriaObjects(Long monitorId, DataObject serverDataObject, DataObject shareDataObject) {
        HashMap<String, HashMap<String, String>> criteriaMap = new HashMap<String, HashMap<String, String>>();
        try {
            Criteria serverCriteria = new Criteria(Column.getColumn((String)MONITOR_SERVER_TABLE, (String)"MONITOR_ID"), (Object)monitorId, 0);
            if (!serverDataObject.isEmpty()) {
                Iterator serverIterator = serverDataObject.getRows(MONITOR_SERVER_TABLE, serverCriteria);
                while (serverIterator.hasNext()) {
                    Row serverRow = (Row)serverIterator.next();
                    Long criteriaId = (Long)serverRow.get("CRITERIA_ID");
                    String serverName = ((String)serverRow.get("SERVERNAME")).toLowerCase();
                    Criteria shareCriteria = new Criteria(Column.getColumn((String)MONITOR_SHARE_TABLE, (String)"CRITERIA_ID"), (Object)criteriaId, 0);
                    HashMap<String, String> serverShareMap = criteriaMap.get(serverName);
                    if (serverShareMap == null) {
                        serverShareMap = new HashMap();
                    }
                    Iterator shareIterator = shareDataObject.getRows(MONITOR_SHARE_TABLE, shareCriteria);
                    while (shareIterator.hasNext()) {
                        Row shareRow = (Row)shareIterator.next();
                        String shareLocalPath = ((String)shareRow.get("LOCAL_PATH")).toLowerCase();
                        serverShareMap.put(shareLocalPath, ((String)shareRow.get("SHARE_NAME")).toLowerCase());
                    }
                    criteriaMap.put(serverName, serverShareMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteriaMap;
    }

    public ArrayList<Action> getActionList(Long monitorId, DataObject monitorDO, DataObject actionDO, DataObject groupDO, DataObject ruleDO, DataObject correlationRuleDO) {
        ArrayList<Action> actionList = new ArrayList<Action>();
        try {
            Criteria monitorCriteria = new Criteria(Column.getColumn((String)"AUDMonitorActions", (String)"MONITOR_ID"), (Object)monitorId, 0);
            Iterator monActIter = monitorDO.getRows("AUDMonitorActions", monitorCriteria);
            while (monActIter.hasNext()) {
                Row monActRow = (Row)monActIter.next();
                Long actionId = (Long)monActRow.get("ACTION_ID");
                Action action = new Action();
                action.setId(actionId);
                Criteria actionCriteria = new Criteria(Column.getColumn((String)"AUDAction", (String)"ACTION_ID"), (Object)actionId, 0);
                Row actionRow = actionDO.getRow("AUDAction", actionCriteria);
                action.setName((String)actionRow.get("ACTION_NAME"));
                action.setTimeInterval((Long)actionRow.get("TIME_INTERVAL"));
                boolean useAdvCorrelations = (Boolean)actionRow.get("USE_ADV_CORRELATIONS");
                action.setUseAdvCorrelations(useAdvCorrelations);
                if (useAdvCorrelations) {
                    action.setCorrelationVariables(this.getCorrelationVariables(actionId, correlationRuleDO));
                    action.initializeEventCollectionThread("EventCollectionThread");
                }
                ArrayList<Group> groupList = new ArrayList();
                groupList = this.getGroupList(actionId, groupDO, ruleDO);
                action.setGroupsList(groupList);
                actionList.add(action);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionList;
    }

    public ArrayList<CorrelationRule> getCorrelationRules(Long actionId, DataObject correlationRuleDO) {
        ArrayList<CorrelationRule> correlationRuleList = new ArrayList<CorrelationRule>();
        try {
            Criteria actionCriteria = new Criteria(Column.getColumn((String)CORRELATION_RULES_TABLE, (String)"ACTION_ID"), (Object)actionId, 0);
            Iterator corrOptIter = correlationRuleDO.getRows(CORRELATION_RULES_TABLE, actionCriteria);
            while (corrOptIter.hasNext()) {
                Row corrOptRow = (Row)corrOptIter.next();
                Long variableId = (Long)corrOptRow.get("VARIABLE_ID");
                RuleVariable variable = EventVariablesAPI.getInstance().getVariable(variableId);
                CorrelationRule correlationRule = new CorrelationRule((Long)corrOptRow.get("CORRELATION_RULE_ID"), variable.getName(), Long.valueOf(variable.getDataType()).intValue());
                correlationRuleList.add(correlationRule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EVENT_LOGGER.log(Level.INFO, new StringBuffer().append("Correlation Rule List: ").append(correlationRuleList).toString());
        return correlationRuleList;
    }

    public ArrayList<String> getCorrelationVariables(Long actionId, DataObject correlationRuleDO) {
        ArrayList<String> correlationvariableList = new ArrayList<String>();
        try {
            Criteria actionCriteria = new Criteria(Column.getColumn((String)CORRELATION_RULES_TABLE, (String)"ACTION_ID"), (Object)actionId, 0);
            Iterator corrOptIter = correlationRuleDO.getRows(CORRELATION_RULES_TABLE, actionCriteria);
            while (corrOptIter.hasNext()) {
                Row corrOptRow = (Row)corrOptIter.next();
                Long variableId = (Long)corrOptRow.get("VARIABLE_ID");
                RuleVariable variable = EventVariablesAPI.getInstance().getVariable(variableId);
                correlationvariableList.add(variable.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return correlationvariableList;
    }

    public ArrayList<Group> getGroupList(Long actionId, DataObject groupDO, DataObject ruleDO) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        try {
            Criteria actionCriteria = new Criteria(Column.getColumn((String)"AUDGroup", (String)"ACTION_ID"), (Object)actionId, 0);
            Iterator groupIter = groupDO.getRows("AUDGroup", actionCriteria);
            while (groupIter.hasNext()) {
                Row groupRow = (Row)groupIter.next();
                Long groupId = (Long)groupRow.get("GROUP_ID");
                Group group = new Group();
                group.setId(groupId);
                group.setOperation((Integer)groupRow.get("OPERATOR"));
                group.setPriorityId((Integer)groupRow.get("PRIORITY_ID"));
                ArrayList<Rule> ruleList = MonitorManager.getRuleList(groupId, ruleDO);
                group.setRulesList(ruleList);
                groupList.add(group);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupList;
    }

    public static ArrayList<Rule> getRuleList(Long groupId, DataObject dataObject) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        try {
            Criteria groupCriteria = new Criteria(Column.getColumn((String)"AUDRule", (String)"GROUP_ID"), (Object)groupId, 0);
            Iterator ruleIter = dataObject.getRows("AUDRule", groupCriteria);
            while (ruleIter.hasNext()) {
                Row ruleRow = (Row)ruleIter.next();
                Long ruleId = (Long)ruleRow.get("RULE_ID");
                Long variableId = (Long)ruleRow.get("VARIABLE_ID");
                RuleVariable variable = EventVariablesAPI.getInstance().getVariable(variableId);
                Rule rule = new Rule(ruleId, variable.getName(), (Integer)ruleRow.get("OPERATOR"), RB.getObject((String)ruleRow.get("VALUE")), Long.valueOf(variable.getDataType()).intValue(), variable.isMultiValued());
                ruleList.add(rule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ruleList;
    }

    public ArrayList<HashMap<String, Object>> getAlertProfiles(Long monitorId, DataObject alertProfileDO) {
        ArrayList<HashMap<String, Object>> alertProfileList = new ArrayList<HashMap<String, Object>>();
        try {
            Criteria monitorCriteria = new Criteria(Column.getColumn((String)ALERT_MONITORMAP_TABLE, (String)"MONITOR_ID"), (Object)monitorId, 0);
            Iterator iterator2 = alertProfileDO.getRows(ALERT_MONITORMAP_TABLE, monitorCriteria);
            while (iterator2.hasNext()) {
                Row row2 = (Row)iterator2.next();
                Long alertProfileId = (Long)row2.get("ALERT_PROFILE_ID");
                Criteria idCriteria2 = new Criteria(Column.getColumn((String)ALERT_PROFILE_TABLE, (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 0);
                Row alertProfileRow = alertProfileDO.getRow(ALERT_PROFILE_TABLE, idCriteria2 = idCriteria2.and(new Criteria(Column.getColumn((String)ALERT_PROFILE_TABLE, (String)"IS_ENABLED"), (Object)true, 0)));
                if (alertProfileRow == null) continue;
                HashMap<String, Object> alertProfileMap = new HashMap<String, Object>();
                List columnList = alertProfileRow.getColumns();
                for (String columnName : columnList) {
                    if (columnName.equalsIgnoreCase("ALERT_PROFILE_NAME") || columnName.equalsIgnoreCase("ALERT_PROFILE_DESCRIPTION")) {
                        alertProfileMap.put(columnName, RB.getString((String)alertProfileRow.get(columnName)));
                        continue;
                    }
                    alertProfileMap.put(columnName, alertProfileRow.get(columnName));
                }
                alertProfileList.add(alertProfileMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertProfileList;
    }

    public ConcurrentHashMap<String, HashMap<Long, HashMap<Long, Monitor>>> getMonitorMap() throws DataAccessException {
        if (monitorMap == null) {
            this.getMonitors(null);
        }
        return monitorMap;
    }

    public Monitor getMonitor(Long monitorId) throws DataAccessException, NullPointerException {
        Monitor monitor = null;
        if (monitorMap == null) {
            this.getMonitors(null);
        }
        block0: for (Map.Entry<String, HashMap<Long, HashMap<Long, Monitor>>> entry : monitorMap.entrySet()) {
            HashMap<Long, HashMap<Long, Monitor>> domainMap = entry.getValue();
            Set<Long> set = domainMap.keySet();
            for (Long categoryId : set) {
                HashMap<Long, Monitor> categoryMap = domainMap.get(categoryId);
                if (categoryMap.get(monitorId) == null) continue;
                monitor = categoryMap.get(monitorId);
                continue block0;
            }
        }
        return monitor;
    }

    public void updateMonitorMap(Long actionId) {
        try {
            if (monitorMap != null) {
                ArrayList<Long> monitorIdList = MonitorManager.getMonitorIdList(actionId);
                this.getMonitors(monitorIdList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Long> getMonitorIdList(Long actionId) {
        ArrayList<Long> monitorIdList = new ArrayList<Long>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AUDMonitorActions"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitorActions", (String)"ACTION_ID"), (Object)actionId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDMonitorActions", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (dataObject != null) {
                Iterator iterator = dataObject.getRows("AUDMonitorActions");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long monitorId = (Long)row.get("MONITOR_ID");
                    monitorIdList.add(monitorId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return monitorIdList;
    }

    public void updateAlertProfileInMonitorMap(Long[] alertProfileId) {
        try {
            if (monitorMap != null) {
                ArrayList<Long> monitorIdList = MonitorManager.getMonitorIds(alertProfileId);
                this.getMonitors(monitorIdList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList<Long> getMonitorIds(Long[] alertProfileId) {
        ArrayList<Long> monitorIdList = new ArrayList<Long>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)ALERT_MONITORMAP_TABLE));
            Criteria crit = new Criteria(Column.getColumn((String)ALERT_MONITORMAP_TABLE, (String)"ALERT_PROFILE_ID"), (Object)alertProfileId, 8);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)ALERT_MONITORMAP_TABLE, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (dataObject != null) {
                Iterator iterator = dataObject.getRows(ALERT_MONITORMAP_TABLE);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long monitorId = (Long)row.get("MONITOR_ID");
                    monitorIdList.add(monitorId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return monitorIdList;
    }

    public void updateMonitorMap(ArrayList<Long> monitorList, String action) {
        try {
            if (monitorMap != null) {
                if (action.equals("Enable")) {
                    this.getMonitors(monitorList);
                } else {
                    MonitorManager.deleteMonitorFromMonitorMap(monitorList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteMonitorFromMonitorMap(ArrayList<Long> monitorIdList) {
        try {
            for (Map.Entry<String, HashMap<Long, HashMap<Long, Monitor>>> entry : monitorMap.entrySet()) {
                HashMap<Long, HashMap<Long, Monitor>> domainMap = entry.getValue();
                Set<Long> set = domainMap.keySet();
                for (Long categoryId : set) {
                    HashMap<Long, Monitor> categoryMap = domainMap.get(categoryId);
                    for (int i = 0; i < monitorIdList.size(); ++i) {
                        Long monitorId = monitorIdList.get(i);
                        categoryMap.remove(monitorId);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSANDriveShare(String domainName, String serverName, String objectName, HashMap<String, String> serverShareMap, Boolean isCluster, Boolean isMountedDrive) {
        String uncPath = null;
        try {
            String sanDriveShare;
            String folderName;
            block32: {
                HashMap<String, HashMap<String, Object>> serverTable;
                HashMap<String, HashMap<String, HashMap<String, Object>>> domainTable = sanDriveTable.get(domainName);
                if (domainTable == null) {
                    Object object = domainLock;
                    synchronized (object) {
                        domainTable = sanDriveTable.get(domainName);
                        if (domainTable == null) {
                            domainTable = new HashMap();
                            sanDriveTable.put(domainName, domainTable);
                        }
                    }
                }
                if ((serverTable = domainTable.get(serverName)) == null) {
                    Object object = serverLock;
                    synchronized (object) {
                        serverTable = domainTable.get(serverName);
                        if (serverTable == null) {
                            serverTable = new HashMap();
                            domainTable.put(serverName, serverTable);
                        }
                    }
                }
                String[] temp = objectName.split("\\\\", 5);
                String sanDriveName = "\\" + temp[1] + "\\" + temp[2];
                int index = objectName.indexOf("\\", sanDriveName.length() + 1);
                folderName = null;
                folderName = index != -1 ? objectName.substring(sanDriveName.length() + 1, objectName.length()) : (sanDriveName.length() == objectName.length() || sanDriveName.length() + 1 == objectName.length() ? null : objectName.substring(sanDriveName.length() + 1, objectName.length()));
                HashMap<String, Object> sanDriveShareMap = serverTable.get(sanDriveName);
                if (sanDriveShareMap == null) {
                    Object object = sanDriveShareMapLock;
                    synchronized (object) {
                        sanDriveShareMap = serverTable.get(sanDriveName);
                        if (sanDriveShareMap == null) {
                            sanDriveShareMap = new HashMap();
                            HashSet s = new HashSet();
                            sanDriveShareMap.put("obj", s);
                            serverTable.put(sanDriveName, sanDriveShareMap);
                        }
                    }
                }
                sanDriveShare = (String)sanDriveShareMap.get("share");
                if (!isCluster.booleanValue() && sanDriveShare == null && folderName != null) {
                    int count = 0;
                    RLock.LockEntry lockEntry = null;
                    try {
                        lockEntry = RLOCK.lock(serverName);
                        Set s = (Set)sanDriveShareMap.get("obj");
                        boolean duplicateObjectName = false;
                        if (s.contains(objectName)) {
                            duplicateObjectName = true;
                        }
                        count = s.size();
                        sanDriveShare = (String)sanDriveShareMap.get("share");
                        if (sanDriveShare != null || folderName == null || serverShareMap == null || count > 49 || duplicateObjectName) break block32;
                        s.add(objectName);
                        sanDriveShareMap.put("obj", s);
                        for (Map.Entry<String, String> entry : serverShareMap.entrySet()) {
                            boolean isFileExists;
                            String filePath;
                            String shareLocalPath = entry.getKey();
                            if (isMountedDrive.booleanValue()) {
                                filePath = entry.getValue() + "\\" + folderName;
                                isFileExists = false;
                                try {
                                    EVENT_LOGGER.log(Level.INFO, "objectName: " + objectName);
                                    isFileExists = ADHandler.isFileExits(domainName, 1L, filePath);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                if (!isFileExists) continue;
                                sanDriveShare = entry.getValue();
                                break;
                            }
                            if (shareLocalPath.length() != 3) continue;
                            filePath = entry.getValue() + "\\" + folderName;
                            isFileExists = false;
                            try {
                                EVENT_LOGGER.log(Level.INFO, "objectName: " + objectName);
                                isFileExists = ADHandler.isFileExits(domainName, 1L, filePath);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (!isFileExists) continue;
                            sanDriveShare = entry.getValue();
                            break;
                        }
                        if (sanDriveShare != null) {
                            sanDriveShareMap.put("share", sanDriveShare);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        RLOCK.unLock(lockEntry);
                    }
                }
            }
            if (sanDriveShare != null) {
                uncPath = folderName != null ? sanDriveShare + "\\" + folderName : sanDriveShare;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return uncPath;
    }
}

