/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.sym.adsm.auditing.server.monitor.ActionConstants;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class Rule {
    private long id = 0L;
    private int operation = 0;
    private String ruleVariable = null;
    private Object conditionValue = null;
    private int dataType = 0;
    private boolean isMultiValued = false;
    private boolean ismultiValuedConditionValue = false;
    private ArrayList mainmultiplevaluelist = null;

    public Rule(Long id, String ruleVariable, int operation, Object conditionValue, int dataType, boolean isMultiValued) {
        this.id = id;
        this.ruleVariable = ruleVariable;
        this.operation = operation;
        this.isMultiValued = isMultiValued;
        this.ismultiValuedConditionValue = false;
        String conditionValueString = (String)conditionValue;
        if (conditionValueString.contains(";")) {
            this.mainmultiplevaluelist = new ArrayList();
            StringTokenizer st = new StringTokenizer(conditionValueString, ";");
            while (st.hasMoreTokens()) {
                this.mainmultiplevaluelist.add(st.nextToken());
            }
            this.ismultiValuedConditionValue = true;
        }
        this.conditionValue = conditionValue;
        this.dataType = dataType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Object getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public String getRuleVariable() {
        return this.ruleVariable;
    }

    public void setRuleVariable(String ruleVariable) {
        this.ruleVariable = ruleVariable;
    }

    public boolean evaluate(Hashtable<String, Object> eventTable) {
        Object value = eventTable.get(this.ruleVariable);
        boolean isSatisfied = false;
        if (value == null && this.dataType == 1001 && !this.isMultiValued) {
            value = "";
        }
        if (value != null) {
            if (this.ismultiValuedConditionValue) {
                if (this.dataType == 1001) {
                    isSatisfied = this.compareMultipleStringValues(value, this.mainmultiplevaluelist, this.operation);
                }
            } else if (!this.isMultiValued && !this.ismultiValuedConditionValue) {
                if (this.dataType == 1001) {
                    isSatisfied = this.compareStringValues(value, this.conditionValue, this.operation);
                } else if (this.dataType == 1002) {
                    isSatisfied = this.compareNumericValues(value, this.conditionValue, this.operation);
                } else if (this.dataType == 1003) {
                    isSatisfied = this.compareBooleanValues(value, this.conditionValue, this.operation);
                } else if (this.dataType == 1005 && !value.equals("(null)")) {
                    isSatisfied = this.compareHexaValues(value, this.conditionValue, this.operation);
                } else if (this.dataType == 0) {
                    isSatisfied = false;
                }
            } else {
                List valueList = (List)value;
                if (this.dataType == 1001) {
                    isSatisfied = this.compareMultipleStringValues(valueList, this.conditionValue, this.operation);
                } else if (this.dataType == 1005) {
                    isSatisfied = this.compareHexaValues(value, this.conditionValue, this.operation);
                }
            }
        }
        return isSatisfied;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Rule :");
        if (!this.ruleVariable.equals(null)) {
            builder.append(this.ruleVariable);
        }
        builder.append(" -> ");
        builder.append(ActionConstants.getStringOperation(this.operation));
        builder.append(" -> ");
        if (!this.conditionValue.equals(null)) {
            builder.append(this.conditionValue);
        }
        return builder.toString();
    }

    private boolean compareHexaValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            long valueLong;
            long conditionLong = Long.decode(conditionValue.toString());
            long l = valueLong = value == null || value.toString().equals("") ? 0L : Long.decode(value.toString());
            if (operation == 1) {
                flag = (valueLong & conditionLong) == conditionLong;
            } else if (operation == 2) {
                flag = (valueLong & conditionLong) != conditionLong;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean compareStringValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            flag = ReportUtil.compareStringValues(value, conditionValue, operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private boolean compareMultipleStringValues(Object value, List conditionValueList, int operation) {
        boolean flag = false;
        for (Object conditionValue : conditionValueList) {
            if (this.compareStringValues(value, conditionValue, operation)) {
                flag = true;
                if (operation != 1 && operation != 7 && operation != 8 && operation != 13 && operation != 11) continue;
                break;
            }
            flag = false;
            if (operation != 2 && operation != 9 && operation != 10 && operation != 14 && operation != 12) continue;
            break;
        }
        return flag;
    }

    private boolean compareMultipleStringValues(List valueList, Object conditionValue, int operation) {
        if (operation == 1) {
            return valueList.contains(conditionValue);
        }
        return !valueList.contains(conditionValue);
    }

    public boolean compareNumericValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            flag = ReportUtil.compareNumericValues(value, conditionValue, operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private boolean compareBooleanValues(Object value, Object conditionValue, int operation) {
        boolean flag = false;
        try {
            boolean conditionBoolean = Boolean.valueOf(conditionValue.toString());
            boolean valueBoolean = Boolean.valueOf(value.toString());
            if (operation == 1) {
                flag = valueBoolean == conditionBoolean;
            } else if (operation == 2) {
                flag = valueBoolean != conditionBoolean;
            } else if (operation == 0) {
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private Object getValue(Hashtable<String, Object> eventTable) {
        Object value = eventTable.get(this.ruleVariable);
        if (value == null) {
            Hashtable messageTable = (Hashtable)eventTable.get("Message");
            value = messageTable.get(this.ruleVariable);
        }
        return value;
    }

    public boolean containsCaseInsensitive(String strToCompare, ArrayList<String> list) {
        for (String str : list) {
            if (!str.equalsIgnoreCase(strToCompare)) continue;
            return true;
        }
        return false;
    }
}

