/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WellKnownSIDsHandler {
    private static Logger logger = Logger.getLogger(WellKnownSIDsHandler.class.getName());
    public static final String ADMINISTRATORS = "S-1-5-32-544";
    public static final String ADMINISTRATOR = "500";
    public static final String GUEST = "501";
    public static final String KRBTGT = "502";
    public static final String DOMAIN_ADMINS = "512";
    public static final String DOMAIN_USERS = "513";
    public static final String DOMAIN_GUESTS = "514";
    public static final String DOMAIN_COMPUTERS = "515";
    public static final String DOMAIN_CONTROLLERS = "516";
    public static final String CERT_PUBLISHERS = "517";
    public static final String GROUP_POLICY_CREATOR_OWNERS = "520";
    public static final String RAS_AND_IAS_SERVERS = "533";
    public static final String SCHEMA_ADMINS = "518";
    public static final String ENTERPRISE_ADMINS = "519";
    public static String[] attributes = new String[]{"canonicalName", "cn", "name", "distinguishedName", "objectSID", "objectGUID"};
    public static String[] attributeColumnNames = new String[]{"CANONICAL_NAME", "COMMON_NAME", "NAME", "DISTINGUISHED_NAME", "SID_STRING", "OBJECT_GUID"};

    public static int getWellKnownSIDsCount(String domainName) {
        int count = 0;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMWellKnownSIDDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMWellKnownSIDDetails", criteria);
            count = dataObject.size("ADSMWellKnownSIDDetails");
            logger.log(Level.FINE, "count of Well known SIDs for domain {0} is {1}:", new Object[]{domainName, count});
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static void addWellKnownSIDs(String domainName) throws Exception {
        if (WellKnownSIDsHandler.getWellKnownSIDsCount(domainName) <= 0) {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (String attribute : attributes) {
                attributeList.add(attribute);
            }
            ArrayList list = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("CONFIGURATION_NAMING_CONTEXT"), attributeList, "(objectClass=foreignSecurityPrincipal)");
            logger.log(Level.FINE, "List of WellKnown SIDs :" + list);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (Object object : list) {
                Properties properties = (Properties)object;
                Row row = new Row("ADSMWellKnownSIDDetails");
                row.set("DOMAIN_NAME", (Object)domainName);
                for (int i = 0; i < attributes.length; ++i) {
                    ArrayList arrayList = (ArrayList)properties.get(attributes[i]);
                    if (arrayList == null || arrayList.isEmpty()) continue;
                    row.set(attributeColumnNames[i], arrayList.get(0));
                }
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
    }
}

