/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AccountMgmtParser
implements EventParser {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable<String, Object> eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration<String> e = eventData.keys();
        block0: while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = reader.readLine();
                boolean nextLineRead = true;
                if (!nextLine.contains(":")) {
                    String valueString = nextLine.trim();
                    String nextLineString = nextLine.trim();
                    nextLineRead = false;
                    boolean isFirstRead = true;
                    while (!nextLineRead) {
                        if (isFirstRead) {
                            isFirstRead = false;
                        } else {
                            nextLineString = reader.readLine();
                        }
                        if (nextLineString == null) break;
                        if (nextLineString.contains(":")) {
                            nextLine = nextLineString;
                            nextLineRead = true;
                            break;
                        }
                        if (nextLineString.trim().equals("") || nextLineString.trim().equals("-")) continue;
                        if (!valueString.equalsIgnoreCase("")) {
                            valueString = valueString + ", ";
                        }
                        valueString = valueString + nextLineString;
                    }
                    if (!valueString.trim().equals("-") && !valueString.trim().equals("")) {
                        if (valueString.toLowerCase().contains("Account Name Changed".toLowerCase())) {
                            parsedEventData.put("FirstLine", (String)parsedEventData.get("FirstLine") + " - " + valueString);
                        } else {
                            EVENT_LOGGER.log(Level.INFO, "Parsed User Account Control Data : " + valueString);
                            parsedEventData.put("User Account Control", valueString);
                        }
                    }
                }
                while (true) {
                    String nextLineString;
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) continue block0;
                    if (!nextLine.contains(":")) continue;
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length < 2) continue;
                    if (!arr[0].trim().equalsIgnoreCase(RB.getString("adap.AUDRuleVariables.variable_name.User_Account_Control"))) {
                        parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                        continue;
                    }
                    String valueString = nextLine.substring(ind + 1).trim();
                    while (!nextLineRead && (nextLineString = reader.readLine()) != null) {
                        if (nextLineString.contains(":")) {
                            nextLine = nextLineString;
                            nextLineRead = true;
                            break;
                        }
                        if (nextLineString.trim().equals("")) continue;
                        valueString = valueString + ", ";
                        valueString = valueString + nextLineString;
                    }
                    parsedEventData.put(arr[0].trim(), valueString);
                }
            }
            parsedEventData.put(key, eventData.get(key));
        }
        EVENT_LOGGER.log(Level.FINE, "parsedEventData for : " + parsedEventData);
        return parsedEventData;
    }
}

