/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class AdfsEventParser
implements EventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final String TOP_CLASS_GUID = "bf967ab7-0de6-11d0-a285-00aa003049e2";

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable<String, Object> eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration<String> e = eventData.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = null;
                boolean nextLineRead = false;
                String issuedCliams = "";
                String callerIdentity = "";
                while (true) {
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) break;
                    if (!nextLine.contains(":")) continue;
                    nextLine = nextLine.trim();
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length > 2) {
                        int int2;
                        String parsedKey = (Integer)eventData.get("EventCode") == 299 || (Integer)eventData.get("EventCode") == 324 ? arr[0] : this.getkey(arr[1]);
                        int len = arr.length;
                        Object apdKey = null;
                        if (parsedKey.equals("x-ms-client-ip") || parsedKey.equalsIgnoreCase("UPN") || parsedKey.equals("insidecorporatenetwork") || parsedKey.equals("Relying Party")) {
                            if (parsedKey.equals("x-ms-client-ip")) {
                                parsedEventData.put("IP Address", arr[len - 1].trim());
                                continue;
                            }
                            if (parsedKey.equals("insidecorporatenetwork")) {
                                parsedEventData.put("Inside Corporate Network", arr[len - 1].trim());
                                continue;
                            }
                            if (parsedKey.equals("Relying Party")) {
                                String subnextLine = nextLine.substring(ind + 1).trim();
                                parsedEventData.put("Relying Party", subnextLine.trim());
                                continue;
                            }
                            parsedEventData.put("Subject Account Name", arr[len - 1].trim());
                            continue;
                        }
                        if ((Integer)eventData.get("EventCode") == 500) {
                            String subnextLine = nextLine.substring(ind + 1).trim();
                            int2 = subnextLine.indexOf(":");
                            issuedCliams = issuedCliams + parsedKey + "=" + subnextLine.substring(int2 + 1).trim() + "$";
                        }
                        if ((Integer)eventData.get("EventCode") != 501) continue;
                        String subnextLine = nextLine.substring(ind + 1).trim();
                        int2 = subnextLine.indexOf(":");
                        callerIdentity = callerIdentity + parsedKey + "=" + subnextLine.substring(int2 + 1).trim() + "$";
                        continue;
                    }
                    if (arr[0].equals("-")) continue;
                    if (arr[0].equals("Relying Party") && !arr[1].equals("-")) {
                        String[] pairs;
                        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
                        for (String pair : pairs = arr[1].split("&")) {
                            int idx = pair.indexOf("=");
                            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
                        }
                        if (query_pairs.get("wtrealm") == null) continue;
                        parsedEventData.put(arr[0].trim(), query_pairs.get("wtrealm"));
                        continue;
                    }
                    parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                }
                if ((Integer)eventData.get("EventCode") == 500) {
                    parsedEventData.put("Issued Claims", issuedCliams);
                }
                if ((Integer)eventData.get("EventCode") != 501) continue;
                parsedEventData.put("Caller Identity", callerIdentity);
                continue;
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }

    private String getkey(String str) {
        String[] words = str.split("/");
        int len = words.length;
        return words[len - 1];
    }
}

