/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.DefaultEventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DSA2k8EventParser
extends DefaultEventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final String[] SCHEMA_GUIDS = new String[]{"bf967a8f-0de6-11d0-a285-00aa003049e2", "bf967a83-0de6-11d0-a285-00aa003049e2", "bf967a80-0de6-11d0-a285-00aa003049e2", "5a8b3261-c38d-11d1-bbc9-0080c76670c0", "52ab8671-5709-11d1-a9c6-0000f80367c1", "bf967a86-0de6-11d0-a285-00aa003049e2"};

    public DSA2k8EventParser() {
        SchemaAPI.getInstance();
    }

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration e = eventData.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = null;
                boolean nextLineRead = false;
                block1: while (true) {
                    String property;
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) continue block0;
                    if (!nextLine.contains(":")) continue;
                    nextLine = nextLine.trim();
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length == 1) {
                        property = arr[0].trim();
                        if (!property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Subject"))) continue;
                        int toReadLines = 4;
                        int i = 0;
                        while (true) {
                            if (i >= toReadLines) continue block1;
                            String nextLineString = reader.readLine();
                            String[] arrStrings = nextLineString.split(":");
                            int index = nextLineString.indexOf(":");
                            if (arrStrings.length > 1) {
                                parsedEventData.put(property + " " + arrStrings[0].trim(), nextLineString.substring(index + 1).trim());
                            }
                            ++i;
                        }
                    }
                    if (arr.length < 2) continue;
                    property = arr[0].trim();
                    if (property.equalsIgnoreCase(RB.getString("adap.DSA2k8EventParser.Parameter_1"))) {
                        parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info"), nextLine.substring(ind + 1).trim());
                        continue;
                    }
                    if (property.equalsIgnoreCase(RB.getString("adap.DSA2k8EventParser.Parameter_2"))) {
                        parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.Additional_Info2"), nextLine.substring(ind + 1).trim());
                        continue;
                    }
                    if (property.equalsIgnoreCase(RB.getString("adap.DSAEventParser.properties"))) {
                        String propValue = nextLine.substring(ind + 1).trim();
                        String[] arr$ = SCHEMA_GUIDS;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block1;
                            String string = arr$[i$];
                            if (propValue.contains(string)) {
                                parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.ObjectClass"), string);
                                SchemaClass schemaClass = SchemaAPI.getInstance().getSchemaClass(string);
                                parsedEventData.put("ObjectClassString", schemaClass.getCommonDisplayName());
                                ArrayList<String> attributeList = schemaClass.getAttributeList();
                                ArrayList<String> attributeGuidList = new ArrayList<String>();
                                ArrayList<String> attributeStringList = new ArrayList<String>();
                                this.setAttributeList(attributeList, attributeGuidList, attributeStringList, propValue);
                                if (attributeGuidList.isEmpty()) continue block1;
                                parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"), attributeGuidList);
                                parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.AttributesString"), attributeStringList);
                                continue block1;
                            }
                            ++i$;
                        }
                    }
                    parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                }
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }
}

