/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.Attribute;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;

public final class DSAEventParser
implements EventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");

    public DSAEventParser() {
        SchemaAPI.getInstance();
    }

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable<String, Object> eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration<String> e = eventData.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.matches("Message")) {
                String nextLine;
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                while ((nextLine = reader.readLine()) != null) {
                    if (!nextLine.contains(":")) continue;
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length <= 0) continue;
                    if (!arr[0].trim().equalsIgnoreCase(RB.getString("adap.DSAEventParser.properties"))) {
                        parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                        continue;
                    }
                    reader.readLine();
                    String line2 = reader.readLine();
                    String line3 = reader.readLine();
                    Set<String> set = SchemaAPI.getInstance().getSchemas();
                    HashSet<String> keySet = new HashSet<String>(set);
                    for (String string : keySet) {
                        if (line2.contains(string)) {
                            parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.ObjectClass"), string);
                            SchemaClass schemaClass = SchemaAPI.getInstance().getSchemaClass(string);
                            parsedEventData.put("ObjectClassString", schemaClass.getCommonDisplayName());
                            ArrayList<String> attributeList = schemaClass.getAttributeList();
                            ArrayList<String> attributeGuidList = new ArrayList<String>();
                            ArrayList<String> attributeStringList = new ArrayList<String>();
                            for (String string2 : attributeList) {
                                if (!line2.contains(string2)) continue;
                                attributeGuidList.add(string2);
                                Attribute attribute = SchemaAPI.getInstance().getAttribute(string2);
                                attributeStringList.add(attribute.getCommonName());
                            }
                            if (attributeGuidList.isEmpty()) break;
                            parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"), attributeGuidList);
                            parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.AttributesString"), attributeStringList);
                            break;
                        }
                        if (!line3.contains(RB.getString("adap.AUDRuleVariables.variable_name.versionNumber"))) continue;
                        parsedEventData.put(RB.getString("adap.AUDRuleVariables.variable_name.Attributes"), line3.trim());
                        break;
                    }
                    keySet = null;
                }
                continue;
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }
}

