/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DSChangeParser
implements EventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable<String, Object> eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration<String> e = eventData.keys();
        int objectLines = 3;
        Integer eventCode = (Integer)eventData.get("EventCode");
        if (eventCode == 5139) {
            objectLines = 4;
        }
        int operationLines = 2;
        if (eventCode == 5136) {
            operationLines = 3;
        }
        block0: while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = null;
                boolean nextLineRead = false;
                block1: while (true) {
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) continue block0;
                    if (!nextLine.contains(":")) continue;
                    nextLine = nextLine.trim();
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length == 1) {
                        String property = arr[0].trim();
                        if (!property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Subject")) && !property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Object")) && !property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Directory_Service")) && !property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Operation")) && !property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Attribute"))) continue;
                        int toReadLines = 0;
                        if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Subject"))) {
                            toReadLines = 4;
                        } else if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Directory_Service")) || property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Attribute"))) {
                            toReadLines = 3;
                        } else if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Object"))) {
                            toReadLines = objectLines;
                        } else if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Operation"))) {
                            toReadLines = operationLines;
                        }
                        int i = 0;
                        while (true) {
                            if (i >= toReadLines) continue block1;
                            String nextLineString = reader.readLine();
                            String[] arrStrings = nextLineString.split(":");
                            int index = nextLineString.indexOf(":");
                            if (arrStrings.length > 1) {
                                parsedEventData.put(property + " " + arrStrings[0].trim(), nextLineString.substring(index + 1).trim());
                                if (arrStrings[0].trim().equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Value"))) {
                                    DSChangeParser.getAttributeValue(msg, parsedEventData);
                                }
                            }
                            ++i;
                        }
                    }
                    if (arr.length < 2) continue;
                    parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                }
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }

    public static void getAttributeValue(String msg, Hashtable<String, Object> parsedEventData) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(msg));
        String nextLine = null;
        String property = null;
        String propertyKey = null;
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.contains(":")) {
                String[] arr = (nextLine = nextLine.trim()).split(":");
                if (arr.length != 1) continue;
                property = arr[0].trim();
                if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Attribute"))) {
                    for (int i = 0; i < 3; ++i) {
                        String nextLineString = reader.readLine();
                        String[] arrStrings = nextLineString.split(":");
                        int index = nextLineString.indexOf(":");
                        if (!arrStrings[0].trim().equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Value"))) continue;
                        propertyKey = property + " " + arrStrings[0].trim();
                        parsedEventData.put(property, nextLineString.substring(index + 1).trim());
                    }
                }
                if (!property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Operation"))) continue;
                break;
            }
            if (propertyKey == null) continue;
            String val = (String)parsedEventData.get(propertyKey);
            val = val + " " + nextLine.trim();
            parsedEventData.put(propertyKey, val);
        }
        if (parsedEventData.get(propertyKey) != null) {
            String propVal = (String)parsedEventData.get(propertyKey);
            propVal = propVal.trim();
            parsedEventData.put(propertyKey, propVal);
        }
    }
}

