/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.Attribute;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultEventParser
implements EventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final String TOP_CLASS_GUID = "bf967ab7-0de6-11d0-a285-00aa003049e2";

    public Hashtable parseEvent(Integer eventNumber, Hashtable eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration e = eventData.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = null;
                boolean nextLineRead = false;
                while (true) {
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) continue block0;
                    if (!nextLine.contains(":")) continue;
                    nextLine = nextLine.trim();
                    int ind = nextLine.indexOf(":");
                    String[] arr = nextLine.split(":");
                    if (arr.length == 1) {
                        String nextLineString;
                        String property = arr[0].trim();
                        if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Subject")) || property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Member")) || property.equalsIgnoreCase(RB.getString("adap.DefaultEventParser.User"))) {
                            this.setParsedEventData(reader, property, parsedEventData);
                            continue;
                        }
                        if (property.equalsIgnoreCase(RB.getString("adap.DefaultEventParser.New_Policy"))) {
                            parsedEventData.put(RB.getString("adap.DefaultEventParser.New_Policy"), this.setNewPolicy(reader, property));
                            continue;
                        }
                        if (!property.equalsIgnoreCase(RB.getString("adap.AUDRuleVariables.variable_name.User_Account_Control"))) continue;
                        String valueString = "";
                        while (!nextLineRead && (nextLineString = reader.readLine()) != null) {
                            if (nextLineString.contains(":")) {
                                nextLine = nextLineString;
                                nextLineRead = true;
                                break;
                            }
                            if (nextLineString.trim().equals("")) continue;
                            if (!valueString.equalsIgnoreCase("")) {
                                valueString = valueString + ", ";
                            }
                            valueString = valueString + nextLineString.trim();
                        }
                        parsedEventData.put(arr[0].trim(), valueString);
                        continue;
                    }
                    if (arr.length < 2) continue;
                    if (arr[0].trim().equalsIgnoreCase(RB.getString("adap.DefaultEventParser.Task_Content")) || arr[0].trim().equalsIgnoreCase(RB.getString("adap.DefaultEventParser.Task_New_Content"))) {
                        String valueString = arr[1].trim();
                        while ((nextLine = reader.readLine()) != null) {
                            valueString = valueString + "\n" + nextLine.trim();
                        }
                        parsedEventData.put(arr[0].trim(), valueString);
                        continue;
                    }
                    parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                }
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }

    private void setParsedEventData(BufferedReader reader, String property, Hashtable<String, Object> parsedEventData) throws IOException {
        int toReadLines = 0;
        if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Subject")) || property.equalsIgnoreCase(RB.getString("adap.DefaultEventParser.User"))) {
            toReadLines = 4;
        } else if (property.equalsIgnoreCase(RB.getString("adap.AccountMgmt2k8Parser.Member"))) {
            toReadLines = 2;
        }
        for (int i = 0; i < toReadLines; ++i) {
            String nextLineString = reader.readLine();
            String[] arrStrings = nextLineString.split(":");
            int index = nextLineString.indexOf(":");
            if (arrStrings.length <= 1) continue;
            parsedEventData.put(property + " " + arrStrings[0].trim(), nextLineString.substring(index + 1).trim());
        }
    }

    private String setNewPolicy(BufferedReader reader, String property) throws IOException {
        int toReadLines = 22;
        String valueString = "";
        for (int i = 0; i < toReadLines; ++i) {
            String nextLine = reader.readLine().trim();
            if (nextLine.equals("")) continue;
            if (valueString != "") {
                valueString = valueString + ", ";
            }
            valueString = valueString + nextLine.replaceAll("\t", "");
        }
        return valueString;
    }

    protected void setAttributeList(ArrayList<String> attributeList, ArrayList<String> attributeGuidList, ArrayList<String> attributeStringList, String propValue) {
        this.setAttributes(attributeList, attributeGuidList, attributeStringList, propValue);
        this.setAttributes(SchemaAPI.getInstance().getSchemaClass(TOP_CLASS_GUID).getAttributeList(), attributeGuidList, attributeStringList, propValue);
    }

    private void setAttributes(ArrayList<String> attributeList, ArrayList<String> attributeGuidList, ArrayList<String> attributeStringList, String propValue) {
        for (String string2 : attributeList) {
            if (!propValue.contains(string2)) continue;
            attributeGuidList.add(string2);
            Attribute attribute = SchemaAPI.getInstance().getAttribute(string2);
            attributeStringList.add(attribute.getCommonName());
        }
    }
}

