/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.parsing;

import com.adventnet.sym.adsm.auditing.server.parsing.EventParser;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;

public final class OAEventParser
implements EventParser {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    @Override
    public Hashtable<String, Object> parseEvent(Integer eventNumber, Hashtable<String, Object> eventData) throws IOException {
        Hashtable<String, Object> parsedEventData = new Hashtable<String, Object>();
        Enumeration<String> e = eventData.keys();
        block0: while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.matches("Message")) {
                String msg = (String)eventData.get(key);
                BufferedReader reader = new BufferedReader(new StringReader(msg));
                String firstLine = reader.readLine();
                parsedEventData.put("FirstLine", firstLine.replace(':', ' '));
                String nextLine = null;
                boolean nextLineRead = false;
                while (true) {
                    String nextLineString;
                    if (nextLineRead) {
                        nextLineRead = false;
                    } else {
                        nextLine = reader.readLine();
                    }
                    if (nextLine == null) continue block0;
                    if (nextLine.contains(":")) {
                        int ind = nextLine.indexOf(":");
                        String[] arr = nextLine.split(":");
                        if (arr.length < 2) continue;
                        if (arr[0].trim().equalsIgnoreCase(RB.getString("New Handle ID"))) {
                            parsedEventData.put("Handle ID", nextLine.substring(ind + 1).trim());
                            continue;
                        }
                        if (!arr[0].trim().equalsIgnoreCase(RB.getString("adap.AUDRuleVariables.variable_name.Accesses")) && !arr[0].trim().equalsIgnoreCase(RB.getString("adap.AUDRuleVariables.variable_name.Access_Reasons"))) {
                            parsedEventData.put(arr[0].trim(), nextLine.substring(ind + 1).trim());
                            continue;
                        }
                        String valueString = nextLine.substring(ind + 1).trim();
                        while (!nextLineRead && (nextLineString = reader.readLine()) != null) {
                            if (nextLineString.contains(":")) {
                                nextLine = nextLineString;
                                nextLineRead = true;
                                break;
                            }
                            if (nextLine.contains(RB.getString("adap.AUDRuleVariables.variable_name.Access_Reasons"))) {
                                valueString = valueString + " " + nextLineString.trim();
                                continue;
                            }
                            if (nextLineString.trim().equals("")) continue;
                            valueString = valueString + ", ";
                            valueString = valueString + nextLineString.replaceAll("\t", "");
                        }
                        parsedEventData.put(arr[0].trim(), valueString);
                        continue;
                    }
                    if (!nextLine.contains("Accesses")) continue;
                    String valueString = nextLine;
                    Long accessMask = 0L;
                    String privilegeString = "";
                    while (!nextLineRead && (nextLineString = reader.readLine()) != null) {
                        int index;
                        if (nextLineString.contains("Privileges")) {
                            nextLine = nextLineString;
                            index = nextLine.indexOf("Privileges");
                            privilegeString = nextLine.substring(index + "Privileges".length());
                            privilegeString = privilegeString.replaceAll("\t", "");
                            nextLineRead = true;
                            break;
                        }
                        if (!nextLineString.trim().equals("")) {
                            if (valueString.contains("Accesses")) {
                                index = valueString.indexOf("Accesses");
                                valueString = valueString.substring(index + "Accesses".length());
                                valueString = valueString.replaceAll("\t", "");
                                accessMask = accessMask | this.getAccessMask(valueString) | this.getAccessMask(nextLineString);
                            } else {
                                accessMask = accessMask | this.getAccessMask(nextLineString);
                            }
                            valueString = valueString + ", ";
                            valueString = valueString + nextLineString.replaceAll("\t", "");
                            continue;
                        }
                        if (!nextLineString.trim().equals("") || accessMask != 0L) continue;
                        index = valueString.indexOf("Accesses");
                        valueString = valueString.substring(index + "Accesses".length());
                        valueString = valueString.replaceAll("\t", "");
                        accessMask = accessMask | this.getAccessMask(valueString);
                    }
                    parsedEventData.put("Accesses", valueString);
                    parsedEventData.put("Access Mask", accessMask);
                    parsedEventData.put("Privileges", privilegeString);
                }
            }
            parsedEventData.put(key, eventData.get(key));
        }
        return parsedEventData;
    }

    private Long getAccessMask(String accesses) {
        Long accessMask = 0L;
        if (accesses.contains("ReadData")) {
            accessMask = 1L;
        } else if (accesses.contains("READ_CONTROL")) {
            accessMask = 131072L;
        } else if (accesses.contains("ReadAttributes")) {
            accessMask = 128L;
        } else if (accesses.contains("ReadEA")) {
            accessMask = 8L;
        } else if (accesses.contains("WriteData")) {
            accessMask = 2L;
        } else if (accesses.contains("AppendData")) {
            accessMask = 4L;
        } else if (accesses.contains("WriteAttributes")) {
            accessMask = 256L;
        } else if (accesses.contains("WriteEA")) {
            accessMask = 16L;
        } else if (accesses.contains("SYNCHRONIZE")) {
            accessMask = 0x100000L;
        } else if (accesses.contains("WRITE_DAC")) {
            accessMask = 262144L;
        } else if (accesses.contains("WRITE_OWNER")) {
            accessMask = 524288L;
        } else if (accesses.contains("ACCESS_SYSTEM_SECURITY")) {
            accessMask = 0x1000000L;
        } else if (accesses.contains("DELETE")) {
            accessMask = 65536L;
        }
        return accessMask;
    }
}

