/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.persistence;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.xml.DynamicValueHandler;
import com.adventnet.persistence.xml.DynamicValueHandlingException;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AUDDynamicValueHandler
implements DynamicValueHandler {
    private static Pattern uvhValuePattern = Pattern.compile("(\\$\\{UVHQUERY:)([^\\}]*)(\\})");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValue(String query) {
        String value = "-1";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Finding UVH For GPO Reports", statement, query);
            while (resultSet.next()) {
                if (value.equalsIgnoreCase("-1")) {
                    value = resultSet.getObject(1).toString();
                    continue;
                }
                value = value + ", ";
                value = value + resultSet.getObject(1).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            value = "-1";
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public Object getColumnValue(String tableName, String columnName, Properties configuredDHVP, String xmlAttribute) throws DynamicValueHandlingException {
        try {
            String value = xmlAttribute;
            if (columnName.equalsIgnoreCase("SUBREPORT_CV_ID")) {
                return AUDDynamicValueHandler.getUVHValues(xmlAttribute);
            }
            Matcher matcher = uvhValuePattern.matcher(value);
            while (matcher.find()) {
                value = this.getValue(matcher.group(2));
                if (value.equalsIgnoreCase("-1")) {
                    value = matcher.replaceAll(matcher.group(2));
                    continue;
                }
                value = matcher.replaceAll(value);
            }
            return value;
        }
        catch (Exception metaExp) {
            DynamicValueHandlingException dyExp = new DynamicValueHandlingException(metaExp.getMessage());
            dyExp.initCause((Throwable)metaExp);
            throw dyExp;
        }
    }

    public static Long getUVHValues(String uvhString) {
        Long uvh = 0L;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"UVHValues", (String)"PATTERN"), (Object)uvhString, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("UVHValues", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("UVHValues");
                uvh = (Long)row.get("GENVALUES");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uvh;
    }

    public String getAttributeValue(String tableName, String columnName, Properties configuredDHVP, Object columnValue) throws DynamicValueHandlingException {
        return null;
    }

    public void set(Object obj) {
    }

    public DataObject get() {
        return null;
    }
}

