/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.printAudit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileListener;
import com.adventnet.sym.adsm.auditing.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

public class PrinterAuditingListener {
    private static final Logger EVENT_LOGGER = Logger.getLogger("EventLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static PrinterAuditingListener printerAuditingListener = null;
    private static final String[] COLUMN_NAMES = new String[]{"COPIES", "PRINTER_NAME", "DOC_SIZE", "PAGES", "JOB_ID", "FILE_NAME", "USERNAME", "TIME_GENERATED", "MACHINE_NAME", "SERVERNAME", "DOMAIN_NAME"};
    private static final String[] HASH_COLUMNS = new String[]{"copiesGenerated", "PrinterName", "docSize", "Pages", "JobId", "DocumentName", "UserName", "SubmittedTime", "userMachineName", "DcName", "DomainName"};
    private static final String[] COLUMN_TYPES = new String[]{"Integer", "String", "Long", "Long", "Integer", "String", "String", "Long", "String", "String", "String"};
    public static ConcurrentLinkedQueue printerQueue = null;
    public static HashMap<String, Queue> printerDataQueueMap = null;
    public static HashMap<String, HashMap> printerDataMap = null;
    public static HashMap<String, Integer> tableRowCountMap = new HashMap();
    public static Action action = null;

    private PrinterAuditingListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrinterAuditingListener getInstance() {
        if (printerAuditingListener != null) return printerAuditingListener;
        Class<PrinterAuditingListener> clazz = PrinterAuditingListener.class;
        synchronized (PrinterAuditingListener.class) {
            printerAuditingListener = new PrinterAuditingListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return printerAuditingListener;
        }
    }

    public boolean interruptThread(String threadName, HashMap rowDataMap) {
        boolean threadExisting = false;
        try {
            if (printerDataQueueMap != null) {
                Queue printerDataQueue = new LinkedList<HashMap>();
                if (printerDataQueueMap.get(threadName) != null) {
                    printerDataQueue = printerDataQueueMap.get(threadName);
                    threadExisting = true;
                }
                printerDataQueue.add(rowDataMap);
                printerDataQueueMap.put(threadName, printerDataQueue);
                this.printerEventData(threadName);
            }
        }
        catch (Exception ex) {
            threadExisting = false;
            ex.printStackTrace();
        }
        return threadExisting;
    }

    public void updatePrintQueueDetails(HashMap rowDataMap) {
        try {
            String printServerThreadName = (String)rowDataMap.get("JobId") + (String)rowDataMap.get("PrinterName") + (String)rowDataMap.get("DcName");
            if (!this.interruptThread(printServerThreadName, rowDataMap)) {
                LinkedList<HashMap> printerDataQueue = new LinkedList<HashMap>();
                printerDataQueue.add(rowDataMap);
                if (printerDataQueueMap == null) {
                    printerDataQueueMap = new HashMap();
                }
                printerDataQueueMap.put(printServerThreadName, printerDataQueue);
                this.printerEventData(printServerThreadName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void insertPendingJobs(HashMap rowDataMap) {
        try {
            String tableName = "AudPrintJobsInQueue";
            DataObject dataObject = null;
            if (this.checkForJobId(Integer.parseInt((String)rowDataMap.get("JobId")), tableName)) {
                this.insertFinishedJobs(rowDataMap, tableName);
            } else {
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"JOB_ID"), (Object)((String)rowDataMap.get("JobId")), 0);
                dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
                if (!dataObject.isEmpty()) {
                    Row tableRow1 = dataObject.getFirstRow(tableName);
                    this.insertRows(tableRow1, rowDataMap);
                    dataObject.updateRow(tableRow1);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void insertFinishedJobs(HashMap rowDataMap, String tableName) {
        try {
            if (this.checkForJobId(Integer.parseInt((String)rowDataMap.get("JobId")), tableName)) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row tableRow1 = new Row(tableName);
                this.insertRows(tableRow1, rowDataMap);
                dataObject.addRow(tableRow1);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void insertRows(Row tableRow1, HashMap rowDataMap) {
        try {
            for (int i = 0; i < COLUMN_NAMES.length; ++i) {
                Object value;
                if (rowDataMap.get(HASH_COLUMNS[i]) == null) continue;
                if (COLUMN_TYPES[i].equalsIgnoreCase("String")) {
                    value = (String)rowDataMap.get(HASH_COLUMNS[i]);
                    tableRow1.set(COLUMN_NAMES[i], (Object)((String)value).replace("\\\\", ""));
                    continue;
                }
                if (COLUMN_TYPES[i].equalsIgnoreCase("Integer")) {
                    tableRow1.set(COLUMN_NAMES[i], (Object)Integer.parseInt((String)rowDataMap.get(HASH_COLUMNS[i])));
                    continue;
                }
                value = 0L;
                value = COLUMN_NAMES[i].equalsIgnoreCase("DOC_SIZE") ? Long.valueOf(Long.valueOf((String)rowDataMap.get(HASH_COLUMNS[i])) / 1024L) : Long.valueOf((String)rowDataMap.get(HASH_COLUMNS[i]));
                tableRow1.set(COLUMN_NAMES[i], value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean checkForJobId(int jobId, String tableName) {
        boolean canEnterValue = true;
        try {
            Criteria deletePendingjobCrit = new Criteria(Column.getColumn((String)tableName, (String)"JOB_ID"), (Object)jobId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, deletePendingjobCrit);
            if (!dataObject.isEmpty()) {
                canEnterValue = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return canEnterValue;
    }

    public void deleteJobIdFromTable(int jobId, String tableName, String printerName, String machineName) {
        try {
            Criteria deleteJobIdCrit1 = new Criteria(Column.getColumn((String)tableName, (String)"JOB_ID"), (Object)jobId, 0);
            Criteria deleteJobIdCrit2 = new Criteria(Column.getColumn((String)tableName, (String)"PRINTER_NAME"), (Object)printerName.replace("\\\\", ""), 0);
            Criteria deleteJobIdCrit3 = deleteJobIdCrit1.and(deleteJobIdCrit2).and(new Criteria(Column.getColumn((String)tableName, (String)"SERVERNAME"), (Object)machineName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, deleteJobIdCrit3);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("JOB_ID", (Object)0);
                dataObject.updateRow(row);
                PrintAlertProfileListener.getInstance().addInQueue(row);
            }
            Integer size = tableRowCountMap.get("AUDPrintJobsInQueue");
            if (size == null) {
                size = MoveRecreateTableHandler.getInstance().getRowCount("AudPrintJobsInQueue");
            }
            if (size > 500000) {
                MoveRecreateTableHandler.getInstance().moveRecreateTable("AudPrintJobsInQueue");
                size = -1;
            }
            size = size + 1;
            tableRowCountMap.put("AUDPrintJobsInQueue", size);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteAllJobIds() {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudPrintJobsInQueue", (Row)null);
            Iterator iterator = dataObject.getRows("AudPrintJobsInQueue");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("JOB_ID", (Object)0);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addInQueue1(Object object) {
        try {
            HashMap queueMap = new HashMap();
            Hashtable hashtable = (Hashtable)object;
            Set hashtableSet = hashtable.keySet();
            Iterator iter = hashtableSet.iterator();
            while (iter.hasNext()) {
                String keyName = iter.next().toString();
                queueMap.put(keyName, hashtable.get(keyName));
            }
            if (printerQueue == null) {
                printerQueue = new ConcurrentLinkedQueue();
            }
            if (printerQueue != null && !queueMap.isEmpty() && !printerQueue.contains(queueMap)) {
                printerQueue.add(queueMap);
                this.startAction();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void formDataMap(HashMap rowDataMap, int jobId, HashMap printerDataMap1) {
        try {
            for (int i = 0; i < HASH_COLUMNS.length; ++i) {
                if (rowDataMap.get(HASH_COLUMNS[i]) == null) continue;
                printerDataMap1.put(HASH_COLUMNS[i], rowDataMap.get(HASH_COLUMNS[i]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startAction() {
        try {
            if (action == null) {
                action = new Action();
                action.start();
            } else {
                action.notifyThread();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void process(HashMap queueMap) {
        try {
            this.updatePrintQueueDetails(queueMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printerEventData(String threadName) {
        try {
            int docSizePrinted = 0;
            String DcName = "";
            String printerName = "";
            int jobId = 0;
            Queue dataQueue = printerDataQueueMap.remove(threadName);
            for (int i = 0; i < dataQueue.size(); ++i) {
                HashMap queueMap = (HashMap)dataQueue.remove();
                if (printerDataMap == null) {
                    printerDataMap = new HashMap();
                }
                HashMap dataMap = new HashMap();
                if (printerDataMap.get(threadName) != null) {
                    dataMap = printerDataMap.get(threadName);
                }
                this.formDataMap(queueMap, 0, dataMap);
                docSizePrinted = dataMap.get("docSize") != null ? Integer.parseInt((String)dataMap.get("docSize")) : 0;
                DcName = (String)dataMap.get("DcName");
                jobId = Integer.parseInt((String)dataMap.get("JobId"));
                printerDataMap.put(threadName, dataMap);
                printerName = (String)dataMap.get("PrinterName");
            }
            this.insertPendingJobs(printerDataMap.get(threadName));
            printerDataMap.remove(threadName);
            if (!PrinterAuditingListener.checkThreadRuning(threadName)) {
                new jobIdReset(DcName, printerName, jobId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean checkThreadRuning(String threadName) {
        boolean threadRunning = false;
        try {
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                if (!t.getName().equalsIgnoreCase(threadName)) continue;
                threadRunning = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return threadRunning;
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                block2: while (!this.shutDown) {
                    if (printerQueue.size() > 0) {
                        block3: while (true) {
                            if (printerQueue.size() <= 0) continue block2;
                            int i = 0;
                            while (true) {
                                if (i >= printerQueue.size()) continue block3;
                                this.waitForUpdate(3000L);
                                HashMap queueMap = (HashMap)printerQueue.remove();
                                PrinterAuditingListener.this.process(queueMap);
                                ++i;
                            }
                            break;
                        }
                    }
                    this.waitForUpdate(30000L);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void notifyThread() {
            try {
                super.notify();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class jobIdReset
    implements Runnable {
        private boolean shutDown = false;
        Thread t;
        public String printerName;
        public String machineName;
        public int jobId;

        public jobIdReset(String machineName, String printerName, int jobId) {
            this.printerName = printerName;
            this.machineName = machineName;
            this.jobId = jobId;
            this.t = new Thread((Runnable)this, jobId + printerName + machineName);
            this.t.start();
        }

        @Override
        public void run() {
            try {
                this.waitForUpdate(80000L);
                PrinterAuditingListener.this.deleteJobIdFromTable(this.jobId, "AudPrintJobsInQueue", this.printerName, this.machineName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

