/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JROriginExporterFilter;
import net.sf.jasperreports.engine.util.JRLoader;

public class ADAPCsvExporter
extends JRCsvExporter {
    private static final String CSV_ORIGIN_EXPORTER_FILTER_PREFIX = "net.sf.jasperreports.export.csv.exclude.origin.";

    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (is != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject((InputStream)is);
                } else {
                    URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (url != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject((URL)url);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject((File)file);
                        } else {
                            String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (fileName != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject((String)fileName);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            File sf = new File((String)this.jasperPrintList.get(0));
            this.jasperPrint = (JasperPrint)JRLoader.loadObject((File)sf);
        }
        if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
            this.filter = JROriginExporterFilter.getFilter((JRPropertiesMap)this.jasperPrint.getPropertiesMap(), (String)CSV_ORIGIN_EXPORTER_FILTER_PREFIX);
        }
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        this.nature = new JRCsvExporterNature(this.filter);
        String encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
        this.delimiter = this.getStringParameterOrDefault((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, "net.sf.jasperreports.export.csv.field.delimiter");
        this.recordDelimiter = this.getStringParameterOrDefault((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, "net.sf.jasperreports.export.csv.record.delimiter");
        StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), (Throwable)e);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int reportIndex = 0; reportIndex < this.jasperPrintList.size(); ++reportIndex) {
            File sf = new File((String)this.jasperPrintList.get(reportIndex));
            this.jasperPrint = (JasperPrint)JRLoader.loadObject((File)sf);
            List pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = pages.size() - 1;
            }
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }
}

