/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AUDCustomViewAPI {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static AUDCustomViewAPI customViewAPI = null;
    private HashMap cvIdMap = null;

    private AUDCustomViewAPI() {
        try {
            if (this.cvIdMap == null) {
                this.getReportCVIds();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AUDCustomViewAPI getInstance() {
        if (customViewAPI != null) return customViewAPI;
        Class<AUDCustomViewAPI> clazz = AUDCustomViewAPI.class;
        synchronized (AUDCustomViewAPI.class) {
            if (customViewAPI != null) return customViewAPI;
            customViewAPI = new AUDCustomViewAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return customViewAPI;
        }
    }

    public DataObject getCustomViewDO(Long cvId) {
        return this.getCustomViewDO(new Long[]{cvId});
    }

    public DataObject getCustomViewDO(Object[] cvId) {
        DataObject dataObject = null;
        try {
            ArrayList<String> cvTableList = new ArrayList<String>();
            cvTableList.add("AUDCVConfig");
            cvTableList.add("AUDSQLQuery");
            cvTableList.add("AUDUnionQuery");
            cvTableList.add("AUDTableViewConfig");
            cvTableList.add("AUDColumnConfiguration");
            cvTableList.add("AUDGraphOptions");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDSQLQuery");
            leftJoinList.add("AUDUnionQuery");
            leftJoinList.add("AUDTableViewConfig");
            leftJoinList.add("AUDColumnConfiguration");
            leftJoinList.add("AUDGraphOptions");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCVConfig", (String)"CV_ID"), (Object)cvId, 8);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get(cvTableList, leftJoinList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    public Long getReportCVId(Long reportId) {
        Long cvId = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReportCVMapping", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDReportCVMapping");
                cvId = (Long)row.get("CV_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cvId;
    }

    public void getReportCVIds() {
        try {
            this.cvIdMap = new HashMap();
            Table reportCvMapTable = Table.getTable((String)"AUDReportCVMapping");
            Table monitorMapTable = Table.getTable((String)"AUDMonitorReportMap");
            SelectQueryImpl sq = new SelectQueryImpl(reportCvMapTable);
            Join monitorReportMapJoin = new Join(reportCvMapTable, monitorMapTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            sq.addJoin(monitorReportMapJoin);
            sq.addSelectColumn(Column.getColumn((String)"AUDReportCVMapping", (String)"*"));
            DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator reportCvMapIterator = reportCvMapDataObject.getRows("AUDReportCVMapping");
            while (reportCvMapIterator.hasNext()) {
                Row reportCvMapRow = (Row)reportCvMapIterator.next();
                this.cvIdMap.put(reportCvMapRow.get("AUDIT_REPORT_ID"), (Long)reportCvMapRow.get("CV_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getReportCVIdInMap(Long auditReportId) {
        try {
            if (this.cvIdMap == null) {
                this.getReportCVIds();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Long)this.cvIdMap.get(auditReportId);
    }

    public void addCvIdInMap(Long auditReportId) {
        try {
            if (this.cvIdMap != null) {
                Table reportCvMapTable = Table.getTable((String)"AUDReportCVMapping");
                SelectQueryImpl sq = new SelectQueryImpl(reportCvMapTable);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)auditReportId, 0);
                sq.setCriteria(crit);
                sq.addSelectColumn(Column.getColumn((String)"AUDReportCVMapping", (String)"*"));
                DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                Iterator iterator = reportCvMapDataObject.getRows("AUDReportCVMapping");
                Long cvId = 0L;
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    cvId = (Long)r.get("CV_ID");
                }
                this.cvIdMap.put(auditReportId, cvId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCvIdInMap(Long monitorId) {
        try {
            if (this.cvIdMap != null) {
                Long auditReportId = this.getReportId(monitorId);
                this.cvIdMap.remove(auditReportId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getReportId(Long monitorId) {
        Long reportId = 0L;
        try {
            Table monitorReportMapTable = Table.getTable((String)"AUDMonitorReportMap");
            SelectQueryImpl sq = new SelectQueryImpl(monitorReportMapTable);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"), (Object)monitorId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"*"));
            DataObject reportCvMapDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator iterator = reportCvMapDataObject.getRows("AUDMonitorReportMap");
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                reportId = (Long)r.get("AUDIT_REPORT_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportId;
    }

    public DataObject getGraphDO(Long cvId) {
        DataObject dataObject = null;
        try {
            ArrayList<String> cvTableList = new ArrayList<String>();
            cvTableList.add("AUDCVConfig");
            cvTableList.add("AUDSQLQuery");
            cvTableList.add("AUDGraphOptions");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDSQLQuery");
            leftJoinList.add("AUDGraphOptions");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDCVConfig", (String)"CV_ID"), (Object)cvId, 0);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get(cvTableList, leftJoinList, criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    public ArrayList getVisibleColumnList(Long cvId, Boolean visible, boolean isMandatory, List<String> columnNameList) {
        ArrayList columnList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
            criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"VISIBLE"), (Object)visible, 0);
            if (!isMandatory) {
                criteria = criteria.and(Column.getColumn((String)"AUDColumnConfiguration", (String)"MANDATORY"), (Object)isMandatory, 0);
            }
            Table table = Table.getTable((String)"AUDColumnConfiguration");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNINDEX"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    List list;
                    Row row = (Row)iterator.next();
                    HashMap<String, Object> columnDetailsMap = new HashMap<String, Object>();
                    list = columnNameList != null ? (list = columnNameList) : row.getColumns();
                    for (String columnName : list) {
                        if (columnName.equals("DATE_FORMAT") && row.get(columnName) != null) {
                            columnDetailsMap.put(columnName, TimeUtil.getDateFormat());
                            continue;
                        }
                        columnDetailsMap.put(columnName, row.get(columnName));
                    }
                    columnList.add(columnDetailsMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public ArrayList getVisibleColumnList(Long cvId, Boolean visible) {
        return this.getVisibleColumnList(cvId, visible, true, null);
    }

    public HashMap<String, Object> getTableViewConfig(Long cvId) {
        HashMap<String, Object> tableViewConfig = new HashMap<String, Object>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDTableViewConfig", (String)"CV_ID"), (Object)cvId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDTableViewConfig", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDTableViewConfig");
                List columnList = row.getColumns();
                for (Object object : columnList) {
                    String column = (String)object;
                    tableViewConfig.put(column, row.get(column));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableViewConfig;
    }

    public void setToDefaultColumn(Long cvID) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDColumnConfiguration", c);
            if (!dObj.isEmpty()) {
                Iterator it = dObj.getRows("AUDColumnConfiguration", (Criteria)null);
                while (it.hasNext()) {
                    Row s = (Row)it.next();
                    int defaultColumnIndexValue = Integer.parseInt(s.get("DEFAULTCOLUMNINDEX").toString());
                    boolean defaultVisible = Boolean.parseBoolean(s.get("DEFAULTVISIBLE").toString());
                    s.set("VISIBLE", (Object)defaultVisible);
                    s.set("COLUMNINDEX", (Object)defaultColumnIndexValue);
                    dObj.updateRow(s);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean updateColumnList(Long cvID, Long[] visibleColumns) {
        boolean b = false;
        try {
            Row row;
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDColumnConfiguration", criteria);
            for (int i = 0; i < visibleColumns.length; ++i) {
                Long columnConfId = visibleColumns[i];
                Criteria columnCriteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"), (Object)columnConfId, 0);
                row = dataObject.getRow("AUDColumnConfiguration", columnCriteria);
                if (row == null) continue;
                row.set("COLUMNINDEX", (Object)(i + 1));
                row.set("VISIBLE", (Object)true);
                dataObject.updateRow(row);
            }
            int j = visibleColumns.length + 1;
            Iterator iterator = dataObject.getRows("AUDColumnConfiguration");
            while (iterator.hasNext()) {
                Row row2 = (Row)iterator.next();
                Long columnConfId = (Long)row2.get("COLUMN_CONF_ID");
                if (this.isIdPresent(columnConfId, visibleColumns)) continue;
                row2.set("COLUMNINDEX", (Object)j++);
                row2.set("VISIBLE", (Object)false);
                dataObject.updateRow(row2);
            }
            Criteria mandatoryColumnCriteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"MANDATORY"), (Object)true, 0);
            Iterator iterator2 = dataObject.getRows("AUDColumnConfiguration", mandatoryColumnCriteria);
            while (iterator2.hasNext()) {
                row = (Row)iterator2.next();
                row.set("COLUMNINDEX", (Object)j++);
                row.set("VISIBLE", (Object)true);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public boolean isIdPresent(Long id, Long[] ids) {
        boolean b = false;
        for (Long long1 : ids) {
            if (!id.equals(long1)) continue;
            return true;
        }
        return b;
    }

    public ArrayList<HashMap<String, Object>> getReportCVIdArray(Long reportId) {
        ArrayList<HashMap<String, Object>> countResultList = new ArrayList<HashMap<String, Object>>();
        int i = 0;
        Long cvID = 0L;
        String name = null;
        try {
            String tableName = "AUDReportCVMapping";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"AUDIT_REPORT_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"CV_ID"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"CV_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    HashMap<String, Object> countMap = new HashMap<String, Object>();
                    Row row = (Row)iterator.next();
                    cvID = (Long)row.get("CV_ID");
                    countMap.put("cvID", cvID);
                    DataObject dataObj = this.getCustomViewDO(cvID);
                    if (dataObj.size("AUDCVConfig") > 0) {
                        Row descRow = dataObj.getRow("AUDCVConfig");
                        name = (String)descRow.get("CV_NAME");
                        countMap.put("name", name);
                    }
                    countResultList.add(i, countMap);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return countResultList;
    }

    public ArrayList getColumnList(Long cvId) {
        ArrayList columnList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvId, 0);
            Table table = Table.getTable((String)"AUDColumnConfiguration");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMNINDEX"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    HashMap<String, Object> columnDetailsMap = new HashMap<String, Object>();
                    List list = row.getColumns();
                    for (String columnName : list) {
                        columnDetailsMap.put(columnName, row.get(columnName));
                    }
                    columnList.add(columnDetailsMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }
}

