/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AUDSummaryReports {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String resultantTableName = "AUDSummaryReports";
    private static String mappingTableName = "AUDSummaryReportMapping";
    private static String categoryTableName = "AUDSummaryReportCategories";
    private static String timeInterval = "Yesterday";
    private static String timeToDisplay = "Yesterday";
    private static final String SUMMARY_VIEW_CONFIG = "AUDSummaryViewConfiguration";
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public static void truncateOldData() throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)resultantTableName, (String)"DOMAIN_NAME"), null, 1);
        CommonUtil.getPersistenceLite().delete(crit);
    }

    public static void setTimeToSay() {
        timeToDisplay = rb.getString("adap.ReportSchedulerBean.Last_24_Hours");
    }

    public static String getTimeToSay() {
        return timeToDisplay;
    }

    public static Date getScheduleTime() {
        Date date = null;
        try {
            String uvhString = "Schedule:schedule_id:UVH@10004";
            Long scheduleId = DBObjectUtil.getUVHValues("Schedule", uvhString);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Task_Input"));
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            Row r = dObj.getRow("Task_Input");
            date = (Date)r.get("SCHEDULE_TIME");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static void fillSummaryReports(String inputDays) throws Exception {
        AUDSummaryReports.updateParameter("TIME_INTERVAL", inputDays);
        AUDSummaryReports.updateParameter("RUNNING_STATUS", 1);
        String dbServerName = CommonUtil.getDBServerName();
        ArrayList configuredList = DomainHandler.getConfiguredList(new Long(1L));
        LinkedHashMap summaryReportMap = AUDSummaryReports.getSummaryReportMap();
        String searchCriteria = "1=1";
        for (int i = 0; i < configuredList.size(); ++i) {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Properties domainProp = (Properties)configuredList.get(i);
            String domainName = domainProp.getProperty("DOMAIN_NAME");
            HashMap<String, String> inputParamsMap = new HashMap<String, String>();
            AUDSummaryReports.setInputParamsMap(inputParamsMap, domainName, inputDays);
            Set keys = summaryReportMap.keySet();
            for (Long obj : keys) {
                HashMap summaryReportDetails = (HashMap)summaryReportMap.get(obj);
                reportLogger.log(Level.INFO, "Summary Report Details is " + summaryReportDetails);
                Long cvId = (Long)summaryReportDetails.get("CV_ID");
                Boolean isMultilineOutput = (Boolean)summaryReportDetails.get("IS_MULTI_LINE_OUTPUT");
                if (isMultilineOutput.booleanValue()) {
                    HashMap<String, Object> tableViewConfig = AUDCustomViewAPI.getInstance().getTableViewConfig(cvId);
                    ArrayList rowsList = AuditReportAPI.getInstance().getReportRows(cvId, searchCriteria, inputParamsMap, (String)tableViewConfig.get("SORTCOLUMN"), (String)tableViewConfig.get("SORTORDER"), new Integer(1), (Integer)tableViewConfig.get("PAGELENGTH"), null, new Integer(0), false);
                    if (rowsList.size() <= 0) continue;
                    for (int size = 0; size < rowsList.size(); ++size) {
                        ArrayList list = (ArrayList)rowsList.get(size);
                        HashMap map = (HashMap)list.get(0);
                        String displayName = map.get("COLUMN_VALUE") != null ? map.get("COLUMN_VALUE").toString() : "-";
                        HashMap map1 = (HashMap)list.get(1);
                        Long value = Long.valueOf(map1.get("COLUMN_VALUE").toString());
                        AUDSummaryReports.addRowToDO(dObj, domainName, obj, displayName, value);
                    }
                    continue;
                }
                Integer count = AuditReportAPI.getInstance().getReportCount(cvId, searchCriteria, inputParamsMap);
                AUDSummaryReports.addRowToDO(dObj, domainName, obj, (String)summaryReportDetails.get("SUMMARY_REPORT_NAME"), count.longValue());
            }
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        }
        Long currTime = System.currentTimeMillis() / 1000L;
        AUDSummaryReports.updateParameter("LAST_SCHEDULE_AT", currTime);
        AUDSummaryReports.updateParameter("RUNNING_STATUS", 0);
        AUDSummaryReports.sendMail();
    }

    private static void addRowToDO(DataObject dObj, String domainName, Long summaryReportId, String summaryReportName, Long summaryReportCount) throws Exception {
        if (summaryReportName == null) {
            summaryReportName = "-";
        }
        Row row = new Row(resultantTableName);
        row.set("DOMAIN_NAME", (Object)domainName);
        row.set("SUMMARY_REPORT_ID", (Object)summaryReportId);
        row.set("REMARKS", (Object)rb.getString(summaryReportName));
        row.set("SUMMARY_RESULT_COUNT", (Object)summaryReportCount);
        dObj.addRow(row);
    }

    private static void setInputParamsMap(HashMap<String, String> inputParamsMap, String domainName, String timeInterval) throws Exception {
        HashMap<String, Object> periodMap = TimeUtil.getTimePeriod(timeInterval);
        inputParamsMap.put("FROM", periodMap.get("FROM").toString());
        inputParamsMap.put("TO", periodMap.get("TO").toString());
        inputParamsMap.put("domainFlatName", DomainDetailsAPI.getDomainFlatName(domainName, true));
        inputParamsMap.put("domainDNSName", DomainDetailsAPI.getDomainDNSName(domainName));
    }

    private static LinkedHashMap getSummaryReportMap() throws Exception {
        LinkedHashMap summaryReportMap = new LinkedHashMap();
        Criteria crit = new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_REPORT_ID"), null, 1);
        crit = crit.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"IS_ENABLED"), (Object)true, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(mappingTableName, crit);
        if (!dObj.isEmpty()) {
            Iterator iter = dObj.getRows(mappingTableName);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                HashMap<String, Object> summaryReportDetails = new HashMap<String, Object>();
                for (Object object : row.getColumns()) {
                    summaryReportDetails.put((String)object, row.get((String)object));
                }
                summaryReportMap.put((Long)row.get("SUMMARY_REPORT_ID"), summaryReportDetails);
            }
        }
        return summaryReportMap;
    }

    private static LinkedHashMap getSummaryReports() throws Exception {
        return AUDSummaryReports.getSummaryReports(0, null, null);
    }

    public static LinkedHashMap getSummaryReport(Long summaryCategoryId, String domainName) {
        return AUDSummaryReports.getSummaryReports(1, summaryCategoryId, domainName);
    }

    public static LinkedHashMap getSummaryReports(int reportCategoryType) {
        return AUDSummaryReports.getSummaryReports(reportCategoryType, null, null);
    }

    public static LinkedHashMap getSummaryReports(int reportCategoryType, String domainName) {
        return AUDSummaryReports.getSummaryReports(reportCategoryType, null, domainName);
    }

    public static LinkedHashMap getSummaryReports(int reportCategoryType, Long summaryCategoryId, String domainName) {
        LinkedHashMap summaryReportMap = new LinkedHashMap();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)mappingTableName));
            Join leftJoin = new Join(Table.getTable((String)mappingTableName), Table.getTable((String)resultantTableName), new String[]{"SUMMARY_REPORT_ID"}, new String[]{"SUMMARY_REPORT_ID"}, 2);
            query.addJoin(leftJoin);
            Join cateJoin = new Join(Table.getTable((String)mappingTableName), Table.getTable((String)categoryTableName), new String[]{"SUMMARY_CATEGORY_ID"}, new String[]{"SUMMARY_CATEGORY_ID"}, 2);
            query.addJoin(cateJoin);
            int domainQC = domainName != null ? 0 : 1;
            int sumCatIdQC = summaryCategoryId != null ? 0 : 1;
            Criteria criteria = new Criteria(Column.getColumn((String)resultantTableName, (String)"DOMAIN_NAME"), (Object)domainName, domainQC);
            criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"IS_ENABLED"), (Object)true, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), (Object)summaryCategoryId, sumCatIdQC));
            if (reportCategoryType != 0) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)mappingTableName, (String)"REPORT_CATEGORY_TYPE"), (Object)reportCategoryType, 0));
            }
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)resultantTableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)mappingTableName, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)categoryTableName, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), true));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dObj.isEmpty()) {
                ArrayList domainList = DomainHandler.getConfiguredList(new Long(1L));
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties p = (Properties)domainList.get(i);
                    domainName = p.getProperty("DOMAIN_NAME");
                    Criteria crit = new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), null, 1);
                    LinkedHashMap categoryMap = new LinkedHashMap();
                    Iterator iterator = dObj.getRows(mappingTableName, crit);
                    while (iterator.hasNext()) {
                        Row mappingRow = (Row)iterator.next();
                        summaryCategoryId = (Long)mappingRow.get("SUMMARY_CATEGORY_ID");
                        Criteria crit1 = new Criteria(Column.getColumn((String)mappingTableName, (String)"SUMMARY_CATEGORY_ID"), (Object)summaryCategoryId, 0);
                        HashMap<String, Object> summaryReportDetails = new HashMap<String, Object>();
                        Criteria cateCrit = new Criteria(Column.getColumn((String)categoryTableName, (String)"SUMMARY_CATEGORY_ID"), (Object)summaryCategoryId, 0);
                        Row categoryRow = dObj.getRow(categoryTableName, cateCrit);
                        summaryReportDetails.put("summaryReportName", rb.getString((String)categoryRow.get("SUMMARY_CATEGORY_NAME")));
                        ArrayList list = new ArrayList();
                        Iterator iter = dObj.getRows(mappingTableName, crit1);
                        while (iter.hasNext()) {
                            HashMap<String, Object> reportMap = new HashMap<String, Object>();
                            Row row1 = (Row)iter.next();
                            Long summaryReportId = (Long)row1.get("SUMMARY_REPORT_ID");
                            Boolean isMultipleRow = (Boolean)row1.get("IS_MULTI_LINE_OUTPUT");
                            reportMap.put("SUMMARY_REPORT_ID", summaryReportId);
                            reportMap.put("IS_MULTI_LINE_OUTPUT", isMultipleRow);
                            Criteria crit2 = new Criteria(Column.getColumn((String)resultantTableName, (String)"SUMMARY_REPORT_ID"), (Object)summaryReportId, 0);
                            crit2 = crit2.and(new Criteria(Column.getColumn((String)resultantTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                            if (isMultipleRow.booleanValue()) {
                                reportMap.put("SUMMARY_REPORT_NAME", rb.getString((String)row1.get("SUMMARY_REPORT_NAME")));
                                ArrayList list1 = new ArrayList();
                                Iterator iter1 = dObj.getRows(resultantTableName, crit2);
                                while (iter1.hasNext()) {
                                    Row row2 = (Row)iter1.next();
                                    if (row2 == null) continue;
                                    HashMap<String, Object> subReportMap = new HashMap<String, Object>();
                                    subReportMap.put("REMARKS", row2.get("REMARKS"));
                                    subReportMap.put("SUMMARY_RESULT_COUNT", row2.get("SUMMARY_RESULT_COUNT"));
                                    list1.add(subReportMap);
                                }
                                reportMap.put("reportRowList", list1);
                            } else {
                                Row row2 = dObj.getRow(resultantTableName, crit2);
                                reportMap.put("AUDIT_REPORT_ID", row1.get("AUDIT_REPORT_ID"));
                                if (row2 != null) {
                                    reportMap.put("REMARKS", row2.get("REMARKS"));
                                    reportMap.put("SUMMARY_RESULT_COUNT", row2.get("SUMMARY_RESULT_COUNT"));
                                } else {
                                    reportMap.put("REMARKS", rb.getString((String)row1.get("SUMMARY_REPORT_NAME")));
                                    reportMap.put("SUMMARY_RESULT_COUNT", new Long(0L));
                                }
                            }
                            list.add(reportMap);
                        }
                        summaryReportDetails.put("resultantReportsList", list);
                        categoryMap.put(summaryCategoryId, summaryReportDetails);
                    }
                    summaryReportMap.put(domainName, categoryMap);
                }
            } else {
                reportLogger.log(Level.INFO, "Handle for empty dataobject");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return summaryReportMap;
    }

    private static String constructMailContent() throws Exception {
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("<html><head><meta content=\"text/plain; charset=UTF-8\" http-equiv=\"Content-Type\"></head>&nbsp;&nbsp;<body>");
        LinkedHashMap summaryReportMap = AUDSummaryReports.getSummaryReports();
        Set keys = summaryReportMap.keySet();
        AUDSummaryReports.setTimePeriod(messageBuffer);
        for (Object obj : keys) {
            messageBuffer.append("<div style=\"width:100%\">");
            messageBuffer.append("<table width=\"98%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\" >");
            messageBuffer.append("<tr height=\"15px\"><td style=\"");
            messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; font-weight: bold; text-decoration: none");
            messageBuffer.append("\">");
            messageBuffer.append(rb.getString("adap.SummaryView.Summary_Report_for_the_Domain"));
            messageBuffer.append(obj);
            messageBuffer.append("</td></tr></table>");
            LinkedHashMap reportCategoryMap = (LinkedHashMap)summaryReportMap.get(obj);
            Set cateKey = reportCategoryMap.keySet();
            for (Object val : cateKey) {
                HashMap reportMap = (HashMap)reportCategoryMap.get(val);
                ArrayList list = (ArrayList)reportMap.get("resultantReportsList");
                String summaryCategoryName = (String)reportMap.get("summaryReportName");
                messageBuffer.append("<table width=\"98%\" cellpadding=\"5\" cellspacing=\"0\" border=\"0\" align=\"center\" style=\"");
                messageBuffer.append("background:#ececec;  border:1px solid #dcdcdc; border-radius:5px 5px 0 0; border-bottom:none; line-height:20px; text-shadow: 1px 1px 0 #FFFFFF; height:23px");
                messageBuffer.append(";margin-top: 5px; padding-left:0px;\">");
                messageBuffer.append("<tr height=\"25px\">");
                messageBuffer.append("<td style=\"");
                messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; font-weight: bold; text-decoration: none");
                messageBuffer.append("\" colspan=\"4\">");
                messageBuffer.append(summaryCategoryName);
                messageBuffer.append("</td></tr>");
                messageBuffer.append("<tr style=\"");
                messageBuffer.append("font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #FFFFFF;padding: 10px 7px;border-bottom: 1px solid #E8E8E8;height: 25px");
                messageBuffer.append("\">");
                int k = 0;
                for (int i = 0; i < list.size(); ++i) {
                    HashMap resultMap = (HashMap)list.get(i);
                    Boolean isMultiline = (Boolean)resultMap.get("IS_MULTI_LINE_OUTPUT");
                    if (isMultiline.booleanValue()) {
                        messageBuffer.append("<td width=\"50%\" valign=\"top\">");
                        messageBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"left\">");
                        messageBuffer.append("<tr colspan=\"2\" width=\"50%\">");
                        messageBuffer.append("<td style=\"");
                        messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 12px; font-weight: bold; text-decoration: none");
                        messageBuffer.append("\">");
                        messageBuffer.append(resultMap.get("SUMMARY_REPORT_NAME"));
                        messageBuffer.append("&nbsp;:&nbsp;</td></tr>");
                        ArrayList reportRowList = (ArrayList)resultMap.get("reportRowList");
                        for (int size = 0; size < reportRowList.size(); ++size) {
                            HashMap reportRowMap = (HashMap)reportRowList.get(size);
                            messageBuffer.append("<tr style=\"");
                            messageBuffer.append("font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #FFFFFF;padding: 10px 7px;border-bottom: 1px solid #E8E8E8;height: 25px");
                            messageBuffer.append("\">");
                            messageBuffer.append("<td style=\"");
                            messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 10px; text-decoration: none");
                            messageBuffer.append("\" width=\"80%\">");
                            messageBuffer.append(reportRowMap.get("REMARKS"));
                            messageBuffer.append("</td><td style=\"");
                            messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 10px; text-decoration: none");
                            messageBuffer.append("\" width=\"20%\">");
                            messageBuffer.append(reportRowMap.get("SUMMARY_RESULT_COUNT"));
                            messageBuffer.append("</td></tr>");
                        }
                        messageBuffer.append("</table></td>");
                        continue;
                    }
                    if (i != 0 && i % 2 == 0) {
                        ++k;
                        messageBuffer.append("<tr style=\"");
                        messageBuffer.append("font-family: Verdana, Arial, Helvetica, sans-serif;font-size: 10px;font-weight: normal;text-decoration: none;background-color: #FFFFFF;padding: 10px 7px;border-bottom: 1px solid #E8E8E8;height: 25px");
                        messageBuffer.append("\">");
                    }
                    messageBuffer.append("<td style=\"");
                    messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 10px; text-decoration: none");
                    messageBuffer.append("\" width=\"40%\">");
                    messageBuffer.append(resultMap.get("REMARKS"));
                    messageBuffer.append("</td><td style=\"");
                    messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 10px; text-decoration: none");
                    messageBuffer.append("\" width=\"10%\">");
                    messageBuffer.append(resultMap.get("SUMMARY_RESULT_COUNT"));
                    messageBuffer.append("</td>");
                    if (i == list.size() - 1 && list.size() % 2 == 1) {
                        messageBuffer.append("<td colspan=\"2\"></td></tr>");
                        continue;
                    }
                    if (i == 0 || i % 2 == 0) continue;
                    messageBuffer.append("</tr>");
                }
                messageBuffer.append("</table>");
                messageBuffer.append("<table width=\"98%\" cellspacing=\"0\" cellpadding=\"3\" style=\"");
                messageBuffer.append("background:#ffffff;  border:1px solid #dcdcdc; border-radius:0 0 5px 5px; border-top:none; height:5px; overflow:hidden");
                messageBuffer.append(";margin-top: 0px; margin-bottom: 5px; border: 1px solid rgb(225, 225, 225); border-top:0px;\" align=\"center\"><tr><td></td></tr></table><br/>");
            }
            messageBuffer.append("</div>");
        }
        messageBuffer.append("</body></html>");
        return messageBuffer.toString();
    }

    private static void sendMail() throws Exception {
        HashMap<String, Object> sendMailMap = new HashMap<String, Object>();
        String toAddress = (String)AUDSummaryReports.getParameter("MAIL_ADDRESS");
        if (!toAddress.equals("no")) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(rb.getString("adap.AUDSummaryReports.Summary_Reports"));
            String mailContent = AUDSummaryReports.constructMailContent();
            reportLogger.log(Level.INFO, mailContent);
            sendMailMap.put("toAddress", toAddress.split(","));
            sendMailMap.put("subject", buffer.toString());
            sendMailMap.put("message", mailContent);
            sendMailMap.put("isSummary", "yes");
            boolean sendMailStatus = SendMailAPI.getInstance().sendMail(sendMailMap);
        }
    }

    private static void setTimePeriod(StringBuffer messageBuffer) throws Exception {
        String timeStr = rb.getString("adap.AudSelectElementAttr.Yesterday");
        String timeInterval = (String)AUDSummaryReports.getParameter("TIME_INTERVAL");
        if (timeInterval.equals("twfourhours")) {
            timeStr = rb.getString("adap.AudSelectElementAttr.Last_24_Hours");
        }
        HashMap<String, Object> timeMap = TimeUtil.getTimePeriod(timeInterval);
        messageBuffer.append("<table width=\"98%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\" ><tr height=\"15p\"><td class=\"");
        messageBuffer.append("color: #000000; font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 10px; text-decoration: none");
        messageBuffer.append("\">");
        messageBuffer.append(rb.getString("adap.SummaryView.TimePeriod"));
        messageBuffer.append("&nbsp;:&nbsp;");
        messageBuffer.append(timeStr);
        messageBuffer.append("&nbsp;(");
        messageBuffer.append(rb.getString("adap.tab.talkback.text.from"));
        messageBuffer.append("&nbsp;");
        messageBuffer.append(TimeUtil.getSimpleDateFormat(new Date((Long)timeMap.get("FROM") * 1000L)));
        messageBuffer.append("&nbsp;");
        messageBuffer.append(rb.getString("adap.tab.talkback.text.to"));
        messageBuffer.append("&nbsp;");
        messageBuffer.append(TimeUtil.getSimpleDateFormat(new Date((Long)timeMap.get("TO") * 1000L)));
        messageBuffer.append(")</td></tr></table>");
    }

    public static void updateParameter(String parameterName, Object parameterValue) {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(SUMMARY_VIEW_CONFIG, (Criteria)null);
            Row row = dObj.getFirstRow(SUMMARY_VIEW_CONFIG);
            row.set(parameterName, parameterValue);
            dObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Object getParameter(String parameterName) {
        Object paramValue = "";
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(SUMMARY_VIEW_CONFIG, (Criteria)null);
            Row row = dObj.getFirstRow(SUMMARY_VIEW_CONFIG);
            paramValue = row.get(parameterName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return paramValue;
    }
}

