/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPGraphSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.manageengine.ads.fw.layout.CustomizationHandler;
import com.manageengine.ads.fw.layout.LayoutBean;
import com.manageengine.ads.fw.layout.customization.WidgetsHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class AuditReportAPI {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AuditReportAPI reportAPI = null;
    private static HashMap reportsDetailsMap = null;
    private static ArrayList reportsDetails = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Pattern tableNamePattern = Pattern.compile("\\$\\{TABLE:([^\\}]*)\\}");
    private static String[] fileCreationReports = new String[]{"AUDReports:audit_report_id:10101", "AUDReports:audit_report_id:10201", "AUDReports:audit_report_id:10301"};
    private ArrayList<Long> fileCreationReportIdList = null;
    private static HashMap<String, Long> objectClassCvidMap = new HashMap();
    private static HashMap<Integer, String> serverTabMap = new HashMap();
    public static ArrayList<Long> subReportList = new ArrayList();
    private static Hashtable<Long, Long> reportAccessMapping = null;

    private AuditReportAPI() {
        Long[] ids;
        this.setReportsDetails();
        this.fileCreationReportIdList = new ArrayList();
        for (Long long1 : ids = DBObjectUtil.getUVHValues("AUDReports", fileCreationReports)) {
            this.fileCreationReportIdList.add(long1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditReportAPI getInstance() {
        if (reportAPI != null) return reportAPI;
        Class<AuditReportAPI> clazz = AuditReportAPI.class;
        synchronized (AuditReportAPI.class) {
            if (reportAPI != null) return reportAPI;
            reportAPI = new AuditReportAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return reportAPI;
        }
    }

    public ArrayList<Long> getFileCreationReports() {
        return this.fileCreationReportIdList;
    }

    public HashMap getReportDetailsMap(Object reportId) {
        if (reportsDetailsMap == null || reportsDetailsMap.get(reportId) == null) {
            this.getReports(reportId);
        }
        return (HashMap)reportsDetailsMap.get(reportId);
    }

    public void changeChartDefault(String col, String value, Long cv_id) {
        try {
            UpdateQueryImpl s = new UpdateQueryImpl("AUDGraphOptions");
            Criteria c = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)cv_id, 0);
            s.setCriteria(c);
            s.setUpdateColumn(col, (Object)value);
            CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, Object> getReportDetails(Long reportId) {
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDReports");
                List list = row.getColumns();
                for (Object object : list) {
                    String string = (String)object;
                    reportMap.put(string, row.get(string));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportMap;
    }

    public int getReportCount(Long cvId, String searchCriteria, HashMap inputParamsMap) {
        Integer count = 0;
        try {
            String countSqlString = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, inputParamsMap);
            count = QueryUtil.getRowsCount(countSqlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public int getReportCount(Long cvId, String searchCriteria, HashMap inputParamsMap, String countUnionSqlString) {
        Integer count = 0;
        try {
            String countSqlString = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, inputParamsMap, countUnionSqlString);
            count = QueryUtil.getRowsCount(countSqlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public ArrayList getVisibleColumnList(Long cvId) {
        ArrayList columnList = new ArrayList();
        try {
            Boolean visible = true;
            columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    public HashMap<String, Object> getTableViewConfig(Long reportId) {
        HashMap<String, Object> tableViewConfig = new HashMap<String, Object>();
        try {
            Long cvId = AUDCustomViewAPI.getInstance().getReportCVId(reportId);
            tableViewConfig = AUDCustomViewAPI.getInstance().getTableViewConfig(cvId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableViewConfig;
    }

    public String getReportTab(Object auditReportId) {
        try {
            Row row;
            Integer reportCategory;
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), auditReportId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
            if (!dObj.isEmpty() && serverTabMap.get(reportCategory = (Integer)(row = dObj.getFirstRow("AUDReports")).get("REPORT_CATEGORY_TYPE")) != null) {
                return serverTabMap.get(reportCategory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "reports";
        }
        return "reports";
    }

    public ArrayList getReportRows(Long cvId, String searchCriteria, HashMap inputParamsMap, String sortColumn, String sortOrder, int startIndex, int noOfObjects, String unionSqlString, int count, Boolean isEmber) {
        ArrayList reportRowsList = new ArrayList();
        try {
            Boolean visible = true;
            HashMap<String, Object> addionalSQLPropsMap = new HashMap<String, Object>();
            addionalSQLPropsMap.put("sortColumn", sortColumn);
            addionalSQLPropsMap.put("sortOrder", sortOrder);
            addionalSQLPropsMap.put("startIndex", startIndex);
            addionalSQLPropsMap.put("noOfObjects", noOfObjects);
            String sqlString = null;
            sqlString = unionSqlString != null ? ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, unionSqlString, count) : ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, count);
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            reportRowsList = QueryUtil.getRows(sqlString, columnList, inputParamsMap, isEmber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportRowsList;
    }

    public String getGraphReportRows(Long cvID, String domainName, Long graphOptID, Long noofday) throws DataAccessException {
        ArrayList reportRows = new ArrayList();
        String sqlString = ADAPGraphSQLQueryAPI.getInstance().getGraphSQLString(cvID, domainName, graphOptID, noofday);
        return sqlString;
    }

    public Object getValue(int dataType, Object value) {
        if (dataType == 1001) {
            return value;
        }
        if (dataType == 1004) {
            return TimeUtil.formatDate((Long)value * 1000L);
        }
        return value;
    }

    public HashMap getCustomVisibleList(Long cvId) {
        HashMap<String, ArrayList> customColumnMap = new HashMap<String, ArrayList>();
        ArrayList visibleList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, true, false, null);
        customColumnMap.put("visibleList", visibleList);
        ArrayList nonVisibleList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, false, false, null);
        customColumnMap.put("nonVisibleList", nonVisibleList);
        return customColumnMap;
    }

    public Boolean setVisibleColumnList(Long cvID, String[] col_id) {
        Boolean retAction = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"), (Object)col_id, 8));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDColumnConfiguration", criteria);
            if (!dObj.isEmpty()) {
                Iterator iterator = dObj.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    row.set("VISIBLE", (Object)"1");
                    dObj.updateRow(row);
                    DataAccess.update((DataObject)dObj);
                }
            }
        }
        catch (Exception ex) {
            retAction = false;
            ex.printStackTrace();
        }
        return retAction;
    }

    public Boolean setNonVisibleColumnList(Long cvID, String[] col_id) {
        Boolean retAction = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"CV_ID"), (Object)cvID, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDColumnConfiguration", (String)"COLUMN_CONF_ID"), (Object)col_id, 9));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDColumnConfiguration", criteria);
            if (!dObj.isEmpty()) {
                Iterator iterator = dObj.getRows("AUDColumnConfiguration");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    row.set("VISIBLE", (Object)"0");
                    dObj.updateRow(row);
                    DataAccess.update((DataObject)dObj);
                }
            }
        }
        catch (Exception ex) {
            retAction = false;
            ex.printStackTrace();
        }
        return retAction;
    }

    public int getRowsCount(Long cvID, Long graphOptID, String inputData, HashMap inputParamsMap, String searchCriteria) {
        Integer count = 0;
        try {
            String countSqlString = ADAPGraphSQLQueryAPI.getInstance().getSQLCountString(cvID, graphOptID, inputData, inputParamsMap, searchCriteria);
            count = QueryUtil.getRowsCount(countSqlString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public ArrayList getReportRows(Long cvID, Long graphOptID, String inputData, HashMap inputParamsMap, String searchCriteria, String sortColumn, String sortOrder, int startIndex, int noOfObjects, int count, Boolean isEmber) {
        ArrayList reportRowsList = new ArrayList();
        Boolean visible = true;
        try {
            HashMap<String, Object> addionalSQLPropsMap = new HashMap<String, Object>();
            addionalSQLPropsMap.put("sortColumn", sortColumn);
            addionalSQLPropsMap.put("sortOrder", sortOrder);
            addionalSQLPropsMap.put("startIndex", startIndex);
            addionalSQLPropsMap.put("noOfObjects", noOfObjects);
            String sqlString = ADAPGraphSQLQueryAPI.getInstance().getSQLString(cvID, graphOptID, inputData, inputParamsMap, searchCriteria, addionalSQLPropsMap, count);
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, visible);
            reportRowsList = QueryUtil.getRows(sqlString, columnList, inputParamsMap, isEmber);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportRowsList;
    }

    public String getXColumnValue(Long cvID, Long graphOptID, String inputData) {
        String searchCriteria = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graphOptID, 0);
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvID);
            if (cvDO.size("AUDGraphOptions") > 0) {
                Row graphRow = cvDO.getRow("AUDGraphOptions", criteria);
                String xColumn = (String)graphRow.get("XCOLUMN");
                QueryBuilder queryBuilder = QueryBuilderAPI.getInstance().getQueryBuilder();
                xColumn = queryBuilder.replaceFunctionPattern(xColumn);
                xColumn = xColumn + (graphRow.get("MCOLUMN") != null ? ";;;" + (String)graphRow.get("MCOLUMN") : "");
                String graphType = (String)graphRow.get("GRAPH_TYPE");
                searchCriteria = ADAPSQLQueryUtil.getXColumnValue(xColumn, inputData, graphType);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCriteria;
    }

    public void updateDescription(Long reportId, String desc) {
        try {
            if (desc != null) {
                UpdateQueryImpl query = new UpdateQueryImpl("AUDReports");
                Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                query.setCriteria(crit);
                query.setUpdateColumn("DESCRIPTION", (Object)desc);
                CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)query);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getDomainSIDString(String domainName) {
        String objSID = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", criteria);
            if (dataObject.isEmpty()) {
                DomainAction.addDomainGeneralDetails(domainName);
                reportLogger.info("Domain SID Details not available, so getting the details froom native.");
                dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", criteria);
            }
            Row row = dataObject.getRow("ADSMDomainGeneralDetails");
            objSID = (String)row.get("SID_STRING");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objSID;
    }

    public ArrayList getGraphUnderlyingData(Long cvID, Long graphOptId, String domainName, String inputElement, Integer fromIndex, Integer range, Long noofday, String graphType, Integer count, Boolean isEmber) {
        ArrayList reportsList = new ArrayList();
        boolean visible = true;
        try {
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, visible);
            String sqlString = ADAPGraphSQLQueryAPI.getInstance().getGraphReportSQLString(cvID, graphOptId, domainName, inputElement, fromIndex, range, noofday, graphType, count);
            reportsList = QueryUtil.getRows(sqlString, columnList, new HashMap(), isEmber);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportsList;
    }

    public int getGraphUnderlyingDataCount(Long cvID, Long graphOptId, String domainName, String inputElement, Long noofday, String graphType) {
        int dataCount = 0;
        try {
            String countSqlString = ADAPGraphSQLQueryAPI.getInstance().getGraphReportCountSQLString(cvID, graphOptId, domainName, inputElement, noofday, graphType);
            dataCount = QueryUtil.getRowsCount(countSqlString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataCount;
    }

    public static DataObject getReportsDO(Object reportId) throws Exception {
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("AUDReports");
        tablesList.add("AUDReportElementMap");
        tablesList.add("AUDReportCVMapping");
        tablesList.add("AUDCVConfig");
        tablesList.add("AUDColumnConfiguration");
        tablesList.add("AUDTableViewConfig");
        tablesList.add("AUDSQLQuery");
        tablesList.add("AUDUnionQuery");
        tablesList.add("AUDGraphOptions");
        ArrayList<String> leftJoinList = new ArrayList<String>();
        leftJoinList.add("AUDReportElementMap");
        leftJoinList.add("AUDReportCVMapping");
        leftJoinList.add("AUDCVConfig");
        leftJoinList.add("AUDColumnConfiguration");
        leftJoinList.add("AUDTableViewConfig");
        leftJoinList.add("AUDSQLQuery");
        leftJoinList.add("AUDUnionQuery");
        leftJoinList.add("AUDGraphOptions");
        Criteria criteria = null;
        criteria = reportId != null ? new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), reportId, 0) : new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), null, 1);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, leftJoinList, criteria);
        return dataObject;
    }

    public void getReports(Object reportId) {
        try {
            HashMap hashMap = reportsDetailsMap = reportsDetailsMap == null ? new HashMap() : reportsDetailsMap;
            if (reportsDetailsMap.get(reportId) == null) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), reportId, 0));
                Row audReportRow = dataObject.getFirstRow("AUDReports");
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                List audReportsList = audReportRow.getColumns();
                for (Object object : audReportsList) {
                    String columnName = (String)object;
                    if (columnName.equalsIgnoreCase("AUDIT_REPORT_ID")) continue;
                    valueMap.put(columnName, audReportRow.get(columnName));
                }
                reportsDetailsMap.put(reportId, valueMap);
            }
            reportLogger.log(Level.FINE, "reportsDetailsMap is " + reportsDetailsMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addORUpdateReportDetails(Long reportId) throws Exception {
        reportsDetailsMap = reportsDetailsMap == null ? new HashMap() : reportsDetailsMap;
        DataObject dataObject = AuditReportAPI.getReportsDO(reportId);
        if (dataObject.size("AUDReports") > 0) {
            Row audReportRow = dataObject.getRow("AUDReports");
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            List audReportsList = audReportRow.getColumns();
            for (Object object : audReportsList) {
                String columnName = (String)object;
                if (columnName.equalsIgnoreCase("AUDIT_REPORT_ID")) continue;
                valueMap.put(columnName, audReportRow.get(columnName));
            }
            this.getReportsCVMap(reportId, dataObject, valueMap);
            reportLogger.log(Level.INFO, "the added/updated report is " + valueMap);
            reportLogger.log(Level.INFO, "the added/updated report's id is " + reportId);
            if (reportsDetailsMap.get(reportId) != null) {
                reportsDetailsMap.remove(reportId);
            }
            reportsDetailsMap.put(reportId, valueMap);
            reportLogger.log(Level.FINE, "reportsDetailsMap is " + reportsDetailsMap);
        }
    }

    public void removeReportDetails(Long reportId) throws Exception {
        reportLogger.log(Level.INFO, "the removed report's id is " + reportId);
        HashMap valueMap = (HashMap)reportsDetailsMap.remove(reportId);
        reportLogger.log(Level.INFO, "the removed report is " + valueMap);
    }

    public HashMap getReportsCVMap(Long reportId, DataObject dataObject, HashMap valueMap) throws Exception {
        if (dataObject.size("AUDReportCVMapping") > 0) {
            ArrayList countResultList = new ArrayList();
            Criteria reportCVCrit = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            Iterator cvMapIterator = dataObject.getRows("AUDReportCVMapping", reportCVCrit);
            while (cvMapIterator.hasNext()) {
                HashMap<String, Object> countMap = new HashMap<String, Object>();
                Row row = (Row)cvMapIterator.next();
                countMap.put("cvID", (Long)row.get("CV_ID"));
                if (dataObject.size("AUDCVConfig") > 0) {
                    Row descRow = dataObject.getRow("AUDCVConfig");
                    countMap.put("name", (String)descRow.get("CV_NAME"));
                }
                countResultList.add(countMap);
            }
            valueMap.put("cvIDMapping", countResultList);
        }
        return valueMap;
    }

    public String addToFavorites(Long reportId, String favName, HashMap inputParams, Long loginId) throws Exception {
        String message = rb.getString("adap.AuditReports.Already_added_to_Favourites");
        DataObject dataObject = null;
        Row row = null;
        dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        row = new Row("AUDFavourites");
        row.set("FAVOURITE_NAME", (Object)favName);
        row.set("AUDIT_REPORT_ID", (Object)reportId);
        row.set("LOGIN_ID", (Object)loginId);
        row.set("DOMAIN_NAME", (Object)((String)inputParams.get("domainName")));
        row.set("REPORT_PERIOD", (Object)((String)inputParams.get("inputDays")));
        if (inputParams.get("inputDays") != null && ((String)inputParams.get("inputDays")).equalsIgnoreCase("customPeriod")) {
            row.set("START_TIME", inputParams.get("startTime"));
            row.set("END_TIME", inputParams.get("endTime"));
            row.set("START_HOUR", inputParams.get("startHour"));
            row.set("END_HOUR", inputParams.get("endHour"));
        }
        if (inputParams.get("objectClass") != null) {
            row.set("OBJECT_CLASS", inputParams.get("objectClass"));
            row.set("ALL_OBJECT_SELECTED", inputParams.get("allObjectSelected"));
            ArrayList list = (ArrayList)inputParams.get("object_guid");
            if (list == null) {
                list = (ArrayList)inputParams.get("printer_name");
            }
            if (list != null) {
                for (int size = 0; size < list.size(); ++size) {
                    Row inputRow = new Row("AUDFavouritesInputMap");
                    inputRow.set("FAVOURITE_ID", row.get("FAVOURITE_ID"));
                    inputRow.set("OBJECT_GUID_VALUE", list.get(size));
                    inputRow.set("OBJECT_CLASS", inputParams.get("objectClass"));
                    dataObject.addRow(inputRow);
                }
            }
        }
        dataObject.addRow(row);
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        message = rb.getString("adap.AuditReportAPI.Successfully_added_to_Favourites");
        return message;
    }

    public static String removeFavourites(Long favouriteId) throws Exception {
        String message = rb.getString("adap.AuditReportAPI.Successfully_removed_from_My_Reports");
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDFavourites", (String)"FAVOURITE_ID"), (Object)favouriteId, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = rb.getString("adap.AuditReportAPI.Exception_while_removing_from_My_Reports");
        }
        return message;
    }

    public static ArrayList getFavourites() throws Exception {
        ArrayList list = new ArrayList();
        try {
            DataObject dataObject = AuditReportAPI.getFavouriteObjects();
            if (!dataObject.isEmpty()) {
                Iterator reportIterator = dataObject.getRows("AUDFavourites");
                while (reportIterator.hasNext()) {
                    Row row = (Row)reportIterator.next();
                    HashMap<String, Object> favMap = new HashMap<String, Object>();
                    favMap.put("FAVOURITE_ID", (Long)row.get("FAVOURITE_ID"));
                    favMap.put("FAVOURITE_NAME", (String)row.get("FAVOURITE_NAME"));
                    favMap.put("AUDIT_REPORT_NAME", (String)row.get("FAVOURITE_NAME"));
                    favMap.put("AUDIT_REPORT_ID", (Long)row.get("AUDIT_REPORT_ID"));
                    favMap.put("name", (String)row.get("FAVOURITE_NAME"));
                    favMap.put("isFavourite", true);
                    favMap.put("favouriteId", (Long)row.get("FAVOURITE_ID"));
                    favMap.put("routeName", "reports.myreport");
                    favMap.put("modelId", (Long)row.get("FAVOURITE_ID"));
                    favMap.put("reportId", (Long)row.get("AUDIT_REPORT_ID"));
                    list.add(favMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static DataObject getFavouriteObjects() throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDFavourites"));
        Join leftJoin = new Join(Table.getTable((String)"AUDFavourites"), Table.getTable((String)"AUDFavouritesInputMap"), new String[]{"FAVOURITE_ID"}, new String[]{"FAVOURITE_ID"}, 1);
        query.addJoin(leftJoin);
        query.addSelectColumn(Column.getColumn((String)"AUDFavourites", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"AUDFavouritesInputMap", (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        return dataObject;
    }

    public static HashMap getFavouritesInput(Long reportId, Long favouriteId) throws Exception {
        DataObject dObj = AuditReportAPI.getFavouriteObjects();
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDFavourites", (String)"FAVOURITE_ID"), (Object)favouriteId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDFavourites", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0));
        Row row = dObj.getRow("AUDFavourites", criteria);
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        inputParams.put("domainName", (String)row.get("DOMAIN_NAME"));
        inputParams.put("inputDays", (String)row.get("REPORT_PERIOD"));
        inputParams.put("FROM", (String)row.get("START_TIME"));
        inputParams.put("TO", (String)row.get("END_TIME"));
        inputParams.put("startHour", (String)row.get("START_HOUR"));
        inputParams.put("endHour", (String)row.get("END_HOUR"));
        inputParams.put("startTime", (String)row.get("START_TIME"));
        inputParams.put("endTime", (String)row.get("END_TIME"));
        if (row.get("OBJECT_CLASS") != null) {
            inputParams.put("objectClass", (String)row.get("OBJECT_CLASS"));
            inputParams.put("allObjectSelected", row.get("ALL_OBJECT_SELECTED"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDFavouritesInputMap", (String)"FAVOURITE_ID"), (Object)favouriteId, 0);
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = dObj.getRows("AUDFavouritesInputMap", crit);
            while (iter.hasNext()) {
                Row inputRow = (Row)iter.next();
                list.add((String)inputRow.get("OBJECT_GUID_VALUE"));
            }
            if (inputParams.get("allObjectSelected") != null && ((String)inputParams.get("allObjectSelected")).equalsIgnoreCase("true")) {
                String objectClass = (String)row.get("OBJECT_CLASS");
                Long cvId = objectClassCvidMap.get(objectClass);
                ArrayList objectsList = DirectoryObjectAPI.getInstance().getObjects(DomainDetailsAPI.getDefaultNamingContext((String)row.get("DOMAIN_NAME")), objectClass, null, -1, 0, cvId, 0L);
                list = new ArrayList();
                for (int i = 0; i < objectsList.size(); ++i) {
                    HashMap listMap = (HashMap)objectsList.get(i);
                    list.add(objectClass.equalsIgnoreCase("printer") ? (String)listMap.get("NAME") : (String)listMap.get("OBJECT_GUID"));
                }
            }
            if (((String)row.get("OBJECT_CLASS")).equalsIgnoreCase("printer")) {
                inputParams.put("printer_name", list);
            } else {
                inputParams.put("object_guid", list);
            }
        }
        return inputParams;
    }

    public static String addToDashBoard(HashMap inputMap, HashMap inputParamsMap) throws Exception {
        Row row;
        String status = rb.getString("adap.domain_settings.policy_status.statusmsg.successfully_configured");
        DataObject dObj = AuditReportAPI.getDataObject("AUDGraphOptions", "GRAPH_OPT_ID", inputMap.get("GRAPH_OPT_ID"), 0);
        DataObject dataObj = AuditReportAPI.getDataObject("AUDHomeGraphs", "GRAPH_OPT_ID", inputMap.get("GRAPH_OPT_ID"), 0);
        if (dataObj.isEmpty()) {
            row = new Row("AUDHomeGraphs");
            for (Object object : row.getColumns()) {
                row.set((String)object, inputMap.get((String)object));
            }
            dObj.addRow(row);
        } else {
            row = dataObj.getFirstRow("AUDHomeGraphs");
            row.set("FIRST_GRAPH_DURATION", inputMap.get("FIRST_GRAPH_DURATION"));
            row.set("SECOND_GRAPH_DURATION", inputMap.get("SECOND_GRAPH_DURATION"));
            row.set("VISIBLE", (Object)true);
            dataObj.updateRow(row);
            DataAccess.update((DataObject)dataObj);
        }
        Row graphRow = dObj.getRow("AUDGraphOptions");
        graphRow.set("GRAPH_TITLE", inputMap.get("GRAPH_TITLE"));
        dObj.updateRow(graphRow);
        CommonUtil.getPersistence(new boolean[0]).update(dObj);
        if (((Boolean)inputMap.get("IS_INPUT_NEEDED")).booleanValue()) {
            AuditReportAPI.addToInputMap(inputParamsMap, (Long)inputMap.get("GRAPH_OPT_ID"));
        }
        return status;
    }

    private static DataObject getDataObject(String tableName, String columnName, Object columnValue, int constantValue) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), columnValue, constantValue);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
        return dObj;
    }

    public Long getPriorityId(int reportCateType) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDHomeGraphs"));
        query.addSelectColumn(Column.getColumn((String)"AUDHomeGraphs", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDHomeGraphs", (String)"PRIORITY_ID"), false));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        return (Long)dataObject.getFirstValue("AUDHomeGraphs", "PRIORITY_ID") + 1L;
    }

    private static void refreshGraph(Object graph_opt_id) throws Exception {
        DataObject dObj = AuditReportAPI.getDataObject("AUDHomeGraphs", "GRAPH_OPT_ID", graph_opt_id, 0);
        Row row = dObj.getRow("AUDHomeGraphs");
        ArrayList domainList = DomainHandler.getConfiguredList(1L);
        Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.schedule.DefaultGraphGenerator");
        for (Object object : domainList) {
            Properties properties = (Properties)object;
            String domainName = properties.getProperty("DOMAIN_NAME");
            try {
                GraphGenerator generator = (GraphGenerator)classToInvoke.newInstance();
                generator.generateGraph((Long)row.get("GRAPH_OPT_ID"), domainName, (Long)row.get("FIRST_GRAPH_DURATION"), new ArrayList<HashMap>());
                generator.generateGraph((Long)row.get("GRAPH_OPT_ID"), domainName, (Long)row.get("SECOND_GRAPH_DURATION"), new ArrayList<HashMap>());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String removeFromDashBoard(Object graphOptId) throws Exception {
        DataObject dObj = AuditReportAPI.getDataObject("AUDHomeGraphs", "GRAPH_OPT_ID", graphOptId, 0);
        Row row = dObj.getRow("AUDHomeGraphs");
        row.set("VISIBLE", (Object)false);
        dObj.updateRow(row);
        DataAccess.update((DataObject)dObj);
        Criteria crit = new Criteria(Column.getColumn((String)"AUDHomeGraphInputMap", (String)"GRAPH_OPT_ID"), graphOptId, 0);
        CommonUtil.getPersistence(new boolean[0]).delete(crit);
        this.deleteHomeGraphData(graphOptId);
        return "Success";
    }

    private void deleteHomeGraphData(Object graphOptId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"GRAPH_OPT_ID"), graphOptId, 0);
        CommonUtil.getPersistence(new boolean[0]).delete(crit);
    }

    private static void addToInputMap(HashMap inputParamsMap, Long graphOptId) throws Exception {
        ArrayList guidList = (ArrayList)inputParamsMap.get("object_guid");
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        for (int i = 0; i < guidList.size(); ++i) {
            Row row = new Row("AUDHomeGraphInputMap");
            row.set("GRAPH_OPT_ID", (Object)graphOptId);
            row.set("INPUT_PARAM", (Object)"object_guid");
            row.set("INPUT_PARAM_VALUE", guidList.get(i));
            row.set("OBJECT_CLASS", inputParamsMap.get("objectClass"));
            dataObject.addRow(row);
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
    }

    public static HashMap getInputMap(Long graphOptId, HashMap inputParamsMap, Long reportId) throws Exception {
        DataObject dObj;
        DataObject dataObject = AuditReportAPI.getDataObject("AUDHomeGraphInputMap", "GRAPH_OPT_ID", graphOptId, 0);
        ArrayList<String> objectGuid = new ArrayList<String>();
        String objectClass = "";
        Iterator iterator = dataObject.getRows("AUDHomeGraphInputMap");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            objectGuid.add((String)row.get("INPUT_PARAM_VALUE"));
            objectClass = (String)row.get("OBJECT_CLASS");
        }
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        inputParams.put("objectClass", objectClass);
        inputParams.put("object_guid", objectGuid);
        if (reportId == null && (dObj = AuditReportAPI.getReportsDO(null)).size("AUDReports") > 0) {
            Row audReportRow = dObj.getRow("AUDReports");
            reportId = (Long)audReportRow.get("AUDIT_REPORT_ID");
        }
        AuditReportParamsAPI.getObjectValues(inputParams, inputParamsMap, reportId);
        return inputParamsMap;
    }

    public static boolean isThisGraphAdded(Long graphOptId) throws Exception {
        boolean status = false;
        Criteria crit = new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"VISIBLE"), (Object)true, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDHomeGraphs", crit);
        if (!dObj.isEmpty()) {
            status = true;
        }
        return status;
    }

    public static Boolean isInputNeeded(Long graphOptId) throws Exception {
        DataObject dataObject = AuditReportAPI.getDataObject("AUDHomeGraphs", "GRAPH_OPT_ID", graphOptId, 0);
        Row row = dataObject.getFirstRow("AUDHomeGraphs");
        return (Boolean)row.get("IS_INPUT_NEEDED");
    }

    public static Boolean isReportGraph(Long graphOptId) throws Exception {
        DataObject dataObject = AuditReportAPI.getDataObject("AUDHomeGraphs", "GRAPH_OPT_ID", graphOptId, 0);
        Row row = dataObject.getFirstRow("AUDHomeGraphs");
        return (Boolean)row.get("IS_THIS_REPORT_GRAPH");
    }

    public String removeFromDashBoard(HttpServletRequest request, Object graphOptId, Long conId) throws Exception {
        WidgetsHandler.removeComponent((Long)conId);
        new LayoutBean(request).removeSession();
        if (graphOptId != null) {
            this.removeFromDashBoard(graphOptId);
        }
        return "Success";
    }

    public String modifyDashBoard(HttpServletRequest request, HashMap inputMap, HashMap inputParamsMap, JSONObject containerDetails) throws Exception {
        CustomizationHandler.setLayoutContainers((JSONObject)containerDetails);
        new LayoutBean(request).removeSession();
        String status = AuditReportAPI.addToDashBoard(inputMap, inputParamsMap);
        return status;
    }

    public void setReportsDetails() {
        this.setReportsDetails(null);
    }

    public void setReportsDetails(HttpServletRequest request) {
        try {
            HttpSession session;
            ADAPAuthObject authObject;
            HashMap<String, Object> loginUserDetails;
            String domainName;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDReports"));
            query.addSelectColumns((List)AuditReportAPI.getColumnList("AUDReports", new String[]{"AUDIT_REPORT_ID", "AUDIT_REPORT_NAME", "TITLE", "DESCRIPTION", "REPORT_CATEGORY_TYPE", "LICENSE_TYPE", "LABELS"}));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), true));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)new Long[]{1L, 2L, 3L}, 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)1L, 1));
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject.size("AUDReports") > 0) {
                reportsDetails = new ArrayList();
                Iterator iterator = dataObject.getRows("AUDReports");
                while (iterator.hasNext()) {
                    HashMap reportMap = new HashMap();
                    Row audReportRow = (Row)iterator.next();
                    AuditReportAPI.getRowDetails(reportMap, audReportRow);
                    reportsDetails.add(reportMap);
                }
            }
            Criteria crit1 = null;
            if (request != null && !(domainName = (String)(loginUserDetails = (authObject = (ADAPAuthObject)(session = request.getSession()).getAttribute("ADAP_AUTH_OBJ")).getLoginUserDetails()).get("DELEGATED_DOMAIN")).equalsIgnoreCase(rb.getString("adap.common.text.All_Domains")) && !domainName.equalsIgnoreCase("All Domains")) {
                crit1 = new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)domainName.split(","), 8);
            }
            SelectQueryImpl query1 = new SelectQueryImpl(Table.getTable((String)"AUDReports"));
            Join reportJoin = new Join(Table.getTable((String)"AUDReports"), Table.getTable((String)"AUDMonitorReportMap"), new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            Join monitorJoin = new Join(Table.getTable((String)"AUDMonitorReportMap"), Table.getTable((String)"AUDMonitor"), new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
            query1.addJoin(reportJoin);
            query1.addJoin(monitorJoin);
            query1.setCriteria(crit1);
            query1.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
            query1.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"*"));
            query1.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"*"));
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query1);
            if (dataObject.size("AUDReports") > 0) {
                Iterator iterator = dataObject.getRows("AUDReports");
                while (iterator.hasNext()) {
                    HashMap reportMap = new HashMap();
                    Row audReportRow = (Row)iterator.next();
                    AuditReportAPI.getRowDetails(reportMap, audReportRow);
                    reportsDetails.add(reportMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList getReportsDetails(HttpServletRequest request) {
        if (request == null) {
            return reportsDetails;
        }
        this.setReportsDetails(request);
        return reportsDetails;
    }

    public ArrayList getReportsDetails() {
        return reportsDetails;
    }

    private static ArrayList getColumnList(String tableName, String[] cols) throws Exception {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < cols.length; ++i) {
            list.add(Column.getColumn((String)tableName, (String)cols[i]));
        }
        return list;
    }

    private static void getRowDetails(HashMap reportMap, Row row) throws Exception {
        String[] columnNames = new String[]{"AUDIT_REPORT_ID", "AUDIT_REPORT_NAME", "TITLE", "DESCRIPTION", "REPORT_CATEGORY_TYPE", "LICENSE_TYPE", "LABELS"};
        for (int i = 0; i < columnNames.length; ++i) {
            String string = columnNames[i];
            if (row.getColumnType(string).equalsIgnoreCase("NCHAR")) {
                reportMap.put(string, row.get(string) != null ? rb.getString((String)row.get(string)).toLowerCase() : "");
            } else {
                reportMap.put(string, row.get(string));
            }
            reportMap.put("DISPLAYNAME", rb.getString((String)row.get("TITLE")));
        }
    }

    public static String saveUDCustomPeriod(String displayName, HashMap inputParams) throws Exception {
        String message = rb.getString("adap.AUDReports.status_message.Successfully_Configured_CustomPeriod");
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row row = null;
        row = new Row("AUDCustomPeriod");
        row.set("CLIENT_NAME", (Object)displayName);
        row.set("SERVER_NAME", (Object)("UD_" + displayName.replace(" ", "_")));
        row.set("START_TIME", inputParams.get("startTime"));
        row.set("END_TIME", inputParams.get("endTime"));
        row.set("START_HOUR", inputParams.get("startHour"));
        row.set("END_HOUR", inputParams.get("endHour"));
        dataObject.addRow(row);
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        message = rb.getString("adap.AUDReports.status_message.Exception_while_Stroing_Custom_Period");
        return message;
    }

    public static DataObject getCustomPeriodDO() throws Exception {
        return CommonUtil.getPersistence(new boolean[0]).get("AUDCustomPeriod", (Criteria)null);
    }

    public void updateFrequentViewReports(Long reportId, Long loginId) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"LOGIN_ID"), (Object)loginId, 0));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDFrequentlyViewedReports", crit);
        if (dObj.isEmpty()) {
            Row row = ReportUtil.formRow("AUDFrequentlyViewedReports", new String[]{"AUDIT_REPORT_ID", "LOGIN_ID", "REPORT_VIEW_TIME", "COUNT"}, new Object[]{reportId, loginId, System.currentTimeMillis(), new Long(1L)});
            dObj.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        } else {
            Row row = dObj.getFirstRow("AUDFrequentlyViewedReports");
            row = ReportUtil.formRow(row, new String[]{"AUDIT_REPORT_ID", "LOGIN_ID", "REPORT_VIEW_TIME", "COUNT"}, new Object[]{reportId, loginId, System.currentTimeMillis(), (Long)row.get("COUNT") + 1L});
            dObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
    }

    public static ArrayList getFrequentlyViewedReports(Long loginId, boolean isFrequently, int size) {
        ArrayList freqReportsList;
        block6: {
            freqReportsList = new ArrayList();
            try {
                Criteria crit = new Criteria(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"LOGIN_ID"), (Object)loginId, 0);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDFrequentlyViewedReports"));
                Join innerJoin = new Join(Table.getTable((String)"AUDFrequentlyViewedReports"), Table.getTable((String)"AUDReports"), new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
                query.addJoin(innerJoin);
                query.addSelectColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"*"));
                query.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
                query.setCriteria(crit);
                if (isFrequently) {
                    query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"COUNT"), false));
                } else {
                    query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"REPORT_VIEW_TIME"), false));
                }
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (dataObject.isEmpty()) break block6;
                int i = 1;
                Iterator iter = dataObject.getRows("AUDFrequentlyViewedReports");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Row reportRow = dataObject.getRow("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)((Long)row.get("AUDIT_REPORT_ID")), 0));
                    HashMap<String, Object> reportDetails = new HashMap<String, Object>();
                    reportDetails.put("AUDIT_REPORT_NAME", reportRow.get("AUDIT_REPORT_NAME"));
                    reportDetails.put("AUDIT_REPORT_ID", reportRow.get("AUDIT_REPORT_ID"));
                    reportDetails.put("REPORT_CATEGORY_ID", reportRow.get("REPORT_CATEGORY_ID"));
                    reportDetails.put("REPORT_CATEGORY_TYPE", reportRow.get("REPORT_CATEGORY_TYPE"));
                    freqReportsList.add(reportDetails);
                    if (i != size) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return freqReportsList;
    }

    public HashMap<String, Object> getFrequentlyViewedReportsEmber(HttpServletRequest request, HttpServletResponse response, Long loginId, boolean isFrequently, int size, AdventNetResourceBundle rb2) throws Exception {
        ArrayList freqReportsList = new ArrayList();
        HashMap<String, Object> reportCategoriesMap = new HashMap<String, Object>();
        try {
            reportCategoriesMap.put("name", rb2.getString("adap.FrequentlyViewedReports.Frequently_Viewed_Reports"));
            reportCategoriesMap.put("hasDropdown", true);
            reportCategoriesMap.put("SR_NAME", rb2.getString("adap.FrequentlyViewedReports.Frequently_Viewed_Reports"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"LOGIN_ID"), (Object)loginId, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDFrequentlyViewedReports"));
            Join innerJoin = new Join(Table.getTable((String)"AUDFrequentlyViewedReports"), Table.getTable((String)"AUDReports"), new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            query.addJoin(innerJoin);
            query.addSelectColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
            query.setCriteria(crit);
            if (isFrequently) {
                query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"COUNT"), false));
            } else {
                query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDFrequentlyViewedReports", (String)"REPORT_VIEW_TIME"), false));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                int i = 1;
                Iterator iter = dataObject.getRows("AUDFrequentlyViewedReports");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    Row reportRow = dataObject.getRow("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)((Long)row.get("AUDIT_REPORT_ID")), 0));
                    HashMap<String, Object> reportDetails = new HashMap<String, Object>();
                    reportDetails.put("AUDIT_REPORT_NAME", reportRow.get("AUDIT_REPORT_NAME"));
                    reportDetails.put("AUDIT_REPORT_ID", reportRow.get("AUDIT_REPORT_ID"));
                    reportDetails.put("REPORT_CATEGORY_ID", reportRow.get("REPORT_CATEGORY_ID"));
                    reportDetails.put("REPORT_CATEGORY_TYPE", reportRow.get("REPORT_CATEGORY_TYPE"));
                    reportDetails.put("name", rb2.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
                    reportDetails.put("modelId", reportRow.get("AUDIT_REPORT_ID"));
                    reportDetails.put("routeName", "reports.report");
                    freqReportsList.add(reportDetails);
                    if (i == size) break;
                    ++i;
                }
            }
            reportCategoriesMap.put("list", freqReportsList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportCategoriesMap;
    }

    public String getDomainName(Long reportId) throws Exception {
        StringBuilder sb = new StringBuilder();
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ReportUtil.getSelectQuery(new String[]{"AUDReports", "AUDCustomReports"}, new boolean[]{false, false}, new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0)));
        if (!dObj.isEmpty()) {
            Row row = dObj.getFirstRow("AUDCustomReports");
            sb.append((String)row.get("DOMAIN_NAME"));
        }
        return sb.toString();
    }

    public static ArrayList getTableNames(Long reportId) throws Exception {
        ArrayList<HashMap<String, Object>> cvIDList = AUDCustomViewAPI.getInstance().getReportCVIdArray(reportId);
        Long[] cvId = new Long[cvIDList.size()];
        for (int i = 0; i < cvIDList.size(); ++i) {
            HashMap<String, Object> map = cvIDList.get(i);
            cvId[i] = (Long)map.get("cvID");
        }
        SelectQuery query = ReportUtil.getSelectQuery(new String[]{"AUDSQLQuery", "AUDUnionQuery"}, new boolean[]{true, true}, new Criteria(Column.getColumn((String)"AUDSQLQuery", (String)"CV_ID"), (Object)cvId, 8));
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(query);
        Iterator iter = dObj.getRows("AUDUnionQuery");
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            Matcher match = tableNamePattern.matcher((String)row.get("UNION_QUERY"));
            while (match.find()) {
                String matchStr = match.group();
                String tableName = matchStr.replace("${TABLE:", "");
                tableName = tableName.replace("}", "");
                list.add(tableName);
            }
        }
        return list;
    }

    public HashMap<String, Object> getReportDetailsEmber(Long reportId, AdventNetResourceBundle rb2) {
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDReports");
                List list = row.getColumns();
                for (Object object : list) {
                    String string = (String)object;
                    if (string.equals("TITLE") || string.equals("AUDIT_REPORT_NAME") || string.equals("DESCRIPTION")) {
                        reportMap.put(string, rb2.getString((String)row.get(string)));
                        continue;
                    }
                    reportMap.put(string, row.get(string));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportMap;
    }

    public String setDefaultTimePeriod(Long reportId, String inputValue) {
        String status = "Failure Occured";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            criteria = criteria.and(Column.getColumn((String)"AudElement", (String)"NAME"), (Object)"inputDays", 0);
            Table baseTable = Table.getTable((String)"AudElement");
            Table refTable = Table.getTable((String)"AUDReportElementMap");
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, refTable, new String[]{"ELEMENT_ID"}, new String[]{"ELEMENT_ID"}, 2);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportElementMap", (String)"*"));
            selectQuery.addJoin(join);
            selectQuery.setCriteria(criteria);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Row r = dataobject.getFirstRow("AUDReportElementMap");
            r.set("INPUT_VALUE", (Object)inputValue);
            dataobject.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataobject);
            status = "success";
        }
        catch (Exception e) {
            status = e.getMessage();
            e.printStackTrace();
        }
        return status;
    }

    public Boolean isReportAccessible(Long reportId, Long reportCategoryId, HttpServletRequest request) throws Exception {
        if (reportAccessMapping == null) {
            reportAccessMapping = new Hashtable();
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), null, 1);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
            if (!dob.isEmpty()) {
                Iterator iter = dob.getRows("AUDReports");
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    reportAccessMapping.put((Long)r.get("AUDIT_REPORT_ID"), (Long)r.get("ACTION_ID"));
                }
            }
        }
        ADAPAuthObject authObject = (ADAPAuthObject)request.getSession().getAttribute("ADAP_AUTH_OBJ");
        ArrayList<Long> actionList = authObject.getUserActins();
        if (reportCategoryId == 1L) {
            return actionList.contains(TDConstants.PROFILE_BASED_REPORTS);
        }
        Long actionId = reportAccessMapping.get(reportId);
        return actionList.contains(actionId);
    }

    static {
        objectClassCvidMap.put("printer", 100005L);
        objectClassCvidMap.put("group", 5L);
        objectClassCvidMap.put("computer", 2L);
        objectClassCvidMap.put("user", 1L);
        objectClassCvidMap.put("organizationalUnit", 7L);
        serverTabMap.put(1, "reports");
        serverTabMap.put(2, "fileAudit");
        serverTabMap.put(3, "serverAudit");
        subReportList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:66"));
        subReportList.add(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15051"));
    }
}

