/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileintegrity.FileIntegrityManager;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuditReportCategoryHandler {
    public static LinkedHashMap getReportCategories(String domainName, Integer categoryType, HttpServletRequest request, boolean isSchedulerInput) {
        LinkedHashMap reportMap = new LinkedHashMap();
        try {
            if (request.getAttribute("REPORT_MAP") != null) {
                reportMap = (LinkedHashMap)request.getAttribute("REPORT_MAP");
            } else {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADAP_SESSION_LOGIN_ID");
                ADAPAuthObject authObject = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
                ArrayList<Long> actionList = authObject.getUserActins();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReportCategories"));
                selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportCategories", (String)"*"));
                ArrayList<Integer> idList = AuditReportCategoryHandler.getExcludedReportCategoryIds();
                Integer[] categoryIds = idList.toArray(new Integer[idList.size()]);
                Criteria c = new Criteria(new Column("AUDReportCategories", "REPORT_CATEGORY_ID"), (Object)categoryIds, 9);
                selectQuery.setCriteria(c);
                selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportCategories", (String)"PRIORITY"), true));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
                crit = crit.or(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), null, 0));
                selectQuery.setCriteria(crit);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                boolean isFIMEnabled = domainName != null ? FileIntegrityManager.getInstance().isFIMEnabledInDomain(domainName) : false;
                Iterator iterator = dataObject.getRows("AUDReportCategories");
                while (iterator.hasNext()) {
                    HashMap<String, Object> reportCategoriesMap = new HashMap<String, Object>();
                    Row row = (Row)iterator.next();
                    Long reportCategoryId = (Long)row.get("REPORT_CATEGORY_ID");
                    reportCategoriesMap.put("REPORT_CATEGORY_ID", reportCategoryId);
                    reportCategoriesMap.put("NAME", rb.getString((String)row.get("NAME")));
                    reportCategoriesMap.put("SR_NAME", rb.getString((String)row.get("SR_NAME")));
                    if (reportCategoryId == 1L) {
                        HashMap<String, Object> loginUserDetails = authObject.getLoginUserDetails();
                        String delegatedDomain = null;
                        if (!"All Domains".equals((String)loginUserDetails.get("DELEGATED_DOMAIN"))) {
                            delegatedDomain = (String)loginUserDetails.get("DELEGATED_DOMAIN");
                        }
                        reportCategoriesMap.put("CATEGORY_REPORTS", AuditReportCategoryHandler.getMonitorReports(categoryType, rb, isSchedulerInput, delegatedDomain));
                    } else if (reportCategoryId == 7L) {
                        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
                        hashtable.put("IS_CUSTOM_PROFILE", true);
                        reportCategoriesMap.put("CATEGORY_REPORTS", AuditReportCategoryHandler.getMonitorReports(categoryType, hashtable, rb, loginId, isSchedulerInput));
                    } else if (reportCategoryId == 20L) {
                        if (isFIMEnabled && categoryType == null || categoryType != null) {
                            reportCategoriesMap.put("CATEGORY_REPORTS", AuditReportCategoryHandler.getCategoryReports(reportCategoryId, categoryType, rb, loginId, actionList, isSchedulerInput));
                        } else {
                            reportCategoriesMap.put("CATEGORY_REPORTS", new ArrayList());
                        }
                    } else {
                        reportCategoriesMap.put("CATEGORY_REPORTS", AuditReportCategoryHandler.getCategoryReports(reportCategoryId, categoryType, rb, loginId, actionList, isSchedulerInput));
                    }
                    reportMap.put(reportCategoryId, reportCategoriesMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Integer> getExcludedReportCategoryIds() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlString = "SELECT DISTINCT(REPORT_CATEGORY_ID) AS REPORT_CATEGORY_ID FROM AUDREPORTS WHERE REPORT_CATEGORY_TYPE IN (4,5,6)";
        ArrayList<Integer> idList = new ArrayList<Integer>();
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            int j = 0;
            while (resultSet.next()) {
                Integer category_id = (int)resultSet.getLong("REPORT_CATEGORY_ID");
                idList.add(category_id);
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return idList;
    }

    public static ArrayList getCategoryReports(Long reportCategoryId, Integer reportCategoryType, AdventNetResourceBundle rb, Long loginId, ArrayList actionList, boolean isSchedulerInput) {
        ArrayList reportList = new ArrayList();
        try {
            SelectQueryImpl selectQueryInner = new SelectQueryImpl(Table.getTable((String)"AUDReports"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)reportCategoryId, 0);
            if (!actionList.isEmpty()) {
                Criteria actionCrit = new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
                actionCrit = actionCrit.or(new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"), (Object)true, 0));
                criteria = criteria.and(actionCrit);
            }
            if (reportCategoryType != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)reportCategoryType, 0));
            }
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_PUBLIC"), (Object)true, 0));
            criteria = criteria.and(crit);
            selectQueryInner.setCriteria(criteria);
            selectQueryInner.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
            selectQueryInner.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReports", (String)"PRIORITY"), true));
            DataObject dObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQueryInner);
            Iterator iterator2 = dObject.getRows("AUDReports", criteria);
            while (iterator2.hasNext()) {
                Row reportRow = (Row)iterator2.next();
                HashMap<String, Object> reportDetailsMap = new HashMap<String, Object>();
                reportDetailsMap.put("AUDIT_REPORT_NAME", rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("AUDIT_REPORT_ID", reportRow.get("AUDIT_REPORT_ID"));
                reportDetailsMap.put("PRIORITY", reportRow.get("PRIORITY"));
                if (isSchedulerInput) {
                    reportDetailsMap.put("INPUT_PARAMS", AuditReportParamsAPI.getReportFormElements((Long)reportRow.get("AUDIT_REPORT_ID"), isSchedulerInput, rb));
                }
                if (loginId.longValue() == ((Long)reportRow.get("LOGIN_ID")).longValue()) {
                    reportDetailsMap.put("IS_CUSTOMIZABLE", reportRow.get("IS_CUSTOMIZABLE"));
                } else {
                    reportDetailsMap.put("IS_CUSTOMIZABLE", false);
                }
                reportList.add(reportDetailsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getMonitorReports(Integer categoryType, AdventNetResourceBundle rb, boolean isSchedulerInput, String delegatedDomain) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList reportList = new ArrayList();
        HashMap monitorReportMap = new HashMap();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMonitorReportMap"));
            Join mrMapMonitorJoin = new Join("AUDMonitorReportMap", "AUDMonitor", new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
            Join monitorCategoryJoin = new Join("AUDMonitor", "AUDCategories", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            Join mrMapReportJoin = new Join("AUDMonitorReportMap", "AUDReports", new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            selectQuery.addJoin(mrMapMonitorJoin);
            selectQuery.addJoin(mrMapReportJoin);
            selectQuery.addJoin(monitorCategoryJoin);
            Criteria criteria = null;
            if (categoryType != null) {
                criteria = new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0);
            }
            if (delegatedDomain != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)delegatedDomain.split(","), 8));
            }
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria != null ? criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0)) : new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0);
            }
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"AUDIT_REPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategories", (String)"PRIORITY_ID"), true));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                LinkedHashMap domainMap = (LinkedHashMap)monitorReportMap.get(domainName);
                if (domainMap == null) {
                    domainMap = new LinkedHashMap();
                }
                String categoryName = rb.getString((String)dataSet.getValue("CATEGORY_NAME"));
                Long categoryId = (Long)dataSet.getValue("CATEGORY_ID");
                String categoryNameIdToken = categoryId + ";;" + categoryName;
                ArrayList categoryReports = (ArrayList)domainMap.get(categoryNameIdToken);
                if (categoryReports == null) {
                    categoryReports = new ArrayList();
                }
                HashMap<String, Object> reportMap = new HashMap<String, Object>();
                reportMap.put("AUDIT_REPORT_ID", (Long)dataSet.getValue("AUDIT_REPORT_ID"));
                reportMap.put("MONITOR_ID", (Long)dataSet.getValue("MONITOR_ID"));
                reportMap.put("AUDIT_REPORT_NAME", rb.getString((String)dataSet.getValue("AUDIT_REPORT_NAME")));
                if (isSchedulerInput) {
                    reportMap.put("INPUT_PARAMS", AuditReportParamsAPI.getReportFormElements((Long)dataSet.getValue("AUDIT_REPORT_ID"), isSchedulerInput, rb));
                }
                reportMap.put("IS_CUSTOMIZABLE", dataSet.getValue("IS_CUSTOMIZABLE"));
                categoryReports.add(reportMap);
                domainMap.put(categoryNameIdToken, categoryReports);
                monitorReportMap.put(domainName, domainMap);
            }
            reportList.add(monitorReportMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return reportList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getMonitorReports(Integer categoryType, Hashtable sqlCriteriaProps, AdventNetResourceBundle rb, Long loginId, boolean isSchedulerInput) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList reportList = new ArrayList();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMonitorReportMap"));
            Join mrMapMonitorJoin = new Join("AUDMonitorReportMap", "AUDMonitor", new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
            Join monitorCategoryJoin = new Join("AUDMonitor", "AUDCategories", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            Join mrMapReportJoin = new Join("AUDMonitorReportMap", "AUDReports", new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            selectQuery.addJoin(mrMapMonitorJoin);
            selectQuery.addJoin(mrMapReportJoin);
            selectQuery.addJoin(monitorCategoryJoin);
            Criteria criteria = null;
            if (!sqlCriteriaProps.isEmpty()) {
                Enumeration enumeration = sqlCriteriaProps.keys();
                while (enumeration.hasMoreElements()) {
                    String keyString = (String)enumeration.nextElement();
                    Object value = sqlCriteriaProps.get(keyString);
                    if (criteria == null) {
                        criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)keyString), value, 0);
                        continue;
                    }
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)keyString), value, 0));
                }
            }
            criteria = criteria == null ? new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0) : criteria.and(new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0));
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0));
            }
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"AUDIT_REPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategories", (String)"PRIORITY_ID"), true));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                HashMap<String, Object> reportDetailsMap = new HashMap<String, Object>();
                reportDetailsMap.put("AUDIT_REPORT_NAME", rb.getString((String)dataSet.getValue("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("AUDIT_REPORT_ID", (Long)dataSet.getValue("AUDIT_REPORT_ID"));
                reportDetailsMap.put("DOMAIN_NAME", (String)dataSet.getValue("DOMAIN_NAME"));
                reportDetailsMap.put("CATEGORY_ID", (Long)dataSet.getValue("CATEGORY_ID"));
                if (isSchedulerInput) {
                    reportDetailsMap.put("INPUT_PARAMS", AuditReportParamsAPI.getReportFormElements((Long)dataSet.getValue("AUDIT_REPORT_ID"), isSchedulerInput, rb));
                }
                reportDetailsMap.put("IS_CUSTOMIZABLE", dataSet.getValue("IS_CUSTOMIZABLE"));
                reportList.add(reportDetailsMap);
            }
            AuditReportAPI.getInstance();
            reportList.addAll(AuditReportAPI.getFavourites());
            reportList.addAll(AuditReportCategoryHandler.getCategoryReports(new Long(7L), categoryType, rb, loginId, new ArrayList(), isSchedulerInput));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return reportList;
    }

    public static Integer getCategoryType(Long auditReportId) {
        Integer categoryId = 1;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)auditReportId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDReports");
                categoryId = (Integer)row.get("REPORT_CATEGORY_TYPE");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return categoryId;
    }

    public static LinkedHashMap getReportUICategories(String domainName, Integer categoryType, HttpServletRequest request, boolean isSchedulerInput) {
        LinkedHashMap<Long, HashMap> reportUIMap = new LinkedHashMap<Long, HashMap>();
        try {
            ADAPAuthObject authObject = (ADAPAuthObject)request.getSession().getAttribute("ADAP_AUTH_OBJ");
            ArrayList<Long> actionList = authObject.getUserActins();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            LinkedHashMap reportMap = AuditReportCategoryHandler.getReportCategories(domainName, categoryType, request, isSchedulerInput);
            request.setAttribute("REPORT_MAP", (Object)reportMap);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDReportUICategories"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportUICategories", (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportUICategories", (String)"REPORT_UI_CATEGORY_ID"), true));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReportUICategories", (String)"PRIORITY_ID"), true));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportUICategories", (String)"REPORT_CATEGORY_TYPE"), (Object)categoryType, 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            HashMap categoryUIMap = null;
            Iterator iterator = dataObject.getRows("AUDReportUICategories");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long uIId = (Long)row.get("REPORT_UI_CATEGORY_ID");
                String uiName = rb.getString((String)row.get("REPORT_UI_CATEGORY_NAME"));
                categoryUIMap = reportUIMap.get(uIId) == null ? new HashMap() : (HashMap)reportUIMap.remove(uIId);
                categoryUIMap.put("REPORT_UI_CATEGORY_ID", uIId);
                categoryUIMap.put("REPORT_UI_CATEGORY_NAME", uiName);
                LinkedHashMap categoryMap = new LinkedHashMap();
                if (categoryUIMap.get("UI_CATEGORIES") != null) {
                    categoryMap = (LinkedHashMap)categoryUIMap.get("UI_CATEGORIES");
                }
                if (uIId == 5L) {
                    categoryMap = AuditReportCategoryHandler.getComplianceReports(rb, actionList, isSchedulerInput);
                } else if (uIId == 1L || uIId == 7L) {
                    categoryMap = AuditReportCategoryHandler.getCumulativeReports(uIId, categoryType, rb, actionList, isSchedulerInput);
                } else if (reportMap.get((Long)row.get("CATEGORY_ID")) != null) {
                    categoryMap.put((Long)row.get("CATEGORY_ID"), reportMap.get((Long)row.get("CATEGORY_ID")));
                }
                categoryUIMap.put("UI_CATEGORIES", categoryMap);
                reportUIMap.put(uIId, categoryUIMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportUIMap;
    }

    private static LinkedHashMap getComplianceReports(AdventNetResourceBundle rb, ArrayList actionList, boolean isSchedulerInput) throws Exception {
        Table complianceTable = Table.getTable((String)"AUDComplianceReportMapping");
        Table reportsTable = Table.getTable((String)"AUDReports");
        SelectQueryImpl selectQuery = new SelectQueryImpl(complianceTable);
        Join innerJoin = new Join(complianceTable, reportsTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
        selectQuery.addJoin(innerJoin);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDComplianceReportMapping", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDComplianceReportMapping", (String)"COMPLIANCE_ID"), true));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        LinkedHashMap<Long, HashMap> complianceMap = new LinkedHashMap<Long, HashMap>();
        HashMap complianceDetailsMap = null;
        ArrayList reportList = null;
        Iterator iterator = dataObject.getRows("AUDComplianceReportMapping");
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long complianceId = (Long)row.get("COMPLIANCE_ID");
            String complianceName = (String)row.get("COMPLIANCE_NAME");
            Long reportId = (Long)row.get("AUDIT_REPORT_ID");
            String section = (String)row.get("SECTION");
            String description = rb.getString((String)row.get("DESCRIPTION"));
            complianceDetailsMap = complianceMap.get(complianceId) != null ? (HashMap)complianceMap.get(complianceId) : new HashMap();
            complianceDetailsMap.put("REPORT_CATEGORY_ID", complianceId);
            complianceDetailsMap.put("NAME", complianceName);
            reportList = complianceDetailsMap.get("CATEGORY_REPORTS") != null ? (ArrayList)complianceDetailsMap.get("CATEGORY_REPORTS") : new ArrayList();
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            Row reportRow = dataObject.getRow("AUDReports", criteria);
            HashMap<String, Object> reportMap = new HashMap<String, Object>();
            reportMap.put("SECTION", section);
            reportMap.put("DESCRIPTION", description);
            reportMap.put("AUDIT_REPORT_NAME", rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
            reportMap.put("AUDIT_REPORT_ID", (Long)reportRow.get("AUDIT_REPORT_ID"));
            reportMap.put("PRIORITY", reportRow.get("PRIORITY"));
            reportMap.put("REPORT_CATEGORY_TYPE", (Integer)reportRow.get("REPORT_CATEGORY_TYPE"));
            reportMap.put("IS_CUSTOMIZABLE", reportRow.get("IS_CUSTOMIZABLE"));
            if (isSchedulerInput) {
                reportMap.put("INPUT_PARAMS", AuditReportParamsAPI.getReportFormElements((Long)reportRow.get("AUDIT_REPORT_ID"), isSchedulerInput, rb));
            }
            reportList.add(reportMap);
            complianceDetailsMap.put("CATEGORY_REPORTS", reportList);
            complianceMap.put(complianceId, complianceDetailsMap);
        }
        return complianceMap;
    }

    private static LinkedHashMap getCumulativeReports(Long uiID, Integer categoryType, AdventNetResourceBundle rb, ArrayList actionList, boolean isSchedulerInput) throws Exception {
        Table reportsTable = Table.getTable((String)"AUDReports");
        SelectQueryImpl selectQuery = new SelectQueryImpl(reportsTable);
        selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_CUMULATIVE_REPORT"), (Object)true, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)categoryType, 0));
        criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8));
        selectQuery.setCriteria(criteria);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        LinkedHashMap cumulativeMap = new LinkedHashMap();
        ArrayList list = new ArrayList();
        HashMap<String, Object> cumulativeDetailsMap = new HashMap<String, Object>();
        Iterator iterator = dataObject.getRows("AUDReports");
        while (iterator.hasNext()) {
            HashMap<String, Object> reportMap = new HashMap<String, Object>();
            Row row = (Row)iterator.next();
            reportMap.put("AUDIT_REPORT_ID", (Long)row.get("AUDIT_REPORT_ID"));
            reportMap.put("AUDIT_REPORT_NAME", rb.getString((String)row.get("AUDIT_REPORT_NAME")));
            reportMap.put("REPORT_CATEGORY_TYPE", (Integer)row.get("REPORT_CATEGORY_TYPE"));
            list.add(reportMap);
            cumulativeDetailsMap.put("CATEGORY_REPORTS", list);
            cumulativeDetailsMap.put("NAME", rb.getString("adap.AUDReportUICategories.report_ui_category_name.CUMULATIVE_REPORTS"));
            cumulativeMap.put(uiID, cumulativeDetailsMap);
        }
        return cumulativeMap;
    }

    public static JSONArray getCategoryReports(Long reportCategoryId, Integer reportCategoryType, AdventNetResourceBundle rb, Long loginId, ArrayList actionList) {
        JSONArray reportList = new JSONArray();
        try {
            SelectQueryImpl selectQueryInner = new SelectQueryImpl(Table.getTable((String)"AUDReports"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)reportCategoryId, 0);
            if (!actionList.isEmpty()) {
                Criteria actionCrit = new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
                actionCrit = actionCrit.or(new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"), (Object)true, 0));
                criteria = criteria.and(actionCrit);
            }
            if (reportCategoryType != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"), (Object)reportCategoryType, 0));
            }
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"AUDReports", (String)"IS_PUBLIC"), (Object)true, 0));
            criteria = criteria.and(crit);
            selectQueryInner.setCriteria(criteria);
            selectQueryInner.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"*"));
            selectQueryInner.addSortColumn(new SortColumn(Column.getColumn((String)"AUDReports", (String)"PRIORITY"), true));
            DataObject dObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQueryInner);
            Iterator iterator2 = dObject.getRows("AUDReports", criteria);
            while (iterator2.hasNext()) {
                Row reportRow = (Row)iterator2.next();
                JSONObject reportDetailsMap = new JSONObject();
                reportDetailsMap.put("AUDIT_REPORT_NAME", (Object)rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("AUDIT_REPORT_ID", reportRow.get("AUDIT_REPORT_ID"));
                reportDetailsMap.put("PRIORITY", reportRow.get("PRIORITY"));
                reportDetailsMap.put("IS_CUSTOMIZABLE", reportRow.get("IS_CUSTOMIZABLE"));
                reportDetailsMap.put("name", (Object)rb.getString((String)reportRow.get("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("modelId", reportRow.get("AUDIT_REPORT_ID"));
                if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:8025").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:117").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:10718").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:70002").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:70003").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:71002").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                } else if (DBObjectUtil.getUVHValues("AUDReports", "AUDReports:audit_report_id:71003").equals(reportRow.get("AUDIT_REPORT_ID"))) {
                    reportDetailsMap.put("isNew", true);
                }
                if (loginId.longValue() == ((Long)reportRow.get("LOGIN_ID")).longValue()) {
                    reportDetailsMap.put("isCustomizable", reportRow.get("IS_CUSTOMIZABLE"));
                } else {
                    reportDetailsMap.put("isCustomizable", false);
                }
                if ((Integer)reportRow.get("REPORT_CATEGORY_TYPE") == 2) {
                    reportDetailsMap.put("routeName", (Object)"fileaudit.report");
                } else if ((Integer)reportRow.get("REPORT_CATEGORY_TYPE") == 3) {
                    reportDetailsMap.put("routeName", (Object)"serveraudit.report");
                } else {
                    reportDetailsMap.put("routeName", (Object)"reports.report");
                }
                reportList.put((Object)reportDetailsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getMonitorReports(Integer categoryType, Hashtable sqlCriteriaProps, AdventNetResourceBundle rb, Long loginId) {
        Connection connection = null;
        DataSet dataSet = null;
        JSONArray reportList = new JSONArray();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMonitorReportMap"));
            Join mrMapMonitorJoin = new Join("AUDMonitorReportMap", "AUDMonitor", new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
            Join monitorCategoryJoin = new Join("AUDMonitor", "AUDCategories", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            Join mrMapReportJoin = new Join("AUDMonitorReportMap", "AUDReports", new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            selectQuery.addJoin(mrMapMonitorJoin);
            selectQuery.addJoin(mrMapReportJoin);
            selectQuery.addJoin(monitorCategoryJoin);
            Criteria criteria = null;
            if (!sqlCriteriaProps.isEmpty()) {
                Enumeration enumeration = sqlCriteriaProps.keys();
                while (enumeration.hasMoreElements()) {
                    String keyString = (String)enumeration.nextElement();
                    Object value = sqlCriteriaProps.get(keyString);
                    if (criteria == null) {
                        criteria = new Criteria(Column.getColumn((String)"AUDMonitor", (String)keyString), value, 0);
                        continue;
                    }
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)keyString), value, 0));
                }
            }
            criteria = criteria == null ? new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0) : criteria.and(new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0));
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0));
            }
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"AUDIT_REPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_TYPE"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategories", (String)"PRIORITY_ID"), true));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                JSONObject reportDetailsMap = new JSONObject();
                reportDetailsMap.put("AUDIT_REPORT_NAME", (Object)rb.getString((String)dataSet.getValue("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("AUDIT_REPORT_ID", (Object)((Long)dataSet.getValue("AUDIT_REPORT_ID")));
                reportDetailsMap.put("DOMAIN_NAME", (Object)((String)dataSet.getValue("DOMAIN_NAME")));
                reportDetailsMap.put("CATEGORY_ID", (Object)((Long)dataSet.getValue("CATEGORY_ID")));
                reportDetailsMap.put("IS_CUSTOMIZABLE", dataSet.getValue("IS_CUSTOMIZABLE"));
                reportDetailsMap.put("name", (Object)rb.getString((String)dataSet.getValue("AUDIT_REPORT_NAME")));
                reportDetailsMap.put("modelId", (Object)((Long)dataSet.getValue("AUDIT_REPORT_ID")));
                if ((Integer)dataSet.getValue("REPORT_CATEGORY_TYPE") == 2) {
                    reportDetailsMap.put("routeName", (Object)"fileaudit.report");
                } else if ((Integer)dataSet.getValue("REPORT_CATEGORY_TYPE") == 3) {
                    reportDetailsMap.put("routeName", (Object)"serveraudit.report");
                } else {
                    reportDetailsMap.put("routeName", (Object)"reports.report");
                }
                reportList.put((Object)reportDetailsMap);
            }
            JSONArray reportList2 = AuditReportCategoryHandler.getCategoryReports(new Long(7L), categoryType, rb, loginId, new ArrayList());
            reportList = AuditReportCategoryHandler.concatArray(reportList, reportList2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return reportList;
    }

    private static JSONArray concatArray(JSONArray arr1, JSONArray arr2) throws JSONException {
        int i;
        JSONArray result = new JSONArray();
        for (i = 0; i < arr1.length(); ++i) {
            result.put(arr1.get(i));
        }
        for (i = 0; i < arr2.length(); ++i) {
            result.put(arr2.get(i));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getMonitorReports(Integer categoryType, Integer tabId, AdventNetResourceBundle rb, String delegatedDomain, Boolean isQuickLink) {
        Connection connection = null;
        DataSet dataSet = null;
        JSONArray reportList = new JSONArray();
        HashMap monitorReportMap = new HashMap();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMonitorReportMap"));
            Join mrMapMonitorJoin = new Join("AUDMonitorReportMap", "AUDMonitor", new String[]{"MONITOR_ID"}, new String[]{"MONITOR_ID"}, 2);
            Join monitorCategoryJoin = new Join("AUDMonitor", "AUDCategories", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            Join mrMapReportJoin = new Join("AUDMonitorReportMap", "AUDReports", new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            selectQuery.addJoin(mrMapMonitorJoin);
            selectQuery.addJoin(mrMapReportJoin);
            selectQuery.addJoin(monitorCategoryJoin);
            Criteria criteria = null;
            if (categoryType != null) {
                criteria = new Criteria(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_TYPE"), (Object)categoryType, 0);
            }
            if (delegatedDomain != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"), (Object)delegatedDomain.split(","), 8));
            }
            if (!LicenseUtil.isProfEdn()) {
                criteria = criteria != null ? criteria.and(new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0)) : new Criteria(Column.getColumn((String)"AUDReports", (String)"LICENSE_TYPE"), (Object)1, 0);
            }
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"AUDIT_REPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitorReportMap", (String)"MONITOR_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"DOMAIN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMonitor", (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDCategories", (String)"CATEGORY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReports", (String)"IS_CUSTOMIZABLE"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AUDCategories", (String)"PRIORITY_ID"), true));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                LinkedHashMap domainMap = (LinkedHashMap)monitorReportMap.get(domainName);
                if (domainMap == null) {
                    domainMap = new LinkedHashMap();
                }
                String categoryName = rb.getString((String)dataSet.getValue("CATEGORY_NAME"));
                Long categoryId = (Long)dataSet.getValue("CATEGORY_ID");
                String categoryNameIdToken = categoryId + ";;" + categoryName;
                ArrayList categoryReports = (ArrayList)domainMap.get(categoryNameIdToken);
                if (categoryReports == null) {
                    categoryReports = new ArrayList();
                }
                HashMap<String, Object> reportMap = new HashMap<String, Object>();
                reportMap.put("AUDIT_REPORT_ID", (Long)dataSet.getValue("AUDIT_REPORT_ID"));
                reportMap.put("MONITOR_ID", (Long)dataSet.getValue("MONITOR_ID"));
                reportMap.put("AUDIT_REPORT_NAME", rb.getString((String)dataSet.getValue("AUDIT_REPORT_NAME")));
                reportMap.put("IS_CUSTOMIZABLE", dataSet.getValue("IS_CUSTOMIZABLE"));
                categoryReports.add(reportMap);
                domainMap.put(categoryNameIdToken, categoryReports);
                monitorReportMap.put(domainName, domainMap);
            }
            if (isQuickLink.booleanValue()) {
                reportList.put(monitorReportMap);
            } else {
                for (Map.Entry pair : monitorReportMap.entrySet()) {
                    JSONObject m1 = new JSONObject();
                    m1.put("name", pair.getKey());
                    m1.put("hasDropdown", true);
                    JSONArray m1List = new JSONArray();
                    HashMap t1 = (HashMap)pair.getValue();
                    for (Map.Entry entry : t1.entrySet()) {
                        String key = (String)entry.getKey();
                        String[] a = key.split(";;");
                        JSONObject m2 = new JSONObject();
                        m2.put("name", (Object)a[1]);
                        m2.put("modelId", (Object)a[0]);
                        m2.put("hasDropdown", true);
                        JSONArray m2List = new JSONArray();
                        ArrayList value = (ArrayList)entry.getValue();
                        for (int i = 0; i < value.size(); ++i) {
                            HashMap t2 = (HashMap)value.get(i);
                            JSONObject m3 = new JSONObject();
                            m3.put("name", t2.get("AUDIT_REPORT_NAME"));
                            m3.put("modelId", t2.get("AUDIT_REPORT_ID"));
                            if (tabId == 2) {
                                m3.put("routeName", (Object)"reports.report");
                            } else if (tabId == 3) {
                                m3.put("routeName", (Object)"fileaudit.report");
                            } else if (tabId == 4) {
                                m3.put("routeName", (Object)"serveraudit.report");
                            }
                            m2List.put((Object)m3);
                        }
                        m2.put("list", (Object)m2List);
                        m1List.put((Object)m2);
                    }
                    m1.put("list", (Object)m1List);
                    reportList.put((Object)m1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return reportList;
    }
}

