/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AuditReportHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static Long saveNewReportDetails(HashMap reportDetailsMap, HashMap categoryElementColumnMap) {
        Long reportIdLong = null;
        try {
            DataObject reportDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            HashMap audReportsMap = (HashMap)reportDetailsMap.get("AUDReports");
            Row audReportsRow = new Row("AUDReports");
            UniqueValueHolder reportId = (UniqueValueHolder)audReportsRow.get("AUDIT_REPORT_ID");
            for (String columnName : audReportsMap.keySet()) {
                Object value = audReportsMap.get(columnName);
                audReportsRow.set(columnName, value);
            }
            reportDO.addRow(audReportsRow);
            ArrayList queryList = (ArrayList)reportDetailsMap.get("AUDSQLQuery");
            for (int size = 0; size < queryList.size(); ++size) {
                HashMap graphMap;
                Object value;
                HashMap sqlQueryMap = (HashMap)queryList.get(size);
                HashMap cvConfigMap = (HashMap)sqlQueryMap.get("AUDCVConfig");
                Row cvConfigRow = new Row("AUDCVConfig");
                UniqueValueHolder cvId = (UniqueValueHolder)cvConfigRow.get("CV_ID");
                for (String columnName : cvConfigMap.keySet()) {
                    cvConfigRow.set(columnName, cvConfigMap.get(columnName));
                }
                reportDO.addRow(cvConfigRow);
                Row sqlQueryRow = new Row("AUDSQLQuery");
                UniqueValueHolder queryId = (UniqueValueHolder)sqlQueryRow.get("QUERY_ID");
                sqlQueryRow.set("SQL_STRING", sqlQueryMap.get("SQL_STRING"));
                sqlQueryRow.set("COUNT_SQL_STRING", sqlQueryMap.get("COUNT_SQL_STRING"));
                sqlQueryRow.set("GROUPBYUSED", sqlQueryMap.get("GROUPBYUSED"));
                sqlQueryRow.set("UNION_USED", sqlQueryMap.get("UNION_USED"));
                if (sqlQueryMap.get("GROUP_BY") != null) {
                    sqlQueryRow.set("GROUP_BY", sqlQueryMap.get("GROUP_BY"));
                }
                sqlQueryRow.set("CV_ID", (Object)cvId);
                reportDO.addRow(sqlQueryRow);
                ArrayList unionSqlQueryList = (ArrayList)sqlQueryMap.get("AUDUnionQuery");
                if (unionSqlQueryList.size() > 0) {
                    for (int i = 0; i < unionSqlQueryList.size(); ++i) {
                        HashMap unionSqlQueryMap = (HashMap)unionSqlQueryList.get(i);
                        Row unionQueryRow = new Row("AUDUnionQuery");
                        for (String columnName : unionSqlQueryMap.keySet()) {
                            value = unionSqlQueryMap.get(columnName);
                            unionQueryRow.set(columnName, value);
                        }
                        unionQueryRow.set("QUERY_ID", (Object)queryId);
                        reportDO.addRow(unionQueryRow);
                    }
                }
                if ((graphMap = (HashMap)sqlQueryMap.get("AUDGraphOptions")) != null) {
                    Row graphRow = new Row("AUDGraphOptions");
                    for (String columnName : graphMap.keySet()) {
                        graphRow.set(columnName, graphMap.get(columnName));
                    }
                    graphRow.set("CV_ID", (Object)cvId);
                    reportDO.addRow(graphRow);
                }
                HashMap viewConfigMap = (HashMap)reportDetailsMap.get("AUDTableViewConfig");
                Row viewConfigRow = new Row("AUDTableViewConfig");
                for (String columnName : viewConfigMap.keySet()) {
                    value = viewConfigMap.get(columnName);
                    viewConfigRow.set(columnName, value);
                }
                viewConfigRow.set("CV_ID", (Object)cvId);
                reportDO.addRow(viewConfigRow);
                Row mappingRow = new Row("AUDReportCVMapping");
                mappingRow.set("AUDIT_REPORT_ID", (Object)reportId);
                mappingRow.set("CV_ID", (Object)cvId);
                reportDO.addRow(mappingRow);
                HashMap columnMap = (HashMap)sqlQueryMap.get("AUDColumnConfiguration");
                Set columnSet = columnMap.keySet();
                for (Object columnId : columnSet) {
                    HashMap columnDetailsMap = (HashMap)columnMap.get(columnId);
                    Row columnRow = new Row("AUDColumnConfiguration");
                    String columnName = (String)columnDetailsMap.get("COLUMN_NAME");
                    columnRow.set("CV_ID", (Object)cvId);
                    columnRow.set("COLUMNINDEX", columnDetailsMap.get("PRIORITY_ID") != null ? columnDetailsMap.get("PRIORITY_ID") : columnDetailsMap.get("COLUMNINDEX"));
                    columnRow.set("DEFAULTCOLUMNINDEX", columnDetailsMap.get("PRIORITY_ID") != null ? columnDetailsMap.get("PRIORITY_ID") : columnDetailsMap.get("COLUMNINDEX"));
                    columnRow.set("COLUMNALIAS", (Object)(columnName != null ? columnName : columnDetailsMap.get("COLUMNALIAS")));
                    columnRow.set("SEARCHENABLED", columnDetailsMap.get("SEARCHENABLED"));
                    columnRow.set("DISPLAYNAME", (Object)((String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") != null ? (String)columnDetailsMap.get("COLUMN_DISPLAY_NAME") : rb.getString((String)columnDetailsMap.get("DISPLAYNAME"))));
                    columnRow.set("SORTENABLED", columnDetailsMap.get("SORTENABLED"));
                    columnRow.set("VISIBLE", columnDetailsMap.get("VISIBLE"));
                    columnRow.set("DEFAULTVISIBLE", columnDetailsMap.get("VISIBLE"));
                    columnRow.set("TABLEALIAS", columnDetailsMap.get("TABLE_NAME") != null ? columnDetailsMap.get("TABLE_NAME") : columnDetailsMap.get("TABLEALIAS"));
                    columnRow.set("TRANSFORMER", columnDetailsMap.get("TRANSFORMER"));
                    if (columnDetailsMap.get("DATE_FORMAT") != null) {
                        columnRow.set("DATE_FORMAT", columnDetailsMap.get("DATE_FORMAT"));
                    }
                    reportDO.addRow(columnRow);
                }
            }
            ArrayList idList = (ArrayList)categoryElementColumnMap.get("ELEMENT_ID");
            ArrayList priorityList = (ArrayList)categoryElementColumnMap.get("PRIORITY_ID");
            ArrayList isScheInput = categoryElementColumnMap.get("IS_SCHEDULER_INPUT") != null ? (ArrayList)categoryElementColumnMap.get("IS_SCHEDULER_INPUT") : new ArrayList();
            for (int i = 0; i < idList.size(); ++i) {
                Row elementMappingRow = new Row("AUDReportElementMap");
                elementMappingRow.set("AUDIT_REPORT_ID", (Object)reportId);
                elementMappingRow.set("ELEMENT_ID", (Object)((Long)idList.get(i)));
                elementMappingRow.set("PRIORITY_ID", (Object)((Long)priorityList.get(i)));
                if (!isScheInput.isEmpty()) {
                    elementMappingRow.set("IS_SCHEDULER_INPUT", (Object)((Boolean)isScheInput.get(i)));
                }
                reportDO.addRow(elementMappingRow);
            }
            CommonUtil.getPersistence(new boolean[0]).add(reportDO);
            reportIdLong = (Long)reportId.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportIdLong;
    }

    public static boolean deleteReports(List reportList) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportList, 8);
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }
}

