/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class AuditReportParamsAPI {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static final DNSResolver DNS_RESOLVER = DNSResolver.getInstance();
    private static String dbName = CommonUtil.getDBServerName();

    public static ArrayList getReportFormElements(Long reportId, boolean isSchedulerInput, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        return AuditReportParamsAPI.getReportFormElements(reportId, isSchedulerInput, rb);
    }

    public static ArrayList getReportFormElements(Long reportId, boolean isSchedulerInput) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        return AuditReportParamsAPI.getReportFormElements(reportId, isSchedulerInput, rb);
    }

    public static ArrayList getReportFormElements(Long reportId, boolean isSchedulerInput, AdventNetResourceBundle rb) {
        ArrayList elementList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"IS_SCHEDULER_INPUT"), (Object)isSchedulerInput, 0));
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AUDReportElementMap");
            tableList.add("AudElement");
            tableList.add("AudElementAttr");
            tableList.add("AudSelectElementAttr");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AudSelectElementAttr");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, leftJoinList, criteria);
            AuditReportParamsAPI.setElementsList(elementList, dataObject, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elementList;
    }

    private static void setElementsList(ArrayList elementList, DataObject dataObject, AdventNetResourceBundle rb) throws Exception {
        if (dataObject.size("AudElement") > 0) {
            Iterator iterator = dataObject.getRows("AudElement");
            while (iterator.hasNext()) {
                HashMap<String, Object> elementMap = new HashMap<String, Object>();
                Row elementRow = (Row)iterator.next();
                Long elementId = (Long)elementRow.get("ELEMENT_ID");
                elementMap.put("elementId", elementId);
                elementMap.put("elementType", (String)elementRow.get("TYPE"));
                elementMap.put("UICreator", (String)elementRow.get("UICREATOR"));
                elementMap.put("new_row", (Boolean)elementRow.get("NEW_ROW"));
                elementMap.put("inputType", (String)elementRow.get("INPUT_TYPE"));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"ELEMENT_ID"), (Object)elementId, 0);
                Row mappingRow = dataObject.getRow("AUDReportElementMap", crit);
                if (mappingRow != null) {
                    elementMap.put("priorityId", (Long)mappingRow.get("PRIORITY_ID"));
                }
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AudElementAttr", (String)"ELEMENT_ID"), (Object)elementId, 0);
                Properties attributeProps = new Properties();
                Iterator iterator2 = dataObject.getRows("AudElementAttr", criteria2);
                while (iterator2.hasNext()) {
                    Row attributeRow = (Row)iterator2.next();
                    attributeProps.setProperty((String)attributeRow.get("ATTRNAME"), rb.getString((String)attributeRow.get("ATTRVALUE")));
                }
                Criteria criteria3 = new Criteria(Column.getColumn((String)"AudSelectElementAttr", (String)"ELEMENT_ID"), (Object)elementId, 0);
                SortColumn sortColumn = new SortColumn(Column.getColumn((String)"AudSelectElementAttr", (String)"PRIORITY_ID"), true);
                ArrayList<String> serverValues = new ArrayList<String>();
                ArrayList<String> clientValues = new ArrayList<String>();
                try {
                    SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"AudSelectElementAttr"));
                    selQuery.setCriteria(criteria3);
                    selQuery.addSortColumn(sortColumn);
                    selQuery.addSelectColumn(Column.getColumn((String)"AudSelectElementAttr", (String)"*"));
                    DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
                    Iterator ite = dataObj.getRows("AudSelectElementAttr");
                    while (ite.hasNext()) {
                        Row elementRows = (Row)ite.next();
                        serverValues.add((String)elementRows.get("SERVER_VALUE"));
                        clientValues.add(rb.getString((String)elementRows.get("CLIENT_VALUE")));
                    }
                    String name = (String)elementRow.get("NAME");
                    String defValue = (String)elementRow.get("DEFAULT_INPUT_VALUE");
                    AuditReportAPI.getInstance();
                    DataObject dObj = AuditReportAPI.getCustomPeriodDO();
                    if (name.equalsIgnoreCase("inputDays") && dObj.size("AUDCustomPeriod") > 0 && !defValue.equals("realtime")) {
                        serverValues.add("-----");
                        clientValues.add("-----");
                        Iterator cpIter = dObj.getRows("AUDCustomPeriod");
                        while (cpIter.hasNext()) {
                            Row row = (Row)cpIter.next();
                            serverValues.add((String)row.get("SERVER_NAME"));
                            clientValues.add((String)row.get("CLIENT_NAME"));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (serverValues.size() > 0) {
                    attributeProps.put("serverValues", serverValues);
                    attributeProps.put("clientValues", clientValues);
                }
                elementMap.put("attributeProps", attributeProps);
                elementList.add(elementMap);
            }
        }
    }

    public static ArrayList getCustomReportCriteriaElements(AdventNetResourceBundle rb) {
        ArrayList elementList = new ArrayList();
        try {
            String[] elementIdUVH = new String[]{"AudElement:element_id:501", "AudElement:element_id:503", "AudElement:element_id:504", "AudElement:element_id:505", "AudElement:element_id:506", "AudElement:element_id:507", "AudElement:element_id:508", "AudElement:element_id:509", "AudElement:element_id:510", "AudElement:element_id:511", "AudElement:element_id:512", "AudElement:element_id:513", "AudElement:element_id:517", "AudElement:element_id:518"};
            Long[] elementIds = DBObjectUtil.getUVHValues("AudElement", elementIdUVH);
            Criteria crit = new Criteria(Column.getColumn((String)"AudElement", (String)"ELEMENT_ID"), (Object)elementIds, 8);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AudElement");
            tableList.add("AudElementAttr");
            tableList.add("AudSelectElementAttr");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AudSelectElementAttr");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, leftJoinList, crit);
            AuditReportParamsAPI.setElementsList(elementList, dataObject, rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return elementList;
    }

    public static ArrayList getInputParams(Long reportId) {
        ArrayList inputList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDReportElementMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
            criteria = criteria.and(Column.getColumn((String)"AudElement", (String)"IS_INPUT_ELEMENT"), (Object)1, 0);
            Table baseTable = Table.getTable((String)"AudElement");
            Table refTable = Table.getTable((String)"AUDReportElementMap");
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, refTable, new String[]{"ELEMENT_ID"}, new String[]{"ELEMENT_ID"}, 2);
            selectQuery.addSelectColumn(Column.getColumn((String)"AudElement", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDReportElementMap", (String)"*"));
            selectQuery.addJoin(join);
            selectQuery.setCriteria(criteria);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (dataobject.size("AudElement") > 0) {
                Iterator iter2 = dataobject.getRows("AUDReportElementMap");
                Iterator iterator = dataobject.getRows("AudElement");
                while (iterator.hasNext()) {
                    HashMap<String, String> inputMap = new HashMap<String, String>();
                    Row inputRow = (Row)iterator.next();
                    Row mappingRow = (Row)iter2.next();
                    String defaultValue = (String)mappingRow.get("INPUT_VALUE");
                    if (defaultValue == null || defaultValue.trim().equals("null") || defaultValue.trim().equals("")) {
                        defaultValue = (String)inputRow.get("DEFAULT_INPUT_VALUE");
                    }
                    inputMap.put("name", (String)inputRow.get("NAME"));
                    inputMap.put("defaultValue", defaultValue);
                    inputMap.put("inputType", (String)inputRow.get("INPUT_TYPE"));
                    inputList.add(inputMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return inputList;
    }

    public static HashMap<String, Object> getInputParamsValues(HashMap inputParams, Long reportId) throws Exception {
        String objectClass;
        HashMap<String, Object> inputParamsMap = new HashMap<String, Object>();
        String domainName = (String)inputParams.get("domainName");
        if (domainName != null) {
            inputParamsMap.put("domainFlatName", DomainDetailsAPI.getDomainFlatName(domainName, true));
            inputParamsMap.put("domainDNSName", DomainDetailsAPI.getDomainDNSName(domainName));
            inputParamsMap.put("RDNC", DomainDetailsAPI.getRootDomainNamingContext(domainName));
        }
        AuditReportParamsAPI.setTimePeriod(inputParams, inputParamsMap);
        String allObjectSelected = (String)inputParams.get("allObjectSelected");
        if (allObjectSelected != null) {
            inputParamsMap.put("allObjectSelected", inputParams.get("allObjectSelected"));
        }
        ArrayList guidList = (ArrayList)inputParams.get("object_guid");
        if (inputParams.get("printer_name") != null) {
            AuditReportParamsAPI.getObjectValues(inputParams, inputParamsMap, reportId);
        }
        if (guidList != null && !guidList.isEmpty()) {
            AuditReportParamsAPI.getObjectValues(inputParams, inputParamsMap, reportId);
        }
        if ((objectClass = (String)inputParams.get("objectClass")) != null) {
            inputParamsMap.put("objectClass", objectClass);
        }
        return inputParamsMap;
    }

    public static void setTimePeriod(HashMap inputParams, HashMap inputParamsMap) throws Exception {
        String inputDays = (String)inputParams.get("inputDays");
        if (inputDays != null && inputDays.equals("customPeriod")) {
            Long from = TimeUtil.getTimePeriod((String)inputParams.get("startTime"), (String)inputParams.get("startHour"));
            Long to = TimeUtil.getTimePeriod((String)inputParams.get("endTime"), (String)inputParams.get("endHour"));
            inputParamsMap.put("FROM", from.toString());
            inputParamsMap.put("TO", to.toString());
        } else if (inputDays != null && inputDays.equals("Last_n_period")) {
            Long last_n = Long.valueOf((String)inputParams.get("last_n"));
            int period = Integer.parseInt((String)inputParams.get("time_period"));
            HashMap periodMap = TimeUtil.getLastNPeriod(period, last_n);
            inputParamsMap.put("FROM", periodMap.get("FROM").toString());
            inputParamsMap.put("TO", periodMap.get("TO").toString());
        } else if (inputDays != null && inputDays.startsWith("UD_")) {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDCustomPeriod", (String)"SERVER_NAME"), (Object)inputDays, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDCustomPeriod", crit);
            Row row = dataObject.getFirstRow("AUDCustomPeriod");
            Long from = TimeUtil.getTimePeriod((String)row.get("START_TIME"), (String)row.get("START_HOUR"));
            Long to = TimeUtil.getTimePeriod((String)row.get("END_TIME"), (String)row.get("END_HOUR"));
            inputParamsMap.put("FROM", from.toString());
            inputParamsMap.put("TO", to.toString());
        } else if (inputDays == null || inputDays.equals("realtime")) {
            reportLogger.log(Level.FINE, "No Need to get the FROM and TO values");
        } else {
            HashMap<String, Object> periodMap = TimeUtil.getTimePeriod(inputDays);
            inputParamsMap.put("FROM", periodMap.get("FROM").toString());
            inputParamsMap.put("TO", periodMap.get("TO").toString());
        }
    }

    public static void getObjectValues(HashMap inputParams, HashMap inputParamsMap, Long reportId) throws Exception {
        HashMap reportMap = AuditReportAPI.getInstance().getReportDetailsMap(reportId);
        Long categoryId = (Long)reportMap.get("REPORT_CATEGORY_ID");
        AuditReportParamsAPI.getObjectValues(categoryId, inputParams, inputParamsMap);
    }

    public static void getObjectValues(Long categoryId, HashMap inputParams, HashMap inputParamsMap) throws Exception {
        String clientMCName = "''";
        String objectClass = (String)inputParams.get("objectClass");
        ArrayList guidList = (ArrayList)inputParams.get("object_guid");
        if (guidList == null && inputParams.get("printer_name") != null) {
            guidList = (ArrayList)inputParams.get("printer_name");
        }
        ArrayList selectedObjList = new ArrayList();
        if (!guidList.isEmpty()) {
            String objectName = "allobjects";
            String objectSIDStr = "allobjects";
            if (!((String)guidList.get(0)).equals("allobjects")) {
                Iterator iter;
                clientMCName = "";
                String guidStr = "";
                String objectSID = "";
                objectSIDStr = "";
                String objectDNSName = "";
                objectName = "";
                boolean isSidNeeded = false;
                boolean isComputer = false;
                if (objectClass.equalsIgnoreCase("user") || objectClass.equalsIgnoreCase("group") || objectClass.equalsIgnoreCase("computer")) {
                    isSidNeeded = true;
                    if (objectClass.equalsIgnoreCase("computer")) {
                        isComputer = true;
                    }
                }
                if ((iter = DirectoryObjectAPI.getInstance().getObjectRows(null, guidList, objectClass)) != null) {
                    while (iter.hasNext()) {
                        HashMap<String, String> selectedObj = new HashMap<String, String>();
                        Row objectRow = (Row)iter.next();
                        String objectName1 = null;
                        String objectGuid1 = null;
                        if (!"".equals(objectName)) {
                            objectName = objectName + " , ";
                            objectSID = objectSID + ",";
                            objectSIDStr = objectSIDStr + ",";
                            guidStr = guidStr + ",";
                            objectDNSName = objectDNSName + ",";
                            if (categoryId == 2L) {
                                clientMCName = clientMCName + ",";
                            }
                        }
                        if (objectClass.equalsIgnoreCase("user")) {
                            objectName = objectName + "'" + EscapeUtil.escSplCharsAsSQLForLike((String)objectRow.get("SAM_ACCOUNT_NAME")) + "'";
                            objectName1 = EscapeUtil.escSplCharsAsSQLForLike((String)objectRow.get("SAM_ACCOUNT_NAME"));
                        } else if (objectClass.equalsIgnoreCase("group")) {
                            objectName = objectName + "'" + EscapeUtil.escSplCharsAsSQLForLike((String)objectRow.get("NAME")) + "'";
                            objectName1 = EscapeUtil.escSplCharsAsSQLForLike((String)objectRow.get("NAME"));
                        } else if (objectClass.equalsIgnoreCase("share")) {
                            objectName = objectName + (String)objectRow.get("LOCATION");
                            objectName1 = (String)objectRow.get("LOCATION");
                        } else if (objectClass.equalsIgnoreCase("printer")) {
                            objectName = objectName + "'";
                            String tempPrinterName = ((String)objectRow.get("PRINTER_NAME")).replace("\\\\", "");
                            if (dbName.equalsIgnoreCase("mysql")) {
                                tempPrinterName = tempPrinterName.replace("\\", "\\\\");
                            }
                            objectName = objectName + tempPrinterName + "'";
                            objectName1 = (String)objectRow.get("PRINTER_NAME");
                        } else {
                            objectName = objectName + "'" + (String)objectRow.get("NAME") + "'";
                            objectName1 = (String)objectRow.get("NAME");
                        }
                        if (isSidNeeded) {
                            objectSIDStr = objectSIDStr + "'" + (String)objectRow.get("SID_STRING") + "'";
                            objectSID = objectSID + "'%{" + (String)objectRow.get("SID_STRING") + "}'";
                            objectGuid1 = (String)objectRow.get("OBJECT_GUID");
                            if (isComputer) {
                                objectDNSName = objectDNSName + "'" + (String)objectRow.get("DNS_NAME") + "'";
                                if (categoryId == 2L) {
                                    try {
                                        ArrayList<String> list = DNS_RESOLVER.getHostName((String)objectRow.get("NAME"));
                                        clientMCName = clientMCName + "'" + list.get(1) + "'";
                                    }
                                    catch (UnknownHostException ex) {
                                        clientMCName = clientMCName + "'" + (String)objectRow.get("NAME") + "'";
                                    }
                                }
                            }
                        } else if (objectClass.equalsIgnoreCase("share")) {
                            guidStr = guidStr + "'%" + (String)objectRow.get("LOCATION") + "'";
                            objectGuid1 = (String)objectRow.get("LOCATION");
                        } else if (objectClass.equalsIgnoreCase("printer")) {
                            guidStr = guidStr + "'%" + (String)objectRow.get("PRINTER_NAME") + "'";
                            objectGuid1 = (String)objectRow.get("PRINTER_NAME");
                        } else {
                            guidStr = guidStr + "'%" + (String)objectRow.get("OBJECT_GUID") + "'";
                            objectGuid1 = (String)objectRow.get("OBJECT_GUID");
                        }
                        selectedObj.put("name", objectName1);
                        selectedObj.put("id", objectGuid1);
                        selectedObjList.add(selectedObj);
                    }
                } else if (objectClass.equalsIgnoreCase("share")) {
                    objectName = objectName + (String)guidList.get(0);
                    guidStr = guidStr + "'%" + (String)guidList.get(0) + "'";
                }
                if (isSidNeeded) {
                    inputParamsMap.put("objectSID", objectSID);
                    inputParamsMap.put("objectSIDStr", objectSIDStr);
                    if (isComputer) {
                        inputParamsMap.put("objectDNSName", objectDNSName);
                        inputParamsMap.put("client_mc_name", clientMCName);
                    }
                } else {
                    inputParamsMap.put("guidStr", guidStr);
                }
            }
            inputParams.put("objectName", objectName);
            inputParamsMap.put("objectName", objectName.toLowerCase());
            inputParams.put("selectedObj", selectedObjList);
            if (objectClass.equalsIgnoreCase("share")) {
                objectName = EscapeUtil.escSplCharsAsSQLForLike(objectName);
                inputParamsMap.put("objectName", objectName.toLowerCase());
            }
        }
    }

    public static ArrayList getPrintersList(String printerNames) {
        ArrayList<String> printerList = new ArrayList<String>();
        try {
            String[] printerNameArray = printerNames.split(",");
            for (int i = 0; i < printerNameArray.length && !printerNames.equalsIgnoreCase(""); ++i) {
                printerList.add(printerNameArray[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return printerList;
    }
}

