/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.reports.customreport.MatrixExportUtil;
import com.adventnet.sym.adsm.auditing.server.reports.subReport.ReportJRDataSource;
import com.adventnet.sym.adsm.auditing.server.useractivity.UserActivityUtil;
import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.export.JRDesignUtil;
import com.adventnet.sym.adsm.common.server.export.JRUtil;
import com.adventnet.sym.adsm.common.server.export.ReportExporter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.model.ReportInterface;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.sql.ADAPGraphSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ExportUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    protected static Logger logger = Logger.getLogger("Logger");
    private static String virtualizerDirName = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "tempreport";
    public static String font1 = "";

    public static ArrayList exportReport(String storagePath, String domainName, String inputDays, String fileFormat, String business, DataObject dataObject, Boolean isReportsEmpty, Boolean isSingleFolder, String schedulerName) throws Exception {
        ArrayList<Object> emptyFileList = new ArrayList<Object>();
        ArrayList<String> filesList = new ArrayList<String>();
        if (!dataObject.isEmpty()) {
            Row audSchedulerRow = dataObject.getFirstRow("AUDScheduler");
            if (dataObject.size("AUDReportSchedulerMap") > 0) {
                int files_count = 0;
                int index = 1;
                emptyFileList.add(0, files_count);
                Iterator reportIter = dataObject.getRows("AUDReportSchedulerMap");
                while (reportIter.hasNext()) {
                    Row reportRow = (Row)reportIter.next();
                    Long reportId = (Long)reportRow.get("AUDIT_REPORT_ID");
                    reportLogger.log(Level.INFO, "the exporting report's reportId is " + reportId);
                    HashMap<String, Object> inputParams = new HashMap<String, Object>();
                    inputParams.put("domainName", domainName);
                    inputParams.put("inputDays", inputDays);
                    Criteria crit = new Criteria(Column.getColumn((String)"AUDSchedulerInputMap", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                    ArrayList<String> inputList = null;
                    boolean isPrinterObject = false;
                    Iterator inputIter = dataObject.getRows("AUDSchedulerInputMap", crit);
                    while (inputIter.hasNext()) {
                        Row inputRow = (Row)inputIter.next();
                        String guidStr = (String)inputRow.get("INPUT_PARAM");
                        if (inputParams.get(guidStr) == null) {
                            inputList = new ArrayList<String>();
                        }
                        inputList.add((String)inputRow.get("INPUT_PARAM_VALUE"));
                        if (((String)inputRow.get("INPUT_PARAM_VALUE")).equalsIgnoreCase("allobjects")) {
                            inputParams.put("allObjectSelected", "true");
                        }
                        inputParams.put(guidStr, inputList);
                        String objectClass = (String)inputRow.get("OBJECT_CLASS");
                        inputParams.put("objectClass", inputRow.get("OBJECT_CLASS"));
                        if (objectClass == null || !objectClass.equalsIgnoreCase("printer")) continue;
                        isPrinterObject = true;
                    }
                    reportLogger.log(Level.FINE, "the inputParams are " + inputParams);
                    HashMap inputParamsMap = AuditReportParamsAPI.getInputParamsValues(inputParams, reportId);
                    String objectName = (String)inputParamsMap.get("objectName");
                    if (isPrinterObject && CommonUtil.getDBServerName().equalsIgnoreCase("mysql")) {
                        objectName = objectName != null ? objectName.replace("\\", "\\\\") : objectName;
                    }
                    objectName = objectName != null ? PrintHandler.escapeRevert(objectName) : objectName;
                    inputParamsMap.put((String)"objectName", (Object)objectName);
                    inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputParams, inputParamsMap, reportId);
                    reportLogger.log(Level.INFO, "the inputParamsMap are " + inputParamsMap);
                    HashMap reportMap = AuditReportAPI.getInstance().getReportDetailsMap(reportId);
                    ArrayList<HashMap<String, Object>> countResultList = AUDCustomViewAPI.getInstance().getReportCVIdArray(reportId);
                    HashMap<String, Object> tableViewConfig = AuditReportAPI.getInstance().getTableViewConfig(reportId);
                    HashMap<String, String> addionalSQLPropsMap = new HashMap<String, String>();
                    addionalSQLPropsMap.put("sortColumn", (String)tableViewConfig.get("SORTCOLUMN"));
                    addionalSQLPropsMap.put("sortOrder", (String)tableViewConfig.get("SORTORDER"));
                    for (int cvIdCount = 0; cvIdCount < countResultList.size(); ++cvIdCount) {
                        String tileName;
                        String fromTime;
                        String reportName = rb.getString((String)reportMap.get("TITLE"));
                        HashMap<String, Object> cvIdMap = countResultList.get(cvIdCount);
                        Long cvId = (Long)cvIdMap.get("cvID");
                        reportLogger.log(Level.INFO, "cvId is " + cvId);
                        if (countResultList.size() > 1) {
                            reportName = reportName + "-" + rb.getString((String)cvIdMap.get("name"));
                        }
                        reportName = isSingleFolder != false ? reportName + "_" + schedulerName.replace(" ", "") + "_" + new SimpleDateFormat("MMM-dd-yyyy-HH-mm-s").format(new Date(System.currentTimeMillis())) : reportName;
                        boolean searchBusinessCondition = false;
                        String searchCriteria = null;
                        HashMap<String, String> businessAlertValues = BusinessServerSettings.getBusinessHourSettings();
                        String string = fromTime = businessAlertValues.isEmpty() ? "" : businessAlertValues.get("FromTime");
                        if (business != null && !fromTime.equalsIgnoreCase("")) {
                            if (business.equalsIgnoreCase("nonbussiness")) {
                                business = "nonbusiness";
                            }
                            if (business.equalsIgnoreCase("bussiness")) {
                                business = "business";
                            }
                            searchBusinessCondition = business.equalsIgnoreCase("business") || business.equalsIgnoreCase("nonbusiness");
                            searchCriteria = searchBusinessCondition ? business : null;
                        }
                        int isEmpty = (tileName = (String)reportMap.get("TILE_NAME")).equalsIgnoreCase("matrix") ? MatrixExportUtil.exportReport(storagePath, (Long)reportRow.get("SCHEDULE_ID"), reportId, inputParamsMap, searchCriteria, addionalSQLPropsMap, cvId, fileFormat, new Long(1L), "simple") : ExportUtil.exportReport(cvId, inputParamsMap, addionalSQLPropsMap, searchCriteria, domainName, reportName, reportMap, fileFormat, storagePath, isReportsEmpty);
                        filesList.add(reportName.replaceAll(" ", "_"));
                        ++files_count;
                        if (isEmpty != 1) continue;
                        emptyFileList.add(index, reportName);
                        ++index;
                    }
                }
                emptyFileList.remove(0);
                emptyFileList.add(0, files_count);
                emptyFileList.add(emptyFileList.size(), filesList);
            }
        }
        return emptyFileList;
    }

    public static void exportReport(Long cvId, HashMap inputParamsMap, HashMap additionalSQLPropsMap, String searchCriteria, String domainName, String reportName, HashMap reportMap, String fileFormat, String storagePath) throws Exception {
        ExportUtil.exportReport(cvId, inputParamsMap, additionalSQLPropsMap, searchCriteria, domainName, reportName, reportMap, fileFormat, storagePath, (Boolean)false);
    }

    public static int exportReport(Long cvId, HashMap inputParamsMap, HashMap additionalSQLPropsMap, String searchCriteria, String domainName, String reportName, HashMap reportMap, String fileFormat, String storagePath, Boolean isReportsEmpty) throws Exception {
        ArrayList jasperPrintList = new ArrayList();
        try {
            String reportFileName = "UserDetails.xml";
            if (reportMap.get("JASPER_NAME") != null) {
                reportFileName = (String)reportMap.get("JASPER_NAME");
            }
            ArrayList resultPrintHashMapList = new ArrayList();
            resultPrintHashMapList = cvId != null && cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15050")) ? ExportUtil.exportScheduleSubreport(cvId, reportMap, domainName, searchCriteria, fileFormat, inputParamsMap, additionalSQLPropsMap, rb.getString((String)reportMap.get("DESCRIPTION"))) : ExportUtil.exportReport(cvId, rb.getString((String)reportMap.get("TITLE")), rb.getString((String)reportMap.get("DESCRIPTION")), reportFileName, domainName, searchCriteria, fileFormat, inputParamsMap, additionalSQLPropsMap, isReportsEmpty, (String)reportMap.get("DISPLAY_TYPE"));
            jasperPrintList = (ArrayList)resultPrintHashMapList.get(0);
            HashMap imagePathMap = (HashMap)resultPrintHashMapList.get(1);
            String isReportEmpty = (String)imagePathMap.get("isemptydata");
            imagePathMap.remove("isemptydata");
            reportFileName = reportName.replaceAll(" ", "_");
            reportLogger.log(Level.INFO, "Exporting file name is " + reportFileName);
            if (fileFormat.toLowerCase().indexOf("pdf") != -1) {
                ReportExporter.getInstance().exportAsPdf(jasperPrintList, reportFileName, cvId, storagePath, false);
            } else if (fileFormat.toLowerCase().indexOf("html") != -1) {
                reportLogger.log(Level.INFO, "The reportFileName in exportreport is : " + reportFileName);
                ReportExporter.getInstance().exportAsHTML(jasperPrintList, reportFileName, cvId, storagePath, imagePathMap.isEmpty() ? "" : (String)imagePathMap.get("imagePath"), false);
            } else if (fileFormat.toLowerCase().indexOf("xls") != -1) {
                ReportExporter.getInstance().exportAsXLS(jasperPrintList, reportFileName, cvId, storagePath, false);
            } else if (fileFormat.toLowerCase().indexOf("csv") != -1) {
                ReportExporter.getInstance().exportAsCSV(jasperPrintList, reportFileName, cvId, storagePath, false);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
            ExportUtil.deleteFiles(jasperPrintList);
            if (isReportEmpty.equals("yes")) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            ExportUtil.deleteFiles(jasperPrintList);
            throw ex;
        }
    }

    public static void exportReport(Long cvID, HashMap reportMap, String domainName, String searchCriteria, String reportType, HashMap inputParamsMap, HashMap addionalSQLPropsMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExportUtil.exportReport(cvID, reportMap, domainName, searchCriteria, reportType, inputParamsMap, addionalSQLPropsMap, request, response, (Boolean)false);
    }

    public static int exportReport(Long cvID, HashMap reportMap, String domainName, String searchCriteria, String reportType, HashMap inputParamsMap, HashMap addionalSQLPropsMap, HttpServletRequest request, HttpServletResponse response, Boolean isReportsEmpty) throws Exception {
        ArrayList jasperPrintMap = new ArrayList();
        try {
            if (cvID != null && cvID.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15050"))) {
                String isReportEmpty = "no";
                return ExportUtil.exportReportWithSubreport(cvID, reportMap, domainName, searchCriteria, reportType, inputParamsMap, addionalSQLPropsMap, request, response, isReportsEmpty);
            }
            String reportFileName = "UserDetails.xml";
            if (reportMap.get("JASPER_NAME") != null) {
                reportFileName = (String)reportMap.get("JASPER_NAME");
            }
            ArrayList resultPrintHashMapList = new ArrayList();
            boolean isJointReport = false;
            ArrayList exportList = new ArrayList();
            if (inputParamsMap.containsKey("isComplianceSummaryReport")) {
                isJointReport = true;
                exportList = (ArrayList)inputParamsMap.get("isComplianceSummaryReport");
                if (inputParamsMap.containsKey("searchObj")) {
                    String message = "";
                    Long type = (Long)((HashMap)exportList.get(0)).get("type");
                    if (type == 0L) {
                        message = rb.getString("adap.UserSearch.Object_History") + " " + (String)inputParamsMap.get("searchObj");
                    } else if (type == 1L) {
                        message = rb.getString("adap.UserSearch.Logon_Activity") + " " + (String)inputParamsMap.get("searchObj");
                    } else if (type == 2L) {
                        message = rb.getString("adap.UserSearch.User_Actions") + " " + (String)inputParamsMap.get("searchObj");
                    }
                    reportMap.put("TITLE", rb.handleGetObject("adap.common.text.exportTitleSummarySearch", new String[]{(String)((HashMap)exportList.get(0)).get("reportName")}));
                    reportMap.put("DESCRIPTION", rb.handleGetObject("adap.common.text.exportDescSummarySearch", new String[]{((Long)((HashMap)exportList.get(0)).get("sum")).toString(), (String)((HashMap)exportList.get(0)).get("reportName"), message}));
                } else {
                    reportMap.put("TITLE", rb.handleGetObject("adap.common.text.exportTitleSummary", new String[]{(String)((HashMap)exportList.get(0)).get("reportName")}));
                    reportMap.put("DESCRIPTION", rb.handleGetObject("adap.common.text.exportDescSummary", new String[]{((Long)((HashMap)exportList.get(0)).get("sum")).toString(), (String)((HashMap)exportList.get(0)).get("reportName")}));
                }
                inputParamsMap.put("isComplianceSummaryReport", (ArrayList)((HashMap)exportList.get(0)).get("exportMaps"));
            }
            resultPrintHashMapList = ExportUtil.exportReport(cvID, inputParamsMap.containsKey("isComplianceReport") ? (String)reportMap.get("TITLE") : rb.getString((String)reportMap.get("TITLE")), inputParamsMap.containsKey("isComplianceReport") ? (String)reportMap.get("DESCRIPTION") : rb.getString((String)reportMap.get("DESCRIPTION")), reportFileName, domainName, searchCriteria, reportType, inputParamsMap, addionalSQLPropsMap, isReportsEmpty, (String)reportMap.get("DISPLAY_TYPE"));
            if (isJointReport && exportList.size() > 1) {
                for (int a = 1; a < exportList.size(); ++a) {
                    if (inputParamsMap.containsKey("searchObj")) {
                        String message = "";
                        Long type = (Long)((HashMap)exportList.get(a)).get("type");
                        if (type == 0L) {
                            message = rb.getString("adap.UserSearch.Object_History") + " " + (String)inputParamsMap.get("searchObj");
                        } else if (type == 1L) {
                            message = rb.getString("adap.UserSearch.Logon_Activity") + " " + (String)inputParamsMap.get("searchObj");
                        } else if (type == 2L) {
                            message = rb.getString("adap.UserSearch.User_Actions") + " " + (String)inputParamsMap.get("searchObj");
                        }
                        reportMap.put("TITLE", rb.handleGetObject("adap.common.text.exportTitleSummarySearch", new String[]{(String)((HashMap)exportList.get(a)).get("reportName")}));
                        reportMap.put("DESCRIPTION", rb.handleGetObject("adap.common.text.exportDescSummarySearch", new String[]{((Long)((HashMap)exportList.get(a)).get("sum")).toString(), (String)((HashMap)exportList.get(a)).get("reportName"), message}));
                    } else {
                        reportMap.put("TITLE", rb.handleGetObject("adap.common.text.exportTitleSummary", new String[]{(String)((HashMap)exportList.get(a)).get("reportName")}));
                        reportMap.put("DESCRIPTION", rb.handleGetObject("adap.common.text.exportDescSummary", new String[]{((Long)((HashMap)exportList.get(a)).get("sum")).toString(), (String)((HashMap)exportList.get(a)).get("reportName")}));
                    }
                    inputParamsMap.put("isComplianceSummaryReport", (ArrayList)((HashMap)exportList.get(a)).get("exportMaps"));
                    resultPrintHashMapList.addAll(ExportUtil.exportReport(cvID, inputParamsMap.containsKey("isComplianceReport") ? (String)reportMap.get("TITLE") : rb.getString((String)reportMap.get("TITLE")), inputParamsMap.containsKey("isComplianceReport") ? (String)reportMap.get("DESCRIPTION") : rb.getString((String)reportMap.get("DESCRIPTION")), reportFileName, domainName, searchCriteria, reportType, inputParamsMap, addionalSQLPropsMap, isReportsEmpty, (String)reportMap.get("DISPLAY_TYPE")));
                }
            }
            jasperPrintMap = (ArrayList)resultPrintHashMapList.get(0);
            if (isJointReport && resultPrintHashMapList.size() > 2) {
                for (int a = 2; a < resultPrintHashMapList.size(); a += 2) {
                    jasperPrintMap.addAll((ArrayList)resultPrintHashMapList.get(a));
                }
            }
            HashMap imagePathMap = (HashMap)resultPrintHashMapList.get(1);
            String isReportEmpty = (String)imagePathMap.get("isemptydata");
            reportFileName = rb.getString((String)reportMap.get("TITLE")).replaceAll(" ", "");
            if (inputParamsMap.containsKey("isComplianceSummaryReport")) {
                reportFileName = rb.getString("adap.common.text.AggregateReports").replaceAll(" ", "");
            }
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                response.reset();
                ReportExporter.getInstance().exportAsPdf(jasperPrintMap, reportFileName, response, request, false);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                logger.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
                request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)((JasperPrint)JRLoader.loadObject((String)((String)jasperPrintMap.get(0)))));
                ReportExporter.getInstance().exportAsHtml(jasperPrintMap, reportFileName, response, request.getSession(), imagePathMap.isEmpty() ? "" : (String)imagePathMap.get("imagePath"), false);
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                ReportExporter.getInstance().exportAsXls(jasperPrintMap, reportFileName, response, request, false);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                ReportExporter.getInstance().exportAsCsv(jasperPrintMap, reportFileName, response, request, false);
            } else {
                logger.log(Level.INFO, "Invalid Report Type");
            }
            ExportUtil.deleteFiles(jasperPrintMap);
            if (isReportEmpty.equals("yes")) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            ExportUtil.deleteFiles(jasperPrintMap);
            throw ex;
        }
    }

    private static ArrayList exportReport(Long cvId, String reportName, String annotation, String reportFileName, String domainName, String searchCriteria, String fileFormat, HashMap inputParamsMap, HashMap addnSQLPropsMap, Boolean isReportsEmpty, String displayType) throws Exception {
        int incrementCount;
        int count;
        boolean isCompliance = false;
        boolean isComplianceSummary = false;
        if (inputParamsMap.containsKey("isComplianceReport")) {
            isCompliance = true;
            if (inputParamsMap.containsKey("isComplianceSummaryReport")) {
                isComplianceSummary = true;
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TimeUtil.getDateFormat());
        String dataInput = "";
        String inputDataTemp = "";
        String searchCriteria1 = "";
        String sqlString = "";
        String[] CriteriaArray = new String[2];
        Class<?> classToInvoke1 = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil");
        ReportInterface reportInterface = (ReportInterface)classToInvoke1.newInstance();
        HashMap graphMap = reportInterface.getReportGraphSQLString(cvId, inputParamsMap, null);
        if (!isCompliance && searchCriteria != null) {
            boolean searchBusinessCondition;
            boolean bl = searchBusinessCondition = searchCriteria.equalsIgnoreCase("business") || searchCriteria.equalsIgnoreCase("nonbusiness");
            if (searchBusinessCondition || searchCriteria.contains(BusinessServerSettings.getQueryDays())) {
                inputDataTemp = searchBusinessCondition ? searchCriteria : (searchCriteria.contains("not between") ? (String)rb.handleGetObject("adap.BusinessReports.ReportsNonBusiness") : (String)rb.handleGetObject("adap.BusinessReports.ReportsBusiness")) + " " + ((String)rb.handleGetObject("adap.BusinessReports.ReportsHours")).toLowerCase();
                searchCriteria = searchBusinessCondition ? ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria(searchCriteria, false) : searchCriteria;
                sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addnSQLPropsMap, 0);
                sqlString = sqlString.replace("${GROUP_BY}", "");
            } else if (graphMap.size() > 0) {
                CriteriaArray = searchCriteria.split("AND");
                searchCriteria1 = CriteriaArray[0];
                inputDataTemp = searchCriteria.replace((String)graphMap.get("xcolumn") + " = ", "");
                searchCriteria = searchCriteria == "" ? "1=1" : searchCriteria;
                searchCriteria1 = searchCriteria1 == "" ? "1=1" : searchCriteria1;
                inputDataTemp = inputDataTemp.replace("'", "");
                count = AuditReportAPI.getInstance().getRowsCount(cvId, (Long)graphMap.get("graphOptID"), inputDataTemp, inputParamsMap, searchCriteria1);
                sqlString = ADAPGraphSQLQueryAPI.getInstance().getSQLString(cvId, (Long)graphMap.get("graphOptID"), inputDataTemp, inputParamsMap, searchCriteria, addnSQLPropsMap, count);
                sqlString = sqlString.replace("${GROUP_BY}", "");
                if (searchCriteria1.contains((String)graphMap.get("xcolumn"))) {
                    inputDataTemp = searchCriteria1.replace((String)graphMap.get("xcolumn") + " = ", "");
                    inputDataTemp = inputDataTemp.replace("'", "");
                } else {
                    inputDataTemp = "";
                }
            } else {
                sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addnSQLPropsMap, 0);
            }
        }
        reportLogger.log(Level.INFO, "The Export query is " + sqlString);
        String getCount = "";
        if (!isCompliance) {
            getCount = ADAPSQLQueryAPI.getInstance().getSQLCountString(cvId, searchCriteria, inputParamsMap);
        } else if (!isComplianceSummary) {
            getCount = "SELECT COUNT(*) FROM (" + ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, null, 0) + ") AS RESULTTABLE";
        }
        count = 0;
        count = !isComplianceSummary ? QueryUtil.getRowsCount(getCount) : ((ArrayList)inputParamsMap.get("isComplianceSummaryReport")).size();
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, true);
        ExportUtil.removecolumnadfs(columnList);
        reportFileName = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "jrxml" + File.separator + reportFileName;
        HashMap<String, String> imagePathMap = new HashMap<String, String>();
        String imagePath = null;
        if (!isCompliance && (ADSMPersUtil.graphValue || displayType.equals("GRAPH"))) {
            imagePath = ExportUtil.setChart(searchCriteria, getCount, inputParamsMap, cvId, domainName);
        }
        if (imagePath != null) {
            imagePathMap.put("imagePath", imagePath);
            imagePath = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "cewolf_charts" + File.separator + imagePath;
        }
        Hashtable columnWidths = JRDesignUtil.calculateWidth(columnList, new ArrayList(), new Hashtable(), fileFormat);
        ArrayList<String> jasperPrintList = new ArrayList<String>();
        ArrayList<Cloneable> resultPrintHashMapList = new ArrayList<Cloneable>();
        Long subreportCvID = null;
        for (int k = 0; k < columnList.size(); ++k) {
            HashMap columnMap = (HashMap)columnList.get(k);
            if (columnMap.get("SUBREPORT_CV_ID") == null) continue;
            subreportCvID = (Long)columnMap.get("SUBREPORT_CV_ID");
        }
        int pageWidth = 0;
        int n = incrementCount = subreportCvID != null ? 100 : 10000;
        incrementCount = fileFormat.toLowerCase().indexOf("pdf") != -1 ? (subreportCvID != null ? 1000 : (imagePath == null ? 20012 : 20006)) : (subreportCvID != null ? 1000 : 30000);
        int totalCount = count;
        if (count > 0) {
            totalCount = count / incrementCount + (count % incrementCount != 0 ? 1 : 0);
        }
        boolean isEmptyReport = false;
        if (totalCount == 0) {
            isEmptyReport = true;
        }
        for (int pageCount = 0; pageCount < totalCount || isEmptyReport; ++pageCount) {
            int i;
            JRElement[] elements2;
            HashMap<String, Object> inputDataMap = new HashMap<String, Object>();
            if (isCompliance) {
                inputParamsMap.put("offset", "" + (totalCount == 1 ? 0 : incrementCount * pageCount));
                inputParamsMap.put("limit", "" + incrementCount);
                if (totalCount - pageCount == 1 && count % incrementCount != 0) {
                    inputParamsMap.put("limit", "" + count % incrementCount);
                }
                if (!isComplianceSummary) {
                    sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, null, 0);
                }
            } else {
                addnSQLPropsMap.put("startIndex", totalCount == 1 ? 1 : incrementCount * pageCount);
                addnSQLPropsMap.put("noOfObjects", incrementCount);
                if (totalCount - pageCount == 1 && count % incrementCount != 0) {
                    addnSQLPropsMap.put("noOfObjects", count % incrementCount);
                }
                sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvId, searchCriteria, inputParamsMap, addnSQLPropsMap, 0);
            }
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            JRDesignBand headerBand = new JRDesignBand();
            JRDesignBand detailBand = new JRDesignBand();
            JRDesignBand subReportBand = new JRDesignBand();
            JRDesignBand spaceBand = new JRDesignBand();
            JRDesignBand colBand = new JRDesignBand();
            spaceBand.setHeight(25);
            boolean imageXPosition = false;
            if (subreportCvID != null) {
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)detailBand);
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)subReportBand);
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)spaceBand);
            } else {
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)detailBand);
            }
            int height = 0;
            if (subreportCvID == null) {
                pageWidth = JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, columnList, fileFormat, 0, colBand, subReportBand, inputParamsMap, addnSQLPropsMap, searchCriteria);
                jasperDesign.setColumnHeader((JRBand)headerBand);
            } else {
                pageWidth = JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, columnList, fileFormat, 1, colBand, subReportBand, inputParamsMap, addnSQLPropsMap, searchCriteria);
            }
            int width = pageWidth;
            String timePeriod = "";
            if ((String)inputParamsMap.get("TO") != null) {
                timePeriod = rb.handleGetObject("adap.ExportUtil.Period_From_To", new String[]{TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("FROM")) * 1000L), TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("TO")) * 1000L)});
            }
            if (pageCount == 0) {
                HashMap<String, Object> parametersMap = new HashMap<String, Object>();
                parametersMap.put("reportName", reportName);
                parametersMap.put("jasperDesign", jasperDesign);
                parametersMap.put("domainName", domainName);
                parametersMap.put("annotation", annotation);
                parametersMap.put("pageWidth", pageWidth);
                parametersMap.put("width", width);
                parametersMap.put("height", height);
                parametersMap.put("fileFormat", fileFormat);
                parametersMap.put("cvId", cvId);
                parametersMap.put("searchCriteria", searchCriteria);
                parametersMap.put("inputDataTemp", inputDataTemp);
                parametersMap.put("imagePath", imagePath);
                parametersMap.put("timePeriod", timePeriod);
                ExportUtil.formTitleBand(inputDataMap, inputParamsMap, parametersMap, graphMap, isEmptyReport);
            }
            inputDataMap.put("timePeriod", timePeriod);
            inputDataMap.put("timePeriodHeader", timePeriod);
            inputDataMap.put("title", reportName);
            JRDesignBand footerBand = (JRDesignBand)jasperDesign.getPageFooter();
            JRDesignTextField footerTxt = (JRDesignTextField)footerBand.getElementByKey("currentPage");
            footerTxt.setX(width - 200);
            JRDesignStaticText footerTxtSlsh = (JRDesignStaticText)footerBand.getElementByKey("slash");
            footerTxtSlsh.setX(width - 125);
            JRDesignTextField footerTxtPage = (JRDesignTextField)footerBand.getElementByKey("totalPage");
            footerTxtPage.setX(width - 120);
            JRDesignLine footerLine = (JRDesignLine)footerBand.getElementByKey("footerLine");
            footerLine.setWidth(width - 100);
            JRDesignBand pageHeaderBand2 = (JRDesignBand)jasperDesign.getPageHeader();
            JRDesignTextField titleHeaderTxt = (JRDesignTextField)pageHeaderBand2.getElementByKey("titleHeader");
            titleHeaderTxt.setBold(true);
            if (fileFormat.toLowerCase().indexOf("pdf") != -1) {
                titleHeaderTxt.setWidth(pageWidth - 200);
            }
            JRDesignTextField timePeriodHeaderTxt = (JRDesignTextField)pageHeaderBand2.getElementByKey("timePeriodHeader");
            timePeriodHeaderTxt.setBold(true);
            inputDataMap.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            if (fileFormat.toLowerCase().indexOf("xls") != -1 || fileFormat.toLowerCase().indexOf("csv") != -1) {
                if (subreportCvID != null) {
                    inputDataMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                }
                JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                JRElement[] elements1 = pageHeaderBand.getElements();
                for (int i2 = 0; i2 < elements1.length; ++i2) {
                    pageHeaderBand.removeElement((JRDesignElement)elements1[i2]);
                }
                pageHeaderBand.setHeight(0);
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                elements2 = pageFooterBand.getElements();
                for (i = 0; i < elements2.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements2[i]);
                }
                pageFooterBand.setHeight(0);
                if (pageCount > 0) {
                    JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                    elements2 = titleBand.getElements();
                    for (int i3 = 0; i3 < elements2.length; ++i3) {
                        titleBand.removeElement((JRDesignElement)elements2[i3]);
                    }
                }
            } else if (fileFormat.toLowerCase().indexOf("html") != -1 || fileFormat.toLowerCase().indexOf("pdf") != -1) {
                JRDesignBand pageHeaderBand1 = (JRDesignBand)jasperDesign.getPageHeader();
                JRDesignTextField timePeriodHeader = (JRDesignTextField)pageHeaderBand1.getElementByKey("timePeriodHeader");
                timePeriodHeader.setX(pageWidth - 480);
                pageHeaderBand1.setHeight(50);
                if (pageCount > 0) {
                    JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                    titleBand.setHeight(30);
                    elements2 = titleBand.getElements();
                    for (i = 0; i < elements2.length; ++i) {
                        JRDesignTextField reportTitleText = (JRDesignTextField)titleBand.getElementByKey("title");
                        JRDesignTextField timeHeaderFirst = (JRDesignTextField)titleBand.getElementByKey("timeHeaderFirst");
                        timeHeaderFirst.setBold(true);
                        timeHeaderFirst.setX(pageWidth - 480);
                        if (elements2[i].equals(timeHeaderFirst) || elements2[i].equals(reportTitleText)) continue;
                        titleBand.removeElement((JRDesignElement)elements2[i]);
                    }
                }
            }
            reportLogger.log(Level.FINE, "the jasperDesign is " + jasperDesign);
            if (!isComplianceSummary) {
                JRDesignQuery query = new JRDesignQuery();
                query.setText(sqlString);
                jasperDesign.setQuery(query);
            } else {
                inputDataMap.put("exportMaps", (ArrayList)inputParamsMap.get("isComplianceSummaryReport"));
            }
            jasperDesign.setPageWidth(pageWidth);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            jasperPrintList.add(ExportUtil.getPrintData(jasperReport, inputDataMap, pageCount, cvId, isComplianceSummary));
            if (isEmptyReport) break;
        }
        resultPrintHashMapList.add(jasperPrintList);
        imagePathMap.put("isemptydata", isEmptyReport && isReportsEmpty != false ? "yes" : "no");
        resultPrintHashMapList.add(imagePathMap);
        return resultPrintHashMapList;
    }

    private static void removecolumnadfs(ArrayList<HashMap> columnList) {
        HashMap columnDetailsMap = columnList.get(1);
        if (columnDetailsMap.get("TABLEALIAS") != null && columnDetailsMap.get("TABLEALIAS").equals("AUDADFSLogonLogoffInfo")) {
            HashMap b = new HashMap();
            Iterator<HashMap> iter = columnList.iterator();
            while (iter.hasNext()) {
                HashMap str = iter.next();
                if (!str.get("COLUMNALIAS").equals("CALLER_IDENTITY")) continue;
                iter.remove();
            }
        }
    }

    public static void deleteFiles(ArrayList fileNameList) {
        try {
            for (int i = 0; i < fileNameList.size(); ++i) {
                File file = new File((String)fileNameList.get(i));
                if (file.delete()) {
                    reportLogger.log(Level.INFO, "the File Name that is deleted  " + file.getName());
                    continue;
                }
                reportLogger.log(Level.INFO, "Delete operation is failed.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrintData(JasperReport jasperReport, HashMap inputDataMap, int pageCount, Long cvId, boolean isComplianceSummary) {
        Double tempRandom = Math.random();
        JRSwapFileVirtualizer virtualizer = null;
        try {
            Connection con = null;
            try {
                con = RelationalAPI.getInstance().getConnection();
                File virtualizerDir = new File(virtualizerDirName);
                if (!virtualizerDir.exists()) {
                    virtualizerDir.mkdirs();
                }
                virtualizer = new JRSwapFileVirtualizer(10, new JRSwapFile(virtualizerDirName, 2048, 1024), false);
                logger.log(Level.INFO, "Exporting Print Object is " + virtualizerDirName + File.separator + "te" + pageCount + "cvId" + cvId + Double.toString(tempRandom) + ".jrprint");
                inputDataMap.put("REPORT_VIRTUALIZER", virtualizer);
                if (isComplianceSummary) {
                    ArrayList maps = (ArrayList)inputDataMap.get("exportMaps");
                    JRMapCollectionDataSource dataSource = new JRMapCollectionDataSource((Collection)maps);
                    JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(virtualizerDirName + File.separator + "te" + pageCount + "cvId" + cvId + Double.toString(tempRandom) + ".jrprint"), (Map)inputDataMap, (JRDataSource)dataSource);
                } else {
                    JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(virtualizerDirName + File.separator + "te" + pageCount + "cvId" + cvId + Double.toString(tempRandom) + ".jrprint"), (Map)inputDataMap, (Connection)con);
                }
                File file = new File(virtualizerDirName + File.separator + "te" + pageCount + "cvId" + cvId + Double.toString(tempRandom) + ".jrprint");
                file.deleteOnExit();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "exception while create the JasperPrint object " + ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (virtualizer != null) {
                    virtualizer.cleanup();
                    logger.log(Level.INFO, " The JRSwapFileVirtualizer is Cleaned");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return virtualizerDirName + File.separator + "te" + pageCount + "cvId" + cvId + Double.toString(tempRandom) + ".jrprint";
    }

    public static void formTitleBand(HashMap inputDataMap, HashMap inputParamsMap, HashMap parametersMap, HashMap graphMap, Boolean reportEmpty) {
        try {
            String reportName = (String)parametersMap.get("reportName");
            JasperDesign jasperDesign = (JasperDesign)parametersMap.get("jasperDesign");
            String domainName = (String)parametersMap.get("domainName");
            String annotation = (String)parametersMap.get("annotation");
            int pageWidth = (Integer)parametersMap.get("pageWidth");
            int width = (Integer)parametersMap.get("width");
            int height = (Integer)parametersMap.get("height");
            String inputDataTemp = (String)parametersMap.get("inputDataTemp");
            String fileFormat = (String)parametersMap.get("fileFormat");
            Long cvId = (Long)parametersMap.get("cvId");
            String searchCriteria = (String)parametersMap.get("searchCriteria");
            String imagePath = (String)parametersMap.get("imagePath");
            String dataInput = "";
            SimpleDateFormat sdf = new SimpleDateFormat(TimeUtil.getDateFormat());
            if ((String)inputParamsMap.get("objectName") != null && !"''".equals((String)inputParamsMap.get("objectName"))) {
                if (((String)inputParamsMap.get("objectName")).equalsIgnoreCase("allobjects")) {
                    dataInput = rb.handleGetObject("adap.ExportUtil.All_s", new String[]{(String)inputParamsMap.get("objectClass")});
                } else {
                    dataInput = (String)inputParamsMap.get("objectName");
                    dataInput = dataInput.length() > 1000 ? dataInput.substring(0, 1000) + "..." : dataInput;
                    dataInput = dataInput.replaceAll("\\\\\\\\", "\\\\");
                    dataInput = dataInput.replaceAll("\\\\\\\\", "\\\\");
                }
                if (fileFormat.toLowerCase().indexOf("csv") == -1) {
                    inputDataMap.put("objectName", dataInput);
                }
            }
            String graphTitle = (String)graphMap.get("graphTitle");
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            int imageXPosition = 0;
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont(font1, font1, 9, true, false);
            JRDesignTextField textFieldfilter = (JRDesignTextField)titleBand.getElementByKey("filterName");
            textFieldfilter.setBold(true);
            JRDesignTextField textFieldText = (JRDesignTextField)titleBand.getElementByKey("filterNameText");
            JRDesignStaticText textFieldColon = (JRDesignStaticText)titleBand.getElementByKey("colonForFilter");
            JRDesignTextField objectNameText = (JRDesignTextField)titleBand.getElementByKey("objectNameText");
            JRDesignTextField reportTitleText = (JRDesignTextField)titleBand.getElementByKey("title");
            reportTitleText.setBold(true);
            if (fileFormat.toLowerCase().indexOf("pdf") != -1) {
                reportTitleText.setWidth(pageWidth - 200);
            }
            JRDesignTextField domainName1 = (JRDesignTextField)titleBand.getElementByKey("domainName");
            domainName1.setBold(true);
            JRDesignTextField annotation1 = (JRDesignTextField)titleBand.getElementByKey("annotation");
            annotation1.setBold(true);
            annotation1.setWidth(pageWidth - 200);
            JRDesignTextField currTimeTxt = (JRDesignTextField)titleBand.getElementByKey("currTime");
            currTimeTxt.setBold(true);
            if (pageWidth == 595) {
                width += 50;
            }
            if (!(fileFormat.toLowerCase().indexOf("pdf") == -1 && fileFormat.toLowerCase().indexOf("html") == -1 && fileFormat.toLowerCase().indexOf("xls") == -1 || "".equalsIgnoreCase(dataInput))) {
                height = dataInput.length() * 8 < pageWidth - 100 ? 15 : dataInput.length() * 80 / (pageWidth - 100) + 15;
                JRDesignTextField objName = (JRDesignTextField)titleBand.getElementByKey("objectName");
                objName.setHeight(height);
                objName.setFont((JRFont)columnFont);
            }
            if (height > 0) {
                textFieldfilter.setY(117 + (height + 5));
                textFieldText.setY(117 + (height + 5));
                textFieldColon.setY(117 + (height + 5));
            }
            if (!inputDataTemp.equals("")) {
                height += 40;
            }
            JRDesignImage image1 = (JRDesignImage)titleBand.getElementByKey("imageReport");
            JRDesignTextField timeHeaderFirst = (JRDesignTextField)titleBand.getElementByKey("timeHeaderFirst");
            timeHeaderFirst.setBold(true);
            imageXPosition = pageWidth == 595 ? (pageWidth - 95) / 2 - 178 : (pageWidth - 120) / 2 - 178;
            int textWidth = 356;
            image1.setX(imageXPosition);
            if (imagePath != null) {
                image1.setY(170 + height);
                if (fileFormat.toLowerCase().indexOf("xls") != -1) {
                    image1.setHeight(370);
                    image1.setWidth(500);
                    textWidth = 500;
                }
            }
            JRDesignStaticText txt = JRUtil.formJRDesignText(imageXPosition, 140 + height, textWidth, graphTitle, columnFont);
            if (imagePath != null && fileFormat.toLowerCase().indexOf("csv") == -1) {
                titleBand.addElement((JRDesignElement)txt);
            }
            if (fileFormat.toLowerCase().indexOf("xls") != -1) {
                timeHeaderFirst.setX(pageWidth - 420);
            }
            if (fileFormat.toLowerCase().indexOf("csv") == -1) {
                timeHeaderFirst.setX(pageWidth - 480);
                ExportUtil.setInputDataMap(inputDataMap, domainName, annotation, imagePath, graphTitle, inputDataTemp, reportName);
                JRDesignTextField objectNameField = (JRDesignTextField)titleBand.getElementByKey("objectName");
                objectNameField.setWidth(width - 250);
            } else {
                timeHeaderFirst.setX(0);
                timeHeaderFirst.setWidth(600);
                inputDataMap.put("timePeriodHeader", reportName + "   " + (String)parametersMap.get("timePeriod"));
                inputDataMap.put("domainNameText", rb.getString("adap.AUDRuleVariables.variable_name.Domain_Name") + " : " + domainName);
                JRDesignTextField domainNameText = (JRDesignTextField)titleBand.getElementByKey("domainNameText");
                domainNameText.setWidth(270);
                domainNameText.setX(0);
                inputDataMap.put("reportGenText", rb.getString("adap.ExportUtil.Report_Generated_at") + " : " + new SimpleDateFormat(TimeUtil.getDateFormat()).format(new Date()));
                JRDesignTextField reportGenText = (JRDesignTextField)titleBand.getElementByKey("reportGenText");
                reportGenText.setWidth(270);
                reportGenText.setX(0);
            }
            if (fileFormat.toLowerCase().indexOf("xls") == -1) {
                titleBand.setHeight(height + 360);
            } else {
                titleBand.setHeight(height + 540);
            }
            if (imagePath == null) {
                image1.setHeight(0);
                txt.setHeight(0);
                titleBand.setHeight(height + 160);
            }
            String line1 = "_";
            for (int i = 0; i < 1000; ++i) {
                line1 = line1 + "__";
            }
            JRDesignStaticText Line1 = JRUtil.formStaticText(line1, "line1", 0, 30, width - 100, 20, 9, font1);
            Line1.setForecolor(new Color(34, 34, 34));
            titleBand.addElement((JRDesignElement)Line1);
            JRDesignStaticText Line2 = JRUtil.formStaticText(line1, "line2", 0, 120 + height, width - 100, 20, 9, font1);
            Line1.setForecolor(new Color(34, 34, 34));
            titleBand.addElement((JRDesignElement)Line2);
            if (reportEmpty.booleanValue()) {
                ExportUtil.addNoDataBand(null, reportName, jasperDesign, (String)parametersMap.get("timePeriod"), domainName, annotation, pageWidth);
                jasperDesign.setWhenNoDataType(WhenNoDataTypeEnum.NO_DATA_SECTION);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addNoDataBand(String noDataText, String reportName, JasperDesign jasperDesign, String timePeriod, String domainName, String annotaTion, int pageWidth) throws Exception {
        String domaintext = rb.getString("adap.AUDRuleVariables.variable_name.Domain_Name");
        String timegenAttext = rb.getString("adap.ExportUtil.Report_Generated_at");
        String annotationtext = rb.getString("adap.ExportUtil.annotation");
        String timegenAt = " : " + TimeUtil.formatDate();
        String domain = " : " + domainName;
        String annotation = " : " + annotaTion;
        if (noDataText == null) {
            noDataText = rb.getString("adap.ExportUtil.No_data_available_to_generate");
        }
        String line1 = "_";
        for (int i = 0; i < 1000; ++i) {
            line1 = line1 + "__";
        }
        JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle().clone();
        JRElement[] elements1 = titleBand.getElements();
        for (int i = 0; i < elements1.length; ++i) {
            titleBand.removeElement((JRDesignElement)elements1[i]);
        }
        titleBand.setHeight(170);
        if (reportName == null) {
            JRDesignStaticText heading = JRUtil.formStaticText(reportName, "title", 169, 5, 400, 20, 15, font1);
            heading.setForecolor(new Color(228, 34, 34));
            heading.setBold(true);
            titleBand.addElement((JRDesignElement)heading);
        }
        JRDesignStaticText repName = JRUtil.formStaticText(reportName, "ReportName", 20, 20, 175, 20, 11, font1);
        repName.setForecolor(new Color(228, 34, 34));
        titleBand.addElement((JRDesignElement)repName);
        JRDesignStaticText fromTo = JRUtil.formStaticText(timePeriod, "timePeriod", pageWidth - 380, 20, 300, 20, 10, font1);
        fromTo.setForecolor(new Color(34, 34, 34));
        titleBand.addElement((JRDesignElement)fromTo);
        JRDesignStaticText Line1 = JRUtil.formStaticText(line1, "line1", 20, 40, pageWidth - 80, 20, 9, font1);
        Line1.setForecolor(new Color(34, 34, 34));
        titleBand.addElement((JRDesignElement)Line1);
        JRDesignStaticText domText = JRUtil.formStaticText(domaintext, "DomainText", 25, 60, 100, 20, 10, font1);
        domText.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)domText);
        JRDesignStaticText annText = JRUtil.formStaticText(annotationtext, "AnnotationText", 25, 80, 100, 20, 10, font1);
        annText.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)annText);
        JRDesignStaticText timegenText = JRUtil.formStaticText(timegenAttext, "TimeGeneratedAtText", 25, 100, 100, 20, 10, font1);
        timegenText.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)timegenText);
        JRDesignStaticText line2 = JRUtil.formStaticText(line1, "line2", 20, 120, pageWidth - 80, 20, 9, font1);
        line2.setForecolor(new Color(34, 34, 34));
        titleBand.addElement((JRDesignElement)line2);
        JRDesignStaticText timegenat = JRUtil.formStaticText(timegenAt, "TimeGeneratedAt", 125, 100, 310, 20, 10, font1);
        timegenat.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)timegenat);
        JRDesignStaticText Domain = JRUtil.formStaticText(domain, "Domain", 125, 60, 310, 20, 10, font1);
        Domain.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)Domain);
        JRDesignStaticText Annotation2 = JRUtil.formStaticText(annotation, "Annotation", 125, 80, 330, 20, 10, font1);
        Annotation2.setForecolor(new Color(0, 0, 0));
        titleBand.addElement((JRDesignElement)Annotation2);
        JRDesignStaticText dataText = JRUtil.formStaticText(noDataText, "noDataText", pageWidth / 2 - 200, 140, 400, 20, 13, font1);
        dataText.setForecolor(new Color(0, 51, 153));
        titleBand.addElement((JRDesignElement)dataText);
        jasperDesign.setNoData((JRBand)titleBand);
    }

    public static String setChart(String searchCriteria, String countSqlString, HashMap inputParamsMap, Long cvId, String domainName) {
        String imagePath = null;
        try {
            Class<?> classToInvoke1 = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil");
            ReportInterface reportInterface = (ReportInterface)classToInvoke1.newInstance();
            HashMap graphMap = reportInterface.getReportGraphSQLString(cvId, inputParamsMap, searchCriteria);
            Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.schedule.DefaultGraphGenerator");
            GraphGenerator generator = (GraphGenerator)classToInvoke.newInstance();
            HashMap<String, HashMap> inputGraphMap = new HashMap<String, HashMap>();
            HashMap<String, Long> cvIdMap = new HashMap<String, Long>();
            HashMap<String, String> searchMap = new HashMap<String, String>();
            ArrayList<HashMap> paramsList = new ArrayList<HashMap>();
            if (graphMap.size() > 0) {
                searchMap.put("searchCriteria", searchCriteria);
                inputGraphMap.put("inputParamsMap", inputParamsMap);
                cvIdMap.put("cvId", cvId);
                paramsList.add(inputGraphMap);
                paramsList.add(cvIdMap);
                paramsList.add(searchMap);
                String fileName = generator.generateGraph(cvId, domainName, 0L, paramsList);
                if (fileName.contains("html")) {
                    imagePath = fileName = fileName.replace("html", "png");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imagePath;
    }

    private static void setInputDataMap(HashMap inputDataMap, String domainName, String annotation, String imagePath, String graphTitle, String inputDataTemp, String reportName) throws Exception {
        inputDataMap.put("domainNameText", rb.getString("adap.AUDColumnConfiguration.displayname.Domain_Name"));
        inputDataMap.put("annotationText", rb.getString("adap.ExportUtil.annotation"));
        inputDataMap.put("reportGenText", rb.getString("adap.ExportUtil.Report_Generated_at"));
        inputDataMap.put("objectNameText", rb.getString("adap.ExportUtil.Object_Names"));
        inputDataMap.put("domainName", domainName);
        inputDataMap.put("annotation", annotation);
        inputDataMap.put("currTime", TimeUtil.formatDate());
        inputDataMap.put("graphImagePath", imagePath);
        inputDataMap.put("productName1", "ADAudit Plus");
        inputDataMap.put("productName2", imagePath);
        inputDataMap.put("graphTitle", graphTitle);
        inputDataMap.put("filter", inputDataTemp);
        inputDataMap.put("filterNameText", rb.getString("adap.ExportUtil.Table_Details"));
        inputDataMap.put("title", reportName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exportReportWithSubreport(Long cvID, HashMap reportMap, String domainName, String searchCriteria, String reportType, HashMap inputParamsMap, HashMap addionalSQLPropsMap, HttpServletRequest request, HttpServletResponse response, Boolean isReportsEmpty) throws Exception {
        JRSwapFileVirtualizer virtualizer = null;
        int retVal = 1;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JRSwapFile swapFile = new JRSwapFile(ExportUtil.getJasperPath(), 1024, 100);
            virtualizer = new JRSwapFileVirtualizer(50, swapFile, true);
            String reportFileName = ExportUtil.getJasperXmlPath() + "MasterReportDesign.xml";
            String reportName = (String)reportMap.get("AUDIT_REPORT_NAME");
            ArrayList<String> printNameList = new ArrayList<String>();
            reportMap.put("DomainName", domainName);
            Map inputParams = ExportUtil.getJrParamMap(reportMap);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(reportName);
            JasperPrint print = new JasperPrint();
            ExportUtil.alignBands(reportType, jasperDesign, inputParams);
            ExportUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JasperReport jasperReport = null;
            ArrayList<HashMap> columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, true);
            String sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvID, searchCriteria, inputParamsMap, addionalSQLPropsMap, 0);
            if (searchCriteria != null) {
                inputParamsMap.put("searchCritBusiness", searchCriteria);
            }
            ArrayList reportRowsList = QueryUtil.getRows(sqlString, columnList, inputParamsMap, false);
            ArrayList<HashMap> exportRowsList = UserActivityUtil.getInstance().getExportRowsList(reportRowsList);
            columnList = ExportUtil.getSubReportColumnList(columnList);
            Hashtable columnWidths = JRDesignUtil.calculateWidth(columnList, new ArrayList(), new Hashtable(), reportType);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, columnList, reportType, rb, ExportUtil.getSubreportDesignList(jasperDesign, reportType));
            ReportJRDataSource dataSource = new ReportJRDataSource(exportRowsList);
            jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            String jrPrintName = "NTFSJrPrint.jrprint";
            JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(ExportUtil.getJasperPath() + jrPrintName), (Map)inputParams, (JRDataSource)dataSource);
            printNameList.add(ExportUtil.getJasperPath() + jrPrintName);
            if (dataSource != null) {
                dataSource = null;
            }
            reportFileName = "LogonDuration";
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                ReportExporter.getInstance().exportAsPdf(printNameList, reportFileName, response, request, false);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                ReportExporter.getInstance().exportAsHtml(printNameList, reportFileName, response, request.getSession(), null, false);
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                ReportExporter.getInstance().exportAsXls(printNameList, reportFileName, response, request, false);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                ReportExporter.getInstance().exportAsCsv(printNameList, reportFileName, response, request, false);
            } else {
                reportLogger.log(Level.INFO, "Invalid Report Type");
            }
            retVal = exportRowsList != null && !exportRowsList.isEmpty() ? 0 : 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (virtualizer != null) {
                virtualizer.cleanup();
            }
        }
        return retVal;
    }

    public static void alignBands(String reportType, JasperDesign jasperDesign, Map inputParams) {
        if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            JRElement[] elements = titleBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                titleBand.removeElement((JRDesignElement)elements[i]);
            }
            titleBand.setHeight(0);
            JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
            JRElement[] elements1 = pageHeaderBand.getElements();
            for (int i = 0; i < elements1.length; ++i) {
                pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
            }
            pageHeaderBand.setHeight(0);
            JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
            JRElement[] elements2 = pageFooterBand.getElements();
            for (int i = 0; i < elements2.length; ++i) {
                pageFooterBand.removeElement((JRDesignElement)elements2[i]);
            }
            pageFooterBand.setHeight(0);
            inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else if (reportType.toLowerCase().indexOf("html") != -1 || reportType.toLowerCase().indexOf("pdf") != -1) {
            inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
        }
    }

    public static void setPDFFontForPageHeaderTitleBand(String reportType, JasperDesign jasperDesign) {
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            JRFont reportPDFFont = JRDesignUtil.getPDFExporterFont();
            JRDesignReportFont normalFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 10, false, false);
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            JRElement[] elements = titleBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand columnHeaderBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRElement[] columnHeaderelements = columnHeaderBand.getElements();
            for (int i = 0; i < columnHeaderelements.length; ++i) {
                if (!(columnHeaderelements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)columnHeaderelements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRElement[] detailelements = detailBand.getElements();
            for (int i = 0; i < detailelements.length; ++i) {
                if (!(detailelements[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)detailelements[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
            JRElement[] elements1 = pageHeaderBand.getElements();
            for (int i = 0; i < elements1.length; ++i) {
                if (!(elements1[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements1[i]).setFont((JRFont)normalFont);
            }
            JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
            JRElement[] elements2 = pageFooterBand.getElements();
            for (int i = 0; i < elements2.length; ++i) {
                if (!(elements2[i] instanceof JRDesignTextField)) continue;
                ((JRDesignTextField)elements2[i]).setFont((JRFont)normalFont);
            }
        }
    }

    public static Boolean createJasperFile(String fileName) throws Exception {
        Boolean isCreated = false;
        File file = new File(ExportUtil.getJasperPath() + fileName);
        isCreated = file.createNewFile();
        return isCreated;
    }

    public static String getJasperPath() throws Exception {
        String productHome = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator;
        String jasperPath = productHome + File.separator + "jasperreports" + File.separator + "jasper" + File.separator;
        File file = new File(jasperPath);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return jasperPath;
    }

    public static String getJasperXmlPath() throws Exception {
        String productHome = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator;
        String jrXmlPath = productHome + File.separator + "jrxml" + File.separator;
        return jrXmlPath;
    }

    public static Map getJrParamMap(HashMap reportMap) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Description", "Description");
        map.put("date", TimeUtil.formatDate());
        map.put("title", rb.getString("adap.AUDReports.title.User_Active_Idle_Time_Duration"));
        map.put("desc", rb.getString(reportMap.get("AUDIT_REPORT_NAME").toString()));
        map.put("Generated at", rb.getString("adap.AUDReports.audit_report_generated_at") + " : ");
        map.put("Domain Name", rb.getString("adap.admin.administration.technician.domain_name") + " : ");
        map.put("DomainName", (String)reportMap.get("DomainName"));
        map.put("Page", rb.getString("adap.AUDReports.audit_report_Page"));
        return map;
    }

    public static ArrayList<HashMap> getSubReportColumnList(ArrayList<HashMap> columnList) throws Exception {
        ArrayList<HashMap> copyColumnList = new ArrayList<HashMap>();
        for (HashMap columnMap : columnList) {
            if (columnMap.get("SUBREPORT_CV_ID") != null) {
                Long subReportCvId = (Long)columnMap.get("SUBREPORT_CV_ID");
                ArrayList subColumnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(subReportCvId, false, true, null);
                for (HashMap map : subColumnList) {
                    if (((String)map.get("COLUMNALIAS")).equalsIgnoreCase("DETAILS")) continue;
                    copyColumnList.add(map);
                }
                continue;
            }
            copyColumnList.add(columnMap);
        }
        return copyColumnList;
    }

    public static ArrayList<HashMap> getSubreportDesignList(JasperDesign jasperDesign, String reportType) throws Exception {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        String name = "Logon Duration";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NAME", name);
        String subReportFile = ExportUtil.getJasperXmlPath() + "SubReportDesign.xml";
        JasperDesign subJasperDesign = JRXmlLoader.load((String)subReportFile);
        int columnWidth = subJasperDesign.getColumnWidth();
        JRDesignBand hBand = (JRDesignBand)subJasperDesign.getColumnHeader();
        JRDesignBand dBand = (JRDesignBand)subJasperDesign.getDetail();
        subJasperDesign.setName(name);
        int pageColumnWidth = subJasperDesign.getColumnWidth();
        jasperDesign.setColumnWidth(pageColumnWidth + 30);
        jasperDesign.setPageWidth(pageColumnWidth + 100);
        ArrayList subColumnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:15052"), true, true, null);
        Hashtable columnWidths = JRDesignUtil.calculateWidth(subColumnList, new ArrayList(), new Hashtable(), reportType);
        JRDesignUtil.fillBandSubReport(columnWidths, subJasperDesign, hBand, dBand, subColumnList, reportType, rb, subReportFile, name, true);
        map.put("SUBREPORT_DESIGN", (String)subJasperDesign);
        ExportUtil.createJasperFile("logonDurationSubReport.jasper");
        JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)(ExportUtil.getJasperPath() + "logonDurationSubReport.jasper"));
        JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)subJasperDesign);
        list.add(map);
        return list;
    }

    public static ArrayList exportScheduleSubreport(Long cvID, HashMap reportMap, String domainName, String searchCriteria, String reportType, HashMap inputParamsMap, HashMap additionalSQLPropsMap, String annotation) throws Exception {
        ArrayList<Cloneable> retPrintNameList = new ArrayList<Cloneable>();
        try {
            ArrayList<String> printNameList = new ArrayList<String>();
            String reportFileName = ExportUtil.getJasperXmlPath() + "MasterReportDesign.xml";
            String reportName = (String)reportMap.get("AUDIT_REPORT_NAME");
            reportMap.put("DomainName", domainName);
            Map inputParams = ExportUtil.getJrParamMap(reportMap);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(reportName);
            JasperPrint print = new JasperPrint();
            ExportUtil.alignBands(reportType, jasperDesign, inputParams);
            ExportUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            ArrayList<HashMap> columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, true);
            if (searchCriteria != null) {
                searchCriteria = searchCriteria.equalsIgnoreCase("business") || searchCriteria.equalsIgnoreCase("nonbusiness") ? ADAPSQLQueryAPI.getInstance().getBusinessSearchCriteria(searchCriteria, false) : searchCriteria;
                inputParamsMap.put("searchCritBusiness", searchCriteria);
            }
            String sqlString = ADAPSQLQueryAPI.getInstance().getSQLString(cvID, searchCriteria, inputParamsMap, additionalSQLPropsMap, 0);
            ArrayList reportRowsList = QueryUtil.getRows(sqlString, columnList, inputParamsMap, false);
            ArrayList<HashMap> exportRowsList = UserActivityUtil.getInstance().getExportRowsList(reportRowsList);
            columnList = ExportUtil.getSubReportColumnList(columnList);
            Hashtable columnWidths = JRDesignUtil.calculateWidth(columnList, new ArrayList(), new Hashtable(), reportType);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, columnList, reportType, rb, ExportUtil.getSubreportDesignList(jasperDesign, reportType));
            if (!exportRowsList.isEmpty()) {
                ReportJRDataSource dataSource = new ReportJRDataSource(exportRowsList);
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                String jrPrintName = "NTFSJrPrint.jrprint";
                JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(ExportUtil.getJasperPath() + jrPrintName), (Map)inputParams, (JRDataSource)dataSource);
                printNameList.add(ExportUtil.getJasperPath() + jrPrintName);
                if (dataSource != null) {
                    dataSource = null;
                }
                retPrintNameList.add(printNameList);
            } else {
                retPrintNameList.add(ExportUtil.exportScheduleEmptySubreport(cvID, reportMap, domainName, searchCriteria, reportType, inputParamsMap, additionalSQLPropsMap, annotation));
            }
            HashMap<String, String> imagePathMap = new HashMap<String, String>();
            imagePathMap.put("isemptydata", exportRowsList != null && !exportRowsList.isEmpty() ? "no" : "yes");
            retPrintNameList.add(imagePathMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retPrintNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList exportScheduleEmptySubreport(Long cvID, HashMap reportMap, String domainName, String searchCriteria, String reportType, HashMap inputParamsMap, HashMap additionalSQLPropsMap, String annotation) throws Exception {
        ArrayList<String> printNameList = new ArrayList<String>();
        Connection con = null;
        try {
            String reportName = (String)reportMap.get("AUDIT_REPORT_NAME");
            reportMap.put("DomainName", domainName);
            Map inputParams = ExportUtil.getJrParamMap(reportMap);
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvID, true);
            Hashtable columnWidths = JRDesignUtil.calculateWidth(columnList, new ArrayList(), new Hashtable(), reportType);
            String reportFileName = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "jrxml" + File.separator + "UserDetails.xml";
            con = RelationalAPI.getInstance().getConnection();
            JRDesignBand subReportBand = new JRDesignBand();
            JRDesignBand colBand = new JRDesignBand();
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(rb.getString(reportName));
            ExportUtil.alignBands(reportType, jasperDesign, inputParams);
            ExportUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)detailBand);
            int pageWidth = JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, columnList, reportType, 1, colBand, subReportBand, inputParamsMap, additionalSQLPropsMap, searchCriteria);
            jasperDesign.setColumnHeader((JRBand)headerBand);
            HashMap<String, Object> parametersMap = new HashMap<String, Object>();
            if ((String)inputParamsMap.get("TO") != null) {
                String timePeriod = rb.handleGetObject("adap.ExportUtil.Period_From_To", new String[]{TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("FROM")) * 1000L), TimeUtil.formatDate(Long.parseLong((String)inputParamsMap.get("TO")) * 1000L)});
                parametersMap.put("timePeriod", timePeriod);
            }
            parametersMap.put("height", 0);
            parametersMap.put("cvId", cvID);
            parametersMap.put("width", pageWidth);
            parametersMap.put("inputDataTemp", "");
            parametersMap.put("pageWidth", pageWidth);
            parametersMap.put("annotation", rb.getString(annotation));
            parametersMap.put("fileFormat", reportType);
            parametersMap.put("reportName", rb.getString(reportName));
            parametersMap.put("domainName", domainName);
            parametersMap.put("jasperDesign", jasperDesign);
            parametersMap.put("searchCriteria", searchCriteria);
            ExportUtil.formTitleBand(new HashMap(), new HashMap(), parametersMap, new HashMap(), true);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            String jrPrintName = "NTFSJrPrint.jrprint";
            JasperFillManager.fillReportToFile((JasperReport)jasperReport, (String)(ExportUtil.getJasperPath() + jrPrintName), (Map)inputParams, (Connection)con);
            printNameList.add(ExportUtil.getJasperPath() + jrPrintName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return printNameList;
    }

    static {
        ArrayList<String> availableFontList = new ArrayList<String>();
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ResourceBundleMgr.getInstance();
        Locale locale = ResourceBundleMgr.getServerLocale();
        for (String font : e.getAvailableFontFamilyNames(locale)) {
            availableFontList.add(font);
        }
        font1 = availableFontList.contains("Arial") ? "Arial" : "Microsoft Sans Serif";
    }
}

