/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ZipUtility;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;

public class ReportSchedulerHandler {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static void runSchedulerReports(Long scheduleId, Long auditId) throws Exception {
        String scheduleStatus = rb.getString("adap.ReportSchedulerHandler.SUCCESS");
        String message = rb.getString("adap.ReportSchedulerHandler.Successfully_stored");
        String storagePath = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).getForPersonality("ScheduledReports", criteria);
            if (!dataObject.isEmpty()) {
                Row scheduleRow = dataObject.getFirstRow("Schedule");
                Row audSchedulerRow = dataObject.getFirstRow("AUDScheduler");
                String domainName = (String)audSchedulerRow.get("DOMAIN_NAME");
                String scheduleName = (String)scheduleRow.get("SCHEDULE_NAME");
                Boolean isSingleFolder = (Boolean)audSchedulerRow.get("IS_SINGLE_FOLDER");
                storagePath = isSingleFolder != false ? ReportSchedulerHandler.makeDirectory((String)audSchedulerRow.get("FILE_STORAGE_PATH"), null) : ReportSchedulerHandler.makeDirectory(scheduleId, scheduleName, (String)audSchedulerRow.get("FILE_STORAGE_PATH"), domainName);
                reportLogger.log(Level.FINE, "storagePath is " + storagePath);
                Boolean isReportsEmpty = (Boolean)audSchedulerRow.get("IS_REPORTS_EMPTY");
                ArrayList emptyFileList = ExportUtil.exportReport(storagePath, domainName, (String)audSchedulerRow.get("REPORT_PERIOD"), (String)audSchedulerRow.get("FILE_FORMAT"), (String)audSchedulerRow.get("BUSINESS_HOUR"), dataObject, isReportsEmpty, isSingleFolder, scheduleName);
                Boolean isNotificationEnabled = (Boolean)audSchedulerRow.get("IS_NOTIFICATION_ENABLED");
                reportLogger.log(Level.INFO, "isNotificationEnabled " + isNotificationEnabled);
                if (isNotificationEnabled.booleanValue()) {
                    int sendflag = 1;
                    String note = " ";
                    if (isReportsEmpty.booleanValue()) {
                        int files_no = (Integer)emptyFileList.get(0);
                        if (emptyFileList.size() == files_no + 2) {
                            sendflag = 0;
                            note = "\n\n\t\t" + rb.getString("adap.ReportSchedulerHandler.no_report_data_all") + " \n\t";
                        } else if (emptyFileList.size() == 2) {
                            sendflag = 2;
                        } else if (emptyFileList.size() > 2 && emptyFileList.size() < files_no + 2) {
                            sendflag = 3;
                            note = "\n\n\t" + rb.getString("adap.ReportSchedulerHandler.no_report_data") + "\n\t";
                            for (int i = 1; i < emptyFileList.size() - 1; ++i) {
                                note = note + i + ". " + (String)emptyFileList.get(i) + "\n\t";
                            }
                        }
                    }
                    reportLogger.log(Level.FINE, "emptyfilelist is \n" + emptyFileList);
                    reportLogger.log(Level.FINE, "isemptyreport is " + isReportsEmpty + " and sendflag is " + sendflag);
                    HashMap<String, Object> sendMailMap = new HashMap<String, Object>();
                    String toAddress = (String)audSchedulerRow.get("TO_MAIL_ADDRESS");
                    String[] mailingAddress = toAddress.split(",");
                    sendMailMap.put("toAddress", mailingAddress);
                    sendMailMap.put("subject", (String)audSchedulerRow.get("MAIL_SUBJECT"));
                    String mailContent = (String)audSchedulerRow.get("MAIL_CONTENT");
                    String linkValue = "";
                    ArrayList<String> filesList = (ArrayList<String>)emptyFileList.get(emptyFileList.size() - 1);
                    if (((String)audSchedulerRow.get("SENDING_OPTIONS")).equalsIgnoreCase("ATTACHMENT")) {
                        Boolean isZipFile = (Boolean)audSchedulerRow.get("IS_ZIP_FILE");
                        if (isZipFile.booleanValue()) {
                            String zipFileName = domainName + "_" + scheduleName.replaceAll(" ", "_") + new SimpleDateFormat("-MMM-dd-yyyy-HH-mm-s").format(new Date(System.currentTimeMillis()));
                            if (sendflag == 2 || sendflag == 1) {
                                ZipUtility.createZipFile(storagePath, zipFileName, false, filesList);
                            } else {
                                ZipUtility.createZipFile(storagePath, zipFileName, false, emptyFileList, filesList);
                            }
                            filesList = new ArrayList<String>();
                            filesList.add(zipFileName);
                            sendMailMap.put("filesList", filesList);
                        } else {
                            sendMailMap.put("filesList", filesList);
                        }
                        sendMailMap.put("attachment", storagePath);
                    } else {
                        linkValue = rb.getString("adap.ReportSchedulerHandler.URL_of_the_published_report") + ReportSchedulerHandler.getURL(storagePath, "url");
                        mailContent = ReportSchedulerHandler.formMailContent(mailContent);
                    }
                    mailContent = mailContent.replace("%link%", linkValue);
                    mailContent = mailContent + note;
                    sendMailMap.put("message", mailContent);
                    reportLogger.log(Level.INFO, "mailContent is " + mailContent);
                    boolean sendMailStatus = sendflag == 2 || sendflag == 1 ? SendMailAPI.getInstance().sendMail(sendMailMap) : SendMailAPI.getInstance().sendMail(sendMailMap, emptyFileList);
                    if (sendMailStatus) {
                        message = rb.getString("adap.ReportSchedulerHandler.Successfully_sent");
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            reportLogger.log(Level.INFO, "Access Denied to access the file for scheduleId " + scheduleId + "   " + storagePath);
            scheduleStatus = rb.getString("adap.ReportSchedulerHandler.ERROR");
            message = ex.getMessage();
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            reportLogger.log(Level.INFO, "NullPointerException occurred at getting datas for scheduleId " + scheduleId);
            scheduleStatus = rb.getString("adap.ReportSchedulerHandler.ERROR");
            message = ex.getMessage();
            ex.printStackTrace();
        }
        catch (SendFailedException ex) {
            reportLogger.log(Level.INFO, "SendFailedException occurred for scheduleId " + scheduleId);
            scheduleStatus = rb.getString("adap.ReportSchedulerHandler.WARNING");
            message = ex.getMessage();
            ex.printStackTrace();
        }
        catch (MessagingException ex) {
            reportLogger.log(Level.INFO, "MessagingException occurred for scheduleId " + scheduleId);
            scheduleStatus = rb.getString("adap.ReportSchedulerHandler.WARNING");
            message = ex.getMessage();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            reportLogger.log(Level.INFO, "Exception occurred for scheduleId " + scheduleId);
            scheduleStatus = rb.getString("adap.ReportSchedulerHandler.ERROR");
            message = rb.getString("adap.ReportSchedulerHandler.Error_during_previous_run");
            ex.printStackTrace();
        }
        ReportSchedulerHandler.updateReportFolderDetails(storagePath, message, auditId, scheduleStatus);
    }

    private static String makeDirectory(Long scheduleId, String scheduleName, String fileStoragePath, String domainName) throws Exception {
        String dir = "";
        Date date = new Date(System.currentTimeMillis());
        scheduleName = scheduleName.replaceAll(" ", "");
        String dateStr = new SimpleDateFormat("MMMddyyyy").format(date);
        String timeStr = new SimpleDateFormat("hh-mm-s-aaa").format(date);
        dir = domainName + File.separator + scheduleName + File.separator + dateStr + File.separator + timeStr;
        String directoryName = fileStoragePath + dir;
        directoryName = ReportSchedulerHandler.makeDirectory(directoryName, dir);
        return directoryName;
    }

    private static String makeDirectory(String directoryName, String dir) throws Exception {
        boolean isCustomDirCreated;
        reportLogger.log(Level.INFO, "Directory Name :: " + directoryName);
        reportLogger.log(Level.INFO, "  Extra Folder :: " + dir);
        File file = new File(directoryName);
        if (!file.exists() && !(isCustomDirCreated = file.mkdirs())) {
            System.out.println("File is not existed");
            directoryName = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "schedule-reports";
            directoryName = dir != null ? directoryName + File.separator + dir : directoryName;
            file = new File(directoryName);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        reportLogger.log(Level.INFO, "Final Dir Name :: " + directoryName);
        return directoryName;
    }

    private static void updateReportFolderDetails(String storagePath, String message, Long auditId, String scheduleStatus) throws Exception {
        String filePath = ReportSchedulerHandler.getURL(storagePath, null);
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDSchedulerAuditMapping", (String)"AUDIT_ID"), (Object)auditId, 0);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDSchedulerAuditMapping", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getFirstRow("AUDSchedulerAuditMapping");
            row.set("AUDIT_ID", (Object)auditId);
            row.set("DIRECTORY_NAME", (Object)filePath);
            row.set("MESSAGE", (Object)message);
            row.set("STATUS", (Object)scheduleStatus);
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        } else {
            Row row = new Row("AUDSchedulerAuditMapping");
            row.set("AUDIT_ID", (Object)auditId);
            row.set("DIRECTORY_NAME", (Object)filePath);
            row.set("MESSAGE", (Object)message);
            row.set("STATUS", (Object)scheduleStatus);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
    }

    private static String getURL(String storagePath, String urlStr) throws Exception {
        if (!storagePath.startsWith("\\")) {
            String filePath;
            String currentSecurityLevel = ADSMPersUtil.getCurrentSecurityLevel();
            Integer portNumber = SDInstallUtil.getWebServerPort();
            String hostName = InetAddress.getLocalHost().getHostName();
            reportLogger.log(Level.FINE, "hostName is " + hostName);
            boolean enableSSL = ADSMPersUtil.checkSSL();
            if (enableSSL) {
                portNumber = SDInstallUtil.getSSLPort();
                currentSecurityLevel = "https";
            }
            if (storagePath.startsWith(filePath = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "schedule-reports")) {
                int index = storagePath.indexOf("webapps" + File.separator + "adap");
                String storagePath2 = storagePath.substring(index);
                storagePath2 = storagePath2.substring(storagePath2.indexOf("adap"));
                if (urlStr != null) {
                    boolean isContentTypePlain = SendMailAPI.getInstance().getIsContentTypePlain();
                    if (isContentTypePlain) {
                        storagePath = currentSecurityLevel.toLowerCase() + "://" + hostName + ":" + portNumber + File.separator + storagePath2;
                    } else {
                        storagePath = "<a href='";
                        storagePath = storagePath + currentSecurityLevel.toLowerCase() + "://" + hostName + ":" + portNumber + File.separator + storagePath2;
                        storagePath = storagePath + "'>";
                        storagePath = storagePath + currentSecurityLevel.toLowerCase() + "://" + hostName + ":" + portNumber + File.separator + storagePath2;
                        storagePath = storagePath + "</a>";
                    }
                } else {
                    storagePath = storagePath2;
                }
                storagePath = storagePath.replace("\\", "/");
            } else if (!storagePath.substring(1, 2).equals(":")) {
                storagePath = "";
            }
        }
        return storagePath;
    }

    private static String formMailContent(String mailContent) throws Exception {
        boolean isContentTypePlain = SendMailAPI.getInstance().getIsContentTypePlain();
        String content = "";
        StringTokenizer token = new StringTokenizer(mailContent, new String(new byte[]{13}));
        if (isContentTypePlain) {
            while (token.hasMoreTokens()) {
                content = content + token.nextToken();
            }
        } else {
            content = "<html><body><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">";
            reportLogger.log(Level.FINE, "total count token is " + token.countTokens());
            while (token.hasMoreTokens()) {
                content = content + "<tr><td>" + token.nextToken() + "</td></tr>";
            }
            content = content + "</table></body></html>";
        }
        return content;
    }
}

